/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.sec.user.utils.UserOperationUtils;

public class UserEmailFormatValidatorPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserEmailFormatValidator());
    }

    private static class UserEmailFormatValidator
    extends AbstractValidator {
        private UserEmailFormatValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject userObj = dataEntity.getDataEntity();
                String email = userObj.getString("email");
                if (!StringUtils.isNotBlank((CharSequence)email)) continue;
                email = email.replaceAll(" ", "");
                userObj.set("email", (Object)email);
                if (UserOperationUtils.isEmail(email)) continue;
                this.addErrorMessage(dataEntity, UserMessage.getMessage((String)"M00016"));
            }
        }
    }
}

