/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.UserOperPlugin;
import kd.bos.sec.user.UserPropertyUniquenessValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.user.YzjUserModel;

public class UserEnableServicePlugin
extends UserOperPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("idcard");
        e.getFieldKeys().add("username");
        e.getFieldKeys().add("email");
        e.getFieldKeys().add("phone");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ArrayList<String> propertyList = new ArrayList<String>(5);
        propertyList.add("number");
        propertyList.add("idcard");
        propertyList.add("phone");
        propertyList.add("email");
        UserPropertyUniquenessValidator uniquenessValidator = new UserPropertyUniquenessValidator(propertyList);
        e.addValidator((AbstractValidator)uniquenessValidator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        IYzjUserService userService = this.getYzjUserService();
        ArrayList<String> openIds = new ArrayList<String>();
        ArrayList<YzjUserModel> addUserList = new ArrayList<YzjUserModel>();
        DynamicObject[] userArr = this.genSelectedUserChangeInfo(e, "5", false, openIds, addUserList);
        if (addUserList.isEmpty()) {
            return;
        }
        YzjConfig yzjConfig = userService.getConfig();
        if (3 != yzjConfig.getSyncMode()) {
            return;
        }
        userService.add(addUserList);
        ArrayList<YzjUserModel> successList = new ArrayList<YzjUserModel>(addUserList);
        for (YzjUserModel userModel : addUserList) {
            if (!userModel.isOperSuccess()) continue;
            successList.add(userModel);
        }
        List yzjUserList = userService.getUsers(1, successList);
        block1: for (Map yzjUser : yzjUserList) {
            for (DynamicObject userObj : userArr) {
                boolean isSameEmail;
                String phone = userObj.getString("phone");
                String email = userObj.getString("email");
                boolean isSamePhone = StringUtils.isNotBlank((CharSequence)phone) && phone.equals(yzjUser.get("phone"));
                boolean bl = isSameEmail = StringUtils.isNotBlank((CharSequence)email) && email.equals(yzjUser.get("email"));
                if (!isSamePhone && !isSameEmail) continue;
                userObj.set("eid", (Object)yzjConfig.getEid());
                userObj.set("tid", (Object)yzjConfig.getEid());
                userObj.set("fuid", yzjUser.get("uid"));
                userObj.set("useropenid", yzjUser.get("openId"));
                continue block1;
            }
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
    }

    @Override
    protected void operateBizPartnerUser(List<Long> userIds) {
        String selectFields = "enable,disabler,disabledate";
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] partnerObjArr = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)selectFields, (QFilter[])filters);
        if (partnerObjArr == null || partnerObjArr.length == 0) {
            return;
        }
        for (DynamicObject partnerObj : partnerObjArr) {
            partnerObj.set("enable", (Object)"1");
            partnerObj.set("disabler", (Object)0L);
            partnerObj.set("disabledate", null);
        }
        SaveServiceHelper.save((DynamicObject[])partnerObjArr);
    }
}

