/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.i18n.mservice.I18nServiceHelper;

public class UserIdCardFormatValidatorPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserIdCardFormatValidator());
    }

    private static class UserIdCardFormatValidator
    extends AbstractValidator {
        private UserIdCardFormatValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String idCard;
                DynamicObject userObj = dataEntity.getDataEntity();
                DynamicObject idType = userObj.getDynamicObject("idtype");
                if (idType == null || !StringUtils.isNotBlank((CharSequence)(idCard = userObj.getString("idcard")))) continue;
                idCard = idCard.replace(" ", "");
                userObj.set("idcard", (Object)idCard);
                Map msg = I18nServiceHelper.validIdentityCardNo(null, (String)idType.getString("number"), (String)idCard);
                if (!Boolean.FALSE.equals(msg.get("isSuccess"))) continue;
                this.addErrorMessage(dataEntity, idCard + BaseMessage.getMessage((String)"M00067") + msg.get("msg"));
            }
        }
    }
}

