/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class UserInfoExpireCleanServicePlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(UserInfoExpireCleanServicePlugin.class);
    private List<String> userInfoCleanFields;
    private Integer userInfoRetainDays;
    private String userInfoSchemeNumber;
    private DynamicObject userInfoCleanSchemeObj;
    private String strJoinerFields;
    private FileService imageFileService = FileServiceFactory.getImageFileService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("disabledate");
        e.getFieldKeys().add("isforbidden");
        e.getFieldKeys().add("userdisabletime");
        e.getFieldKeys().add("modifytime");
        if (CollectionUtils.isEmpty(this.userInfoCleanFields)) {
            this.userInfoCleanFields = this.queryUserInfoCleanSchemeFields();
        }
        StringJoiner sj = new StringJoiner(",");
        for (String field : this.userInfoCleanFields) {
            sj.add(field);
            e.getFieldKeys().add(field);
        }
        this.strJoinerFields = sj.toString();
        logger.info(sj.toString());
    }

    private List<String> queryUserInfoCleanSchemeFields() {
        ArrayList<String> res = new ArrayList<String>(10);
        String cleanSchemeId = this.getOption().getVariableValue("userinfocleanschemeid");
        if (StringUtils.isBlank((CharSequence)cleanSchemeId)) {
            return res;
        }
        DynamicObject userInfoCleanSchemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(cleanSchemeId), (String)"bos_user_infocleanscheme");
        if (userInfoCleanSchemeObj == null) {
            return res;
        }
        DynamicObjectCollection fieldDoc = userInfoCleanSchemeObj.getDynamicObjectCollection("fieldentry");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        for (DynamicObject fieldObj : fieldDoc) {
            String fieldNumber = fieldObj.getString("fieldnumber");
            if (mainEntityType.findProperty(fieldNumber) == null) continue;
            res.add(fieldNumber);
        }
        this.userInfoRetainDays = userInfoCleanSchemeObj.getInt("retainday") - 1;
        this.userInfoSchemeNumber = userInfoCleanSchemeObj.getString("number");
        this.userInfoCleanSchemeObj = userInfoCleanSchemeObj;
        return res;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserInfoExpireCleanValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.cleanUserInfo(e);
        this.cleanUserInfoHistory(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user_clean");
        ArrayList<DynamicObject> userCleanObjs = new ArrayList<DynamicObject>(e.getDataEntities().length);
        Long userInfoMgrSchemeId = Long.valueOf(this.getOption().getVariableValue("userinfocleanschemeid"));
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        for (DynamicObject userObj : e.getDataEntities()) {
            DynamicObject userCleanObj = new DynamicObject((DynamicObjectType)mainEntityType);
            userCleanObj.set("userinfocleanschemeid", (Object)userInfoMgrSchemeId);
            userCleanObj.set("user", userObj.getPkValue());
            userCleanObj.set("cleaner", (Object)currUserId);
            userCleanObj.set("cleantime", (Object)now);
            userCleanObjs.add(userCleanObj);
        }
        if (!CollectionUtils.isEmpty(userCleanObjs)) {
            SaveServiceHelper.save((DynamicObject[])userCleanObjs.toArray(new DynamicObject[userCleanObjs.size()]));
        }
    }

    private void cleanUserInfo(BeginOperationTransactionArgs e) {
        if (ArrayUtils.isEmpty((Object[])e.getDataEntities())) {
            return;
        }
        DynamicObjectType dynamicObjectType = e.getDataEntities()[0].getDynamicObjectType();
        if (dynamicObjectType == null || !(dynamicObjectType instanceof MainEntityType)) {
            logger.debug(String.format("\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u5b9e\u4f53\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", "bos_user"));
            return;
        }
        this.cleanInfo(e.getDataEntities(), (MainEntityType)dynamicObjectType);
    }

    private void cleanUserInfoHistory(BeginOperationTransactionArgs e) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user_history");
        if (mainEntityType == null) {
            logger.debug(String.format("\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u5b9e\u4f53\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", "bos_user_history"));
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object> userIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            userIds.add(dataEntity.getPkValue());
        }
        QFilter filter = new QFilter("user", "in", userIds);
        DynamicObject[] userHistoryObjs = BusinessDataServiceHelper.load((String)"bos_user_history", (String)this.strJoinerFields, (QFilter[])new QFilter[]{filter});
        this.cleanInfo(userHistoryObjs, mainEntityType);
    }

    private void cleanInfo(DynamicObject[] dataEntities, MainEntityType mainEntityType) {
        if (ArrayUtils.isEmpty((Object[])dataEntities) || mainEntityType == null) {
            return;
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        Map<String, String> field2EntityMap = this.findPropertyInEntity(mainEntityType, this.userInfoCleanFields);
        for (DynamicObject object : dataEntities) {
            for (String field : this.userInfoCleanFields) {
                DynamicProperty property = mainEntityType.getProperty(field);
                if (property != null) {
                    this.addFilePaths(filePaths, object, field, property);
                    object.set(field, null);
                    continue;
                }
                this.cleanInfoInEntry(filePaths, object, field, field2EntityMap);
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        this.deleteFileSource(filePaths);
    }

    private Map<String, String> findPropertyInEntity(MainEntityType mainEntityType, List<String> fields) {
        HashMap<String, String> res = new HashMap<String, String>(fields.size());
        for (String field : fields) {
            IDataEntityProperty property = mainEntityType.findProperty(field);
            if (property == null || property.getParent() == null) continue;
            res.put(field, property.getParent().getName());
        }
        return res;
    }

    private void deleteFileSource(List<String> filePaths) {
        if (CollectionUtils.isEmpty(filePaths)) {
            return;
        }
        for (String filePath : filePaths) {
            if (!this.imageFileService.exists(filePath)) continue;
            this.imageFileService.delete(filePath);
        }
    }

    private void addFilePaths(List<String> filePaths, DynamicObject object, String field, DynamicProperty property) {
        if (property instanceof PictureProp && StringUtils.isNotBlank((CharSequence)object.getString(field))) {
            filePaths.add(object.getString(field));
        }
    }

    private void cleanInfoInEntry(List<String> filePaths, DynamicObject userObj, String field, Map<String, String> field2EntityMap) {
        String entityKey = field2EntityMap.get(field);
        DynamicObjectCollection doc = userObj.getDynamicObjectCollection(entityKey);
        DynamicObjectType dynamicObjectType = doc.getDynamicObjectType();
        for (DynamicObject object : doc) {
            this.addFilePaths(filePaths, object, field, dynamicObjectType.getProperty(field));
            object.set(field, null);
        }
    }

    private Map<Object, String> matchCleanScheme(List<Object> ids, Long cleanSchemeId) {
        HashMap<Object, String> res = new HashMap<Object, String>(ids.size());
        if (this.userInfoCleanSchemeObj == null) {
            this.userInfoCleanSchemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)cleanSchemeId, (String)"bos_user_infocleanscheme");
        }
        DynamicObject cleanSchemeObj = this.userInfoCleanSchemeObj;
        String cleanSchemeNumber = cleanSchemeObj.getString("number");
        if (cleanSchemeObj == null) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u4eba\u4fe1\u606f\u6e05\u9664\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"UserInfoExpireCleanServicePlugin_2", (String)"bos-sec-user", (Object[])new Object[0]);
            ids.forEach(id -> res.put(id, msg));
            return res;
        }
        if (!cleanSchemeObj.getBoolean("enable")) {
            String msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u4eba\u4fe1\u606f\u6e05\u9664\u65b9\u6848%s\u672a\u542f\u7528\u3002", (String)"UserInfoExpireCleanServicePlugin_3", (String)"bos-sec-user", (Object[])new Object[0]), cleanSchemeNumber);
            ids.forEach(id -> res.put(id, msg));
            return res;
        }
        String rule = cleanSchemeObj.getString("rule");
        QFilter ruleFilter = UserOperationUtils.convertRule2Filter("bos_user", rule);
        if (ruleFilter == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u4eba\u4fe1\u606f\u6e05\u9664\u65b9\u6848%s\u672a\u8bbe\u7f6e\u6761\u4ef6\u89c4\u5219\u3002", (String)"UserInfoExpireCleanServicePlugin_4", (String)"bos-sec-user", (Object[])new Object[0]), cleanSchemeNumber);
            ids.forEach(id -> res.put(id, msg));
            return res;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{ruleFilter, idFilter};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])filters);
        for (Object id2 : ids) {
            DynamicObject userObj = (DynamicObject)userObjMap.get(id2);
            if (userObj != null) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u6570\u636e\u4e0d\u7b26\u5408\u4eba\u5458\u4e2a\u4eba\u4fe1\u606f\u6e05\u9664\u65b9\u6848%s\u7684\u6761\u4ef6\u89c4\u5219\u3002", (String)"UserInfoExpireCleanServicePlugin_5", (String)"bos-sec-user", (Object[])new Object[0]), cleanSchemeNumber);
            res.put(id2, msg);
        }
        return res;
    }

    private class UserInfoExpireCleanValidator
    extends AbstractValidator {
        private UserInfoExpireCleanValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            ArrayList<Object> ids = new ArrayList<Object>(this.getDataEntities().length);
            if (StringUtils.isBlank((CharSequence)this.getOption().getVariableValue("userinfocleanschemeid", ""))) {
                logger.debug("UserInfoExpireCleanServicePlugin#validate param infocleanschemeid is null");
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4eba\u5458\u4fe1\u606f\u7ba1\u7406\u65b9\u6848\u53c2\u6570\u3002", (String)"UserInfoExpireCleanServicePlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
            }
            Map userId2Msg = new HashMap(1);
            Boolean needValidate = Boolean.valueOf(this.getOption().getVariableValue("needvalidate", "true"));
            if (needValidate.booleanValue()) {
                String cleanSchemeId = this.getOption().getVariableValue("userinfocleanschemeid");
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    ids.add(dataEntity.getDataEntity().getPkValue());
                }
                userId2Msg = UserInfoExpireCleanServicePlugin.this.matchCleanScheme(ids, Long.valueOf(cleanSchemeId));
            }
            for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                Date date;
                Date latestDate;
                DynamicObject userObj = extendedDataEntity.getDataEntity();
                Object id = userObj.getPkValue();
                if (needValidate.booleanValue() && userId2Msg.containsKey(id)) {
                    this.addErrorMessage(extendedDataEntity, (String)userId2Msg.get(id));
                }
                if (!(latestDate = UserOperationUtils.getMaxDate(userObj.getDate("modifytime"), userObj.getDate("disabledate"), userObj.getDate("userdisabletime"))).after(date = Utils.getDate((int)(-UserInfoExpireCleanServicePlugin.this.userInfoRetainDays.intValue())))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u65b9\u6848%s\u7559\u5b58\u5929\u6570\u3002", (String)"UserInfoExpireCleanServicePlugin_1", (String)"bos-sec-user", (Object[])new Object[0]), UserInfoExpireCleanServicePlugin.this.userInfoSchemeNumber);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

