/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class UserNoActivationServicePlugin
extends AbstractOperationServicePlugIn {
    protected static Log logger = LogFactory.getLog(UserNoActivationServicePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserNoActivationValidator());
    }

    private static class UserNoActivationValidator
    extends AbstractValidator {
        private UserNoActivationValidator() {
        }

        public void validate() {
            LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"G_CRI");
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject userObj = dataEntity.getDataEntity();
                String phone = userObj.getString("phone");
                String email = userObj.getString("email");
                if (!StringUtils.isBlank((CharSequence)phone) || !StringUtils.isBlank((CharSequence)email) || checkResult.getHasLicense().booleanValue()) continue;
                this.addFatalErrorMessage(dataEntity, UserMessage.getMessage((String)"M00081"));
            }
        }
    }
}

