/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.history.UserHistoryUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.UserOperationValidator;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.sec.user.utils.YptSynLogUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.user.cache.UserCache;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.user.YzjUserModel;
import kd.bos.yzj.service.YzjServiceFactory;

public class UserOperPlugin
extends AbstractOperationServicePlugIn {
    protected static Log logger = LogFactory.getLog(UserOperPlugin.class);
    private IYzjUserService yzjUserService;
    protected List<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("usertype")) {
            fieldKeys.add("usertype");
        }
        if (!fieldKeys.contains("usertypes")) {
            fieldKeys.add("usertypes");
        }
        e.getFieldKeys().add("isforbidden");
        e.getFieldKeys().add("userdisablerid");
        e.getFieldKeys().add("userdisabletime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserOperationValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs event) {
        super.endOperationTransaction(event);
        DynamicObject[] dataEntities = event.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        boolean isOperationFromPage = "1".equals(this.getOption().getVariableValue("isFrom_bos_user_Page", "0"));
        if (isOperationFromPage) {
            this.operateBizPartnerUser(dataEntities);
        }
    }

    private void operateBizPartnerUser(DynamicObject[] dataEntities) {
        ArrayList<Long> userIds = new ArrayList<Long>(dataEntities.length);
        block2: for (DynamicObject userObj : dataEntities) {
            DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
            if (CollectionUtils.isEmpty((Collection)userTypesCol)) continue;
            for (DynamicObject usertypesObj : userTypesCol) {
                DynamicObject usertypeObj = usertypesObj.getDynamicObject("fbasedataId");
                if (usertypeObj == null || !"2".equals(usertypeObj.getString("category"))) continue;
                userIds.add(userObj.getLong("id"));
                continue block2;
            }
        }
        if (!userIds.isEmpty()) {
            try {
                this.operateBizPartnerUser(userIds);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u5546\u52a1\u4f19\u4f34\u7528\u6237\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u6839\u636e\u63d0\u793a\u5904\u7406\uff1a", (String)"UserOperPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]) + e.getMessage());
            }
        }
    }

    protected void operateBizPartnerUser(List<Long> userIds) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List selectRows = e.getSelectedRows();
        String operationKey = e.getOperationKey().toLowerCase();
        if (Utils.isListEmpty((List)selectRows)) {
            return;
        }
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_userposition"));
        cacheManager.removeByDt();
        ArrayList<Long> userIds = new ArrayList<Long>(selectRows.size());
        boolean isAddNew = true;
        for (ExtendedDataEntity dataEntity : selectRows) {
            DynamicObject user = dataEntity.getDataEntity();
            if (isAddNew && user.getDataEntityState().getFromDatabase()) {
                isAddNew = false;
            }
            userIds.add(user.getLong("id"));
            UserCache.updateUserMainOrgIdCache((String)user.getString("id"), null);
        }
        ThreadPools.executeOnce((String)"UserOperPlugin.saveUserChange", () -> UserOperationUtils.saveUserChange(((ExtendedDataEntity)selectRows.get(0)).getDataEntity(), this.userChangeList));
        HashSet userIdSet = new HashSet(userIds);
        if ("delete".equalsIgnoreCase(operationKey)) {
            logger.debug(operationKey + "\uff1a\u5f00\u59cb\u8bb0\u5f55\u6267\u884c\u4e86\u5220\u9664\u64cd\u4f5c\u7684\u4eba\u5458\u5386\u53f2\u6570\u636e\u3002");
            UserHistoryUtils.saveUserDeleteHistory(userIds);
            YptSynLogUtils.deleteLogByUserIds(userIds);
        } else {
            if (!"disable".equalsIgnoreCase(operationKey)) {
                logger.debug(operationKey + "\uff1a\u4eba\u5458\u6267\u884c\u64cd\u4f5c\u540e\u8bb0\u5f55\u8bb8\u53ef\u5dee\u91cf\u4fe1\u606f\u3002");
                ThreadPools.executeOnce((String)"UserOperPlugin.addUsers2LicGroupDif", () -> LicenseServiceHelper.addUsers2LicGroupDif((Set)userIdSet));
            }
            logger.debug(operationKey + "\uff1a\u5f00\u59cb\u8bb0\u5f55\u4eba\u5458\u64cd\u4f5c\u540e\u7684\u5386\u53f2\u8bb0\u5f55\u3002");
            UserHistoryUtils.saveUserHistory(userIds, (!isAddNew ? 1 : 0) != 0);
        }
    }

    public boolean delYzjUser(BeforeOperationArgs operArgs, List<String> openIds) {
        if (CollectionUtils.isEmpty(openIds)) {
            return true;
        }
        logger.info("@......\u5f00\u59cb\u5220\u9664\u4e91\u4e4b\u5bb6\u4eba\u5458\u3002");
        ArrayList<YzjUserModel> userList = new ArrayList<YzjUserModel>(openIds.size());
        for (String openId : openIds) {
            YzjUserModel userModel = new YzjUserModel();
            userModel.setOpenId(openId);
            userList.add(userModel);
        }
        try {
            this.getYzjUserService().delete(userList);
            for (YzjUserModel userModel : userList) {
                String msg = userModel.getOperMsg();
                if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
                operArgs.setCancelMessage(UserMessage.getMessage((String)"M00030", (Object[])new Object[]{msg}));
                return false;
            }
            logger.info("@......\u5b8c\u6210\u5220\u9664\u4e91\u4e4b\u5bb6\u4eba\u5458\u3002");
        }
        catch (Exception e) {
            logger.info("@......\u5220\u9664\u4e91\u4e4b\u5bb6\u4eba\u5458\u9519\u8bef\uff1a" + e.getMessage());
            operArgs.setCancelMessage(UserMessage.getMessage((String)"M00030", (Object[])new Object[]{e.getMessage()}));
            return false;
        }
        return true;
    }

    public DynamicObject[] genSelectedUserChangeInfo(BeforeOperationArgs e, String userChangeType, boolean findByPhone, List<String> openIds, List<YzjUserModel> addUserList) {
        boolean syncToYzj;
        DynamicObject[] userArr = this.getSelectedUserInfo(e);
        if (userArr == null || userArr.length == 0) {
            return userArr;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<YzjUserModel> noOpenIdUserList = new ArrayList<YzjUserModel>();
        for (DynamicObject user : userArr) {
            this.findYzjOpenIds(openIds, noOpenIdUserList, user);
            this.userChangeList.add(UserOperationUtils.genUserChange(user, userChangeType));
            if ("4".equals(userChangeType)) {
                user.set("fuid", (Object)0L);
                user.set("useropenid", (Object)"");
                user.set("disabler", (Object)currUserId);
                user.set("disabledate", (Object)date);
                continue;
            }
            if ("5".equals(userChangeType)) {
                user.set("disabler", (Object)0L);
                user.set("disabledate", null);
                continue;
            }
            if ("13".equals(userChangeType)) {
                user.set("isforbidden", (Object)1L);
                user.set("userdisablerid", (Object)currUserId);
                user.set("userdisabletime", (Object)date);
                continue;
            }
            if (!"12".equals(userChangeType)) continue;
            user.set("isforbidden", (Object)0L);
            user.set("userdisablerid", (Object)0L);
            user.set("userdisabletime", null);
        }
        boolean bl = syncToYzj = 3 == this.getYzjUserService().getConfig().getSyncMode();
        if (syncToYzj && addUserList != null) {
            for (DynamicObject user : userArr) {
                String status;
                if (!this.isEmployee(user)) continue;
                YzjUserModel yzjUserModel = UserOperationUtils.genUserModel(user);
                if (this.getYzjUserService().getConfig().isDisableuser()) {
                    status = user.getBoolean("enable") ? "1" : "0";
                    yzjUserModel.setStatus(status);
                } else {
                    status = user.getBoolean("isforbidden") ? "1" : "0";
                    yzjUserModel.setStatus(status);
                }
                addUserList.add(yzjUserModel);
            }
        }
        if (syncToYzj && findByPhone) {
            this.getOpenIdByPhone(noOpenIdUserList, openIds);
        }
        return userArr;
    }

    private boolean isEmployee(DynamicObject userObj) {
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return false;
        }
        for (DynamicObject userTypeEditObj : userTypesCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (userTypeObj == null || !"1".equals(userTypeObj.getPkValue().toString())) continue;
            return true;
        }
        return false;
    }

    private void findYzjOpenIds(List<String> openIds, List<YzjUserModel> noOpenIdUserList, DynamicObject userObj) {
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return;
        }
        boolean isStaff = false;
        for (DynamicObject usertypesObj : userTypesCol) {
            DynamicObject usertypeObj = usertypesObj.getDynamicObject("fbasedataId");
            if (usertypeObj == null || !"1".equals(usertypeObj.getString("category"))) continue;
            isStaff = true;
            break;
        }
        if (!isStaff) {
            return;
        }
        String openId = userObj.getString("useropenid");
        if (StringUtils.isBlank((CharSequence)openId)) {
            YzjUserModel userModel = new YzjUserModel();
            userModel.setPhone(userObj.getString("phone"));
            noOpenIdUserList.add(userModel);
            return;
        }
        if (!openIds.contains(openId)) {
            openIds.add(openId);
        }
    }

    private DynamicObject[] getSelectedUserInfo(BeforeOperationArgs e) {
        List dataEntityList = e.getValidExtDataEntities();
        if (Utils.isListEmpty((List)dataEntityList)) {
            return null;
        }
        ArrayList<Long> userIds = new ArrayList<Long>(dataEntityList.size());
        for (ExtendedDataEntity obj : dataEntityList) {
            DynamicObject userObj = obj.getDataEntity();
            userIds.add(userObj.getLong("id"));
        }
        return (DynamicObject[])BusinessDataServiceHelper.load((Object[])userIds.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bos_user").getDataEntityType());
    }

    private void getOpenIdByPhone(List<YzjUserModel> noOpenIdUserList, List<String> openIds) {
        if (noOpenIdUserList.isEmpty()) {
            return;
        }
        this.getYzjUserService().getUser(0, noOpenIdUserList);
        for (YzjUserModel userModel : noOpenIdUserList) {
            String openId = userModel.getOpenId();
            if (!StringUtils.isNotBlank((CharSequence)openId) || !"1".equals(userModel.getStatus()) || openIds.contains(openId)) continue;
            openIds.add(openId);
        }
    }

    public IYzjUserService getYzjUserService() {
        if (this.yzjUserService == null) {
            this.yzjUserService = YzjServiceFactory.getUserService();
        }
        return this.yzjUserService;
    }

    public void setYzjUserService(IYzjUserService yzjUserService) {
        this.yzjUserService = yzjUserService;
    }
}

