/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.sec.user.utils.UserOperationUtils;

public class UserOperationValidator
extends AbstractValidator {
    public void validate() {
        boolean isOperationFromPage = "1".equals(this.getOption().getVariableValue("isFrom_bos_user_Page", "0"));
        boolean isModifyAdminUser = "1".equals(this.getOption().getVariableValue("modifyAdminUser", "0"));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!dataEntity.getDataEntity().getDataEntityState().getFromDatabase() || !isOperationFromPage) continue;
            this.checkUserType(dataEntity, isModifyAdminUser);
        }
    }

    private void checkUserType(ExtendedDataEntity dataEntity, boolean isModifyAdminUser) {
        DynamicObject userObj = dataEntity.getDataEntity();
        String usertype = userObj.getString("usertype");
        if (StringUtils.isBlank((CharSequence)usertype)) {
            this.addErrorMessage(dataEntity, UserMessage.getMessage((String)"M00071"));
            return;
        }
        String errorMsg = "";
        if ("7".equals(usertype)) {
            if (!isModifyAdminUser) {
                errorMsg = UserMessage.getMessage((String)"M00029");
            }
        } else if (!UserOperationUtils.isInsider(userObj)) {
            errorMsg = UserMessage.getMessage((String)"M00071");
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

