/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.permission.util.PhoneI18nValidator;

public class UserPhoneFormatValidatorPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserPhoneFormatValidator());
    }

    private static class UserPhoneFormatValidator
    extends AbstractValidator {
        private UserPhoneFormatValidator() {
        }

        public void validate() {
            Object msg = null;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject userObj = dataEntity.getDataEntity();
                String phone = userObj.getString("phone");
                if (StringUtils.isBlank((CharSequence)phone)) continue;
                PhoneI18nValidator phoneNewValidator = new PhoneI18nValidator(phone, true);
                userObj.set("phone", (Object)phoneNewValidator.getStore());
                String err = phoneNewValidator.getErrorMsg();
                if (!StringUtils.isNotBlank((CharSequence)err)) continue;
                this.addErrorMessage(dataEntity, err);
            }
        }
    }
}

