/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class UserPropertyUniquenessValidator
extends AbstractValidator {
    private List<String> propertyList;
    private Map<Long, String> duplicateUserIdNameMap = new HashMap<Long, String>();

    public UserPropertyUniquenessValidator(List<String> propertyList) {
        this.propertyList = propertyList;
    }

    public void validate() {
        if (CollectionUtils.isEmpty(this.propertyList)) {
            return;
        }
        Map<String, Map<String, Long>> duplicateMap = this.getDuplicateData(this.dataEntities, this.propertyList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject userObj = dataEntity.getDataEntity();
            for (String property : this.propertyList) {
                String value = userObj.getString(property);
                if (StringUtils.isBlank((String)value)) continue;
                Map<String, Long> valueIdMap = duplicateMap.get(property);
                Long duplicateUserId = valueIdMap.get(value);
                Long userId = userObj.getLong("id");
                if (duplicateUserId != null && !duplicateUserId.equals(userId)) {
                    this.addDuplicateErrorMessage(dataEntity, property, duplicateUserId);
                    continue;
                }
                valueIdMap.put(value, userId);
                duplicateMap.put(property, valueIdMap);
                this.duplicateUserIdNameMap.put(userId, userObj.getString("name"));
            }
        }
    }

    private Map<String, Map<String, Long>> getDuplicateData(ExtendedDataEntity[] extendedDataEntity, List<String> propertylist) {
        HashMap propertyMap = new HashMap(propertylist.size());
        for (String key : propertylist) {
            propertyMap.put(key, new ArrayList());
        }
        for (ExtendedDataEntity extendedData : extendedDataEntity) {
            DynamicObject user = extendedData.getDataEntity();
            for (String property : propertylist) {
                String value = user.getString(property);
                if (StringUtils.isBlank((String)value)) continue;
                ((List)propertyMap.get(property)).add(value);
            }
        }
        HashMap<String, Map<String, Long>> returnMap = new HashMap<String, Map<String, Long>>(propertylist.size());
        for (String property : propertylist) {
            Map<String, Long> result = this.getDuplicateData((List)propertyMap.get(property), property);
            returnMap.put(property, result);
        }
        return returnMap;
    }

    private Map<String, Long> getDuplicateData(List<String> values, String property) {
        int count = values.size();
        HashMap<String, Long> duplicatePropValueMap = new HashMap<String, Long>(count);
        if (count == 0) {
            return duplicatePropValueMap;
        }
        QFilter valueQFilter = new QFilter(property, "in", values);
        QFilter userTypeQFilter = new QFilter("usertype", "!=", (Object)"7");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{valueQFilter, userTypeQFilter, enableQFilter};
        String selectFields = "id".equalsIgnoreCase(property) || "name".equalsIgnoreCase(property) ? "id,name" : "id,name," + property;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Long userId = row.getLong("id");
                duplicatePropValueMap.put(row.getString(property), userId);
                this.duplicateUserIdNameMap.put(userId, row.getString("name"));
            }
        }
        return duplicatePropValueMap;
    }

    private void addDuplicateErrorMessage(ExtendedDataEntity dataEntity, String property, Long duplicateUserId) {
        DynamicObject userObj;
        String msg;
        switch (property) {
            case "number": {
                msg = "M00076";
                break;
            }
            case "username": {
                msg = "M00077";
                break;
            }
            case "phone": {
                msg = "M00078";
                break;
            }
            case "email": {
                msg = "M00079";
                break;
            }
            case "idcard": {
                msg = "M00080";
                break;
            }
            default: {
                msg = "M00075";
            }
        }
        String duplicateName = this.duplicateUserIdNameMap.get(duplicateUserId);
        if (duplicateName == null && duplicateUserId != null && (userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)duplicateUserId, (String)"bos_user", (String)"name")) != null) {
            duplicateName = userObj.getString("name");
        }
        this.addErrorMessage(dataEntity, UserMessage.getMessage((String)msg, (Object[])new Object[]{duplicateName}));
    }
}

