/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.license.api.ILicenseService;
import kd.bos.org.utils.Utils;
import kd.bos.sec.user.UserOperPlugin;
import kd.bos.sec.user.UserSaveValidator;
import kd.bos.sec.user.UserSyncYzjValidator;
import kd.bos.sec.user.utils.UserOperationExecutor;
import kd.bos.service.ServiceFactory;

public class UserSaveServicePlugin
extends UserOperPlugin {
    private Set<Long> newUserIDs = new HashSet<Long>(16);

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String sources = this.getOption().getVariableValue("sources", null);
        UserSaveValidator userSaveValidator = new UserSaveValidator();
        userSaveValidator.setSource(sources);
        e.addValidator((AbstractValidator)userSaveValidator);
        e.addValidator((AbstractValidator)new UserSyncYzjValidator(this.getYzjUserService()));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List selectRows = e.getValidExtDataEntities();
        if (Utils.isListEmpty((List)selectRows)) {
            return;
        }
        UserOperationExecutor executor = new UserOperationExecutor();
        for (ExtendedDataEntity entityObj : selectRows) {
            DynamicObject user = entityObj.getDataEntity();
            String msg = executor.beforeSaveOperation(user, this.userChangeList);
            if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
            e.setCancelMessage(msg);
            e.cancel = true;
        }
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (!"save".equals(operationKey)) {
            return;
        }
        HashSet<Long> newUserIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            boolean fromDatabase = dynamicObject.getDataEntityState().getFromDatabase();
            if (fromDatabase) continue;
            long userId = Long.parseLong(dynamicObject.getPkValue().toString());
            boolean isStaff = UserUtils.checkUserType((DynamicObject)dynamicObject, (Long)1L);
            newUserIds.add(userId);
            if (!isStaff) continue;
            this.newUserIDs.add(userId);
        }
        HashMap<String, HashSet<Long>> interNationalEventParam = new HashMap<String, HashSet<Long>>(1);
        interNationalEventParam.put("newUserIds", newUserIds);
        String userSaveEventOperationParams = SerializationUtils.toJsonString(interNationalEventParam);
        this.getOption().setVariableValue("userSaveEventOperationParams", userSaveEventOperationParams);
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.newUserIDs.isEmpty()) {
            return;
        }
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        service.addUserAllUserLicGroup(new ArrayList<Long>(this.newUserIDs));
    }
}

