/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.util.PhoneI18nValidator;
import kd.bos.sec.user.utils.UserOperateValidator;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserSaveValidator
extends AbstractValidator {
    private String source = null;

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void validate() {
        HashSet<Long> orgIdSet = new HashSet<Long>();
        ArrayList<String> phoneList = new ArrayList<String>();
        ArrayList<String> emailList = new ArrayList<String>();
        this.validateData(orgIdSet, phoneList, emailList);
        this.validateDataBase(orgIdSet, phoneList, emailList);
        this.contactValidate();
    }

    private void validateData(Set<Long> orgIdSet, List<String> phoneList, List<String> emailList) {
        Map userTypeMap = null;
        ArrayList<Long> updateIds = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        Map enableLangMap = BaseUtils.getEnableLangMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryEntity;
            DynamicObject userObj = dataEntity.getDataEntity();
            long userId = userObj.getLong("id");
            boolean enable = userObj.getBoolean("enable");
            if (userObj.getDataEntityState().getFromDatabase()) {
                updateIds.add(userId);
                dataEntityMap.put(userId, dataEntity);
            }
            if (userTypeMap == null) {
                userTypeMap = UserUtils.getAllUserType();
            }
            UserUtils.parseUserType((DynamicObject)userObj, (Map)userTypeMap);
            UserOperateValidator validator = new UserOperateValidator(userObj);
            validator.setEnableLangMap(enableLangMap);
            String errorMsg = validator.check();
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            String phone = userObj.getString("phone");
            if (enable && StringUtils.isNotBlank((CharSequence)phone)) {
                if (phoneList.contains(phone)) {
                    this.addPhoneDuplicateError(dataEntity);
                    continue;
                }
                phoneList.add(phone);
            }
            String email = userObj.getString("email");
            if (enable && StringUtils.isNotBlank((CharSequence)email)) {
                if (emailList.contains(email)) {
                    this.addEmailDuplicateError(dataEntity);
                    continue;
                }
                emailList.add(email);
            }
            if (Utils.isListEmpty((List)(entryEntity = userObj.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject entityObj : entryEntity) {
                DynamicObject orgObj = entityObj.getDynamicObject("dpt");
                if (orgObj == null) continue;
                orgIdSet.add(orgObj.getLong("id"));
            }
        }
        this.validateUserType(updateIds, dataEntityMap);
    }

    private void validateUserType(List<Long> updateIds, Map<Long, ExtendedDataEntity> dataEntityMap) {
        if (updateIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", updateIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] userObjArr = BusinessDataServiceHelper.load((String)"bos_user", (String)"usertypes", (QFilter[])filters);
        Long staffTypeId = Long.valueOf("1");
        List partnerUserTypeIds = UserUtils.getUserTypeByCategory((String)"2");
        for (DynamicObject userObj : userObjArr) {
            Set<Long> oldUserTypeIds = this.getUserTypeIds(userObj);
            if (this.includePartnerUserType(oldUserTypeIds, partnerUserTypeIds)) continue;
            long userId = userObj.getLong("id");
            ExtendedDataEntity dataEntity = dataEntityMap.get(userId);
            boolean changeUserType = false;
            Set<Long> newUserTypeIds = this.getUserTypeIds(dataEntity.getDataEntity());
            int oldCount = oldUserTypeIds.size();
            int newCount = newUserTypeIds.size();
            if (oldCount == 0) {
                changeUserType = false;
            } else if (this.getSource() != null && newCount > 1 && newUserTypeIds.contains(staffTypeId)) {
                changeUserType = false;
            } else if (oldCount != newCount) {
                changeUserType = true;
            } else {
                oldUserTypeIds.addAll(newUserTypeIds);
                if (oldUserTypeIds.size() != oldCount) {
                    changeUserType = true;
                }
            }
            if (!changeUserType) continue;
            this.addMessage(dataEntity, UserMessage.getMessage((String)"M00074"));
        }
    }

    private boolean includePartnerUserType(Set<Long> userTypeIds, List<Long> partnerUserTypeIds) {
        if (CollectionUtils.isEmpty(userTypeIds) || CollectionUtils.isEmpty(partnerUserTypeIds)) {
            return false;
        }
        for (Long userTypeId : userTypeIds) {
            if (!partnerUserTypeIds.contains(userTypeId)) continue;
            return true;
        }
        return false;
    }

    private Set<Long> getUserTypeIds(DynamicObject userObj) {
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        HashSet<Long> oldUserTypeIds = new HashSet<Long>(userTypesCol.size());
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return oldUserTypeIds;
        }
        for (DynamicObject userTypeBdObj : userTypesCol) {
            DynamicObject usertypeObj = userTypeBdObj.getDynamicObject("fbasedataId");
            if (usertypeObj == null) continue;
            oldUserTypeIds.add(usertypeObj.getLong("id"));
        }
        return oldUserTypeIds;
    }

    private void validateDataBase(Set<Long> orgIdSet, List<String> phoneList, List<String> emailList) {
        Map<String, Long> duplicatePhoneMap = this.getDuplicatePhone(phoneList);
        Map<String, Long> duplicateEmailMap = this.getDuplicateEmail(emailList);
        Map<Long, DynamicObject> orgStrutMap = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryEntity;
            Long existUserId;
            Long existUserId2;
            DynamicObject userObj = dataEntity.getDataEntity();
            long userId = userObj.getLong("id");
            boolean enable = userObj.getBoolean("enable");
            String phone = userObj.getString("phone");
            if (enable && StringUtils.isNotBlank((CharSequence)phone) && (existUserId2 = duplicatePhoneMap.get(phone)) != null && userId != existUserId2) {
                this.addPhoneDuplicateError(dataEntity);
            }
            String email = userObj.getString("email");
            if (enable && StringUtils.isNotBlank((CharSequence)email) && (existUserId = duplicateEmailMap.get(email)) != null && userId != existUserId) {
                this.addEmailDuplicateError(dataEntity);
            }
            if (Utils.isListEmpty((List)(entryEntity = userObj.getDynamicObjectCollection("entryentity"))) || CollectionUtils.isEmpty(orgIdSet)) continue;
            for (DynamicObject entityObj : entryEntity) {
                DynamicObject orgObj = entityObj.getDynamicObject("dpt");
                if (orgObj == null) continue;
                if (orgStrutMap == null) {
                    orgStrutMap = UserOperationUtils.getOrgStructure(orgIdSet, UserOperationUtils.getOrgStructureDynamicObjectType(userObj));
                }
                entityObj.set("orgstructure", (Object)orgStrutMap.get(orgObj.getLong("id")));
            }
        }
    }

    private void addPhoneDuplicateError(ExtendedDataEntity dataEntity) {
        this.addErrorMessage(dataEntity, UserMessage.getMessage((String)"M00031"));
    }

    private void addEmailDuplicateError(ExtendedDataEntity dataEntity) {
        this.addErrorMessage(dataEntity, UserMessage.getMessage((String)"M00032"));
    }

    private Map<String, Long> getDuplicatePhone(List<String> phoneList) {
        int count = phoneList.size();
        HashMap<String, Long> duplicatePhoneMap = new HashMap<String, Long>(count);
        if (count == 0) {
            return duplicatePhoneMap;
        }
        String selectFields = "id,phone,usertype";
        QFilter phoneFilter = new QFilter("phone", "in", phoneList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{phoneFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserSaveValidator.isPhoneDuplicate", (String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                if ("7".equals(row.getString("usertype"))) continue;
                duplicatePhoneMap.put(row.getString("phone"), row.getLong("id"));
            }
        }
        return duplicatePhoneMap;
    }

    private Map<String, Long> getDuplicateEmail(List<String> emailList) {
        int count = emailList.size();
        HashMap<String, Long> duplicateEmailMap = new HashMap<String, Long>(count);
        if (count == 0) {
            return duplicateEmailMap;
        }
        String selectFields = "id,email,usertype";
        QFilter phoneFilter = new QFilter("email", "in", emailList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{phoneFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserSaveValidator.isEmailDuplicate", (String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                if ("7".equals(row.getString("usertype"))) continue;
                duplicateEmailMap.put(row.getString("email"), row.getLong("id"));
            }
        }
        return duplicateEmailMap;
    }

    private void contactValidate() {
        LinkedHashMap<String, LinkedHashMap> phoneMap = new LinkedHashMap<String, LinkedHashMap>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject userEntity = dataEntity.getDataEntity();
            DynamicObjectCollection contactEntity = userEntity.getDynamicObjectCollection("contactentity");
            if (Utils.isListEmpty((List)contactEntity)) continue;
            HashMap<String, String> duplicateMap = new HashMap<String, String>(contactEntity.size());
            ArrayList<String> sameContactTypeList = new ArrayList<String>(contactEntity.size());
            for (DynamicObject contactObj : contactEntity) {
                String error;
                String contactName;
                DynamicObject contactTypeObj = contactObj.getDynamicObject("contacttype");
                if (contactTypeObj == null) {
                    this.addMessage(dataEntity, UserMessage.getMessage((String)"M00025", (Object[])new Object[]{contactObj.get("seq")}));
                    continue;
                }
                String contactType = contactTypeObj.getString("number");
                boolean isDefault = contactObj.getBoolean("isdefault");
                String contact = contactObj.getString("contact");
                contact = contact.trim();
                contactObj.set("contact", (Object)contact);
                if (StringUtils.isBlank((CharSequence)contact)) {
                    this.addMessage(dataEntity, UserMessage.getMessage((String)"M00026", (Object[])new Object[]{contactObj.get("seq")}));
                    continue;
                }
                if ("phone".equals(contactType)) {
                    PhoneI18nValidator phoneValidator = new PhoneI18nValidator(contact, true, false);
                    contact = phoneValidator.getStore();
                    contactObj.set("contact", (Object)contact);
                    phoneMap.computeIfAbsent(phoneValidator.getFormattedPhone(), v -> new LinkedHashMap(4)).put(contactObj.get("seq"), dataEntity);
                }
                if (contact.equals(duplicateMap.get(contactName = contactTypeObj.getString("name")))) {
                    this.addMessage(dataEntity, UserMessage.getMessage((String)"M00027", (Object[])new Object[]{contactObj.get("seq"), contactName}));
                    continue;
                }
                duplicateMap.put(contactName, contact);
                if ("email".equals(contactType) && !UserOperationUtils.isEmail(contact)) {
                    error = String.format(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u7b2c%s\u884c\uff1a", (String)"UserOperateValidator_3", (String)"bos-sec-user", (Object[])new Object[0]), contactObj.get("seq")) + UserMessage.getMessage((String)"M00016");
                    this.addMessage(dataEntity, error);
                    continue;
                }
                if (!isDefault) continue;
                if (sameContactTypeList.contains(contactType)) {
                    error = String.format(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u7b2c%1$s\u884c,\u6bcf\u79cd\u8054\u7cfb\u65b9\u5f0f\u7c7b\u578b\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"UserOperateValidator_4", (String)"bos-sec-user", (Object[])new Object[0]), contactObj.get("seq"));
                    this.addMessage(dataEntity, error);
                    continue;
                }
                sameContactTypeList.add(contactType);
            }
        }
        if (phoneMap.isEmpty()) {
            return;
        }
        PhoneI18nValidator phoneValidator = new PhoneI18nValidator(new ArrayList(phoneMap.keySet()));
        Map phoneMessageMap = phoneValidator.batchCheck();
        for (Map.Entry pEntry : phoneMap.entrySet()) {
            Map rowEntityMap;
            String phone = (String)pEntry.getKey();
            String error = (String)phoneMessageMap.get(phone);
            if (StringUtils.isBlank((CharSequence)error) || (rowEntityMap = (Map)pEntry.getValue()) == null) continue;
            for (Map.Entry entityEntry : rowEntityMap.entrySet()) {
                this.addMessage((ExtendedDataEntity)entityEntry.getValue(), String.format(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u7b2c%s\u884c\uff1a", (String)"UserOperateValidator_3", (String)"bos-sec-user", (Object[])new Object[0]), entityEntry.getKey()) + error);
            }
        }
    }
}

