/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjApiRes;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.user.YzjEmailParam;
import kd.bos.yzj.model.user.YzjPhoneParam;
import kd.bos.yzj.model.user.YzjUserModel;
import kd.bos.yzj.service.YzjServiceFactory;

public class UserSyncYzjValidator
extends AbstractValidator {
    public static final Log logger = LogFactory.getLog(UserSyncYzjValidator.class);
    private IYzjUserService yzjUserService;
    private YzjConfig yzjConfig;
    private Map<String, ExtendedDataEntity> userEntityMap;
    private Map<String, List<String>> oldChargeOrgMap = new HashMap<String, List<String>>();

    public UserSyncYzjValidator(IYzjUserService yzjUserService) {
        this.yzjUserService = yzjUserService;
        if (yzjUserService == null) {
            yzjUserService = YzjServiceFactory.getUserService();
        }
        this.yzjConfig = yzjUserService.getConfig();
    }

    public void validate() {
        if (3 == this.yzjConfig.getSyncMode()) {
            if (this.userEntityMap == null) {
                this.userEntityMap = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
            }
            this.validateSyncToYzj();
        }
    }

    private boolean validateSyncToYzj() {
        int count = this.dataEntities.length;
        ArrayList<YzjUserModel> openIdQueryList = new ArrayList<YzjUserModel>(count);
        ArrayList<YzjUserModel> phoneQueryList = new ArrayList<YzjUserModel>(count);
        ArrayList<YzjUserModel> addUserList = new ArrayList<YzjUserModel>(count);
        HashSet<Integer> errorDataIndexSet = this.getErrorDataIndex();
        ArrayList<String> openIds = new ArrayList<String>();
        for (ExtendedDataEntity userEntity : this.dataEntities) {
            YzjUserModel yzjUserModel;
            String email;
            String phone;
            DynamicObject userObj;
            if (errorDataIndexSet.contains(userEntity.getDataEntityIndex()) || !this.isEmployee(userObj = userEntity.getDataEntity()) || !userObj.getBoolean("enable")) continue;
            boolean unableSync = true;
            String openId = userObj.getString("useropenid");
            if (StringUtils.isNotBlank((CharSequence)openId)) {
                unableSync = false;
                this.userEntityMap.put(openId, userEntity);
                openIds.add(openId);
            }
            if (StringUtils.isNotBlank((CharSequence)(phone = userObj.getString("phone")))) {
                unableSync = false;
                this.userEntityMap.put(phone, userEntity);
            }
            if (StringUtils.isNotBlank((CharSequence)(email = userObj.getString("email")))) {
                unableSync = false;
                this.userEntityMap.put(email, userEntity);
            }
            if (unableSync) {
                logger.info(userObj.getString("number") + "\uff1a\u627e\u4e0d\u5230\u4e0e\u4e91\u4e4b\u5bb6\u5339\u914d\u4eba\u5458\u7684\u5b57\u6bb5\uff0c\u4e0d\u6267\u884c\u4eba\u5458\u4fe1\u606f\u540c\u6b65\u5230\u4e91\u4e4b\u5bb6\u3002");
                continue;
            }
            YzjUserModel queryModel = new YzjUserModel();
            queryModel.setOpenId(openId);
            queryModel.setPhone(phone);
            queryModel.setEmail(email);
            if (StringUtils.isNotBlank((CharSequence)openId)) {
                openIdQueryList.add(queryModel);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                phoneQueryList.add(queryModel);
                continue;
            }
            if (1000 == addUserList.size()) {
                this.add(addUserList);
                addUserList.clear();
            }
            if ((yzjUserModel = UserOperationUtils.genUserModel(userObj)).isOperSuccess()) {
                addUserList.add(yzjUserModel);
                continue;
            }
            this.addErrorMessage(userEntity, yzjUserModel.getOperMsg());
        }
        this.getOldChargeOrg(openIds);
        this.add(addUserList);
        BaseBatchHandler.handle(openIdQueryList, batchList -> this.batchSync(batchList, true));
        BaseBatchHandler.handle(phoneQueryList, batchList -> this.batchSync(batchList, false));
        return true;
    }

    private void getOldChargeOrg(List<String> openIds) {
        if (openIds.isEmpty()) {
            return;
        }
        QFilter openIdFilter = new QFilter("useropenid", "in", openIds);
        QFilter chargeFilter = new QFilter("entryentity.isincharge", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{openIdFilter, chargeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserSyncYzjValidator.getOldChargeOrg", (String)"bos_user", (String)"id,useropenid,entryentity.dpt.fyzjorgid fyzjorgid", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                String yzjOrgId = row.getString("fyzjorgid");
                if (StringUtils.isBlank((CharSequence)yzjOrgId)) continue;
                String openId = row.getString("useropenid");
                List<String> yzjOrgIds = this.oldChargeOrgMap.get(openId);
                if (yzjOrgIds == null) {
                    yzjOrgIds = new ArrayList<String>();
                    this.oldChargeOrgMap.put(openId, yzjOrgIds);
                }
                yzjOrgIds.add(yzjOrgId);
            }
        }
    }

    private HashSet<Integer> getErrorDataIndex() {
        ValidateContext validateContext = this.getValidateContext();
        if (validateContext == null) {
            return new HashSet<Integer>(0);
        }
        ValidateResultCollection validateResults = validateContext.getValidateResults();
        if (validateResults == null) {
            return new HashSet<Integer>(0);
        }
        return validateResults.getErrorDataIndexs();
    }

    private void batchSync(List<YzjUserModel> queryList, boolean queryByOpenId) {
        int count = queryList.size();
        if (count == 0) {
            return;
        }
        ArrayList<YzjUserModel> addUserList = new ArrayList<YzjUserModel>(count);
        ArrayList<YzjUserModel> updateUserList = new ArrayList<YzjUserModel>(count);
        ArrayList<YzjPhoneParam> updatePhoneList = new ArrayList<YzjPhoneParam>(count);
        ArrayList<YzjEmailParam> updateEmailList = new ArrayList<YzjEmailParam>(count);
        List<Map<String, Object>> yzjDataMapList = null;
        yzjDataMapList = queryByOpenId ? this.getExistsUserByOpenId(queryList) : this.getExistsUserByPhone(queryList);
        ArrayList<YzjUserModel> phoneQueryList = new ArrayList<YzjUserModel>(count);
        for (YzjUserModel userModel : queryList) {
            ExtendedDataEntity userEntity = this.getUserEntity(userModel.getOpenId(), userModel.getPhone(), userModel.getEmail());
            if (userEntity == null) continue;
            DynamicObject userObj = userEntity.getDataEntity();
            boolean isUserExists = false;
            for (Map<String, Object> yzjUserMap : yzjDataMapList) {
                if ("0".equals(yzjUserMap.get("status"))) continue;
                if (queryByOpenId) {
                    if (userModel.getOpenId().equals(yzjUserMap.get("openId"))) {
                        isUserExists = true;
                    }
                } else if (userModel.getPhone().equals(yzjUserMap.get("phone"))) {
                    isUserExists = true;
                }
                if (!isUserExists) continue;
                this.parseYzjUserInfo(userEntity, yzjUserMap);
                YzjUserModel yzjUserModel = UserOperationUtils.genUserModel(userObj);
                if (yzjUserModel.isOperSuccess()) {
                    String currentYzjEmail;
                    updateUserList.add(yzjUserModel);
                    String currentYzjPhone = String.valueOf(yzjUserMap.get("phone"));
                    if (!currentYzjPhone.equals(userModel.getPhone())) {
                        YzjPhoneParam phoneParam = new YzjPhoneParam(userModel.getOpenId(), userModel.getPhone());
                        updatePhoneList.add(phoneParam);
                    }
                    if ((currentYzjEmail = String.valueOf(yzjUserMap.get("email"))).equals(userModel.getEmail())) break;
                    YzjEmailParam emailParam = new YzjEmailParam(userModel.getOpenId(), userModel.getEmail());
                    updateEmailList.add(emailParam);
                    break;
                }
                this.addErrorMessage(userEntity, yzjUserModel.getOperMsg());
                break;
            }
            if (isUserExists) continue;
            if (queryByOpenId && StringUtils.isNotBlank((CharSequence)userModel.getPhone())) {
                phoneQueryList.add(userModel);
                continue;
            }
            YzjUserModel yzjUserModel = UserOperationUtils.genUserModel(userObj);
            if (yzjUserModel.isOperSuccess()) {
                addUserList.add(yzjUserModel);
                continue;
            }
            this.addErrorMessage(userEntity, yzjUserModel.getOperMsg());
        }
        this.add(addUserList);
        this.update(updateUserList);
        this.updatePhone(updatePhoneList);
        this.updateEmail(updateEmailList);
        this.batchSync(phoneQueryList, false);
    }

    private boolean isEmployee(DynamicObject userObj) {
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return false;
        }
        for (DynamicObject userTypeEditObj : userTypesCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (userTypeObj == null || !"1".equals(userTypeObj.getPkValue().toString())) continue;
            return true;
        }
        return false;
    }

    private void parseYzjUserInfo(ExtendedDataEntity userEntity, Map<String, Object> yzjUserMap) {
        Object jobNo;
        if (userEntity == null || yzjUserMap == null) {
            return;
        }
        String openId = String.valueOf(yzjUserMap.get("openId"));
        this.userEntityMap.put(openId, userEntity);
        DynamicObject userObj = userEntity.getDataEntity();
        String eid = this.yzjConfig.getEid();
        userObj.set("eid", (Object)eid);
        userObj.set("tid", (Object)eid);
        userObj.set("useropenid", (Object)openId);
        userObj.set("fuid", yzjUserMap.get("uid"));
        if (StringUtils.isBlank((Object)userObj.get("phone"))) {
            userObj.set("phone", yzjUserMap.get("phone"));
        }
        if (StringUtils.isBlank((Object)userObj.get("email"))) {
            userObj.set("email", yzjUserMap.get("email"));
        }
        if (StringUtils.isNotBlank((Object)(jobNo = yzjUserMap.get("jobNo"))) && StringUtils.isBlank((Object)userObj.get("number"))) {
            userObj.set("number", jobNo);
        }
    }

    private List<Map<String, Object>> getExistsUserByPhone(List<YzjUserModel> yzjUserModelList) {
        List yzjDataMapList = this.yzjUserService.getUsers(0, yzjUserModelList);
        if (yzjDataMapList == null) {
            yzjDataMapList = Collections.EMPTY_LIST;
        }
        return yzjDataMapList;
    }

    private List<Map<String, Object>> getExistsUserByOpenId(List<YzjUserModel> yzjUserModelList) {
        List yzjDataMapList = this.yzjUserService.getUsers(1, yzjUserModelList);
        if (yzjDataMapList == null) {
            yzjDataMapList = Collections.EMPTY_LIST;
        }
        return yzjDataMapList;
    }

    private boolean add(List<YzjUserModel> userList) {
        if (userList.isEmpty()) {
            return true;
        }
        this.yzjUserService.add(userList);
        int count = userList.size();
        ArrayList<YzjUserModel> yzjUserModelList = new ArrayList<YzjUserModel>(count);
        ArrayList<String> successOpenIds = new ArrayList<String>(count);
        HashMap<String, ExtendedDataEntity> successUserEntityMap = new HashMap<String, ExtendedDataEntity>(count);
        for (YzjUserModel yzjUser : userList) {
            ExtendedDataEntity userEntity = this.getUserEntity(yzjUser.getOpenId(), yzjUser.getPhone(), yzjUser.getEmail());
            if (userEntity == null || !this.isSyncSuccess(yzjUser, userEntity)) continue;
            String openId = yzjUser.getOpenId();
            successOpenIds.add(openId);
            successUserEntityMap.put(openId, userEntity);
        }
        this.removeExistsOpenIdForAdd(successOpenIds);
        for (YzjUserModel yzjUser : userList) {
            String openId = yzjUser.getOpenId();
            if (!successOpenIds.contains(openId)) continue;
            ExtendedDataEntity userEntity = (ExtendedDataEntity)successUserEntityMap.get(openId);
            String phone = yzjUser.getPhone();
            String email = yzjUser.getEmail();
            DynamicObject userObj = userEntity.getDataEntity();
            userObj.set("phone", (Object)phone);
            userObj.set("email", (Object)email);
            userObj.set("useropenid", (Object)openId);
            YzjUserModel queryModel = new YzjUserModel();
            queryModel.setName(userObj.getString("name"));
            queryModel.setOpenId(openId);
            queryModel.setPhone(phone);
            queryModel.setEmail(email);
            yzjUserModelList.add(queryModel);
            this.updateYzjOrgAdmin(yzjUser);
        }
        this.writeBackYzjUserInfo(yzjUserModelList, successUserEntityMap);
        return true;
    }

    private void removeExistsOpenIdForAdd(List<String> successOpenIds) {
        QFilter openIdFilter = new QFilter("useropenid", "in", successOpenIds);
        QFilter[] filters = new QFilter[]{openIdFilter};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"useropenid", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)userObjMap)) {
            return;
        }
        for (DynamicObject userObj : userObjMap.values()) {
            successOpenIds.remove(userObj.getString("useropenid"));
        }
    }

    private void writeBackYzjUserInfo(List<YzjUserModel> yzjUserModelList, Map<String, ExtendedDataEntity> successUserEntityMap) {
        if (yzjUserModelList.isEmpty()) {
            return;
        }
        List<Map<String, Object>> userList = this.getExistsUserByOpenId(yzjUserModelList);
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        for (Map<String, Object> mpUser : userList) {
            String openId = String.valueOf(mpUser.get("openId"));
            this.parseYzjUserInfo(successUserEntityMap.get(openId), mpUser);
        }
    }

    private ExtendedDataEntity getUserEntity(String openId, String phone, String email) {
        ExtendedDataEntity userEntity = null;
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            userEntity = this.userEntityMap.get(openId);
        }
        if (userEntity != null) {
            return userEntity;
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            userEntity = this.userEntityMap.get(phone);
        }
        if (userEntity != null) {
            return userEntity;
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            userEntity = this.userEntityMap.get(email);
        }
        return userEntity;
    }

    private boolean update(List<YzjUserModel> userList) {
        if (userList.isEmpty()) {
            return true;
        }
        this.yzjUserService.update(userList);
        for (YzjUserModel yzjUser : userList) {
            ExtendedDataEntity userEntity = this.getUserEntity(yzjUser.getOpenId(), yzjUser.getPhone(), yzjUser.getEmail());
            if (userEntity == null || !this.isSyncSuccess(yzjUser, userEntity)) continue;
            this.updateYzjOrgAdmin(yzjUser);
        }
        return true;
    }

    private boolean isSyncSuccess(YzjUserModel yzjUser, ExtendedDataEntity userEntity) {
        boolean success = yzjUser.isOperSuccess();
        if (!success) {
            String msg = UserMessage.getMessage((String)"M00033", (Object[])new Object[]{yzjUser.getOperMsg()});
            this.addErrorMessage(userEntity, msg);
            yzjUser.setOperMsg(msg);
        }
        return success;
    }

    private boolean updatePhone(List<YzjPhoneParam> params) {
        if (params.isEmpty()) {
            return true;
        }
        List resList = this.yzjUserService.batchUpdatePhone(params);
        for (YzjApiRes res : resList) {
            ExtendedDataEntity userEntity = this.getUserEntity(res.getMsgId(), res.getMsgId(), "");
            if (userEntity == null || res.isSuccess()) continue;
            String errorMsg = UserMessage.getMessage((String)"M00034", (Object[])new Object[]{res.getMsg()});
            this.addErrorMessage(userEntity, errorMsg);
        }
        return true;
    }

    private boolean updateEmail(List<YzjEmailParam> params) {
        if (params.isEmpty()) {
            return true;
        }
        List resList = this.yzjUserService.batchUpdateEmail(params);
        for (YzjApiRes res : resList) {
            ExtendedDataEntity userEntity = this.getUserEntity(res.getMsgId(), "", res.getMsgId());
            if (userEntity == null || res.isSuccess()) continue;
            String errorMsg = UserMessage.getMessage((String)"M00035", (Object[])new Object[]{res.getMsg()});
            this.addErrorMessage(userEntity, errorMsg);
        }
        return true;
    }

    private void updateYzjOrgAdmin(YzjUserModel userModel) {
        HashSet<String> commonOrgIds = new HashSet<String>(16);
        List<String> oldYzjOrgIds = this.oldChargeOrgMap.get(userModel.getOpenId());
        if (oldYzjOrgIds == null) {
            oldYzjOrgIds = new ArrayList<String>(0);
        } else {
            commonOrgIds.addAll(oldYzjOrgIds);
        }
        List curYzjOrgIds = userModel.getChargeOrgList() == null ? new ArrayList(0) : userModel.getChargeOrgList();
        commonOrgIds.addAll(curYzjOrgIds);
        if (commonOrgIds.isEmpty()) {
            return;
        }
        String selectFields = "id,org,yzjorgid,fullname,parent";
        QFilter yzjIdFilter = new QFilter("yzjorgid", "in", commonOrgIds);
        yzjIdFilter.or(new QFilter("org", "=", (Object)100000L));
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter[] filters = new QFilter[]{yzjIdFilter, viewFilter};
        Map orgStructureObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (CollectionUtils.isEmpty((Map)orgStructureObjMap)) {
            return;
        }
        String rootFullName = "";
        ArrayList<YzjUserModel> delList = new ArrayList<YzjUserModel>();
        ArrayList<YzjUserModel> addList = new ArrayList<YzjUserModel>();
        String openId = userModel.getOpenId();
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        for (DynamicObject structObj : orgStructureObjMap.values()) {
            DynamicObject orgObj;
            String fullName = structObj.getString("fullname");
            if (StringUtils.isBlank((CharSequence)fullName) || (orgObj = structObj.getDynamicObject("org")) == null) continue;
            long orgId = orgObj.getLong("id");
            if (100000L == orgId) {
                rootFullName = fullName;
            }
            String yzjOrgId = structObj.getString("yzjorgid");
            if (StringUtils.isBlank((CharSequence)rootFullName) || !commonOrgIds.contains(yzjOrgId)) continue;
            YzjUserModel yzjUser = new YzjUserModel();
            yzjUser.setOpenId(openId);
            String department = rootFullName;
            if (!rootFullName.equals(fullName)) {
                department = fullName.substring(rootFullName.length() + 1);
                department = department.replace(fullNameSep, "\\");
            }
            yzjUser.setDepartment(department);
            yzjUser.setDepartmentID(orgId);
            if (oldYzjOrgIds.contains(yzjOrgId)) {
                delList.add(yzjUser);
            }
            if (!curYzjOrgIds.contains(yzjOrgId)) continue;
            addList.add(yzjUser);
        }
        this.delYzjOrgAdmin(delList);
        this.addYzjOrgAdmin(addList);
    }

    private boolean delYzjOrgAdmin(List<YzjUserModel> delList) {
        if (delList.size() == 0) {
            return true;
        }
        this.yzjUserService.deleteOrgAdmin(delList);
        for (YzjUserModel user : delList) {
            if (user.isOperSuccess() || !StringUtils.isNotBlank((CharSequence)user.getOperMsg())) continue;
            logger.info(user.getOpenId() + "\uff1a" + UserMessage.getMessage((String)"M00036", (Object[])new Object[]{user.getOperMsg()}));
            return false;
        }
        return true;
    }

    private boolean addYzjOrgAdmin(List<YzjUserModel> addList) {
        if (addList.size() == 0) {
            return true;
        }
        this.yzjUserService.addOrgAdmin(addList);
        for (YzjUserModel user : addList) {
            if (user.isOperSuccess() || !StringUtils.isNotBlank((CharSequence)user.getOperMsg())) continue;
            logger.info(user.getOpenId() + "\uff1a" + UserMessage.getMessage((String)"M00037", (Object[])new Object[]{user.getOperMsg()}));
            return false;
        }
        return true;
    }

    public void setDataEntities(ExtendedDataEntity[] dataEntities) {
        super.setDataEntities(dataEntities);
        if (dataEntities != null) {
            this.userEntityMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        }
    }
}

