/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.org.utils.Utils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;

public class UsernameAutoAssignServicePlugin
extends AbstractOperationServicePlugIn {
    private static final int THREAD_COUNT = 2;
    private final List<String> pList = new Vector<String>();
    private DynamicObject pStrategyObj;

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] userObjs = e.getDataEntities();
        if (userObjs == null || userObjs.length == 0) {
            return;
        }
        this.presetOnAddValidators(userObjs);
        HashSet<String> lowerCaseUserNames = new HashSet<String>(userObjs.length);
        this.setDataBeforeValidators(userObjs, lowerCaseUserNames);
        this.setUsernameByFullPinyin(userObjs, lowerCaseUserNames);
    }

    private void presetOnAddValidators(DynamicObject[] dataEntities) {
        int triggerCount = 10;
        if (dataEntities.length < triggerCount) {
            return;
        }
        int newCount = 0;
        for (DynamicObject userObj : dataEntities) {
            if (!StringUtils.isBlank((Object)userObj.get("password"))) continue;
            ++newCount;
        }
        if (newCount < triggerCount) {
            return;
        }
        int batch = newCount / 2 + 1;
        for (int i = 0; i < 2; ++i) {
            ThreadPools.executeOnce((String)"UsernameAutoAssignServicePlugin.onAddValidators.preset", () -> {
                for (int m = 0; m < batch; ++m) {
                    this.pList.add(UserServiceHelper.getUserDefaultPsw());
                }
            });
        }
    }

    private DynamicObject getDefaultPswStrategy() {
        if (this.pStrategyObj != null) {
            return this.pStrategyObj;
        }
        MainEntityType userEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        BasedataProp pswstrategyPro = (BasedataProp)userEntityType.getProperty("pswstrategy");
        if (pswstrategyPro == null) {
            this.pStrategyObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_pswstrategy");
            this.pStrategyObj.set("id", (Object)338333884850648064L);
        } else {
            DynamicObjectType pswstrategyType = (DynamicObjectType)pswstrategyPro.getComplexType();
            this.pStrategyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)338333884850648064L, (DynamicObjectType)pswstrategyType);
        }
        return this.pStrategyObj;
    }

    private void setDataBeforeValidators(DynamicObject[] users, Set<String> lowerCaseUserNames) {
        Date date = Utils.getDate((int)0);
        DynamicObject nameMergeStyleObj = UserUtils.getNameMergeStyleDynamicObject((DynamicObject)users[0]);
        for (DynamicObject user : users) {
            String userName;
            if (StringUtils.isBlank((Object)user.get("password"))) {
                String p = this.pList.isEmpty() ? UserServiceHelper.getUserDefaultPsw() : this.pList.remove(0);
                user.set("password", (Object)p);
                user.set("psweffectivedate", (Object)date);
            }
            if (StringUtils.isNotBlank((CharSequence)(userName = user.getString("username")))) {
                lowerCaseUserNames.add(userName.toLowerCase());
            }
            if (StringUtils.isBlank((Object)user.get("pswstrategy"))) {
                user.set("pswstrategy", (Object)this.getDefaultPswStrategy());
            }
            this.setNsNameStyleAndNsName(user, nameMergeStyleObj);
        }
    }

    private void setNsNameStyleAndNsName(DynamicObject userObj, DynamicObject nameMergeStyleObj) {
        String localeName;
        ILocaleString name;
        DynamicObject nsNameStyleObj = userObj.getDynamicObject("ns_namestyle");
        if (nsNameStyleObj != null && 1997239714909794304L != nsNameStyleObj.getLong("id")) {
            return;
        }
        if (nsNameStyleObj == null) {
            if (nameMergeStyleObj == null) {
                return;
            }
            userObj.set("ns_namestyle", (Object)nameMergeStyleObj);
        }
        if ((name = userObj.getLocaleString("name")) == null) {
            name = new LocaleString();
        }
        if (StringUtils.isNotBlank((CharSequence)(localeName = name.getLocaleValue()))) {
            userObj.set("ns_firstname", (Object)localeName);
        } else {
            String nsName = userObj.getString("ns_firstname");
            name.setLocaleValue(nsName);
            userObj.set("name", (Object)name);
        }
    }

    private void setUsernameByFullPinyin(DynamicObject[] userObjs, Set<String> lowerCaseUserNames) {
        Map existsUserNameMap = null;
        for (DynamicObject userObj : userObjs) {
            Map idUserNameMap;
            long userId = userObj.getLong("id");
            UserUtils.transUserNamePinyin((DynamicObject)userObj, lowerCaseUserNames, (boolean)false);
            String fullPinyin = userObj.getString("fullpinyin");
            String userName = userObj.getString("username");
            if (StringUtils.isNotBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)fullPinyin)) continue;
            if (existsUserNameMap == null) {
                existsUserNameMap = UserUtils.getAllUserNames((boolean)true, userObjs.length > 1 ? null : String.valueOf(fullPinyin.charAt(0)));
                lowerCaseUserNames.addAll(existsUserNameMap.keySet());
            }
            if ((idUserNameMap = (Map)existsUserNameMap.get(fullPinyin.toLowerCase())) != null && userObj.getDataEntityState().getFromDatabase() && Objects.equals(fullPinyin, idUserNameMap.get(userId))) {
                userName = fullPinyin;
            }
            if (StringUtils.isBlank((CharSequence)userName)) {
                userName = UserUtils.getUserNameByFullPinyin((long)userId, (String)fullPinyin, lowerCaseUserNames, (boolean)false);
            }
            userObj.set("username", (Object)userName);
        }
    }
}

