/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class UsernameValidatorServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String USERNAME_REGEX = "^(?!_)(?!.*?_$)[a-zA-Z0-9_\\u4e00-\\u9fa5]+$";
    private static final String BOS_USER = "bos_user";
    private static final String BOS_SEC_USER = "bos-sec-user";
    private static final String ENABLE_USER_NAME_CHECK = "enableusernamecheck";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UsernameValidatorService());
    }

    private static class UsernameValidatorService
    extends AbstractValidator {
        private UsernameValidatorService() {
        }

        public void validate() {
            Boolean billParameter = (Boolean)SystemParamServiceHelper.getBillParameter((String)UsernameValidatorServicePlugin.BOS_USER, (String)UsernameValidatorServicePlugin.ENABLE_USER_NAME_CHECK);
            if (billParameter != null && !billParameter.booleanValue()) {
                return;
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String msg;
                DynamicObject userObj = dataEntity.getDataEntity();
                String userName = userObj.getString("username");
                if (!StringUtils.isNotBlank((CharSequence)userName) || !StringUtils.isNotBlank((CharSequence)(msg = this.verifyCharacter(userName)))) continue;
                this.addErrorMessage(dataEntity, msg);
            }
        }

        private String verifyCharacter(String username) {
            Pattern pattern;
            Matcher matcher;
            if (StringUtils.isNotBlank((CharSequence)username) && !(matcher = (pattern = Pattern.compile(UsernameValidatorServicePlugin.USERNAME_REGEX)).matcher(username)).matches()) {
                return UserMessage.getMessage((String)"M00012");
            }
            return "";
        }
    }
}

