/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.controller;

import java.util.List;
import kd.bos.base.AbstractBasedataController;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserController
extends AbstractBasedataController {
    private static final Log log = LogFactory.getLog(UserController.class);

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        super.buildBaseDataCoreFilter(event);
        ListShowParameter listShowParameter = event.getListShowParameter();
        IFormView formView = BaseUtils.getFormViewByControllerEvent((BaseDataCustomControllerEvent)event);
        IPageCache pageCache = null;
        if (formView != null) {
            pageCache = formView.getPageCache();
        }
        this.addAdminChargeUsersFilter(event.getQfilters(), listShowParameter, pageCache);
        this.addUserTypeFilter(event);
    }

    private void addAdminChargeUsersFilter(List<QFilter> filters, ListShowParameter listShowParameter, IPageCache pageCache) {
        QFilter filter;
        long userId = RequestContext.get().getCurrUserId();
        if (!listShowParameter.isLookUp()) {
            if (PermissionServiceHelper.isAdminUser((long)userId)) {
                listShowParameter.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            } else {
                return;
            }
        }
        if ((filter = UserUtils.getAdminChargeUsersFilter((long)userId, (ListShowParameter)listShowParameter, (IPageCache)pageCache)) != null) {
            filters.add(filter);
        }
    }

    private void addUserTypeFilter(BaseDataCustomControllerEvent event) {
        List listTreeNodeFilter;
        ListShowParameter listShowParameter = event.getListShowParameter();
        String externalUserType = (String)listShowParameter.getCustomParam("externalUserType");
        Boolean isOnlyShowExternalUser = (Boolean)listShowParameter.getCustomParam("isOnlyShowExternalUser");
        if (isOnlyShowExternalUser == null) {
            isOnlyShowExternalUser = Boolean.FALSE;
        }
        List paramUserTypeIds = null;
        if (StringUtils.isBlank((CharSequence)externalUserType)) {
            if (event.getSourceEnum() != BasedataControllerSourceEnum.LIST) {
                paramUserTypeIds = isOnlyShowExternalUser.booleanValue() ? UserUtils.getUserTypeByCategory((String)"2") : UserUtils.getUserTypeByCategory((String)"1");
            }
        } else {
            paramUserTypeIds = "all".equalsIgnoreCase(externalUserType) ? (isOnlyShowExternalUser.booleanValue() ? UserUtils.getUserTypeByCategory((String)"2") : UserUtils.getUserTypeByCategory(null)) : this.getExternalUserTypeFilter(externalUserType, isOnlyShowExternalUser);
        }
        if ((listTreeNodeFilter = (List)listShowParameter.getCustomParam("buildTreeUserTypeFilter")) == null) {
            listTreeNodeFilter = paramUserTypeIds;
        } else if (paramUserTypeIds != null) {
            listTreeNodeFilter.retainAll(paramUserTypeIds);
        }
        QFilter userTypesFilter = UserUtils.getUserTypesLikeFilter((List)listTreeNodeFilter);
        if (userTypesFilter == null) {
            userTypesFilter = UserUtils.getUserTypeJoinNotEqualsFilter((String)"7");
        }
        log.info("\u3010\u4eba\u5458\u8fc7\u6ee4\u63a7\u5236\u5668\u3011\u63a7\u5236\u5668\u7684\u4eba\u5458\u7c7b\u578b\u8fc7\u6ee4\u6761\u4ef6\uff1a" + userTypesFilter);
        event.getQfilters().add(userTypesFilter);
    }

    private List<Long> getExternalUserTypeFilter(String externalUserType, Boolean isOnlyShowExternalUser) {
        List<Long> userTypeIds = UserOperationUtils.getUserTypeIds(externalUserType);
        if (isOnlyShowExternalUser.booleanValue()) {
            return userTypeIds;
        }
        if (userTypeIds.isEmpty()) {
            return UserUtils.getUserTypeByCategory((String)"1");
        }
        userTypeIds.addAll(UserUtils.getUserTypeByCategory((String)"1"));
        return userTypeIds;
    }
}

