/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IpManagementEditPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(IpManagementEditPlugin.class);
    private static final String NAME_CODE = "userid";
    private static final String DEPARTMENT_CODE = "departmentid";
    private static final String SYSTEM_TYPE = "bos-sec-user";
    private static final String IP_SEPARATOR = "-";
    private static final String IP_FORMAT = "(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.";

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!(args.getSource() instanceof FormOperate)) {
            return;
        }
        AbstractOperate oper = (AbstractOperate)args.getSource();
        if ("save".equals(oper.getOperateKey()) && !this.check()) {
            args.setCancel(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean check() {
        boolean bothNameAndDptIsEmpty;
        Object user = this.getModel().getValue(NAME_CODE);
        Object department = this.getModel().getValue(DEPARTMENT_CODE);
        boolean bl = bothNameAndDptIsEmpty = !(user != null && !StringUtils.isEmpty((CharSequence)String.valueOf(user)) || department != null && !StringUtils.isEmpty((CharSequence)String.valueOf(department)));
        if (bothNameAndDptIsEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d3\u540d\u548c\u90e8\u95e8\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"IpManagementEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        Object ip = this.getModel().getValue("ip");
        if (ip == null || StringUtils.isEmpty((CharSequence)String.valueOf(ip))) {
            return true;
        }
        if (String.valueOf(ip).contains(IP_SEPARATOR)) {
            if (this.ipRangeCheck(String.valueOf(ip))) {
                String[] ips = String.valueOf(ip).split(IP_SEPARATOR);
                int result = this.compareIp(ips[0], ips[1]);
                if (result == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u5c3eIP\u9700\u5927\u4e8e\u8d77\u59cbIP\u3002", (String)"IpManagementEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
                if (result != -1) return true;
                this.showIpFormatErrorTip();
                return false;
            }
            this.showIpFormatErrorTip();
            return false;
        }
        if (this.ipCheck(String.valueOf(ip))) return true;
        this.showIpFormatErrorTip();
        return false;
    }

    private void showIpFormatErrorTip() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"IP\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"IpManagementEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    private boolean ipRangeCheck(String ipRange) {
        String regex;
        return StringUtils.isNotEmpty((CharSequence)ipRange) && ipRange.matches(regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)-(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    }

    private boolean ipCheck(String ip) {
        String regex;
        return StringUtils.isNotEmpty((CharSequence)ip) && ip.matches(regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    }

    private int compareIp(String startIp, String endIp) {
        if (this.ipCheck(startIp) && this.ipCheck(endIp)) {
            int endIpValue;
            int startIpValue = this.getIpValue(startIp);
            if (startIpValue > (endIpValue = this.getIpValue(endIp))) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private int getIpValue(String ip) {
        byte[] addr = this.getIpBytes(ip);
        int address1 = addr[3] & 0xFF;
        address1 |= addr[2] << 8 & 0xFF00;
        address1 |= addr[1] << 16 & 0xFF0000;
        return address1 |= addr[0] << 24 & 0xFF000000;
    }

    private byte[] getIpBytes(String ip) {
        try {
            String[] addrs = ip.split("\\.");
            int length = addrs.length;
            byte[] addr = new byte[length];
            for (int index = 0; index < length; ++index) {
                addr[index] = (byte)(Integer.parseInt(addrs[index]) & 0xFF);
            }
            return addr;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return new byte[4];
        }
    }
}

