/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.plugin.PositionDeleteValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class PositionDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String REPORT_TYPE = "reporttype";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.getOption().setVariableValue("ignorerefentityids", BOS_REPORT_RELATION);
        e.addValidator((AbstractValidator)new PositionDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        QFilter positionIdFilter;
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashMap<Long, DynamicObject> positionIdsMap = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        for (DynamicObject positionObj : dynamicObjects) {
            long positionId = positionObj.getLong("id");
            positionIdsMap.put(positionId, positionObj);
        }
        String selectProperties = "id,reporttype,position,superiorposition";
        QFilter typeFilter = new QFilter(REPORT_TYPE, "=", (Object)1690596074244322304L);
        DynamicObject[] willDeleteReportRelationObjs = BusinessDataServiceHelper.load((String)BOS_REPORT_RELATION, (String)selectProperties, (QFilter[])new QFilter[]{typeFilter, positionIdFilter = new QFilter("position", "in", positionIdsMap.keySet())});
        if (willDeleteReportRelationObjs == null || willDeleteReportRelationObjs.length == 0) {
            return;
        }
        OperateOption operateOption = this.getOption();
        operateOption.setVariableValue("source", "PositionDeleteOpPlugin");
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)BOS_REPORT_RELATION, (DynamicObject[])willDeleteReportRelationObjs, (OperateOption)operateOption);
        this.addErrorMsg(result, willDeleteReportRelationObjs, positionIdsMap);
        e.setDataEntities(positionIdsMap.values().toArray(new DynamicObject[0]));
    }

    private void addErrorMsg(OperationResult result, DynamicObject[] willDeleteReportRelationObjs, Map<Long, DynamicObject> positionIdsMap) {
        List errorOrValidateInfo = result.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)errorOrValidateInfo)) {
            return;
        }
        Map<Long, DynamicObject> rRLTOPosition = this.getRRLTOPosition(willDeleteReportRelationObjs, positionIdsMap);
        for (IOperateInfo operateInfo : errorOrValidateInfo) {
            long pkValue = Long.parseLong(operateInfo.getPkValue().toString());
            DynamicObject positionObj = rRLTOPosition.get(pkValue);
            if (positionObj == null) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, positionObj.getPkValue());
            operateErrorInfo.setMessage(operateInfo.getMessage());
            this.operationResult.addErrorInfo(operateErrorInfo);
            positionIdsMap.remove(positionObj.getLong("id"));
        }
    }

    private Map<Long, DynamicObject> getRRLTOPosition(DynamicObject[] willDeleteReportRelationObjs, Map<Long, DynamicObject> positionIdsMap) {
        HashMap<Long, DynamicObject> rRLTOPosition = new HashMap<Long, DynamicObject>(willDeleteReportRelationObjs.length);
        for (DynamicObject reportRelationObj : willDeleteReportRelationObjs) {
            DynamicObject pObj = reportRelationObj.getDynamicObject("position");
            if (pObj == null) continue;
            long pId = pObj.getLong("id");
            rRLTOPosition.put(reportRelationObj.getLong("id"), positionIdsMap.get(pId));
        }
        return rRLTOPosition;
    }
}

