/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PositionDeleteValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PositionDeleteValidator.class);
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String REPORT_TYPE = "reporttype";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";

    public void validate() {
        this.validateDeleteReportRelation();
    }

    private void validateDeleteReportRelation() {
        HashMap<Long, ExtendedDataEntity> positionIdsMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject positionObj = extendedDataEntity.getDataEntity();
            long positionId = positionObj.getLong("id");
            positionIdsMap.put(positionId, extendedDataEntity);
        }
        this.validateIsExistOtherRRL(positionIdsMap);
    }

    private void validateIsExistOtherRRL(Map<Long, ExtendedDataEntity> positionIdsMap) {
        if (positionIdsMap.isEmpty()) {
            return;
        }
        QFilter nTypeFilter = new QFilter(REPORT_TYPE, "!=", (Object)1690596074244322304L);
        QFilter positionIdFilter = new QFilter("position", "in", positionIdsMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PositionDeleteValidator.validateIsExistOtherRRL", (String)BOS_REPORT_RELATION, (String)"position.id,position.number", (QFilter[])new QFilter[]{nTypeFilter, positionIdFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                long positionId = r.getLong("position.id");
                ExtendedDataEntity errorPosition = positionIdsMap.get(positionId);
                if (errorPosition == null) continue;
                this.addErrorMessage(errorPosition, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u88ab\u9664\u201c\u884c\u653f\u201d\u6c47\u62a5\u5173\u7cfb\u5916\u7684\u6c47\u62a5\u5173\u7cfb\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PositionDeleteValidator_0", (String)"bos-sec-user", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.warn("PositionDeleteValidator.validateIsExistOtherRRL is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
    }
}

