/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PositionExportListPlugin
extends AbstractListPlugin {
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String REPORT_TYPE = "reporttype";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String SUPERIOR_POSITION = "superiorposition";

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas = e.getQueryValues();
        ArrayList<Long> positionIds = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            if (!data.containsProperty(SUPERIOR_POSITION)) {
                return;
            }
            long position = data.getLong("id");
            positionIds.add(position);
        }
        String selectProperties = "position,superiorposition";
        QFilter qFilter = new QFilter("position", "in", positionIds);
        QFilter typeFilter = new QFilter(REPORT_TYPE, "=", (Object)1690596074244322304L);
        Map reportRelationMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (String)selectProperties, (QFilter[])new QFilter[]{qFilter, typeFilter});
        HashMap<Long, DynamicObject> supPositionMap = new HashMap<Long, DynamicObject>(datas.length);
        for (Map.Entry entry : reportRelationMap.entrySet()) {
            DynamicObject reportRelationObj = (DynamicObject)entry.getValue();
            DynamicObject positionObj = reportRelationObj.getDynamicObject("position");
            DynamicObject sPositionObj = reportRelationObj.getDynamicObject(SUPERIOR_POSITION);
            supPositionMap.put(positionObj.getLong("id"), sPositionObj);
        }
        for (DynamicObject data : datas) {
            long position = data.getLong("id");
            DynamicObject sPositionObj = (DynamicObject)supPositionMap.get(position);
            data.set(SUPERIOR_POSITION, (Object)sPositionObj);
        }
    }
}

