/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PositionFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String REPORT_TYPE = "reporttype";
    private static final String SUPERIOR_POSITION = "superiorposition";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit dpt = (OrgEdit)this.getControl("dpt");
        if (dpt != null) {
            dpt.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("dpt".equals(beforeF7SelectEvent.getProperty().getName())) {
            ListShowParameter listShowPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowPara.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String dptId = (String)this.getView().getFormShowParameter().getCustomParam("dpt");
        if (dptId == null) {
            return;
        }
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            this.getModel().setValue("dpt", (Object)Long.parseLong(dptId));
            return;
        }
        HasPermOrgResult list = PermissionServiceHelper.getAdminChargeOrgWithParaMap((Long)RequestContext.get().getCurrUserId(), (String)"01", (boolean)false, null);
        if (!list.hasAllOrgPerm() && !list.getHasPermOrgs().contains(Long.parseLong(dptId))) {
            return;
        }
        this.getModel().setValue("dpt", (Object)Long.parseLong(dptId));
    }

    public void beforeBindData(EventObject e) {
        QFilter positionFilter;
        Object pkId = this.getModel().getDataEntity().getPkValue();
        if (pkId == null || "0".equals(pkId.toString())) {
            return;
        }
        QFilter reportTypeListFilter = new QFilter(REPORT_TYPE, "=", (Object)1690596074244322304L);
        DynamicObject reportRelationObj = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_REPORT_RELATION, (QFilter[])new QFilter[]{reportTypeListFilter, positionFilter = new QFilter("position", "=", (Object)Long.parseLong(pkId.toString()))});
        if (reportRelationObj == null) {
            return;
        }
        DynamicObject sPositionObj = reportRelationObj.getDynamicObject(SUPERIOR_POSITION);
        if (sPositionObj != null) {
            this.getModel().setValue(SUPERIOR_POSITION, (Object)sPositionObj);
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Button button = (Button)evt.getSource();
        if (!ObjectUtils.isEmpty((Object)button) && "btnsave".equals(button.getKey())) {
            Object number = this.getModel().getValue("number");
            Object name = this.getModel().getValue("name");
            Object dpt = this.getModel().getValue("dpt");
            if (ObjectUtils.isEmpty((Object)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7f16\u7801\u201d\u3002", (String)"PositionFormPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (ObjectUtils.isEmpty((Object)name.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"PositionFormPlugin_1", (String)"bos-sec-user", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (ObjectUtils.isEmpty((Object)dpt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6240\u5c5e\u90e8\u95e8\u201d\u3002", (String)"PositionFormPlugin_2", (String)"bos-sec-user", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

