/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.plugin.PositionSaveValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class PositionSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String IS_MAIN_POSITION = "ismainposition";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String REPORT_TYPE = "reporttype";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String BOS_REPORT_TYPE = "bos_reporttype";
    private static final String SUPERIOR_POSITION = "superiorposition";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("orgstructure");
        e.getFieldKeys().add(IS_MAIN_POSITION);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PositionSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<DynamicObject> newPositions = new ArrayList<DynamicObject>(dynamicObjects.length);
        HashMap<Long, DynamicObject> changePositions = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        HashMap<Object, DynamicObject> rRLToPosition = new HashMap<Object, DynamicObject>(dynamicObjects.length);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject positionObj : dynamicObjects) {
            long id = positionObj.getLong("id");
            successObjs.add(positionObj);
            if (!positionObj.getDataEntityState().getFromDatabase()) {
                newPositions.add(positionObj);
                continue;
            }
            changePositions.put(id, positionObj);
        }
        List<DynamicObject> willSaveRRLList = this.buildRRLObjList(changePositions, rRLToPosition, newPositions);
        if (willSaveRRLList.isEmpty()) {
            e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)BOS_REPORT_RELATION, (DynamicObject[])willSaveRRLList.toArray(new DynamicObject[0]), (OperateOption)this.operateOption);
        this.addErrorMsg(result, rRLToPosition, successObjs);
        e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> buildRRLObjList(Map<Long, DynamicObject> changePositions, Map<Object, DynamicObject> rRLToPosition, List<DynamicObject> newPositions) {
        ArrayList<DynamicObject> willSaveRRLList = new ArrayList<DynamicObject>(changePositions.size() + newPositions.size());
        this.buildChangeRRLObj(changePositions, willSaveRRLList, rRLToPosition);
        this.buildNewRRLObj(newPositions, willSaveRRLList, rRLToPosition);
        return willSaveRRLList;
    }

    private void buildChangeRRLObj(Map<Long, DynamicObject> changePositions, List<DynamicObject> willSaveRRLList, Map<Object, DynamicObject> rRLToPosition) {
        QFilter reportTypeListFilter = new QFilter(REPORT_TYPE, "=", (Object)1690596074244322304L);
        QFilter positionFilter = new QFilter("position", "in", changePositions.keySet());
        String selectProperties = "id,position,superiorposition,reporttype";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BOS_REPORT_RELATION, (String)selectProperties, (QFilter[])new QFilter[]{reportTypeListFilter, positionFilter});
        HashMap<Long, Long> positionToSPosition = new HashMap<Long, Long>(dynamicObjects.length);
        HashMap<Long, DynamicObject> positionToRRL = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        for (DynamicObject RRL : dynamicObjects) {
            DynamicObject positionObj = RRL.getDynamicObject("position");
            DynamicObject sPositionObj = RRL.getDynamicObject(SUPERIOR_POSITION);
            if (positionObj == null) continue;
            long positionId = positionObj.getLong("id");
            long sPId = 0L;
            if (sPositionObj != null) {
                sPId = sPositionObj.getLong("id");
            }
            positionToSPosition.put(positionId, sPId);
            positionToRRL.put(positionId, RRL);
        }
        this.isChangeSuperiorPosition(changePositions, positionToSPosition, positionToRRL, willSaveRRLList, rRLToPosition);
    }

    private void isChangeSuperiorPosition(Map<Long, DynamicObject> changePositions, Map<Long, Long> positionToSPosition, Map<Long, DynamicObject> positionToRRL, List<DynamicObject> willSaveRRLList, Map<Object, DynamicObject> rRLToPosition) {
        ArrayList<DynamicObject> newPositions = new ArrayList<DynamicObject>(8);
        for (Map.Entry<Long, DynamicObject> entry : changePositions.entrySet()) {
            DynamicObject positionObj = entry.getValue();
            DynamicObject sPObj = positionObj.getDynamicObject(SUPERIOR_POSITION);
            long sPId = 0L;
            if (sPObj != null) {
                sPId = sPObj.getLong("id");
            }
            if (positionToSPosition.get(entry.getKey()) != null && positionToSPosition.get(entry.getKey()).equals(sPId)) continue;
            DynamicObject existReportRelationObj = positionToRRL.get(positionObj.getLong("id"));
            if (existReportRelationObj == null) {
                newPositions.add(positionObj);
                continue;
            }
            existReportRelationObj.set(SUPERIOR_POSITION, (Object)sPObj);
            willSaveRRLList.add(existReportRelationObj);
            rRLToPosition.put(existReportRelationObj.getLong("id"), positionObj);
        }
        if (CollectionUtils.isEmpty(newPositions)) {
            return;
        }
        this.buildNewRRLObj(newPositions, willSaveRRLList, rRLToPosition);
    }

    private void buildNewRRLObj(List<DynamicObject> newPositions, List<DynamicObject> willSaveRRLList, Map<Object, DynamicObject> rRLToPosition) {
        if (CollectionUtils.isEmpty(newPositions)) {
            return;
        }
        DynamicObject reportTypeObj = BusinessDataServiceHelper.loadSingle((Object)1690596074244322304L, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)BOS_REPORT_TYPE).getDynamicObjectType());
        for (DynamicObject positionObj : newPositions) {
            DynamicObject reportRelationObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_REPORT_RELATION);
            DynamicObject sPositionObj = positionObj.getDynamicObject(SUPERIOR_POSITION);
            ORM orm = ORM.create();
            long id = orm.genLongId(BOS_REPORT_RELATION);
            reportRelationObj.set("id", (Object)id);
            reportRelationObj.set(REPORT_TYPE, (Object)reportTypeObj);
            reportRelationObj.set("position", (Object)positionObj);
            reportRelationObj.set(SUPERIOR_POSITION, (Object)sPositionObj);
            willSaveRRLList.add(reportRelationObj);
            rRLToPosition.put(id, positionObj);
        }
    }

    private void addErrorMsg(OperationResult result, Map<Object, DynamicObject> rRLToPosition, List<DynamicObject> successObjs) {
        for (int j = 0; j < result.getAllErrorOrValidateInfo().size(); ++j) {
            Object pkValue = ((IOperateInfo)result.getAllErrorOrValidateInfo().get(j)).getPkValue();
            String msg = ((IOperateInfo)result.getAllErrorOrValidateInfo().get(j)).getMessage();
            DynamicObject positionObj = rRLToPosition.get(pkValue);
            if (positionObj == null) continue;
            this.addOperationResult(msg, positionObj);
            successObjs.remove(positionObj);
        }
    }

    private void addOperationResult(String message, DynamicObject positionObj) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, positionObj.getPkValue());
        operateErrorInfo.setMessage(message);
        this.operationResult.addErrorInfo(operateErrorInfo);
    }
}

