/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class PositionSaveValidator
extends AbstractValidator {
    private static final String DPT_NUMBER = "dpt.number";
    private static final String DPT = "dpt";
    private static final String BOS_POSITION = "bos_position";
    private static final String IS_MAIN_POSITION = "ismainposition";

    public void validate() {
        HashMap<String, ExtendedDataEntity> positionMap = new HashMap<String, ExtendedDataEntity>();
        this.validateData(positionMap);
        this.validateMainPositionIsDisable(positionMap);
        this.validateDataBase(positionMap);
    }

    private void validateData(Map<String, ExtendedDataEntity> positionMap) {
        Map<Long, DynamicObject> orgStrutMap = this.getOrgStructureMap();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject positionObj = extendedDataEntity.getDataEntity();
            DynamicObject dptObj = positionObj.getDynamicObject(DPT);
            if (dptObj == null) continue;
            positionObj.set("orgstructure", (Object)orgStrutMap.get(dptObj.getLong("id")));
            String number = positionObj.getString("number");
            ExtendedDataEntity dataEntity = positionMap.get(number);
            if (dataEntity != null) {
                DynamicObject existsOrgDutyObj = dataEntity.getDataEntity();
                this.validateUnique(extendedDataEntity, existsOrgDutyObj);
                continue;
            }
            positionMap.put(number, extendedDataEntity);
        }
    }

    private Map<Long, DynamicObject> getOrgStructureMap() {
        HashSet<Long> dptIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject positionObj = extendedDataEntity.getDataEntity();
            DynamicObject dptObj = positionObj.getDynamicObject(DPT);
            if (dptObj == null) continue;
            dptIds.add(dptObj.getLong("id"));
        }
        return UserOperationUtils.getOrgStructure(dptIds, null);
    }

    private void validateMainPositionIsDisable(Map<String, ExtendedDataEntity> positionMap) {
        if (positionMap.isEmpty()) {
            return;
        }
        ArrayList<ExtendedDataEntity> positionDEList = new ArrayList<ExtendedDataEntity>(positionMap.values());
        for (ExtendedDataEntity positionDE : positionDEList) {
            DynamicObject positionObj = positionDE.getDataEntity();
            boolean isMainPosition = positionObj.getBoolean(IS_MAIN_POSITION);
            boolean enable = positionObj.getBoolean("enable");
            if (enable || !isMainPosition) continue;
            String msg = ResManager.loadKDString((String)"\u7981\u7528\u7684\u5c97\u4f4d\u4e0d\u80fd\u8bbe\u4e3a\u4e3b\u5c97\u3002", (String)"PositionSaveValidator_1", (String)"bos-sec-user", (Object[])new Object[0]);
            this.addErrorMessage(positionDE, msg);
            positionMap.remove(positionObj.getString("number"));
        }
    }

    private void validateDataBase(Map<String, ExtendedDataEntity> positionMap) {
        if (positionMap.isEmpty()) {
            return;
        }
        QFilter positionFilter = new QFilter("number", "in", positionMap.keySet());
        QFilter[] filters = new QFilter[]{positionFilter};
        String selectFields = "id,dpt.number,number,name";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)BOS_POSITION, (String)selectFields, (QFilter[])filters);
        for (DynamicObject orgDutyObj : dynamicObjectCollection) {
            ExtendedDataEntity extendedDataEntity = positionMap.get(orgDutyObj.getString("number"));
            this.validateUnique(extendedDataEntity, orgDutyObj);
        }
    }

    private void validateUnique(ExtendedDataEntity extendedDataEntity, DynamicObject existsOrgDutyObj) {
        long id;
        long existsId = existsOrgDutyObj.getLong("id");
        if (existsId != (id = extendedDataEntity.getDataEntity().getLong("id"))) {
            Object existsDptNumber = existsOrgDutyObj.get(DPT_NUMBER);
            Object positionNumber = existsOrgDutyObj.get("number");
            String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5c97\u4f4d\u201c%1$s\u201d\u5728\u90e8\u95e8\u201c%2$s\u201d\u4e0b\u3002", (String)"PositionSaveValidator_2", (String)"bos-sec-user", (Object[])new Object[0]), positionNumber, existsDptNumber);
            this.addErrorMessage(extendedDataEntity, msg);
        }
    }
}

