/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PositionTreeListPlugin
extends StandardTreeListPlugin
implements ListRowClickListener {
    private static final Log log = LogFactory.getLog(PositionTreeListPlugin.class);
    private boolean isFilterContainerSearchClick;
    private static final String DPT = "dpt";
    private static final String BOS_POSITION = "bos_position";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String REPORTING_RELATIONSHIP = "reportingrelationship";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String SET_MAIN_POSITION = "setmainposition";
    private static final String CANCEL_MAIN_POSITION = "cancelmainposition";
    private static final String IS_MAIN_POSITION = "ismainposition";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String SUPPOSITION = "superiorposition";

    public void initialize() {
        super.initialize();
        ((TreeListModel)this.getTreeModel()).setGobackToRoot(false);
    }

    public void initializeTree(EventObject e) {
        HashMap customParams = this.getView().getFormShowParameter().getCustomParams();
        log.info("\u3010\u5c97\u4f4d\u67e5\u8be2\u3011\u521d\u59cb\u5316\u53c2\u6570\uff1a" + customParams);
        if (customParams == null) {
            customParams = new HashMap(0);
        }
        this.initRootNode(customParams);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode root = this.getTreeModel().getRoot();
        if (root != null) {
            this.getTreeListView().getTreeView().focusNode(root);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        if (this.isFilterContainerSearchClick) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        QFilter treeListFilter = null;
        long orgId = Long.parseLong(nodeId);
        if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
            if (OrgUnitServiceHelper.getRootOrgId() != orgId) {
                treeListFilter = this.getNotRootNodeFilter(orgId);
            }
        } else {
            treeListFilter = new QFilter(DPT, "=", (Object)orgId);
        }
        e.addQFilter(treeListFilter);
    }

    public void setFilter(SetFilterEvent e) {
        if (((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            return;
        }
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            return;
        }
        HasPermOrgResult list = PermissionServiceHelper.getAdminChargeOrgWithParaMap((Long)RequestContext.get().getCurrUserId(), (String)"01", (boolean)false, null);
        if (!list.hasAllOrgPerm()) {
            QFilter idFilter = new QFilter(DPT, "in", (Object)list.getHasPermOrgs());
            e.getQFilters().add(idFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isFilterContainerSearchClick = true;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Object nodeId = e.getNodeId();
        this.treeListView.getTreeView().queryTreeNodeChildren(String.valueOf(e.getParentNodeId()), String.valueOf(nodeId));
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        e.setChildNodes(this.refreshNodeChildren(nodeId, this.getOrgUnitTreeParam()));
    }

    public void expendTreeNode(TreeNodeEvent e) {
        this.treeListView.getTreeView().expand(e.getNodeId().toString());
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (StringUtils.isBlank((CharSequence)searchEnterEvent.getText())) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchEnterEvent.getText(), (ListView)this.getView(), "01");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        if (!OrgTreeUtils.focusTreeNodeAfterListRowClick((ListRowClickEvent)evt, (IPageCache)this.getPageCache())) {
            return;
        }
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        QFilter pkFilter = new QFilter("id", "=", row.getPrimaryKeyValue());
        DynamicObject dptToPosition = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_POSITION, (QFilter[])new QFilter[]{pkFilter});
        DynamicObject dptObj = dptToPosition.getDynamicObject(DPT);
        if (dptObj == null) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(dptObj.getString("id"), (ListView)this.getView(), "01");
        searchParam.setSearchById(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
            TreeView tv;
            Map focusMap;
            if ("chkincludechild".equals(proName) && (focusMap = (tv = this.treeListView.getTreeView()).getTreeState().getFocusNode()) != null) {
                tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
            }
        });
    }

    private QFilter getNotRootNodeFilter(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        List orgIncludeSubs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"01", orgIds, (boolean)true, null);
        QFilter treeListFilter = new QFilter(DPT, "in", (Object)orgIncludeSubs);
        return treeListFilter;
    }

    private void initRootNode(Map<String, Object> customParams) {
        Object initOrgId;
        long rootOrgId = 0L;
        Object paramInitRootOrgId = customParams.get("initRootOrgId");
        if (StringUtils.isNotBlank((Object)paramInitRootOrgId)) {
            long initRootOrgId = Long.parseLong(paramInitRootOrgId.toString());
            if (OrgUnitServiceHelper.getRootOrgId() != initRootOrgId) {
                rootOrgId = initRootOrgId;
            }
        }
        if (StringUtils.isNotBlank((Object)(initOrgId = customParams.get("initOrgId"))) && !initOrgId.equals(paramInitRootOrgId)) {
            this.getPageCache().put("initOrgId", initOrgId.toString());
        }
        OrgTreeParam param = this.getOrgUnitTreeParam();
        param.setId(rootOrgId);
        param.setBuildRootNodeInRange(true);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null && rootOrgId != 0L) {
            param.setId(0L);
            root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        }
        this.initRootNode(root);
    }

    private void initRootNode(TreeNode root) {
        if (root == null) {
            return;
        }
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        log.debug("\u5de6\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + root.getId());
    }

    private List<TreeNode> refreshNodeChildren(String nodeId, OrgTreeParam param) {
        if (param == null) {
            return Collections.emptyList();
        }
        param.setId(Long.parseLong(nodeId));
        return OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
    }

    private OrgTreeParam getOrgUnitTreeParam() {
        OrgTreeParam param = new OrgTreeParam();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        param.setOrgRangeList(UserOperationUtils.getAdminChargeOrgs(listShowParameter, this.getPageCache()));
        return param;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (REPORTING_RELATIONSHIP.equals(evt.getItemKey())) {
            boolean hasQueryPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)BOS_REPORT_RELATION, (String)QUERY_PERM);
            if (hasQueryPerm) {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)BOS_REPORT_RELATION, (boolean)true, (int)0, (boolean)false);
                listShowParameter.setPageId(this.getView().getPageId() + listShowParameter.getBillFormId());
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u6c47\u62a5\u5173\u7cfb\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionTreeListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String nodeId = this.treeListView.getTreeModel().getCurrentNodeId().toString();
        e.getParameter().setCustomParam(DPT, (Object)nodeId);
        e.getParameter().setCustomParam("id", e.getParameter().getPkId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (SET_MAIN_POSITION.equals(operate.getOperateKey())) {
            this.setOrCancelMainPosition(true);
        }
        if (CANCEL_MAIN_POSITION.equals(operate.getOperateKey())) {
            this.setOrCancelMainPosition(false);
        }
    }

    private void setOrCancelMainPosition(boolean isMainPosition) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null) {
            return;
        }
        Object[] positionIds = rows.getPrimaryKeyValues();
        DynamicObject[] mainPositions = BusinessDataServiceHelper.load((Object[])positionIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)BOS_POSITION).getDynamicObjectType());
        if (mainPositions == null || mainPositions.length == 0) {
            return;
        }
        Map<Long, DynamicObject> positionToSPosition = this.getPositionToSPosition(positionIds);
        for (DynamicObject mainPosition : mainPositions) {
            mainPosition.set(SUPPOSITION, positionToSPosition.getOrDefault(mainPosition.getLong("id"), null));
            mainPosition.set(IS_MAIN_POSITION, (Object)isMainPosition);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)BOS_POSITION, (DynamicObject[])mainPositions, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            if (isMainPosition) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u4e3a\u4e3b\u5c97\u6210\u529f\u3002", (String)"PositionTreeListPlugin_2", (String)"bos-sec-user", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4e3b\u5c97\u6210\u529f\u3002", (String)"PositionTreeListPlugin_3", (String)"bos-sec-user", (Object[])new Object[0]));
            }
        } else {
            this.getView().showOperationResult(operationResult);
        }
        this.treeListView.refreshTreeView();
    }

    private Map<Long, DynamicObject> getPositionToSPosition(Object[] positionIds) {
        QFilter positionFilter = new QFilter("position", "in", (Object)positionIds);
        QFilter reportTypeListFilter = new QFilter("reporttype", "=", (Object)1690596074244322304L);
        Map rRlObj = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (String)"position,superiorposition", (QFilter[])new QFilter[]{reportTypeListFilter, positionFilter});
        if (rRlObj.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> positionToSPosition = new HashMap<Long, DynamicObject>(rRlObj.size());
        for (Map.Entry entry : rRlObj.entrySet()) {
            DynamicObject rRl = (DynamicObject)entry.getValue();
            DynamicObject positionObj = rRl.getDynamicObject("position");
            if (positionObj == null) continue;
            positionToSPosition.put(positionObj.getLong("id"), rRl.getDynamicObject(SUPPOSITION));
        }
        return positionToSPosition;
    }
}

