/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.utils.PositionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PostRelationChartPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String TBL_QUERY = "tblquery";
    private static final String TOOL_BARAP1 = "toolbarap1";
    private static final String TOOL_BARAP = "toolbarap";
    private static final String TBL_REFRESH = "tblrefresh";
    private static final String REPORT_TYPE = "reporttype";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String POSITION_ID = "position.id";
    private static final String SUPERIOR_POSITION_ID = "superiorposition.id";
    private static final String BOS_REPORT_TYPE = "bos_reporttype";
    private static final String BOS_POSITION = "bos_position";
    private static final String METHOD_NAME = "methodName";
    private static final String ON_DUTY_PERSONNEL = "u";
    private static final String SUBORDINATE_POSITIONS = "p";

    public void beforeBindData(EventObject e) {
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        Object[] param = new Object[]{this.getParams(REPORT_TYPE, BOS_REPORT_TYPE, "setData"), this.getParams("position", BOS_POSITION, "setPositionFocus")};
        control.setData((Object)param);
    }

    private Map<String, Object> getParams(String customParamKey, String entityName, String methodName) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        Object paramId = this.getView().getFormShowParameter().getCustomParam(customParamKey);
        if (paramId != null) {
            long id = Long.parseLong(paramId.toString());
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            this.getModel().setValue(customParamKey, (Object)obj);
            params.put(METHOD_NAME, methodName);
            if (customParamKey.equals(REPORT_TYPE)) {
                params.put("value", this.showChart(obj));
            } else {
                params.put("value", String.valueOf(id));
            }
        }
        return params;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit position = (BasedataEdit)this.getControl("position");
        position.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{TOOL_BARAP1, TOOL_BARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemClick = evt.getItemKey();
        DynamicObject reportTypeObj = (DynamicObject)this.getModel().getValue(REPORT_TYPE);
        DynamicObject postObj = (DynamicObject)this.getModel().getValue("position");
        if (TBL_QUERY.equals(itemClick)) {
            if (reportTypeObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u62a5\u7c7b\u578b\u3002", (String)"PostRelationChartPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            this.postData(reportTypeObj, postObj);
        }
        if (TBL_REFRESH.equals(itemClick)) {
            if (reportTypeObj == null) {
                return;
            }
            this.postData(reportTypeObj, postObj);
        }
    }

    private void postData(DynamicObject reportTypeObj, DynamicObject postObj) {
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        Object[] param = new Object[2];
        HashMap<String, Object> treeParams = new HashMap<String, Object>(3);
        if (postObj != null) {
            HashMap<String, String> focusParams = new HashMap<String, String>(2);
            long positionId = postObj.getLong("id");
            this.getPeopleUnderPosition(positionId);
            focusParams.put(METHOD_NAME, "setPositionFocus");
            focusParams.put("value", String.valueOf(positionId));
            param[1] = focusParams;
        }
        treeParams.put(METHOD_NAME, "setData");
        treeParams.put("value", this.showChart(reportTypeObj));
        treeParams.put("randomKey", new Date());
        param[0] = treeParams;
        control.setData((Object)param);
    }

    private void getPeopleUnderPosition(long positionId) {
        QFilter positionIdFilter = new QFilter("entryentity.post", "=", (Object)positionId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String selectProperties = "name,number,entryentity.dpt,entryentity.orgstructure";
        Map userObjsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectProperties, (QFilter[])new QFilter[]{positionIdFilter, enableFilter});
        int i = 0;
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        for (Map.Entry entry : userObjsMap.entrySet()) {
            DynamicObject userObj = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryEntity = userObj.getDynamicObjectCollection("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size());
            for (DynamicObject entryObj : entryEntity) {
                DynamicObject dptObj = entryObj.getDynamicObject("dpt");
                DynamicObject structureObj = entryObj.getDynamicObject("orgstructure");
                if (dptObj == null || structureObj == null) {
                    this.getModel().deleteEntryRow("entryentity", i++);
                    continue;
                }
                String name = userObj.getString("name");
                String number = userObj.getString("number");
                String dptName = dptObj.getString("name");
                String dptFullName = structureObj.getString("fullname");
                this.getModel().setValue("name", (Object)name, i);
                this.getModel().setValue("number", (Object)number, i);
                this.getModel().setValue("dpt", (Object)dptName, i);
                this.getModel().setValue("dptfullname", (Object)dptFullName, i);
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        List<Object> positionIds = new ArrayList(8);
        if ("position".equals(propName)) {
            QFilter[] qFilter = new QFilter[1];
            DynamicObject reportTypeObj = (DynamicObject)this.getModel().getValue(REPORT_TYPE);
            if (reportTypeObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u62a5\u7c7b\u578b\u3002", (String)"PostRelationChartPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilter[0] = new QFilter(REPORT_TYPE, "=", (Object)reportTypeObj.getLong("id"));
            positionIds = this.queryF7Select(qFilter);
        }
        QFilter idFilter = new QFilter("id", "in", positionIds);
        ListShowParameter listShowPara = (ListShowParameter)evt.getFormShowParameter();
        listShowPara.getListFilterParameter().setFilter(idFilter);
    }

    private List<Long> queryF7Select(QFilter[] qFilter) {
        Map idToReportTypeObj = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (String)"position,superiorposition", (QFilter[])qFilter);
        if (idToReportTypeObj.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> positionIds = new ArrayList<Long>(idToReportTypeObj.size());
        for (DynamicObject relationObj : idToReportTypeObj.values()) {
            long positionId = relationObj.getLong(POSITION_ID);
            positionIds.add(positionId);
            if (relationObj.get(SUPERIOR_POSITION_ID) == null) continue;
            positionIds.add(relationObj.getLong(SUPERIOR_POSITION_ID));
        }
        return positionIds;
    }

    private List<TreeNode> showChart(DynamicObject reportTypeObj) {
        Map<String, TreeNode> allNodes = PositionUtils.getAllNodes(reportTypeObj.getLong("id"));
        return this.buildChildrenNodes(allNodes);
    }

    private List<TreeNode> buildChildrenNodes(Map<String, TreeNode> allNodes) {
        if (CollectionUtils.isEmpty(allNodes)) {
            return new ArrayList<TreeNode>(0);
        }
        Set<Long> positionIds = allNodes.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        Map<String, Set<Long>> userIds = this.getPeopleUnderPositionCount(positionIds);
        List<TreeNode> rootNodeList = this.getIntegrityNode(allNodes, userIds);
        if (CollectionUtils.isEmpty(rootNodeList)) {
            return rootNodeList;
        }
        for (TreeNode root : rootNodeList) {
            List child;
            if (root.isLeaf() || CollectionUtils.isEmpty((Collection)(child = root.getChildren()))) continue;
            this.setChildNumber(root, child, child.size());
        }
        return rootNodeList;
    }

    private List<TreeNode> getIntegrityNode(Map<String, TreeNode> positionIdsMap, Map<String, Set<Long>> userIds) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(8);
        for (Map.Entry<String, TreeNode> entry : positionIdsMap.entrySet()) {
            TreeNode treeNode = entry.getValue();
            Set userId = userIds.getOrDefault(treeNode.getId(), new HashSet(0));
            HashMap<String, Integer> positionAttribute = new HashMap<String, Integer>(2);
            positionAttribute.put(ON_DUTY_PERSONNEL, userId.size());
            positionAttribute.put(SUBORDINATE_POSITIONS, 0);
            treeNode.setData(positionAttribute);
            if ("0".equals(treeNode.getParentid())) {
                arrayList.add(treeNode);
                continue;
            }
            TreeNode parentNode = positionIdsMap.get(treeNode.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(treeNode);
            parentNode.setLeaf(false);
        }
        return arrayList;
    }

    private void setChildNumber(TreeNode node, List<TreeNode> child, int childNumber) {
        for (TreeNode treeNode : child) {
            if (treeNode.isLeaf()) continue;
            List childes = treeNode.getChildren();
            this.setChildNumber(treeNode, childes, childes.size());
            Map positionAttribute = (Map)treeNode.getData();
            childNumber += positionAttribute.getOrDefault(SUBORDINATE_POSITIONS, 0).intValue();
        }
        Map positionAttribute = (Map)node.getData();
        positionAttribute.put(SUBORDINATE_POSITIONS, childNumber);
    }

    private Map<String, Set<Long>> getPeopleUnderPositionCount(Set<Long> positionIds) {
        QFilter positionIdFilter = new QFilter("entryentity.post", "in", positionIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HashMap<String, Set<Long>> userIdsMap = new HashMap<String, Set<Long>>(positionIds.size());
        Map userObj = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,entryentity.post", (QFilter[])new QFilter[]{positionIdFilter, enableFilter});
        for (Map.Entry entry : userObj.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            long userId = dynamicObject.getLong("id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject dpt : entryEntity) {
                DynamicObject positionObj = dpt.getDynamicObject("post");
                if (positionObj == null) continue;
                String positionId = positionObj.getString("id");
                Set userIds = userIdsMap.computeIfAbsent(positionId, k -> new HashSet(userObj.size()));
                userIds.add(userId);
            }
        }
        return userIdsMap;
    }

    public void customEvent(CustomEventArgs e) {
        if (!e.getEventName().equals("clickPosition")) {
            return;
        }
        if (e.getEventArgs().isEmpty()) {
            return;
        }
        long positionId = Long.parseLong(e.getEventArgs());
        this.getPeopleUnderPosition(positionId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (REPORT_TYPE.equals(propName)) {
            this.getModel().setValue("position", (Object)"");
        }
    }
}

