/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class RepRelDeleteValidator
extends AbstractValidator {
    private static final String REPORT_TYPE = "reporttype";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private String source = null;

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void validate() {
        ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        this.validateIsPositionDelete(extendedDataEntities);
        this.validateIsInAdminOrgCharge(extendedDataEntities);
    }

    private void validateIsPositionDelete(List<ExtendedDataEntity> extendedDataEntities) {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject positionObj;
            DynamicObject relationObj = extendedDataEntity.getDataEntity();
            DynamicObject reportTypeObj = relationObj.getDynamicObject(REPORT_TYPE);
            if (reportTypeObj == null || (positionObj = relationObj.getDynamicObject("position")) == null) continue;
            if (this.getSource() == null && 1690596074244322304L == reportTypeObj.getLong("id")) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u5141\u8bb8\u5728\u6c47\u62a5\u5173\u7cfb\u4e2d\u5220\u9664\u201c\u884c\u653f\u201d\u4e0b\u7684\u6c47\u62a5\u5173\u7cfb\u3002", (String)"RepRelDeleteValidator_0", (String)"bos-sec-user", (Object[])new Object[0]), positionObj.getString("number")));
                continue;
            }
            extendedDataEntities.add(extendedDataEntity);
        }
        this.setDataEntities(extendedDataEntities.toArray(new ExtendedDataEntity[0]));
    }

    private void validateIsInAdminOrgCharge(List<ExtendedDataEntity> extendedDataEntities) {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            return;
        }
        HasPermOrgResult list = PermissionServiceHelper.getAdminChargeOrgWithParaMap((Long)RequestContext.get().getCurrUserId(), (String)"01", (boolean)false, null);
        if (list.hasAllOrgPerm()) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject relationObj = extendedDataEntity.getDataEntity();
            DynamicObject positionObj = relationObj.getDynamicObject("position");
            if (positionObj == null) continue;
            DynamicObject dptObj = positionObj.getDynamicObject("dpt");
            long dptId = dptObj.getLong("id");
            if (list.getHasPermOrgs().contains(dptId)) continue;
            this.errorMsg(extendedDataEntity, positionObj);
            extendedDataEntities.remove(extendedDataEntity);
        }
        this.setDataEntities(extendedDataEntities.toArray(new ExtendedDataEntity[0]));
    }

    private void errorMsg(ExtendedDataEntity extendedDataEntity, DynamicObject positionObj) {
        this.addFatalErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u5c97\u4f4d\u4e0d\u5728\u7ba1\u7406\u5458\u7684\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"RepRelDeleteValidator_1", (String)"bos-sec-user", (Object[])new Object[0]), positionObj.getString("number")));
    }
}

