/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class RepRelDeleteValidatorSubPositions
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(RepRelDeleteValidatorSubPositions.class);
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String REPORT_TYPE_ID = "reporttype.id";
    private static final String SUPERIOR_POSITION_ID = "superiorposition.id";
    private static final String REPORT_TYPE = "reporttype";

    public void validate() {
        this.validateIsExistSubordinatePositions();
    }

    private void validateIsExistSubordinatePositions() {
        ArrayList<Long> typeIds = new ArrayList<Long>(8);
        HashMap<Long, ExtendedDataEntity> deletePositionIds = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        HashSet errorDataIndexes = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        int i = 0;
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            if (errorDataIndexes.contains(i++)) continue;
            DynamicObject relationObj = extendedDataEntity.getDataEntity();
            DynamicObject reportTypeObj = relationObj.getDynamicObject(REPORT_TYPE);
            DynamicObject positionObj = relationObj.getDynamicObject("position");
            if (reportTypeObj == null || positionObj == null) continue;
            long typeId = reportTypeObj.getLong("id");
            long positionId = positionObj.getLong("id");
            typeIds.add(typeId);
            deletePositionIds.put(positionId, extendedDataEntity);
        }
        this.setDataEntities(deletePositionIds.values().toArray(new ExtendedDataEntity[0]));
        Map<Long, Map<Long, List<Long>>> positionToSubordinatePositions = this.buildPositionToSubordinatePositions(typeIds, deletePositionIds);
        this.validateIsExistSubordinatePositions(positionToSubordinatePositions, deletePositionIds);
    }

    private Map<Long, Map<Long, List<Long>>> buildPositionToSubordinatePositions(List<Long> typeIds, Map<Long, ExtendedDataEntity> positionIds) {
        HashMap<Long, Map<Long, List<Long>>> positionToSubordinatePositions = new HashMap<Long, Map<Long, List<Long>>>(typeIds.size());
        QFilter typeFilter = new QFilter(REPORT_TYPE_ID, "in", typeIds);
        QFilter sPFilter = new QFilter(SUPERIOR_POSITION_ID, "in", positionIds.keySet());
        String selectFields = "reporttype.id,position.id,superiorposition.id";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"RepRelDeleteValidatorSubPositions.buildPositionToSubordinatePositions", (String)BOS_REPORT_RELATION, (String)selectFields, (QFilter[])new QFilter[]{typeFilter, sPFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                long rId = r.getLong(REPORT_TYPE_ID);
                long sPId = r.getLong(SUPERIOR_POSITION_ID);
                long pId = r.getLong("position.id");
                Map p2SP = positionToSubordinatePositions.computeIfAbsent(rId, k -> new HashMap(8));
                List subordinatePositions = p2SP.computeIfAbsent(sPId, k -> new ArrayList(8));
                subordinatePositions.add(pId);
            }
        }
        catch (Exception e) {
            log.warn("buildPositionToSubordinatePositions is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return positionToSubordinatePositions;
    }

    private void validateIsExistSubordinatePositions(Map<Long, Map<Long, List<Long>>> positionToSubordinatePositions, Map<Long, ExtendedDataEntity> deletePositionIds) {
        HashMap<Long, Boolean> isCheckPositionIds = new HashMap<Long, Boolean>(deletePositionIds.size());
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            Map pToSP;
            DynamicObject relationObj = extendedDataEntity.getDataEntity();
            DynamicObject positionObj = relationObj.getDynamicObject("position");
            DynamicObject reportTypeObj = relationObj.getDynamicObject(REPORT_TYPE);
            if (reportTypeObj == null || positionObj == null) continue;
            long typeId = reportTypeObj.getLong("id");
            long positionId = positionObj.getLong("id");
            if (isCheckPositionIds.containsKey(positionId) || (pToSP = (Map)positionToSubordinatePositions.getOrDefault(typeId, new HashMap(0))).isEmpty()) continue;
            this.validateIsExistSubordinatePositions(pToSP, deletePositionIds, positionId, isCheckPositionIds);
        }
    }

    private boolean validateIsExistSubordinatePositions(Map<Long, List<Long>> pToSP, Map<Long, ExtendedDataEntity> deletePositionIds, long positionId, Map<Long, Boolean> isCheckPositionIds) {
        List subordinatePositions = pToSP.getOrDefault(positionId, new ArrayList(0));
        if (CollectionUtils.isEmpty((Collection)subordinatePositions)) {
            isCheckPositionIds.put(positionId, true);
            return true;
        }
        ArrayList copySubordinatePositions = new ArrayList(subordinatePositions);
        subordinatePositions.removeAll(deletePositionIds.keySet());
        if (!CollectionUtils.isEmpty((Collection)subordinatePositions)) {
            this.addErrorMsg(deletePositionIds, positionId, isCheckPositionIds);
            return false;
        }
        Iterator iterator = copySubordinatePositions.iterator();
        while (iterator.hasNext()) {
            long subordinatePosition = (Long)iterator.next();
            Boolean isCheck = isCheckPositionIds.get(subordinatePosition);
            if (isCheck != null) {
                if (Boolean.TRUE.equals(isCheck)) continue;
                this.addErrorMsg(deletePositionIds, positionId, isCheckPositionIds);
                return false;
            }
            if (this.validateIsExistSubordinatePositions(pToSP, deletePositionIds, subordinatePosition, isCheckPositionIds)) continue;
            this.addErrorMsg(deletePositionIds, positionId, isCheckPositionIds);
            return false;
        }
        isCheckPositionIds.put(positionId, true);
        return true;
    }

    private void addErrorMsg(Map<Long, ExtendedDataEntity> deletePositionIds, long positionId, Map<Long, Boolean> isCheckPositionIds) {
        ExtendedDataEntity extendedDataEntity = deletePositionIds.get(positionId);
        if (extendedDataEntity != null) {
            DynamicObject rRL = extendedDataEntity.getDataEntity();
            DynamicObject positionObj = rRL.getDynamicObject("position");
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u5c97\u4f4d\u8fd8\u5b58\u5728\u4e0b\u7ea7\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RepRelDeleteValidatorSubPositions_0", (String)"bos-sec-user", (Object[])new Object[0]), positionObj.getString("number")));
            deletePositionIds.remove(positionId);
            isCheckPositionIds.put(positionId, false);
        }
    }
}

