/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RepRelSaveValidator
extends AbstractValidator {
    private static final String REPORT_TYPE = "reporttype";
    private static final String REPORT_TYPE_NAME = "reporttype.name";
    private static final String POSITION_NUMBER = "position.number";
    private static final String SUPERIOR_POSITION = "superiorposition";
    private static final String POSITION = "position";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String POSITION_ID = "position.id";
    private static final String SUPERIOR_POSITION_ID = "superiorposition.id";
    private static final String REPORT_TYPE_ID = "reporttype.id";

    public void validate() {
        HashMap<Long, Map<Long, ExtendedDataEntity>> reportRelationMap = new HashMap<Long, Map<Long, ExtendedDataEntity>>();
        this.validateData(reportRelationMap);
        this.validatorMutualSuperiors(reportRelationMap);
        this.validateDataBase(reportRelationMap);
    }

    private void validateData(Map<Long, Map<Long, ExtendedDataEntity>> reportRelationMap) {
        HashMap<Long, Map<Long, Long>> existsReportRelationMap = new HashMap<Long, Map<Long, Long>>(reportRelationMap.size());
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject reportRelationObj = extendedDataEntity.getDataEntity();
            DynamicObject superiorPositionObj = reportRelationObj.getDynamicObject(SUPERIOR_POSITION);
            DynamicObject positionObj = reportRelationObj.getDynamicObject(POSITION);
            DynamicObject reportTypeObj = reportRelationObj.getDynamicObject(REPORT_TYPE);
            if (reportTypeObj == null || positionObj == null) continue;
            boolean isChange = this.validateIsChange(reportRelationObj, extendedDataEntity);
            boolean has = this.validatorSuperiorPosition(extendedDataEntity, existsReportRelationMap);
            if (!has || isChange) continue;
            long reportTypeId = reportTypeObj.getLong("id");
            Map positionIdMap = reportRelationMap.computeIfAbsent(reportTypeId, k -> new HashMap(this.dataEntities.length));
            Map positionIdMap2 = existsReportRelationMap.computeIfAbsent(reportTypeId, k -> new HashMap(this.dataEntities.length));
            long positionId = positionObj.getLong("id");
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)positionIdMap.get(positionId);
            if (dataEntity != null) {
                DynamicObject existsOrgDutyObj = dataEntity.getDataEntity();
                this.validateUnique(extendedDataEntity, existsOrgDutyObj);
            }
            positionIdMap.put(positionId, extendedDataEntity);
            positionIdMap2.put(positionId, null == superiorPositionObj ? 0L : superiorPositionObj.getLong("id"));
        }
    }

    private boolean validateIsChange(DynamicObject reportRelationObj, ExtendedDataEntity extendedDataEntity) {
        if (!reportRelationObj.getDataEntityState().getFromDatabase()) {
            return false;
        }
        String dirtyProperties = reportRelationObj.getDataEntityState().GetDirtyProperties(false).toString();
        if (dirtyProperties.contains("fpositionid")) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u5c97\u4f4d\u3002", (String)"RepRelSaveValidator_0", (String)"bos-sec-user", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, msg);
            return true;
        }
        if (dirtyProperties.contains("freporttypeid")) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u6c47\u62a5\u7c7b\u578b\u3002", (String)"RepRelSaveValidator_1", (String)"bos-sec-user", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, msg);
            return true;
        }
        return false;
    }

    private boolean validatorSuperiorPosition(ExtendedDataEntity extendedDataEntity, Map<Long, Map<Long, Long>> existsReportRelationMap) {
        DynamicObject reportRelationObj = extendedDataEntity.getDataEntity();
        DynamicObject superiorPositionObj = reportRelationObj.getDynamicObject(SUPERIOR_POSITION);
        DynamicObject positionObj = reportRelationObj.getDynamicObject(POSITION);
        DynamicObject reportTypeObj = reportRelationObj.getDynamicObject(REPORT_TYPE);
        long reportTypeId = reportTypeObj.getLong("id");
        long positionID = positionObj.getLong("id");
        Map<Long, Long> reportRelationMap = existsReportRelationMap.get(reportTypeId);
        if (superiorPositionObj != null) {
            long superiorPositionID = superiorPositionObj.getLong("id");
            if (superiorPositionID == positionID) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5c97\u4f4d\u201c%2$s\u201d\u7684\u4e0a\u7ea7\u5c97\u4f4d\u4e0d\u80fd\u662f\u81ea\u8eab\u3002", (String)"RepRelSaveValidator_2", (String)"bos-sec-user", (Object[])new Object[0]), reportTypeObj.getString("name"), positionObj.getString("number"));
                this.addErrorMessage(extendedDataEntity, msg);
                return false;
            }
            if (!CollectionUtils.isEmpty(reportRelationMap) && this.validatorMutualSuperiorsDataBase(existsReportRelationMap, reportTypeId, superiorPositionID, positionID)) {
                String msg = this.getMsg(extendedDataEntity.getDataEntity().getDataEntityState().getFromDatabase());
                this.addErrorMessage(extendedDataEntity, msg);
                return false;
            }
        }
        return true;
    }

    private void validatorMutualSuperiors(Map<Long, Map<Long, ExtendedDataEntity>> reportRelationMap) {
        if (reportRelationMap.isEmpty()) {
            return;
        }
        HashMap<Long, Map<Long, Long>> existsReportRelationMap = new HashMap<Long, Map<Long, Long>>(reportRelationMap.size());
        QFilter[] qFilter = new QFilter[]{new QFilter(REPORT_TYPE_ID, "in", reportRelationMap.keySet())};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (QFilter[])qFilter);
        HashMap<Long, DynamicObject> rootIdMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            long reportTypeId = dynamicObject.getLong(REPORT_TYPE_ID);
            long superiorPositionID = dynamicObject.getLong(SUPERIOR_POSITION_ID);
            if (superiorPositionID == 0L) {
                rootIdMap.put(reportTypeId, dynamicObject);
            }
            long positionID = dynamicObject.getLong(POSITION_ID);
            Map positionIdMap = existsReportRelationMap.computeIfAbsent(reportTypeId, k -> new HashMap(this.dataEntities.length));
            positionIdMap.put(positionID, superiorPositionID);
        }
        this.validatorMutualSuperiors(existsReportRelationMap, reportRelationMap, rootIdMap);
    }

    private void validatorMutualSuperiors(Map<Long, Map<Long, Long>> existsReportRelationMap, Map<Long, Map<Long, ExtendedDataEntity>> reportRelationMap, Map<Long, DynamicObject> rootIdMap) {
        for (Map.Entry<Long, Map<Long, ExtendedDataEntity>> entry : reportRelationMap.entrySet()) {
            long reportTypeId = entry.getKey();
            Map<Long, ExtendedDataEntity> positionIdMap = entry.getValue();
            ArrayList<Long> rootId = new ArrayList<Long>(1);
            for (Map.Entry<Long, ExtendedDataEntity> entryMap : positionIdMap.entrySet()) {
                long superiorPositionId;
                ExtendedDataEntity positionDE = positionIdMap.get(entryMap.getKey());
                DynamicObject reportTypeObj = positionDE.getDataEntity().getDynamicObject(REPORT_TYPE);
                DynamicObject superiorPositionObj = positionDE.getDataEntity().getDynamicObject(SUPERIOR_POSITION);
                if (superiorPositionObj == null) continue;
                long superiorPositionID = superiorPositionObj.getLong("id");
                if (this.validatorMutualSuperiorsDataBase(existsReportRelationMap, reportTypeId, superiorPositionID, entryMap.getKey())) {
                    String msg = this.getMsg(positionDE.getDataEntity().getDataEntityState().getFromDatabase());
                    this.addErrorMessage(positionDE, msg);
                }
                if (this.validatorIsExistSuperiorReportRelation(existsReportRelationMap, rootIdMap, rootId, reportTypeId, superiorPositionId = this.getTopLevelPosition(reportRelationMap, reportTypeId, superiorPositionID, rootId))) continue;
                this.addErrorMsg(reportTypeObj, positionDE);
            }
        }
    }

    private boolean validatorMutualSuperiorsDataBase(Map<Long, Map<Long, Long>> existsReportRelationMap, long reportTypeId, long superiorPositionID, long positionID) {
        if (existsReportRelationMap.isEmpty() || null == existsReportRelationMap.get(reportTypeId)) {
            return false;
        }
        boolean has = false;
        if (null != existsReportRelationMap.get(reportTypeId).get(superiorPositionID)) {
            long superId = existsReportRelationMap.get(reportTypeId).get(superiorPositionID);
            if (superId != 0L && superId != positionID) {
                has = this.validatorMutualSuperiorsDataBase(existsReportRelationMap, reportTypeId, superId, positionID);
            }
            if (superId != 0L && superId == positionID) {
                has = true;
            }
        }
        return has;
    }

    private long getTopLevelPosition(Map<Long, Map<Long, ExtendedDataEntity>> reportRelationMap, long reportTypeId, long superiorPositionID, List<Long> rootId) {
        ExtendedDataEntity extendedDataEntity = reportRelationMap.get(reportTypeId).get(superiorPositionID);
        if (extendedDataEntity == null) {
            return superiorPositionID;
        }
        DynamicObject superiorPositionObj = extendedDataEntity.getDataEntity().getDynamicObject(SUPERIOR_POSITION);
        if (superiorPositionObj == null) {
            rootId.add(extendedDataEntity.getDataEntity().getDynamicObject(POSITION).getLong("id"));
            return 0L;
        }
        superiorPositionID = superiorPositionObj.getLong("id");
        superiorPositionID = this.getTopLevelPosition(reportRelationMap, reportTypeId, superiorPositionID, rootId);
        return superiorPositionID;
    }

    private boolean validatorIsExistSuperiorReportRelation(Map<Long, Map<Long, Long>> existsReportRelationMap, Map<Long, DynamicObject> rootIdMap, List<Long> rootId, long reportTypeId, long superiorPositionId) {
        if (superiorPositionId != 0L) {
            if (existsReportRelationMap.get(reportTypeId) == null) {
                return false;
            }
            return existsReportRelationMap.get(reportTypeId).get(superiorPositionId) != null;
        }
        if (existsReportRelationMap.get(reportTypeId) == null) {
            return true;
        }
        DynamicObject dynamicObject = rootIdMap.get(reportTypeId);
        long positionId = dynamicObject.getDynamicObject(POSITION).getLong("id");
        return rootId.get(0) == positionId;
    }

    private void validateDataBase(Map<Long, Map<Long, ExtendedDataEntity>> reportRelationMap) {
        if (reportRelationMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Map<Long, ExtendedDataEntity>> entry : reportRelationMap.entrySet()) {
            QFilter positionFilter = new QFilter(POSITION, "in", entry.getValue().keySet());
            QFilter dptFilter = new QFilter(REPORT_TYPE, "in", (Object)entry.getKey());
            QFilter[] filters = new QFilter[]{positionFilter, dptFilter};
            String selectFields = "id,position,position.number,reporttype.name,superiorposition";
            Map dynamicObjectCollection = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_RELATION, (String)selectFields, (QFilter[])filters);
            for (Map.Entry dynamicObjectEntry : dynamicObjectCollection.entrySet()) {
                ExtendedDataEntity extendedDataEntity = entry.getValue().get(((DynamicObject)dynamicObjectEntry.getValue()).getLong(POSITION_ID));
                this.validateUnique(extendedDataEntity, (DynamicObject)dynamicObjectEntry.getValue());
            }
        }
    }

    private void validateUnique(ExtendedDataEntity extendedDataEntity, DynamicObject existsOrgDutyObj) {
        long existsId;
        long id = extendedDataEntity.getDataEntity().getLong("id");
        if (id != (existsId = existsOrgDutyObj.getLong("id"))) {
            Object reportTypeName = extendedDataEntity.getDataEntity().get(REPORT_TYPE_NAME);
            Object positionNumber = existsOrgDutyObj.get(POSITION_NUMBER);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u5b58\u5728\u5c97\u4f4d\u201c%2$s\u201d\u3002", (String)"RepRelSaveValidator_5", (String)"bos-sec-user", (Object[])new Object[0]), reportTypeName, positionNumber);
            this.addErrorMessage(extendedDataEntity, msg);
        }
    }

    private String getMsg(boolean isComeFromDateBase) {
        String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u4e0b\u7ea7\u5c97\u4f4d\u4f5c\u4e3a\u4e0a\u7ea7\u3002", (String)"RepRelSaveValidator_7", (String)"bos-sec-user", (Object[])new Object[0]);
        if (!isComeFromDateBase) {
            msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u4e0a\u7ea7\u5c97\u4f4d\u4f5c\u4e3a\u4e0b\u7ea7\u3002", (String)"RepRelSaveValidator_8", (String)"bos-sec-user", (Object[])new Object[0]);
        }
        return msg;
    }

    private void addErrorMsg(DynamicObject reportTypeObj, ExtendedDataEntity positionDE) {
        String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4e0a\u7ea7\u5c97\u4f4d\u7684\u6c47\u62a5\u5173\u7cfb\u4e0d\u5b58\u5728\u201c%1$s\u201d\u6c47\u62a5\u7c7b\u578b\u4e2d\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"RepRelSaveValidator_9", (String)"bos-sec-user", (Object[])new Object[0]), reportTypeObj.getString("name"));
        this.addErrorMessage(positionDE, msg);
    }
}

