/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.sec.user.utils.PositionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ReportRelationListPlugin
extends StandardTreeListPlugin {
    private static final String PARAM_IS_ORG_BASE_ADMIN = "isOrgBaseAdmin";
    private boolean isFilterContainerSearchClick;
    private static final String REPORT_TYPE = "reporttype";
    private static final String BOS_REPORT_TYPE = "bos_reporttype";
    private static final String NEW_PERM = "47156aff000000ac";
    private static final String EDIT_PERM = "4715a0df000000ac";
    private static final String DELETE_PERM = "4715e1f1000000ac";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final long PRESET_TYPE_ID = 1690596074244322304L;
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String BOS_POST_RELATIONS_CHART = "bos_postrelationschart";
    private static final String REPORT_RELATION_CHART = "reportrelationchart";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String SUPERIOR_POSITION = "superiorposition";
    private static final String CMBSTANDARDLST = "cmbstandardlst";
    private static final String POSITION_ID = "position.id";
    private static final String BOS_POSITION = "bos_position";

    public void initialize() {
        super.initialize();
        ((TreeListModel)this.getTreeModel()).setGobackToRoot(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btnok"});
    }

    public void initializeTree(EventObject e) {
        TreeNode root = new TreeNode("", String.valueOf(1690596074244322304L), ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportRelationListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
        root.setChildren(new ArrayList(128));
        root.setIsOpened(true);
        this.getTreeModel().setRoot(root);
        this.treeListView.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void refreshNode(RefreshNodeEvent e) {
        long typeId = Long.parseLong(this.getReportType());
        String currentNodeId = e.getNodeId().toString();
        Map<String, TreeNode> allNodes = PositionUtils.getAllNodes(typeId);
        List<TreeNode> rootList = this.buildEntireTree(allNodes);
        if (CollectionUtils.isEmpty(rootList)) {
            return;
        }
        if (typeId == Long.parseLong(currentNodeId)) {
            e.setChildNodes(rootList);
            return;
        }
        TreeNode currentNode = allNodes.get(currentNodeId);
        if (currentNode == null) {
            return;
        }
        List treeNodeList = currentNode.getChildren();
        e.setChildNodes(treeNodeList);
    }

    private List<TreeNode> buildEntireTree(Map<String, TreeNode> allNodes) {
        if (CollectionUtils.isEmpty(allNodes)) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(8);
        for (Map.Entry<String, TreeNode> entry : allNodes.entrySet()) {
            TreeNode treeNode = entry.getValue();
            String parentId = treeNode.getParentid();
            if ("0".equals(parentId)) {
                treeNode.setIsOpened(true);
                arrayList.add(treeNode);
                continue;
            }
            TreeNode parentNode = allNodes.get(parentId);
            if (parentNode == null) continue;
            parentNode.addChild(treeNode);
            parentNode.setLeaf(false);
        }
        return arrayList;
    }

    public void setFilter(SetFilterEvent e) {
        String typeId = this.getReportType();
        QFilter reportTypeListFilter = new QFilter(REPORT_TYPE, "=", (Object)Long.parseLong(typeId));
        e.getQFilters().add(reportTypeListFilter);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        evt.setCancel(true);
        if (this.isFilterContainerSearchClick) {
            return;
        }
        String typeId = this.getReportType();
        String nodeId = evt.getNodeId().toString();
        long positionId = Long.parseLong(nodeId);
        if (nodeId.equals(typeId)) {
            return;
        }
        if (Boolean.TRUE.equals(this.getModel().getValue("chkincludechild"))) {
            List<Long> subPositionIds = PositionUtils.getSubPositionIdIncludeGrand(Long.parseLong(typeId), positionId);
            QFilter positionTreeListFilter = new QFilter(POSITION_ID, "in", subPositionIds);
            evt.addQFilter(positionTreeListFilter);
            return;
        }
        QFilter positionTreeListFilter = new QFilter(POSITION_ID, "=", (Object)positionId);
        QFilter sPositionTreeListFilter = new QFilter(SUPERIOR_POSITION, "=", (Object)positionId);
        evt.addQFilter(positionTreeListFilter.or(sPositionTreeListFilter));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isFilterContainerSearchClick = true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (CMBSTANDARDLST.equals(propertyName)) {
            this.treeListView.getTreeView().deleteAllNodes();
            long typeId = Long.parseLong(this.getReportType());
            this.getView().setVisible(Boolean.valueOf(typeId != 1690596074244322304L), new String[]{"tblnew", "tbldel"});
            TreeNode root = new TreeNode("", String.valueOf(typeId), ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportRelationListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
            String rootId = root.getId();
            root.setIsOpened(true);
            this.treeListView.getTreeModel().setRoot(root);
            this.treeListView.getTreeModel().setCurrentNodeId((Object)rootId);
            this.treeListView.getTreeView().addNode(root);
            this.treeListView.refreshTreeView();
            return;
        }
        BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
            if ("chkincludechild".equals(propertyName)) {
                this.treeListView.refreshTreeView();
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if ("openpositionlist".equals(operateKey)) {
            this.showPositionF7();
            return;
        }
        if (REPORT_RELATION_CHART.equals(operateKey)) {
            if (!this.hasPermission(QUERY_PERM, BOS_POST_RELATIONS_CHART)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5c97\u4f4d\u5173\u7cfb\u56fe\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportRelationListPlugin_2", (String)"bos-sec-user", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.showPositionRelChart();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        OperationResult operationResult = eventArgs.getOperationResult();
        if ("delete".equals(eventArgs.getOperateKey()) && operationResult.isSuccess()) {
            Map<String, Object> focusNode = this.getFocusNode();
            String parentId = focusNode.get("parentid").toString();
            if ("0".equals(parentId)) {
                parentId = this.getReportType();
            }
            this.treeListView.getTreeView().treeNodeClick("", parentId);
            this.treeListView.refreshTreeView();
        }
    }

    private void showPositionRelChart() {
        Object typeId = this.getModel().getValue(CMBSTANDARDLST);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(BOS_POST_RELATIONS_CHART);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(REPORT_TYPE, typeId);
        Map<String, Object> focusNode = this.getFocusNode();
        if (focusNode != null) {
            String positionId = focusNode.get("id").toString();
            formShowParameter.setCustomParam("position", (Object)positionId);
        }
        this.getView().showForm(formShowParameter);
    }

    private void showPositionF7() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)BOS_POSITION, (boolean)true);
        listShowParameter.setCustomParam(PARAM_IS_ORG_BASE_ADMIN, (Object)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_POSITION));
        listShowParameter.setCustomParam(CMBSTANDARDLST, this.getModel().getValue(CMBSTANDARDLST));
        Map<String, Object> focusNode = this.getFocusNode();
        Object nodeId = "0";
        if (focusNode != null) {
            nodeId = focusNode.get("id");
        }
        if (StringUtils.isNotBlank((Object)nodeId) && !"0".equals(nodeId)) {
            QFilter qFilter = new QFilter("id", "not in", (Object)Long.valueOf(nodeId.toString()));
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void treeToolbarClick(EventObject e) {
        Control ctl = (Control)e.getSource();
        String reportTypeId = this.getReportType();
        switch (ctl.getKey()) {
            case "btnnew": {
                if (this.hasPermission(NEW_PERM, BOS_REPORT_TYPE)) {
                    this.treeToolBarAddClick();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6c47\u62a5\u7c7b\u578b\u201d\u65b0\u589e\u201c\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportRelationListPlugin_3", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
            case "btnedit": {
                if (this.hasPermission(EDIT_PERM, BOS_REPORT_TYPE)) {
                    this.treeToolBarEditClick(reportTypeId);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6c47\u62a5\u7c7b\u578b\u201d\u4fee\u6539\u201c\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportRelationListPlugin_4", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
            case "btndel": {
                if (this.hasPermission(DELETE_PERM, BOS_REPORT_TYPE)) {
                    this.treeToolBarDeleteClick();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6c47\u62a5\u7c7b\u578b\u201d\u5220\u9664\u201c\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportRelationListPlugin_5", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void treeToolBarAddClick() {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(BOS_REPORT_TYPE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void treeToolBarEditClick(String reportTypeId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(BOS_REPORT_TYPE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setPkId((Object)reportTypeId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void treeToolBarDeleteClick() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        String str = ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u8be5\u6c47\u62a5\u7c7b\u578b\uff1f", (String)"ReportRelationListPlugin_6", (String)"bos-sec-user", (Object[])new Object[0]);
        this.getView().showConfirm(str, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modify"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("addnew".equals(closedCallBackEvent.getActionId())) {
            this.initializeCmbStandardList(this.getReportType());
            return;
        }
        if ("edit".equals(closedCallBackEvent.getActionId())) {
            this.initializeCmbStandardList(this.getReportType());
            return;
        }
        if (BOS_POSITION.equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.addPosition(selectedRows);
            return;
        }
        if ("modify".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!(returnData instanceof Map)) {
                return;
            }
            Map returnDataMap = (Map)returnData;
            Object positionId = returnDataMap.get("positionId");
            Object newSuperiorPositionId = returnDataMap.get("superiorPositionId");
            if (positionId == null || newSuperiorPositionId == null) {
                return;
            }
            String pId = positionId.toString();
            String newParentId = newSuperiorPositionId.toString();
            TreeNode rootNode = this.getTreeModel().getRoot();
            if (rootNode == null) {
                return;
            }
            TreeNode currentNode = rootNode.getTreeNode(pId);
            if (currentNode == null || newParentId.equals(currentNode.getParentid())) {
                return;
            }
            TreeNode newParentNode = rootNode.getTreeNode(newParentId);
            if (newParentNode == null) {
                return;
            }
            currentNode.setParentid(newParentId);
            TreeView treeView = this.getTreeListView().getTreeView();
            treeView.deleteNode(pId);
            rootNode.deleteChildNode(pId);
            newParentNode.addChild(currentNode);
            treeView.addNode(currentNode);
            this.getTreeListView().refreshTreeView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes && "delete".equals(event.getCallBackId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            long reportTypeId = Long.parseLong(this.getReportType());
            if (1690596074244322304L == reportTypeId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReportRelationListPlugin_7", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            if (billList.queryBillDataCount() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6c47\u62a5\u7c7b\u578b\u4e0b\u8fd8\u5b58\u5728\u5c97\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ReportRelationListPlugin_8", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(reportTypeId);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)BOS_REPORT_TYPE, (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReportRelationListPlugin_9", (String)"bos-sec-user", (Object[])new Object[0]));
                this.getModel().setValue(CMBSTANDARDLST, (Object)String.valueOf(1690596074244322304L));
                this.initializeCmbStandardList(String.valueOf(1690596074244322304L));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void addPosition(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        Map<String, Object> focusNode = this.getFocusNode();
        if (CollectionUtils.isEmpty(focusNode)) {
            return;
        }
        ArrayList<Long> positionIdList = new ArrayList<Long>(selectedRows.size() + 1);
        for (ListSelectedRow row : selectedRows) {
            long positionId = Long.parseLong(row.getPrimaryKeyValue().toString());
            positionIdList.add(positionId);
        }
        long superiorPositionId = 0L;
        String typeId = this.getReportType();
        String focusNodeId = focusNode.get("id").toString();
        if (focusNodeId.equals(typeId)) {
            this.addReportRelation(selectedRows, positionIdList, typeId, superiorPositionId);
            return;
        }
        superiorPositionId = Long.parseLong(focusNodeId);
        positionIdList.add(superiorPositionId);
        this.addReportRelation(selectedRows, positionIdList, typeId, superiorPositionId);
    }

    private void addReportRelation(ListSelectedRowCollection selectedRows, List<Long> positionIdList, String typeId, long superiorPositionId) {
        Map positionObjMap = BusinessDataServiceHelper.loadFromCache((Object[])positionIdList.toArray(new Object[0]), (String)BOS_POSITION);
        if (CollectionUtils.isEmpty((Map)positionObjMap)) {
            return;
        }
        DynamicObject reportTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_REPORT_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(typeId))});
        if (reportTypeObj == null) {
            return;
        }
        DynamicObject superiorPositionObj = (DynamicObject)positionObjMap.get(superiorPositionId);
        ArrayList<DynamicObject> reportRelationObjList = new ArrayList<DynamicObject>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            DynamicObject positionObj = (DynamicObject)positionObjMap.get(row.getPrimaryKeyValue());
            DynamicObject reportRelationObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_REPORT_RELATION);
            reportRelationObj.set(REPORT_TYPE, (Object)reportTypeObj);
            reportRelationObj.set("position", (Object)positionObj);
            reportRelationObj.set(SUPERIOR_POSITION, (Object)superiorPositionObj);
            reportRelationObjList.add(reportRelationObj);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)BOS_REPORT_RELATION, (DynamicObject[])reportRelationObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"ReportRelationListPlugin_10", (String)"bos-sec-user", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
        this.treeListView.refreshTreeView();
    }

    private boolean hasPermission(String perm, String entityName) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityName, (String)perm);
    }

    private Map<String, Object> getFocusNode() {
        return this.treeListView.getTreeView().getTreeState().getFocusNode();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long focusRowPkId = (Long)billList.getFocusRowPkId();
        QFilter idFilter = new QFilter("id", "=", (Object)focusRowPkId);
        String selectProperties = "position,superiorposition";
        DynamicObject relationObj = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_REPORT_RELATION, (String)selectProperties, (QFilter[])new QFilter[]{idFilter});
        if (relationObj == null) {
            return;
        }
        DynamicObject positionObj = relationObj.getDynamicObject("position");
        DynamicObject dptObj = positionObj.getDynamicObject("dpt");
        long dptId = dptObj.getLong("id");
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            return;
        }
        HasPermOrgResult list = PermissionServiceHelper.getAdminChargeOrgWithParaMap((Long)RequestContext.get().getCurrUserId(), (String)"01", (boolean)false, null);
        if (list.hasAllOrgPerm()) {
            return;
        }
        if (!list.getHasPermOrgs().contains(dptId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u4e0d\u5728\u7ba1\u7406\u5458\u7684\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ReportRelationListPlugin_12", (String)"bos-sec-user", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initializeCmbStandardList(String.valueOf(1690596074244322304L));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tbldel"});
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        if (row == null) {
            return;
        }
        Object id = row.getPrimaryKeyValue();
        DynamicObject reportRelationObj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)BOS_REPORT_RELATION);
        if (reportRelationObj == null) {
            return;
        }
        DynamicObject positionObj = reportRelationObj.getDynamicObject("position");
        if (positionObj == null) {
            return;
        }
        String focusNodeId = positionObj.getString("id");
        TreeNode root = this.getTreeModel().getRoot();
        if (root == null) {
            return;
        }
        TreeNode focusNode = root.getTreeNode(focusNodeId);
        if (focusNode == null) {
            return;
        }
        this.treeListView.getTreeView().focusNode(focusNode);
        this.treeListView.getTreeModel().setCurrentNodeId((Object)focusNodeId);
    }

    private void initializeCmbStandardList(String reportTypeId) {
        ComboEdit combo = (ComboEdit)this.getControl(CMBSTANDARDLST);
        String selectProperties = "number,name,enable";
        Map reportTypeMap = BusinessDataServiceHelper.loadFromCache((String)BOS_REPORT_TYPE, (String)selectProperties, null);
        this.getModel().beginInit();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(reportTypeMap.size());
        for (DynamicObject reportTypeObj : reportTypeMap.values()) {
            ComboItem item = new ComboItem();
            String id = reportTypeObj.getString("id");
            String name = reportTypeObj.getString("name");
            String number = reportTypeObj.getString("number");
            String caption = name + " " + number;
            boolean enable = reportTypeObj.getBoolean("enable");
            if (!enable) {
                item.setImageKey("/icons/pc/state/disable30_30.png");
            } else {
                item.setImageKey("kdfont kdfont-tongguo3");
            }
            item.setValue(id);
            item.setCaption(new LocaleString(caption));
            items.add(item);
        }
        combo.setComboItems(items);
        this.getModel().setValue(CMBSTANDARDLST, (Object)reportTypeId);
        this.getModel().endInit();
        this.getView().updateView(CMBSTANDARDLST);
    }

    private String getReportType() {
        Object reportType = this.getModel().getValue(CMBSTANDARDLST);
        if (ObjectUtils.isEmpty((Object)reportType)) {
            return "0";
        }
        return reportType.toString();
    }
}

