/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.sec.user.utils.UserOperationUtils;

public class UserEditPagePlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String PROP_USER_CONTACT_TYPE = "contacttype";
    private static final String PROP_USER_CONTACT_ENTITY = "contactentity";
    private static final String PROP_ORG_STRUCTURE = "orgstructure";
    private static final String POST = "post";

    public void registerListener(EventObject e) {
        MulBasedataEdit userTypesEdit;
        BasedataEdit post;
        UserEdit user;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("dpt");
        if (orgEdit != null) {
            orgEdit.setIsOrgBaseAdmin(true);
            orgEdit.addBeforeF7SelectListener(this::beforeF7Select);
            orgEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((user = (UserEdit)this.getControl("superior")) != null) {
            user.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if ((post = (BasedataEdit)this.getControl(POST)) != null) {
            post.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((userTypesEdit = (MulBasedataEdit)this.getControl("usertypes")) != null) {
            userTypesEdit.addBeforeF7SelectListener(event -> {
                ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
                formShowParameter.setMultiSelect(false);
            });
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String phone = this.getModel().getValue("phone").toString();
        if (StringUtils.isBlank((CharSequence)phone) || phone.contains("-") || phone.length() != 11 || !phone.startsWith("1")) {
            return;
        }
        String areaPhone = "+86-" + phone;
        this.getModel().setValue("phone", (Object)areaPhone);
    }

    public void afterCreateNewData(EventObject e) {
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        if (StringUtils.isNotBlank((Object)orgId) && !"0".equals(orgId.toString())) {
            if (this.getModel().getEntryRowCount("entryentity") == 0) {
                this.getModel().createNewEntryRow("entryentity");
            }
            this.getModel().setValue("dpt", orgId, 0);
            this.positionOrgChanged(0);
        }
        this.initUserType();
        this.getView().getFormShowParameter().setCustomParam("isNSCountryAllowedNull", (Object)true);
        this.getModel().setValue("ns_country", null);
        long nameMergeStyleId = UserUtils.getNameMergeStyleId();
        if (nameMergeStyleId != 0L) {
            this.getModel().setValue("ns_namestyle", (Object)nameMergeStyleId);
        }
    }

    private void initUserType() {
        String defaultType = "1";
        this.getModel().setValue("usertype", (Object)defaultType);
        Object[] userTypeIds = new Object[]{defaultType};
        this.getModel().setValue("usertypes", (Object)userTypeIds);
    }

    public void afterBindData(EventObject e) {
        this.editAble();
        this.getModel().setDataChanged(false);
    }

    private void editAble() {
        DynamicObject userObj = this.getModel().getDataEntity();
        if (!userObj.getBoolean("enable")) {
            this.getModel().setValue("editable", (Object)Boolean.FALSE);
            return;
        }
        Boolean editAble = Boolean.FALSE;
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("usertypes");
        if (rows != null) {
            for (DynamicObject row : rows) {
                DynamicObject userTypeObj = row.getDynamicObject("fbasedataid");
                if (userTypeObj == null || !"1".equals(userTypeObj.getString("category"))) continue;
                editAble = Boolean.TRUE;
            }
        }
        this.getModel().setValue("editable", (Object)editAble);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("name".equals(propName)) {
            this.nameChanged(e);
            return;
        }
        if ("usertypes".equals(propName)) {
            this.userTypeChanged(e);
            return;
        }
        if ("ispartjob".equals(propName)) {
            this.partJobChanged(e);
            return;
        }
        if ("dpt".equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            this.dptChanged(changeData.getRowIndex());
            return;
        }
        if ("isdefault".equals(propName) || PROP_USER_CONTACT_TYPE.equals(propName)) {
            this.defaultContactChanged(e);
            return;
        }
    }

    private void nameChanged(PropertyChangedArgs e) {
        Object nameObj = this.getModel().getValue("name");
        if (StringUtils.isBlank((Object)nameObj)) {
            this.getModel().setValue("fullpinyin", (Object)"");
            this.getModel().setValue("simplepinyin", (Object)"");
        } else if (this.isNameChanged(e)) {
            String name = nameObj.toString();
            String fullPinyin = UserOperationUtils.getFullSpellByName(name);
            Object oldFullPinyin = this.getModel().getValue("fullpinyin");
            this.getModel().setValue("fullpinyin", (Object)fullPinyin);
            Object username = this.getModel().getValue("username");
            if (StringUtils.isBlank((Object)username) || username.equals(oldFullPinyin)) {
                this.getModel().setValue("username", (Object)UserOperationUtils.getUserNameByFormatedFullPinyin(this.getModel().getDataEntity().getLong("id"), fullPinyin, null));
            }
            String simplePinyin = UserOperationUtils.getFirstSpellByName(name);
            this.getModel().setValue("simplepinyin", (Object)simplePinyin);
        }
    }

    private boolean isNameChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if (!(oldValue instanceof LocaleDynamicObjectCollection) || !(newValue instanceof LocaleDynamicObjectCollection)) {
            return true;
        }
        LocaleDynamicObjectCollection oldNames = (LocaleDynamicObjectCollection)oldValue;
        LocaleDynamicObjectCollection newNames = (LocaleDynamicObjectCollection)newValue;
        for (DynamicObject oldName : oldNames) {
            for (DynamicObject newName : newNames) {
                if (!Objects.equals(oldName.get("name"), newName.get("name"))) continue;
                return false;
            }
        }
        return true;
    }

    private void userTypeChanged(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        Object newValue = data.getNewValue();
        if (!(newValue instanceof DynamicObjectCollection)) {
            return;
        }
        DynamicObjectCollection userTypeCol = (DynamicObjectCollection)newValue;
        StringJoiner userTypeIds = new StringJoiner(",");
        for (DynamicObject userTypeEditObj : userTypeCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (userTypeObj == null) continue;
            userTypeIds.add(userTypeObj.getPkValue().toString());
        }
        String userTypeId = userTypeIds.toString();
        this.getModel().setValue("usertype", (Object)userTypeId);
        if ("6".equals(userTypeId)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData(PROP_USER_CONTACT_ENTITY);
        }
    }

    private void partJobChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (!(newValue instanceof Boolean)) {
            return;
        }
        boolean isPartJob = (Boolean)newValue;
        if (isPartJob) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowCount = entryEntity.size();
        if (rowCount == 1) {
            return;
        }
        int curRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (curRowIndex == rowIndex) continue;
            this.getModel().setValue("ispartjob", (Object)Boolean.TRUE, rowIndex);
        }
    }

    private void positionOrgChanged(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(1);
        DynamicObject posObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject orgObj = posObj.getDynamicObject("dpt");
        if (orgObj == null) {
            if (posObj.get(PROP_ORG_STRUCTURE) != null) {
                this.getModel().setValue(PROP_ORG_STRUCTURE, null, rowIndex);
            }
            return;
        }
        long orgId = orgObj.getLong("id");
        orgIds.add(orgId);
        if (orgIds.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> orgStrutMap = UserOperationUtils.getOrgStructure(orgIds);
        this.getModel().setValue(PROP_ORG_STRUCTURE, (Object)orgStrutMap.get(orgId), rowIndex);
    }

    private void dptChanged(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        int curRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue(POST, (Object)"", curRowIndex);
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        OrgEdit edit;
        if (event.getSource() instanceof OrgEdit && "dpt".equals((edit = (OrgEdit)event.getSource()).getFieldKey())) {
            this.fillBackOrgStructure(event);
        }
    }

    private void fillBackOrgStructure(AfterF7SelectEvent event) {
        DynamicObject orgObj;
        ListSelectedRowCollection selectedRows = event.getListSelectedRowCollection();
        List inputValues = event.getInputValues();
        if (CollectionUtils.isEmpty((Collection)selectedRows) && CollectionUtils.isEmpty((Collection)inputValues)) {
            this.getModel().setValue(PROP_ORG_STRUCTURE, null, event.getCurrentRowIndex());
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(CollectionUtils.isEmpty((Collection)selectedRows) ? inputValues.size() : selectedRows.size());
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            for (ListSelectedRow row : selectedRows) {
                orgIds.add((Long)row.getPrimaryKeyValue());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)inputValues)) {
            for (Object dptId : inputValues) {
                orgIds.add(Long.parseLong(dptId.toString()));
            }
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        DynamicObject userObj = this.getModel().getDataEntity();
        if (userObj == null) {
            return;
        }
        Map<Long, DynamicObject> orgStrutMap = UserOperationUtils.getOrgStructure(orgIds, UserOperationUtils.getOrgStructureDynamicObjectType(userObj));
        if (CollectionUtils.isEmpty(orgStrutMap)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        String jobNumber = "";
        for (DynamicObject positionObj : entryEntity) {
            if (positionObj.getBoolean("ispartjob") || (orgObj = positionObj.getDynamicObject("dpt")) == null) continue;
            jobNumber = orgObj.getString("number");
            break;
        }
        for (DynamicObject entityObj : entryEntity) {
            DynamicObject object;
            orgObj = entityObj.getDynamicObject("dpt");
            if (orgObj == null || (object = orgStrutMap.get(orgObj.getLong("id"))) == null) continue;
            entityObj.set(PROP_ORG_STRUCTURE, (Object)object);
            if (!StringUtils.isNotBlank((CharSequence)jobNumber) || jobNumber.equals(orgObj.getString("number"))) continue;
            entityObj.set("ispartjob", (Object)Boolean.TRUE);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void defaultContactChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        int currentIndex = changeData.getRowIndex();
        DynamicObject contactObj = this.getModel().getEntryRowEntity(PROP_USER_CONTACT_ENTITY, currentIndex);
        if (newValue instanceof DynamicObject ? !contactObj.getBoolean("isdefault") : !Boolean.parseBoolean(newValue.toString())) {
            return;
        }
        DynamicObject contactTypeObj = contactObj.getDynamicObject(PROP_USER_CONTACT_TYPE);
        if (contactTypeObj == null) {
            return;
        }
        long contactyTypeId = contactTypeObj.getLong("id");
        int rowCount = this.getModel().getEntryRowCount(PROP_USER_CONTACT_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            if (i == currentIndex || (contactTypeObj = (contactObj = this.getModel().getEntryRowEntity(PROP_USER_CONTACT_ENTITY, i)).getDynamicObject(PROP_USER_CONTACT_TYPE)) == null || contactyTypeId != contactTypeObj.getLong("id")) continue;
            contactObj.set("isdefault", (Object)Boolean.FALSE);
        }
        this.getView().updateView(PROP_USER_CONTACT_ENTITY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof EntityOperate) {
            EntityOperate opService = (EntityOperate)source;
            OperateOption op = opService.getOption();
            op.setVariableValue("isFrom_bos_user_Page", "1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equalsIgnoreCase(args.getOperateKey())) {
            this.getView().updateView();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
        String name = arg0.getProperty().getName();
        if ("dpt".equals(name)) {
            listShowParameter.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        } else if ("superior".equals(name)) {
            listShowParameter.setMultiSelect(false);
            Object originalValue = arg0.getOriginalValue();
            if (originalValue != null) {
                DynamicObject superiorObj = (DynamicObject)originalValue;
                listShowParameter.setSelectedRows(new Object[]{superiorObj.getPkValue()});
            }
        } else if (POST.equals(name)) {
            int rowIndex = arg0.getRow();
            DynamicObject posObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            DynamicObject orgObj = posObj.getDynamicObject("dpt");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u90e8\u95e8\u3002", (String)"UserEditPagePlugin_1", (String)"bos-sec-user", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            QFilter dptFilter = new QFilter("dpt", "=", (Object)orgObj.getLong("id"));
            listShowParameter.getListFilterParameter().getQFilters().add(dptFilter);
            listShowParameter.setFormId("bos_listf7");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        if ("entryentity".equals(entityName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities == null || rowDataEntities.length == 0) {
                return;
            }
            int rowIndex = rowDataEntities[0].getRowIndex();
            this.autoSetPartJobForNewPosition(rowIndex);
        }
    }

    private void autoSetPartJobForNewPosition(int rowIndex) {
        if (rowIndex == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject positionObj : entryEntity) {
            if (!positionObj.getBoolean("ispartjob") && index != rowIndex) {
                this.getModel().setValue("ispartjob", (Object)Boolean.TRUE, rowIndex);
                break;
            }
            ++index;
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.refreshListFilterCache();
    }

    private void refreshListFilterCache() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        if (pageCache == null) {
            return;
        }
        pageCache.remove("cache_admin_charge_user");
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        if ("idcard".equals(key) && "cts_personal_identity".equals(e.getEventName())) {
            String appId = "cts";
            String menuItemId = "1270339492749807616";
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            if (app == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u627e\u516c\u5171\u8bbe\u7f6e\u5e94\u7528\u5931\u8d25\u3002", (String)"UserEditPagePlugin_2", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuItemId);
            if (menu == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5171\u8bbe\u7f6e\uff1a\u67e5\u627e\u4e2a\u4eba\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u83dc\u5355\u5931\u8d25\u3002", (String)"UserEditPagePlugin_3", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            String appHomeNum = app.getHomeNum();
            String menuFormId = menu.getFormId();
            if (StringUtils.isBlank((CharSequence)appHomeNum) || StringUtils.isBlank((CharSequence)menuFormId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5171\u8bbe\u7f6e\u6ca1\u6709\u914d\u7f6e\u83dc\u5355\u3002", (String)"UserEditPagePlugin_4", (String)"bos-sec-user", (Object[])new Object[0]));
                return;
            }
            String appName = app.getName().getLocaleValue();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("appname", appName);
            map.put("appmainnumber", appHomeNum);
            map.put("formnumber", menuFormId);
            map.put("parametertype", menu.getParamType());
            map.put("parameter", menu.getParams());
            map.put("menuname", menu.getName().getLocaleValue());
            OpenPageUtils.openApp((String)app.getNumber(), (String)menuItemId, map, (IFormView)this.getView());
        }
    }
}

