/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.ErrorLevel;

public class UserFieldEncodeServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM_TYPE = "bos-sec-user";
    private static final String FIELD_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERCOLUMNS WHERE upper(KSQL_COL_TABNAME) = '%s' AND upper(KSQL_COL_NAME) ='%s'";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.validatePrepare(e);
    }

    private void validatePrepare(BeginOperationTransactionArgs e) {
        String property = this.getEncodeProperty();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
        DynamicProperty dynamicProperty = dt.getProperty(property);
        if (!(dynamicProperty instanceof FieldProp)) {
            e.setCancelOperation(true);
            return;
        }
        FieldProp encodeFieldProp = (FieldProp)dynamicProperty;
        if (!encodeFieldProp.isEncrypt()) {
            String msg1 = String.format(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u201c\u4eba\u5458\u201d\u5b9e\u4f53\u201c%s\u201d\u5b57\u6bb5\u7684\u201c\u52a0\u5bc6\u5b58\u50a8\u201d\u5c5e\u6027\u3002", (String)"UserFieldEncodeServicePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), encodeFieldProp.getDisplayName().getLocaleValue());
            e.setCancelOperation(true);
            this.sendErrorMsg(msg1);
            return;
        }
        String property_enp = encodeFieldProp.getAlias().toUpperCase() + "_ENP";
        if (!this.fieldIsExisted("T_SEC_USER", property_enp)) {
            String msg2 = String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u4eba\u5458\u8868\u6dfb\u52a0\u201c%1$s\u201d\u5bf9\u5e94\u7684\u52a0\u5bc6\u5b57\u6bb5\u201c%2$s\u201d\u3002", (String)"UserFieldEncodeServicePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), encodeFieldProp.getDisplayName().getLocaleValue(), property_enp);
            e.setCancelOperation(true);
            this.sendErrorMsg(msg2);
            return;
        }
        String fproperty = encodeFieldProp.getAlias().toLowerCase();
        this.encryptData(DBRoute.basedata, "fid", fproperty, property_enp, "t_sec_user");
    }

    private void sendErrorMsg(String error) {
        OperateErrorInfo info = new OperateErrorInfo();
        info.setLevel(ErrorLevel.Error);
        info.setMessage(error);
        this.operationResult.addErrorInfo(info);
    }

    private boolean fieldIsExisted(String tableName, String fieldName) {
        String sql = String.format(FIELD_IS_EXISTED_SQL, tableName, fieldName);
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private void encryptData(DBRoute dbRoute, String pkIdField, String textField, String encryptTextField, String tableName) {
        String sql = String.format("select %s , %s  from %s where %s is null", pkIdField, textField, tableName, encryptTextField);
        String encodeSQl = String.format("update %s set %s =? where %s =?", tableName, encryptTextField, pkIdField);
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"encryptData", (DBRoute)dbRoute, (String)sql));){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1000);
            while (ds.hasNext()) {
                Row row = ds.next();
                Object id = row.get(0);
                Object f1 = row.get(1);
                String f2 = Encrypters.encode((String)String.valueOf(f1));
                Object[] objects = new Object[]{f2, id};
                paramsList.add(objects);
                if (paramsList.size() != 1000) continue;
                this.handleAction(dbRoute, encodeSQl, paramsList);
                paramsList.clear();
            }
            if (!paramsList.isEmpty()) {
                this.handleAction(dbRoute, encodeSQl, paramsList);
            }
        }
    }

    private void handleAction(DBRoute dbRoute, String sql, List<Object[]> paramsList) {
        try (TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
        }
    }

    protected String getEncodeProperty() {
        return "";
    }
}

