/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.i18n.mservice.BatchImportNameCtlPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UserImportPlugin
extends BatchImportNameCtlPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        this.ctx.addOption("isNSCountryAllowedNull", (Object)true);
        this.checkUserType(billdatas, logger);
        super.beforeSave(billdatas, logger);
    }

    private void checkUserType(List<ImportBillData> billdatas, ImportLogger logger) {
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        int count = billdatas.size();
        HashMap<Object, String> userTypeErrorMap = new HashMap<Object, String>(count);
        ArrayList<ImportBillData> errorBillDataList = new ArrayList<ImportBillData>(count);
        for (ImportBillData billData : billdatas) {
            Object userType;
            Object importprop;
            JSONObject data = billData.getData();
            JSONObject userTypes = data.getJSONObject("usertypes");
            if (StringUtils.isBlank((Object)userTypes) || StringUtils.isBlank((Object)(importprop = userTypes.get((Object)"importprop"))) || StringUtils.isBlank((Object)(userType = userTypes.get((Object)importprop.toString())))) continue;
            String errorMsg = (String)userTypeErrorMap.get(userType);
            if (errorMsg == null) {
                errorMsg = this.checkUserType(importprop.toString(), userType);
                userTypeErrorMap.put(userType, errorMsg);
            }
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            errorBillDataList.add(billData);
            Object number = data.get((Object)"number");
            if (StringUtils.isNotBlank((Object)number)) {
                errorMsg = number + ":" + errorMsg;
            }
            logger.log(Integer.valueOf(billData.getStartIndex()), errorMsg);
            logger.fail();
        }
        billdatas.removeAll(errorBillDataList);
    }

    private String checkUserType(String checkProperty, Object checkValue) {
        if (!("id".equals(checkProperty) || "number".equals(checkProperty) || "name".equals(checkProperty))) {
            return "";
        }
        QFilter categoryFilter = new QFilter("category", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        QFilter numberFilter = "id".equals(checkProperty) ? new QFilter(checkProperty, "=", (Object)Long.valueOf(checkValue.toString())) : new QFilter(checkProperty, "=", checkValue);
        QFilter[] filters = new QFilter[]{categoryFilter, enableFilter, visibleFilter, numberFilter};
        DynamicObject userTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_usertype", (String)"id", (QFilter[])filters);
        if (userTypeObj == null) {
            return UserMessage.getMessage((String)"M00070");
        }
        if ("6".equals(userTypeObj.getPkValue().toString())) {
            return UserMessage.getMessage((String)"M00072");
        }
        return "";
    }
}

