/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserInfoCleanSchemeFormPlugin
extends AbstractBillPlugIn
implements ItemClickListener {
    private static final String CONTROL_FILTERGRIDAP = "filtergridap";
    private static final String ITEM_FILTERGRIDAP = "baritem_choosefield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("advcontoolbarap");
        toolBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setFieldEntry(e);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setFieldEntry(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFilterGridBeforeBindData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterGridAfterBindData();
    }

    private void setFieldEntry(EventObject e) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        int rowCount = this.getModel().getEntryRowCount("fieldentry");
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().beginInit();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            String localeFieldName;
            LocaleString displayName;
            IDataEntityProperty property;
            Object field = this.getModel().getValue("fieldnumber", i);
            if (field == null || (property = dataEntityType.findProperty(field.toString())) == null || property.getParent() == null) continue;
            IDataEntityType parentEntityType = property.getParent();
            if (parentEntityType instanceof EntryType) {
                LocaleString parentDisplayName = parentEntityType.getDisplayName();
                displayName = property.getDisplayName();
                sb.append(parentDisplayName == null ? "" : parentDisplayName.getLocaleValue());
                sb.append(".");
                sb.append(displayName == null ? "" : displayName.getLocaleValue());
                localeFieldName = sb.toString();
                sb.setLength(0);
            } else {
                displayName = property.getDisplayName();
                localeFieldName = displayName == null ? "" : displayName.getLocaleValue();
            }
            this.getModel().setValue("fieldname", (Object)localeFieldName, i);
        }
        this.getModel().endInit();
        this.getView().updateView("fieldentry");
        if (!dataChanged) {
            this.setDataChanged(false);
        }
    }

    private void setDataChanged(boolean changed) {
        this.getModel().setDataChanged(changed);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (ITEM_FILTERGRIDAP.equals(itemKey)) {
            HashSet<String> idSet = new HashSet<String>();
            int listRowCount = this.getModel().getEntryRowCount("fieldentry");
            ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
            for (int index = 0; index < listRowCount; ++index) {
                String id = (String)this.getModel().getValue("fieldnumber", index);
                String name = (String)this.getModel().getValue("fieldname", index);
                ListSelectedRow listSelectedRow = new ListSelectedRow((Object)(id + "||" + name), Boolean.FALSE);
                listSelectedRow.setName(name);
                listSelectedRow.setNumber(id);
                listSelectedRowCollection.add((Object)listSelectedRow);
                if (!StringUtils.isNotEmpty((String)id)) continue;
                idSet.add(id);
            }
            ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"bos_user_choosefield", (boolean)true, (int)0, (boolean)true);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_user_choosefield"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("paramEntityName", (Object)"bos_user");
            fsp.setCustomParam("paramAllReadySelectedPropertyNameSet", idSet);
            fsp.setListSelectedRowCollection(listSelectedRowCollection);
            fsp.setShowTitle(true);
            fsp.setHasRight(true);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("bos_user_choosefield".equals(actionId)) {
            Object retData = e.getReturnData();
            if (retData == null) {
                return;
            }
            if (retData instanceof ListSelectedRowCollection) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)retData;
                HashSet<String> ids = new HashSet<String>();
                HashMap<String, String> propInfo = new HashMap<String, String>();
                for (ListSelectedRow listSelectedRow : returnData) {
                    String id2Name = listSelectedRow.getPrimaryKeyValue().toString();
                    int index = id2Name.indexOf("||", 0);
                    String fieldNum = id2Name.substring(0, index);
                    String fieldName = id2Name.substring(index + 2);
                    ids.add(fieldNum);
                    propInfo.put(fieldNum, fieldName);
                }
                map.put("returnDataResult", "returnDataSave");
                map.put("returnDataSelectedFieldIdArray", ids);
                map.put("returnDataSelectedFieldInfo", propInfo);
                this.fillFieldPermListBySelField(map);
            }
        }
    }

    protected void fillFieldPermListBySelField(Map<String, Object> map) {
        Set selFieldIdSet = (Set)map.get("returnDataSelectedFieldIdArray");
        Map selFieldInfo = (Map)map.get("returnDataSelectedFieldInfo");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("fieldentry");
        ArrayList<Integer> delIndexList = new ArrayList<Integer>();
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String fieldNum = row.getString("fieldnumber");
            boolean ifFound = false;
            for (String selFieldNum : selFieldIdSet) {
                if (!fieldNum.equals(selFieldNum)) continue;
                ifFound = true;
                break;
            }
            if (ifFound) continue;
            delIndexList.add(i);
        }
        int[] delIndexArr = null;
        if (delIndexList != null && delIndexList.size() > 0) {
            delIndexArr = new int[delIndexList.size()];
            for (int i = 0; i < delIndexList.size(); ++i) {
                delIndexArr[i] = (Integer)delIndexList.get(i);
            }
            this.getModel().deleteEntryRows("fieldentry", delIndexArr);
        }
        for (String selFieldId : selFieldIdSet) {
            String selFieldName = (String)selFieldInfo.get(selFieldId);
            boolean ifFound = false;
            for (int j = 0; j < entry.size(); ++j) {
                DynamicObject row = (DynamicObject)entry.get(j);
                String fieldNum = row.getString("fieldnumber");
                if (!fieldNum.equals(selFieldId)) continue;
                ifFound = true;
                break;
            }
            if (ifFound) continue;
            this.getModel().beginInit();
            int curIndex = this.getModel().createNewEntryRow("fieldentry");
            this.getModel().setValue("fieldnumber", (Object)selFieldId, curIndex);
            this.getModel().setValue("fieldname", (Object)selFieldName, curIndex);
            this.getModel().endInit();
        }
        this.getView().updateView("fieldentry");
    }

    private void setFilterGridBeforeBindData() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTERGRIDAP);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterGrid.setEntityNumber("bos_user");
        filterGrid.setFilterColumns(filterColumns);
    }

    private void setFilterGridAfterBindData() {
        String filter = this.getModel().getDataEntity().getString("rule");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((String)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTERGRIDAP);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.beforeSaveOperation(evt);
                break;
            }
        }
    }

    private void beforeSaveOperation(BeforeDoOperationEventArgs evt) {
        FilterCondition filterCondition = this.getFilter();
        this.saveFilterToText(filterCondition);
    }

    private void saveFilterToText(FilterCondition filterCondition) {
        String filter = "";
        if (filterCondition != null && !CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("rule", (Object)filter);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        return filterCondition;
    }
}

