/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class UserInfoCleanSchemeListPlugin
extends AbstractListPlugin {
    private static final String OPERATION_CLEANEDUSER = "cleaneduser";
    private static final String OPERATION_TOCLEANUSER = "tocleanuser";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            ids.add(primaryKeyValue);
        }
        switch (operateKey) {
            case "cleaneduser": {
                this.showCleanedUserList(ids);
                break;
            }
            case "tocleanuser": {
                this.showToCleanUserF7List(ids);
                break;
            }
        }
    }

    private void showToCleanUserF7List(List<Object> ids) {
        QFilter filter = null;
        Map userInfoCleanSchemeObjs = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(new Object[ids.size()]), (String)"bos_user_infocleanscheme");
        for (Map.Entry entry : userInfoCleanSchemeObjs.entrySet()) {
            DynamicObject userInfoCleanSchemeObj = (DynamicObject)entry.getValue();
            String rule = userInfoCleanSchemeObj.getString("rule");
            QFilter temp = UserOperationUtils.convertRule2Filter("bos_user", rule);
            if (temp == null) continue;
            if (filter == null) {
                filter = temp;
                continue;
            }
            filter.or(temp);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (filter == null) {
            filter = new QFilter("1", "!=", (Object)1);
        }
        filters.add(filter);
        List<Object> cleanedUserIds = this.queryHasCleanUserIds(ids);
        if (!CollectionUtils.isEmpty(cleanedUserIds)) {
            filters.add(new QFilter("id", "not in", cleanedUserIds));
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user_toclean", (boolean)false, (int)2, (boolean)false);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setListFilterParameter(new ListFilterParameter(filters, null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showCleanedUserList(List<Object> ids) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user_clean", (boolean)false, (int)2, (boolean)false);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("userinfocleanschemeid", "in", ids);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        lsp.setListFilterParameter(new ListFilterParameter(filters, null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Object> queryHasCleanUserIds(List<Object> ids) {
        ArrayList<Object> res = new ArrayList<Object>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserInfoCleanSchemeListPlugin#queryHasCleanUserIds", (String)"bos_user_clean", (String)"user", (QFilter[])new QFilter[]{new QFilter("userinfocleanschemeid", "in", ids)}, (String)"");){
            if (!dataSet.hasNext()) {
                ArrayList<Object> arrayList = res;
                return arrayList;
            }
            for (Row row : dataSet) {
                res.add(row.get("user"));
            }
        }
        return res;
    }
}

