/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;

public class UserPeriodSetFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object userIds = fsp.getCustomParam("userids");
        this.getModel().setValue("userids", userIds);
        this.initUseEndDate(userIds);
    }

    private void initUseEndDate(Object userIds) {
        DynamicObject userObj;
        Date useEndDate = null;
        String[] split = userIds.toString().split(",");
        if (split.length > 1) {
            useEndDate = null;
        } else if (split.length == 1 && (useEndDate = (userObj = QueryServiceHelper.queryOne((String)"bos_user", (String)"useenddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(split[0]))})).getDate("useenddate")) == null) {
            useEndDate = Utils.getEndDate();
        }
        this.getModel().setValue("useenddate", useEndDate);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object useEndDate;
        super.beforeClick(evt);
        Button button = (Button)evt.getSource();
        if (!ObjectUtils.isEmpty((Object)button) && "btnok".equals(button.getKey()) && ObjectUtils.isEmpty((Object)(useEndDate = this.getModel().getValue("useenddate")))) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_usergroup_userperiod");
            DynamicProperty fieldProperty = dataEntityType.getProperty("useenddate");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"UserPeriodSetFormPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]), fieldProperty.getDisplayName()));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if ("btnok".equals(key)) {
            DynamicObject userPeriodSetObj = this.getModel().getDataEntity();
            DynamicObject[] userObjArr = this.loadSelectedUserObjs(userPeriodSetObj);
            Date endTime = UserOperationUtils.getDateStartTime(userPeriodSetObj.getDate("useenddate"), 0);
            for (DynamicObject userObj : userObjArr) {
                Date oldUseEndDate = userObj.getDate("useenddate");
                userObj.set("useenddate", (Object)endTime);
                if (oldUseEndDate != null && endTime.compareTo(oldUseEndDate) != 0) continue;
                DynamicProperty property = userObj.getDynamicObjectType().getProperty("useenddate");
                DataEntityState dataEntityState = userObj.getDataEntityState();
                dataEntityState.setBizChanged(property.getOrdinal(), true);
            }
            OperateOption operateOption = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_user", (DynamicObject[])userObjArr, (OperateOption)operateOption);
            this.addLogs(userObjArr, operationResult);
            this.getView().returnDataToParent((Object)operationResult);
            this.getView().close();
        }
    }

    private void addLogs(DynamicObject[] userObjArr, OperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            return;
        }
        ArrayList<OpLogAppInfo> logs = new ArrayList<OpLogAppInfo>(successPkIds.size());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u7528\u6237\u65f6\u6548\u8bbe\u7f6e", "UserPeriodSetFormPlugin_1", "bos-sec-user");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u7528\u6237\u65f6\u6548\u8bbe\u7f6e\u6210\u529f\u3002", "UserPeriodSetFormPlugin_2", "bos-sec-user");
        String appId = this.getView().getFormShowParameter().getAppId();
        for (DynamicObject userObj : userObjArr) {
            Object id = userObj.getPkValue();
            if (!successPkIds.contains(id)) continue;
            OpLogAppInfo log = new OpLogAppInfo();
            log.setBizObjID("bos_user");
            log.setKeyWord(userObj.getString("number"));
            log.setOpName("setUserPeriod", opNameBridge);
            log.setOpDesc(opDescBridge, new String[]{userObj.getString("number")});
            log.setBizAppID(appId);
            logs.add(log);
        }
        if (!CollectionUtils.isEmpty(logs)) {
            LogServiceHelper.addBatchLog(logs);
        }
    }

    private DynamicObject[] loadSelectedUserObjs(DynamicObject userPeriodSetObj) {
        if (StringUtils.isEmpty((CharSequence)userPeriodSetObj.getString("userids"))) {
            return new DynamicObject[0];
        }
        String[] userIdArr = userPeriodSetObj.getString("userids").split(",");
        List userIds = Arrays.stream(userIdArr).map(strId -> Long.valueOf(strId)).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((Object[])userIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bos_user").getDynamicObjectType());
    }
}

