/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserSortFormPlugin
extends AbstractFormPlugin {
    private static final String SORT_NUMBER = "sortnumber";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUserEntryEntity();
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control c = (Control)evt.getSource();
        String itemKey = c.getKey().toLowerCase();
        if ("btnok".equals(itemKey)) {
            this.save(evt);
        }
    }

    private void save(BeforeClickEvent evt) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        HashMap<Long, Integer> userIds = new HashMap<Long, Integer>(32);
        for (DynamicObject dynamicObject : entryEntity) {
            String sortNumber = dynamicObject.get(SORT_NUMBER).toString();
            if (Long.parseLong(sortNumber) < 0L || Long.parseLong(sortNumber) > 9999999L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u5e8f\u7801\u53ea\u80fd\u662f0\u52309999999\u7684\u6574\u6570\u3002", (String)"UserSortFormPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long userId = dynamicObject.getLong("user");
            userIds.put(userId, Integer.parseInt(sortNumber));
        }
        String userSelectFields = "id,name,number,gender,enable,sortnumber";
        QFilter userFilters = new QFilter("id", "in", userIds.keySet());
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)userSelectFields, (QFilter[])userFilters.toArray(), (String)SORT_NUMBER);
        for (Map.Entry orgEntry : userMap.entrySet()) {
            DynamicObject userObj = (DynamicObject)orgEntry.getValue();
            long userId = userObj.getLong("id");
            userObj.set(SORT_NUMBER, userIds.get(userId));
        }
        SaveServiceHelper.save((DynamicObject[])userMap.values().toArray(new DynamicObject[0]));
        this.getView().returnDataToParent((Object)"save");
    }

    private void initUserEntryEntity() {
        Object userIds = this.getView().getFormShowParameter().getCustomParam("userIds");
        if (ObjectUtils.isEmpty((Object)userIds)) {
            return;
        }
        String userSelectFields = "id,picturefield,name,number,gender,enable,sortnumber";
        QFilter userFilters = new QFilter("id", "in", userIds);
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)userSelectFields, (QFilter[])userFilters.toArray(), (String)SORT_NUMBER);
        if (userMap.isEmpty()) {
            return;
        }
        int userCount = userMap.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", userCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        for (Map.Entry orgEntry : userMap.entrySet()) {
            DynamicObject userPositionObj = (DynamicObject)orgEntry.getValue();
            DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
            long userId = userPositionObj.getLong("id");
            String name = userPositionObj.getString("name");
            String number = userPositionObj.getString("number");
            Object gender = userPositionObj.get("gender");
            Object sortNumber = userPositionObj.get(SORT_NUMBER);
            Object enable = userPositionObj.get("enable");
            Object pictureField = userPositionObj.get("picturefield");
            row.set("user", (Object)userId);
            row.set("number", (Object)number);
            row.set("name", (Object)name);
            row.set("gender", gender);
            row.set("enable", enable);
            row.set("picturefield", pictureField);
            if (!sortNumber.toString().isEmpty() && Integer.parseInt(sortNumber.toString()) != 1000000) {
                row.set(SORT_NUMBER, sortNumber);
            }
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }
}

