/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.sec.user.task.SynDingTalkTask;
import kd.bos.util.StringUtils;

public class UserSynProgressPlugin
extends AbstractFormPlugin {
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BOS_SEC_USER = "bos-sec-user";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_user_sync", new DistributeCacheHAPolicy(true, true));

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"syn_dingtalk_err_msg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"label_fail_msg"});
        progressBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView view = this.getView();
        final ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        final Label label = (Label)view.getControl("syn_dingtalk_labelap");
        final Label labelError = (Label)view.getControl("syn_dingtalk_err_msg");
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent progressEvent) {
                String progressbarap_disable = (String)cache.get(SynDingTalkTask.getCacheKeyPrefix() + "progressbarap_disable");
                String errorMsg = (String)cache.get(SynDingTalkTask.getCacheKeyPrefix() + "errormsg");
                if (StringUtils.isNotEmpty((String)errorMsg)) {
                    progressBar.stop();
                    if ("true".equals(progressbarap_disable)) {
                        view.setVisible(Boolean.valueOf(false), new String[]{UserSynProgressPlugin.PROGRESSBARAP, "syn_dingtalk_labelap"});
                        view.setVisible(Boolean.valueOf(true), new String[]{"syn_dingtalk_err_msg"});
                        view.setVisible(Boolean.valueOf(true), new String[]{"label_fail_msg"});
                        labelError.setText(errorMsg);
                    } else {
                        label.setText(errorMsg);
                    }
                } else {
                    String synType = (String)cache.get(SynDingTalkTask.getCacheKeyPrefix() + "synType");
                    String text = ResManager.loadKDString((String)"\u540c\u6b65\u201c%s\u201d\u4eba\u5458\u4fe1\u606f\u5b8c\u6210\u3002", (String)"UserSynProgressPlugin_2", (String)UserSynProgressPlugin.BOS_SEC_USER, (Object[])new Object[0]);
                    switch (synType) {
                        case "welink": {
                            text = String.format(text, ResManager.loadKDString((String)"\u534e\u4e3aWeLink", (String)"UserSynProgressPlugin_0", (String)UserSynProgressPlugin.BOS_SEC_USER, (Object[])new Object[0]));
                            break;
                        }
                        case "wxqyh": {
                            text = String.format(text, ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1", (String)"UserSynProgressPlugin_1", (String)UserSynProgressPlugin.BOS_SEC_USER, (Object[])new Object[0]));
                            break;
                        }
                        default: {
                            text = UserMessage.getMessage((String)"M00057");
                        }
                    }
                    int percent = UserSynProgressPlugin.this.getPercent();
                    if (percent >= 100) {
                        percent = 100;
                        this.setProgress(progressEvent, percent);
                        progressBar.stop();
                        label.setText(text);
                    } else {
                        this.setProgress(progressEvent, percent);
                    }
                }
            }

            private void setProgress(ProgressEvent progress, int per) {
                progress.setProgress(per);
            }
        });
    }

    private int getPercent() {
        int percent = 0;
        String completedCount = (String)cache.get(SynDingTalkTask.getCacheKeyPrefix() + "completed-count");
        String totalCount = (String)cache.get(SynDingTalkTask.getCacheKeyPrefix() + "total-count");
        if (StringUtils.isNotEmpty((String)completedCount) && StringUtils.isNotEmpty((String)totalCount)) {
            percent = new BigDecimal(completedCount).divide(new BigDecimal(totalCount), 3, 3).multiply(new BigDecimal(100)).intValue();
        }
        return percent;
    }
}

