/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.task.SynTypeEnum;
import kd.bos.sec.user.task.UserSynToYptTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class UserSynToYptListPlugin
extends AbstractListPlugin {
    private static final String KEY_BTN_SYN = "btn_syn";
    private static final String ENTITY_USER_SYN_FAIL_LOG = "bos_user_syntoyptfaillog";
    private static final String SELECT_LOG_FIELDS = "user";
    private static final String FIELD_USER = "user";
    private static final String SELECT_USER_FIELDS = "number,fuid,phone,birthday,email,name,enable,gender,username,idcard,usertype,isregisted,isactived";
    private static final String SYSTEM_TYPE = "bos-sec-user";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_BTN_SYN});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (KEY_BTN_SYN.equals(itemKey)) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u3002", (String)"UserSynToYptListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OK, null);
                return;
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(KEY_BTN_SYN, (IFormPlugin)this);
            ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                ids.add(row.getPrimaryKeyValue());
            }
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_USER_SYN_FAIL_LOG, (String)"user", (QFilter[])filter.toArray());
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u540c\u6b65\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"UserSynToYptListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OK, callBackListener);
                return;
            }
            ArrayList<Long> userIds = new ArrayList<Long>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                userIds.add(dynamicObject.getLong("user"));
            }
            QFilter userFilter = new QFilter("id", "in", userIds);
            DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)SELECT_USER_FIELDS, (QFilter[])userFilter.toArray());
            if (users == null || users.length == 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u540c\u6b65\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"UserSynToYptListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OK, callBackListener);
                return;
            }
            UserSynToYptTask synTask = new UserSynToYptTask();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(Arrays.asList(users));
            String message = synTask.executeSynUser(RequestContext.get(), list, SynTypeEnum.MANUAL);
            this.getView().showConfirm(message, MessageBoxOptions.OK, callBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Cancel == result && KEY_BTN_SYN.equals(callBackId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }
}

