/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.task.SynThirdAppTask;
import kd.bos.sec.user.task.SynUserTypeEnum;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.threads.ThreadPools;

public class UserTreeListPlugin
extends StandardTreeListPlugin
implements ListRowClickListener {
    private static final Log log = LogFactory.getLog(UserTreeListPlugin.class);
    private static final String NO_ORG = "noOrg";
    private String NODE_NAME_UNKNOWN = ResManager.loadKDString((String)"\u672a\u5206\u914d\u90e8\u95e8", (String)"UserTreeListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]);
    public static final String NODE_ID_EXTERNAL_USER_TYPE = "externalUserType";
    public static final String EXTERNAL_NODE_ID = "buildTreeListFilter_External_nodeId";
    public static final String BUILD_TREE_USERTYPE_FILTER = "buildTreeUserTypeFilter";
    private static final String CACHE_CHARGE_USER = "cache_charge_user";
    private static final String PARAM_IS_INCLUDE_ALLSUB = "isIncludeAllSub";
    private static final String CHK_INCLUDE_CHILD = "chkincludechild";
    private static final int F7_STYLE_CONTROLLED = 3;
    private static final String F7_STYLE_CONTROLLED_FILTER_CACHE = "F7_STYLE_CONTROLLED_FILTER_CACHE";
    private static final String BTN_BAR_SHARE = "bar_share";
    private static final String PROP_ENTRY_ENTITY_DPT = "entryentity.dpt";
    private boolean isFilterContainerSearchClick;

    public void initialize() {
        super.initialize();
        ((TreeListModel)this.getTreeModel()).setGobackToRoot(false);
    }

    public void initializeTree(EventObject e) {
        HashMap<String, Object> customParams = this.getView().getFormShowParameter().getCustomParams();
        log.info("\u3010\u4eba\u5458\u67e5\u8be2\u3011\u521d\u59cb\u5316\u53c2\u6570\uff1a" + customParams);
        if (customParams == null) {
            customParams = new HashMap<String, Object>(0);
        }
        this.parseCustomParams((Map<String, Object>)customParams);
        if (this.isOnlyShowExternalUser(customParams)) {
            this.initExternalUserRootTreeNode();
        } else {
            this.initAdminOrgRootTreeNode(customParams);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initButtonBySystemParam();
        this.parseIncludeSubAllParam();
        TreeNode root = this.getTreeModel().getRoot();
        if (root != null) {
            this.getTreeListView().getTreeView().treeNodeClick("", root.getId());
        }
    }

    private void initButtonBySystemParam() {
        Object isenablewelink;
        Object isenablewxqyh;
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        Object syncmode = paramMap.get("syncmode");
        if (StringUtils.isBlank(syncmode) || "1".equals(syncmode.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BAR_SHARE});
        } else {
            String loginUserId = RequestContext.get().getUserId();
            if ("1".equals(loginUserId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_BAR_SHARE});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_BAR_SHARE});
            }
        }
        Object isenableding = paramMap.get("isenableding");
        if (StringUtils.isBlank(isenableding) || !Boolean.parseBoolean(isenableding.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_synding"});
        }
        if (StringUtils.isBlank(isenablewxqyh = paramMap.get("isenablewxqyh")) || !Boolean.parseBoolean(isenablewxqyh.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_synwxqyh"});
        }
        if (StringUtils.isBlank(isenablewelink = paramMap.get("isenablewelink")) || !Boolean.parseBoolean(isenablewelink.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_synwelink"});
        }
    }

    private void parseCustomParams(Map<String, Object> customParams) {
        boolean isOnlyShowExternalUser = this.isOnlyShowExternalUser(customParams);
        this.parseExternalUserTypeParam(customParams, isOnlyShowExternalUser);
    }

    private void parseIncludeSubAllParam() {
        boolean isIncludeAllSub = false;
        Object isIncludeAllSubObj = this.getView().getFormShowParameter().getCustomParam(PARAM_IS_INCLUDE_ALLSUB);
        if (StringUtils.isBlank((Object)isIncludeAllSubObj)) {
            if (RunModeServiceHelper.isGalaxyMode()) {
                isIncludeAllSub = true;
            }
        } else {
            isIncludeAllSub = Boolean.parseBoolean(isIncludeAllSubObj.toString());
        }
        if (isIncludeAllSub) {
            this.getView().getModel().setValue(CHK_INCLUDE_CHILD, (Object)Boolean.TRUE);
            this.getView().updateView(CHK_INCLUDE_CHILD);
        }
    }

    private void parseExternalUserTypeParam(Map<String, Object> customParams, boolean isOnlyShowExternalUser) {
        boolean isShowOtherTypeNode = false;
        String externalUserType = "all";
        if (this.isUserF7()) {
            Object externalUserTypeParam = customParams.get(NODE_ID_EXTERNAL_USER_TYPE);
            if (StringUtils.isBlank((Object)externalUserTypeParam)) {
                if (isOnlyShowExternalUser) {
                    isShowOtherTypeNode = true;
                }
            } else {
                isShowOtherTypeNode = true;
                externalUserType = externalUserTypeParam.toString();
            }
        } else {
            isShowOtherTypeNode = true;
        }
        if (isShowOtherTypeNode) {
            this.getPageCache().put(NODE_ID_EXTERNAL_USER_TYPE, externalUserType.toString().trim());
        } else {
            this.getPageCache().remove(NODE_ID_EXTERNAL_USER_TYPE);
        }
        this.getPageCache().put("isShowOtherTypeNode", Boolean.toString(isShowOtherTypeNode));
    }

    private boolean isOnlyShowExternalUser(Map<String, Object> customParams) {
        boolean isOnlyShowExternalUser = false;
        Object isOnlyShowExternalUserParam = customParams.get("isOnlyShowExternalUser");
        if (StringUtils.isNotBlank((Object)isOnlyShowExternalUserParam)) {
            isOnlyShowExternalUser = (Boolean)isOnlyShowExternalUserParam;
        }
        this.getPageCache().put("isOnlyShowExternalUser", Boolean.toString(isOnlyShowExternalUser));
        return isOnlyShowExternalUser;
    }

    private void initExternalUserRootTreeNode() {
        TreeNode root = new TreeNode("", NODE_ID_EXTERNAL_USER_TYPE, this.getExternalUserTypeNodeName(), true);
        root.setIsOpened(true);
        this.initRootNode(root, true, null);
        root.setChildren(this.getOtherUserTypeNode());
    }

    private String getExternalUserTypeNodeName() {
        return ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u4eba\u5458", (String)"UserTreeListPlugin_1", (String)"bos-sec-user", (Object[])new Object[0]);
    }

    private void initAdminOrgRootTreeNode(Map<String, Object> customParams) {
        Object initOrgId;
        boolean isHideShowAllOrgCheckbox = true;
        long rootOrgId = 0L;
        Object paramInitRootOrgId = customParams.get("initRootOrgId");
        if (StringUtils.isNotBlank((Object)paramInitRootOrgId)) {
            long initRootOrgId = Long.parseLong(paramInitRootOrgId.toString());
            if (OrgUnitServiceHelper.getRootOrgId() != initRootOrgId) {
                isHideShowAllOrgCheckbox = false;
                rootOrgId = initRootOrgId;
            }
        }
        if (StringUtils.isNotBlank((Object)(initOrgId = customParams.get("initOrgId"))) && !initOrgId.equals(paramInitRootOrgId)) {
            this.getPageCache().put("initOrgId", initOrgId.toString());
        }
        OrgTreeParam param = this.getAdminOrgTreeParam();
        param.setId(rootOrgId);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null && rootOrgId != 0L) {
            isHideShowAllOrgCheckbox = true;
            param.setId(0L);
            root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        }
        this.initRootNode(root, isHideShowAllOrgCheckbox, param);
    }

    private void initRootNode(TreeNode root, boolean isHideShowAllOrgCheckbox, OrgTreeParam param) {
        if (root == null) {
            root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserTreeListPlugin_2", (String)"bos-sec-user", (Object[])new Object[0]));
            root.setChildren(this.refreshNodeChildren(root.getId(), param, true));
            root.setIsOpened(true);
        } else if (StringUtils.isBlank((CharSequence)this.getPageCache().get("initOrgId"))) {
            root.setChildren(this.refreshNodeChildren(root.getId(), param, true));
        } else {
            root.setChildren(new ArrayList());
        }
        String rootId = root.getId();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)rootId);
        log.debug("\u5de6\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        if (isHideShowAllOrgCheckbox) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"showallorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"showallorg"});
            this.getPageCache().put("showallorg", "1");
        }
    }

    private List<TreeNode> refreshNodeChildren(String nodeId, OrgTreeParam param, boolean isRootNode) {
        if (param == null) {
            return null;
        }
        param.setId(Long.parseLong(nodeId));
        List treeNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (isRootNode) {
            TreeNode noOrgNode = new TreeNode(nodeId, NO_ORG, this.NODE_NAME_UNKNOWN, false);
            treeNodes.add(noOrgNode);
            boolean isShowOtherTypeNode = false;
            String isShowOtherTypeNodeCache = this.getPageCache().get("isShowOtherTypeNode");
            if (StringUtils.isNotBlank((CharSequence)isShowOtherTypeNodeCache)) {
                isShowOtherTypeNode = Boolean.parseBoolean(isShowOtherTypeNodeCache);
            }
            if (isShowOtherTypeNode) {
                TreeNode otherTypeNode = new TreeNode(nodeId, NODE_ID_EXTERNAL_USER_TYPE, this.getExternalUserTypeNodeName(), true);
                treeNodes.add(otherTypeNode);
            }
        }
        return treeNodes;
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (NO_ORG.equalsIgnoreCase(nodeId)) {
            return;
        }
        if (nodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            if (NODE_ID_EXTERNAL_USER_TYPE.equals(nodeId)) {
                e.setChildNodes(this.getOtherUserTypeNode());
            }
            return;
        }
        e.setChildNodes(this.refreshNodeChildren(nodeId, this.getAdminOrgTreeParam(), nodeId.equals(this.getTreeModel().getRoot().getId())));
    }

    private OrgTreeParam getAdminOrgTreeParam() {
        OrgTreeParam param = new OrgTreeParam();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        param.setOrgRangeList(UserOperationUtils.getAdminChargeOrgs(listShowParameter, this.getPageCache()));
        this.addOrgByListFilterParameter(param);
        boolean buildRootNodeInRange = !listShowParameter.isLookUp() || 3 == listShowParameter.getF7Style();
        param.setBuildRootNodeInRange(buildRootNodeInRange);
        return param;
    }

    private void addOrgByListFilterParameter(OrgTreeParam param) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (3 != listShowParameter.getF7Style()) {
            return;
        }
        Set<Long> orgIds = this.getOrgByListFilterParameter(param, listShowParameter.getListFilterParameter().getQFilters());
        if (orgIds == null) {
            return;
        }
        List orgRangeList = param.getOrgRangeList();
        if (orgRangeList == null) {
            param.setOrgRangeList(new ArrayList<Long>(orgIds));
        } else {
            orgRangeList.retainAll(orgIds);
        }
    }

    private Set<Long> getOrgByListFilterParameter(OrgTreeParam param, List<QFilter> listFilters) {
        HashMap<String, HashSet<Long>> filterOrgIdMap;
        Collection orgIds;
        if (listFilters == null || listFilters.isEmpty()) {
            return null;
        }
        boolean hasCustomFilter = false;
        String proName = "";
        StringBuilder filterCacheKey = new StringBuilder();
        for (QFilter filter : listFilters) {
            filterCacheKey.append(filter.toString());
            proName = filter.getProperty();
            if ("enable".equals(proName) || "status".equals(proName)) continue;
            hasCustomFilter = true;
        }
        if (!hasCustomFilter) {
            return null;
        }
        String filterCache = this.getPageCache().get(F7_STYLE_CONTROLLED_FILTER_CACHE);
        if (filterCache != null && (orgIds = (Collection)(filterOrgIdMap = (HashMap<String, HashSet<Long>>)SerializationUtils.fromJsonString((String)filterCache, Map.class)).get(filterCacheKey.toString())) != null) {
            return new HashSet<Long>(orgIds);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(listFilters);
        if (param.getId() > 0L) {
            ArrayList<Long> parentIds = new ArrayList<Long>(1);
            parentIds.add(param.getId());
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, parentIds, (boolean)false);
            if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
                return new HashSet<Long>(0);
            }
            QFilter dptFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "in", (Object)subOrgIds);
            filters.add(dptFilter);
        }
        HashSet<Long> orgIds2 = new HashSet<Long>(64);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserTreeListPlugin.getOrgByListFilterParameter", (String)"bos_user", (String)PROP_ENTRY_ENTITY_DPT, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"");){
            for (Row row : dataSet) {
                orgIds2.add(row.getLong(PROP_ENTRY_ENTITY_DPT));
            }
        }
        filterOrgIdMap = new HashMap<String, HashSet<Long>>(1);
        filterOrgIdMap.put(filterCacheKey.toString(), orgIds2);
        this.getPageCache().put(F7_STYLE_CONTROLLED_FILTER_CACHE, SerializationUtils.toJsonString(filterOrgIdMap));
        return orgIds2;
    }

    private List<TreeNode> getOtherUserTypeNode() {
        QFilter externalUserTypeFilter = this.getExternalUserTypeFilter();
        if (externalUserTypeFilter == null) {
            return new ArrayList<TreeNode>();
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter, visibleFilter, externalUserTypeFilter};
        Map typeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (String)"id,number,name", (QFilter[])filters, (String)"number");
        if (typeMap == null || typeMap.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> typeNodes = new ArrayList<TreeNode>(typeMap.size());
        for (DynamicObject typeObj : typeMap.values()) {
            TreeNode typeNode = new TreeNode(NODE_ID_EXTERNAL_USER_TYPE, NODE_ID_EXTERNAL_USER_TYPE + typeObj.getString("id"), typeObj.getString("name"));
            typeNodes.add(typeNode);
        }
        return typeNodes;
    }

    private QFilter getExternalUserTypeFilter() {
        QFilter idFilter = null;
        String externalUserType = this.getPageCache().get(NODE_ID_EXTERNAL_USER_TYPE);
        if (StringUtils.isBlank((CharSequence)externalUserType)) {
            return idFilter;
        }
        if ("all".equalsIgnoreCase(externalUserType)) {
            idFilter = new QFilter("category", "=", (Object)"2");
        } else {
            Set<String> usertyepSet = UserOperationUtils.getExternalUserTypeSet(externalUserType);
            if (usertyepSet.isEmpty()) {
                return idFilter;
            }
            ArrayList<Long> ids = new ArrayList<Long>(usertyepSet.size());
            for (String userTypeId : usertyepSet) {
                ids.add(Long.valueOf(userTypeId));
            }
            idFilter = new QFilter("id", "in", ids);
        }
        return idFilter;
    }

    private boolean isOrgInCharge(List<Long> chargeOrgList, String nodeId) {
        if (chargeOrgList == null) {
            return true;
        }
        boolean isInitDepartment = false;
        int max = chargeOrgList.size();
        for (int i = 0; i < max; ++i) {
            Long orgId = chargeOrgList.get(i);
            if (!nodeId.equals(((Object)orgId).toString())) continue;
            isInitDepartment = true;
            break;
        }
        return isInitDepartment;
    }

    private boolean isUserF7() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    public void expendTreeNode(TreeNodeEvent e) {
        this.treeListView.getTreeView().expand(e.getNodeId().toString());
        OrgTreeUtils.focusInitOrgTreeNode((ListView)((ListView)this.getView()), (String)"01");
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.treeListView.getTreeView().queryTreeNodeChildren(String.valueOf(e.getParentNodeId()), String.valueOf(e.getNodeId()));
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        if (this.isFilterContainerSearchClick) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        QFilter treeListFilter = null;
        List<Long> userTypeIds = null;
        if (NO_ORG.equals(nodeId)) {
            treeListFilter = QFilter.isNull((String)PROP_ENTRY_ENTITY_DPT);
            userTypeIds = UserUtils.getUserTypeByCategory((String)"1");
        } else if (nodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            this.getView().getFormShowParameter().setCustomParam(EXTERNAL_NODE_ID, (Object)nodeId);
            if (NODE_ID_EXTERNAL_USER_TYPE.equals(nodeId)) {
                userTypeIds = ((Boolean)this.getModel().getValue(CHK_INCLUDE_CHILD)).booleanValue() ? UserUtils.getUserTypeByCategory((String)"2") : new ArrayList<Long>(0);
            } else {
                String userTypeId = StringUtils.substringAfterLast((String)nodeId, (String)NODE_ID_EXTERNAL_USER_TYPE);
                if (StringUtils.isNotBlank((CharSequence)userTypeId)) {
                    userTypeIds = new ArrayList(1);
                    userTypeIds.add(Long.valueOf(userTypeId));
                }
            }
        } else {
            long orgId = Long.parseLong(nodeId);
            if (Boolean.parseBoolean(this.getModel().getValue(CHK_INCLUDE_CHILD).toString())) {
                if (OrgUnitServiceHelper.getRootOrgId() != orgId) {
                    treeListFilter = this.getNotRootNodeFilter(orgId);
                }
            } else {
                treeListFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "=", (Object)orgId);
            }
        }
        this.getView().getFormShowParameter().setCustomParam(BUILD_TREE_USERTYPE_FILTER, (Object)userTypeIds);
        QFilter userTypesFilter = UserUtils.getUserTypesLikeFilter((List)userTypeIds);
        if (treeListFilter == null) {
            treeListFilter = userTypesFilter;
        } else if (userTypesFilter != null) {
            treeListFilter = treeListFilter.and(userTypesFilter);
        }
        if (treeListFilter != null) {
            e.addQFilter(treeListFilter);
        }
    }

    private QFilter getNotRootNodeFilter(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        List orgIncludeSubs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"01", orgIds, (boolean)true, null);
        if (Objects.isNull(orgIncludeSubs)) {
            orgIncludeSubs = Collections.emptyList();
        }
        QFilter treeListFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "in", orgIncludeSubs);
        return treeListFilter;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.isFilterContainerSearchClick = true;
        super.filterContainerSearchClick(args);
        OrgTreeUtils.removeListRowClickCache((IPageCache)this.getPageCache());
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        this.addSubOrgFilter(filters);
    }

    private void addSubOrgFilter(List<QFilter> filters) {
        QFilter subOrgFilter;
        if (((Boolean)this.getModel().getValue("showallorg")).booleanValue()) {
            return;
        }
        String focusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        if (StringUtils.isNotBlank((CharSequence)focusNodeId) && focusNodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object initRootOrgId = customParams.get("initRootOrgId");
        if (StringUtils.isBlank(initRootOrgId)) {
            return;
        }
        if (!"1".equals(this.getPageCache().get("showallorg"))) {
            return;
        }
        String cacheKey = "initRootOrgId_subOrgQFilter";
        String subOrgQFilterCache = this.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)subOrgQFilterCache)) {
            List subOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(Long.valueOf(initRootOrgId.toString())), (boolean)true);
            subOrgFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "in", (Object)subOrgList);
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)subOrgFilter));
        } else {
            subOrgFilter = (QFilter)SerializationUtils.fromJsonString((String)subOrgQFilterCache, QFilter.class);
        }
        subOrgFilter = subOrgFilter.or(QFilter.isNull((String)PROP_ENTRY_ENTITY_DPT));
        filters.add(subOrgFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
            if (CHK_INCLUDE_CHILD.equals(proName)) {
                TreeView tv = this.treeListView.getTreeView();
                Map focusMap = tv.getTreeState().getFocusNode();
                if (focusMap != null) {
                    tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
                }
            } else if ("showallorg".equals(proName)) {
                this.showAllOrg();
            }
        });
    }

    private void showAllOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object paramInitRootOrgId = customParams.get("initRootOrgId");
        if (paramInitRootOrgId == null) {
            return;
        }
        long rootOrgId = 0L;
        if (!((Boolean)this.getModel().getValue("showallorg")).booleanValue()) {
            rootOrgId = Long.parseLong(paramInitRootOrgId.toString());
        }
        OrgTreeParam param = this.getAdminOrgTreeParam();
        param.setId(rootOrgId);
        OrgTreeUtils.fireClickShowAllOrgCheckBox((ListView)((ListView)this.getView()), (OrgTreeParam)param);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        this.beforeShowAddNewPage(parameter);
    }

    private void beforeShowAddNewPage(BillShowParameter parameter) {
        String nodeId;
        if (BillOperationStatus.ADDNEW.equals((Object)parameter.getBillStatus()) || BillOperationStatus.ADDNEW.getValue() == parameter.getBillStatusValue().intValue()) {
            this.getPageCache().remove(CACHE_CHARGE_USER);
        }
        if (StringUtils.isBlank((CharSequence)(nodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId()))) {
            TreeNode rootNode = this.treeListView.getTreeModel().getRoot();
            nodeId = rootNode.getId();
        }
        boolean isInitDepartment = false;
        if (!NO_ORG.equalsIgnoreCase(nodeId) && !nodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            isInitDepartment = this.isOrgInCharge(UserOperationUtils.getAdminChargeOrgs((ListShowParameter)this.getView().getFormShowParameter(), this.getPageCache()), nodeId);
        }
        if (isInitDepartment) {
            parameter.setCustomParam("orgId", (Object)nodeId);
        } else {
            parameter.setCustomParam("orgId", (Object)"");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.getPageCache().put("syncToYzj", "1");
        switch (evt.getItemKey()) {
            case "bar_share": {
                this.chatYZJ(evt);
                break;
            }
        }
    }

    private void chatYZJ(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelect = billList.getSelectedRows();
        if (Utils.isListEmpty((List)listSelect)) {
            this.getView().showTipNotification(UserMessage.getMessage((String)"M00056"));
            evt.setCancel(true);
            return;
        }
        int count = listSelect.size();
        ArrayList<Long> lstUserId = new ArrayList<Long>(count);
        for (ListSelectedRow row : listSelect) {
            long userId = (Long)row.getPrimaryKeyValue();
            lstUserId.add(userId);
        }
        UserOperationUtils.chatYZJ(this.getView(), lstUserId);
        evt.setCancel(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_director": {
                this.showOrgDirectorForm();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "dingtalksynchronization": {
                if (!UserOperationUtils.checkDdConfigByToken(this.getView()).booleanValue()) break;
                ThreadPools.executeOnceIncludeRequestContext((String)"syn-dingding", (Runnable)new SynThirdAppTask(this.getView(), SynUserTypeEnum.DINGDING));
                this.showSynProgress(ResManager.loadKDString((String)"\u9489\u9489\u540c\u6b65", (String)"UserOperationUtils_3", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
            case "wechatsynchronization": {
                if (!UserOperationUtils.checkWxConfigByToken(this.getView()).booleanValue()) break;
                ThreadPools.executeOnceIncludeRequestContext((String)"syn-wechat", (Runnable)new SynThirdAppTask(this.getView(), SynUserTypeEnum.WXQYH));
                this.showSynProgress(ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65", (String)"UserOperationUtils_8", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
            case "hwwelinksynchronization": {
                if (!UserOperationUtils.checkWlConfigByToken(this.getView()).booleanValue()) break;
                ThreadPools.executeOnceIncludeRequestContext((String)"syn-welink", (Runnable)new SynThirdAppTask(this.getView(), SynUserTypeEnum.WELINK));
                this.showSynProgress(ResManager.loadKDString((String)"\u534e\u4e3aWeLink\u540c\u6b65", (String)"UserOperationUtils_6", (String)"bos-sec-user", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void showOrgDirectorForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_user_director");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("org", (Object)this.getTreeListView().getTreeView().getTreeState().getFocusNodeId());
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        if (row != null) {
            formShowParameter.setCustomParam("user", row.getPrimaryKeyValue());
        }
        this.getView().showForm(formShowParameter);
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        if (!OrgTreeUtils.focusTreeNodeAfterListRowClick((ListRowClickEvent)evt, (IPageCache)this.getPageCache())) {
            return;
        }
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        Object entityId = row.getEntryPrimaryKeyValue();
        if (entityId == null) {
            return;
        }
        Object userId = row.getPrimaryKeyValue();
        Object[] userInfo = this.getListRowClickOrgId(userId, (Long)entityId);
        String userType = userInfo[1] == null ? "1" : userInfo[1].toString();
        String focusNodeId = this.getDefaultFocusNodeIdByUserType(userType);
        if (StringUtils.isBlank((CharSequence)focusNodeId)) {
            long orgId = (Long)userInfo[0];
            focusNodeId = orgId == 0L ? this.getFocusNodeIdByUserType(userType) : Long.toString(orgId);
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(focusNodeId, (ListView)this.getView(), "01");
        searchParam.setSearchById(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    private String getDefaultFocusNodeIdByUserType(String userType) {
        String[] userTypes;
        TreeView treeView = this.getTreeListView().getTreeView();
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (focusNodeId == null || !focusNodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            return "";
        }
        if (!focusNodeId.startsWith(NODE_ID_EXTERNAL_USER_TYPE)) {
            return "";
        }
        for (String type : userTypes = userType.split(",")) {
            if (!focusNodeId.equals(NODE_ID_EXTERNAL_USER_TYPE + type)) continue;
            return focusNodeId;
        }
        return "";
    }

    private String getFocusNodeIdByUserType(String userType) {
        String focusUserTypeNodeId = null;
        ArrayList<String> userTypeNodeIds = new ArrayList<String>(16);
        if ("1".equals(userType) || "6".equals(userType)) {
            userTypeNodeIds.add(NO_ORG);
        } else {
            String[] userTypeArr;
            boolean onlyShowExternalUser = this.isOnlyShowExternalUser(this.getView().getFormShowParameter().getCustomParams());
            for (String type : userTypeArr = userType.split(",")) {
                if (StringUtils.isBlank((CharSequence)type)) continue;
                if ("1".equals(type)) {
                    if (onlyShowExternalUser) continue;
                    userTypeNodeIds.add(NO_ORG);
                    continue;
                }
                String userTypeNodeId = NODE_ID_EXTERNAL_USER_TYPE + type;
                if (focusUserTypeNodeId == null) {
                    focusUserTypeNodeId = userTypeNodeId;
                }
                userTypeNodeIds.add(userTypeNodeId);
            }
        }
        TreeView treeView = this.getTreeListView().getTreeView();
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (userTypeNodeIds.contains(focusNodeId)) {
            return focusNodeId;
        }
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null) {
            return focusNodeId;
        }
        focusNodeId = userTypeNodeIds.contains(NO_ORG) ? NO_ORG : focusUserTypeNodeId;
        return focusNodeId;
    }

    private Object[] getListRowClickOrgId(Object userId, long entityId) {
        long orgId = 0L;
        QFilter idFilter = new QFilter("id", "=", userId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"usertype,entryentity.dpt", (QFilter[])filters);
        if (userObj == null) {
            return new Object[]{orgId, "1"};
        }
        DynamicObjectCollection posEntryColObj = userObj.getDynamicObjectCollection("entryentity");
        if (Utils.isListEmpty((List)posEntryColObj)) {
            return new Object[]{orgId, userObj.getString("usertype")};
        }
        for (DynamicObject posEntryObj : posEntryColObj) {
            if (entityId != posEntryObj.getLong("id")) continue;
            DynamicObject orgObj = posEntryObj.getDynamicObject("dpt");
            if (orgObj == null) break;
            orgId = orgObj.getLong("id");
            break;
        }
        return new Object[]{orgId, userObj.getString("usertype")};
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof EntityOperate) {
            EntityOperate opService = (EntityOperate)source;
            OperateOption op = opService.getOption();
            op.setVariableValue("isFrom_bos_user_Page", "1");
        }
        if (args.getSource() instanceof Donothing) {
            Donothing operation = (Donothing)args.getSource();
            operation.getOption().setVariableValue("bos_skip_op_batch", "true");
            String operateKey = operation.getOperateKey();
            if ("sort".equals(operateKey)) {
                this.showUserSortForm();
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        if (StringUtils.isBlank((CharSequence)evt.getText())) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView(), "01");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    private void showSynProgress(String typeName) {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(typeName);
        para.setFormId("bos_user_syn_third_app");
        para.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        this.getView().showForm(para);
    }

    private void showUserSortForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_user_sort");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        BillList billList = (BillList)this.getControl("billlistap");
        formShowParameter.setCustomParam("userIds", (Object)billList.getSelectedRows().getPrimaryKeyValues());
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, "bos_user_sort"));
        this.getView().showForm(formShowParameter);
    }

    private CloseCallBack genClosedCallBack(IFormPlugin plugin, String actionId) {
        return new CloseCallBack(plugin, actionId);
    }
}

