/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class PersonInformationUseRecordsFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PersonInformationUseRecordsFormPlugin.class);
    private static final String ENTRY_ACCESS_RECORDS = "ACCESSRECORDS";
    private static final String ACCESSRECORDS_LIMIT_MONTH = "ACCESSRECORDS_LIMIT_MONTH";

    public void beforeBindData(EventObject e) {
        this.loadAccessRecords();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("timescope".equals(e.getProperty().getName())) {
            String monthCache = this.getPageCache().get(ACCESSRECORDS_LIMIT_MONTH);
            if (StringUtils.isNotBlank((CharSequence)monthCache)) {
                int newMonth;
                int monthLimit = Integer.parseInt(monthCache);
                ChangeData changeData = e.getChangeSet()[0];
                Object oldValue = changeData.getOldValue();
                int oldMonth = oldValue == null ? 1 : Integer.parseInt(oldValue.toString());
                Object newValue = changeData.getNewValue();
                int n = newMonth = newValue == null ? 1 : Integer.parseInt(newValue.toString());
                if (monthLimit <= newMonth && monthLimit <= oldMonth) {
                    this.showLimitNotification();
                    return;
                }
            }
            this.getView().showLoading(null);
            this.loadAccessRecords();
            this.getView().updateView(ENTRY_ACCESS_RECORDS);
            this.getView().hideLoading();
        }
    }

    private void loadAccessRecords() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRY_ACCESS_RECORDS);
        dataModel.beginInit();
        logger.debug("\u3010\u4e2a\u4eba\u6d3b\u52a8\u8bb0\u5f55\u67e5\u8be2\u3011\u5f00\u59cb\u83b7\u53d6\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u3002");
        int timeScope = this.getTimeScope();
        int quantity = this.getQuantity();
        List logList = LogServiceHelper.getOperationLogByUserId((Long)RequestContext.get().getCurrUserId(), (int)timeScope, (int)quantity);
        if (logList == null || logList.isEmpty()) {
            return;
        }
        int count = logList.size();
        logger.debug("\u3010\u4e2a\u4eba\u6d3b\u52a8\u8bb0\u5f55\u67e5\u8be2\u3011\u5b8c\u6210\u83b7\u53d6\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\uff1a" + count);
        dataModel.batchCreateNewEntryRow(ENTRY_ACCESS_RECORDS, count);
        int i = 0;
        Map appNubmerMap = AppMetadataCache.getAllAppInfo();
        Map<String, AppInfo> appIdMap = this.getAppIdMap(appNubmerMap);
        Map<String, ILocaleString> entityNameMap = this.getEntityNames(logList);
        HashMap<String, List<Integer>> entityNoNameMap = new HashMap<String, List<Integer>>(logList.size());
        for (Map logMap : logList) {
            Object bizAppId = logMap.get("bizAppId");
            dataModel.setValue("appid", bizAppId, i);
            LocaleString appName = null;
            AppInfo appInfo = appIdMap.getOrDefault(bizAppId, (AppInfo)appNubmerMap.get(bizAppId));
            if (appInfo != null) {
                appName = appInfo.getName();
            }
            if (appName == null) {
                dataModel.setValue("appname", logMap.get("bizappname"), i);
            } else {
                dataModel.setValue("appname", (Object)appName, i);
            }
            Object bizObjId = logMap.get("bizObjId");
            dataModel.setValue("entityid", bizObjId, i);
            ILocaleString entityName = entityNameMap.get(bizObjId);
            if (entityName == null) {
                dataModel.setValue("entityname", logMap.get("bizobjname"), i);
                if (bizObjId != null) {
                    entityNoNameMap.computeIfAbsent(bizObjId.toString(), v -> new ArrayList(16)).add(i);
                }
            } else {
                dataModel.setValue("entityname", (Object)entityName, i);
            }
            dataModel.setValue("operation", logMap.get("opName"), i);
            dataModel.setValue("description", logMap.get("opDescription"), i);
            dataModel.setValue("operationtime", logMap.get("opTime"), i);
            ++i;
        }
        this.loadExtendedEntityName(entityNoNameMap);
        if (count >= quantity) {
            String cacheMonth = this.getPageCache().get(ACCESSRECORDS_LIMIT_MONTH);
            if (cacheMonth == null || Integer.parseInt(cacheMonth) > timeScope) {
                this.getPageCache().put(ACCESSRECORDS_LIMIT_MONTH, Integer.toString(timeScope));
            }
            this.showLimitNotification();
        }
        logger.debug("\u3010\u4e2a\u4eba\u6d3b\u52a8\u8bb0\u5f55\u67e5\u8be2\u3011\u5b8c\u6210\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u7ed1\u5b9a\u6570\u636e\u5217\u8868\u3002");
        dataModel.endInit();
    }

    private void loadExtendedEntityName(Map<String, List<Integer>> entityNoNameMap) {
        if (entityNoNameMap.isEmpty()) {
            return;
        }
        StringJoiner whereSql = new StringJoiner(",");
        ArrayList<String> params = new ArrayList<String>(entityNoNameMap.size());
        for (Map.Entry<String, List<Integer>> entry : entityNoNameMap.entrySet()) {
            whereSql.add("?");
            params.add(entry.getKey());
        }
        Map entityNumberIdMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)("select fmasterid id,fnumber number from t_meta_formdesign where fnumber in (" + whereSql + ")"), (Object[])params.toArray(), resultSet -> {
            HashMap<String, String> resultMap = new HashMap<String, String>(entityNoNameMap.size());
            while (resultSet.next()) {
                String extEntityNumber = resultSet.getString("number");
                String id = resultSet.getString("id");
                resultMap.put(extEntityNumber, id);
                entityNoNameMap.put(id, (List<Integer>)entityNoNameMap.remove(extEntityNumber));
            }
            return resultMap;
        });
        HashMap<String, ILocaleString> entityNameMap = new HashMap<String, ILocaleString>(entityNumberIdMap.size());
        this.loadEntityNames(entityNameMap, "dentityid", entityNumberIdMap.values());
        if (entityNameMap.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        for (Map.Entry<String, List<Integer>> entry : entityNoNameMap.entrySet()) {
            ILocaleString entityName = (ILocaleString)entityNameMap.get(entry.getKey());
            if (entityName == null) continue;
            List<Integer> rows = entry.getValue();
            for (Integer row : rows) {
                dataModel.setValue("entityname", (Object)entityName, row.intValue());
            }
        }
    }

    private Map<String, AppInfo> getAppIdMap(Map<String, AppInfo> allAppInfo) {
        HashMap<String, AppInfo> appIdMap = new HashMap<String, AppInfo>(allAppInfo.size());
        for (Map.Entry<String, AppInfo> entry : allAppInfo.entrySet()) {
            AppInfo appInfo = entry.getValue();
            appIdMap.put(appInfo.getId(), appInfo);
        }
        return appIdMap;
    }

    private Map<String, ILocaleString> getEntityNames(List<Map<String, Object>> logList) {
        HashMap<String, ILocaleString> entityNameMap = new HashMap<String, ILocaleString>(logList.size());
        for (Map<String, Object> logMap : logList) {
            Object bizObjId = logMap.get("bizObjId");
            if (bizObjId == null) continue;
            entityNameMap.put(bizObjId.toString(), null);
        }
        this.loadEntityNames(entityNameMap, "id", entityNameMap.keySet());
        return entityNameMap;
    }

    private void loadEntityNames(Map<String, ILocaleString> entityNameMap, String keyProp, Collection params) {
        QFilter filter = new QFilter(keyProp, "in", (Object)params);
        QFilter[] filters = new QFilter[]{filter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)(keyProp + ",name"), (QFilter[])filters);
        for (Map.Entry entry : objMap.entrySet()) {
            DynamicObject entityObj = (DynamicObject)entry.getValue();
            entityNameMap.put(entityObj.getString(keyProp), entityObj.getLocaleString("name"));
        }
    }

    private int getTimeScope() {
        try {
            Object timeScope = this.getModel().getValue("timescope");
            return Integer.parseInt(timeScope.toString());
        }
        catch (Exception e) {
            return 1;
        }
    }

    private int getQuantity() {
        try {
            Object quantity = this.getModel().getValue("quantity");
            return Integer.parseInt(quantity.toString());
        }
        catch (Exception e) {
            return 1000;
        }
    }

    private void showLimitNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bb0\u5f55\u8d85\u8fc7\u4e86\u9650\u5236\u7684\u6570\u91cf\uff0c\u66f4\u591a\u6d3b\u52a8\u8bb0\u5f55\u8bf7\u901a\u8fc7\u65e5\u5fd7\u7ba1\u7406\u67e5\u8be2\u3002", (String)"PersonInformationUseRecordsFormPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]));
    }
}

