/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SHAUtils;
import kd.bos.util.HttpClientUtils;

public class UserAuthCenterHelper {
    private static Log logger = LogFactory.getLog(UserAuthCenterHelper.class);
    private static ConcurrentHashMap<String, Map<String, Object>> accessTokenMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> accessTokenExpiresMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenTimeMap = new ConcurrentHashMap();

    public static Map<String, Object> getUserCenterAccessToken(String clientId, String secrect, String uid, String prodInstCode, String userCenterHost) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)secrect)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)prodInstCode)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)userCenterHost)) {
            return Collections.emptyMap();
        }
        String key = clientId + uid;
        Integer accessTokenExpires = accessTokenExpiresMap.get(key);
        Long accessTokenTime = accessTokenTimeMap.get(key);
        if (Objects.isNull(accessTokenExpires)) {
            accessTokenExpires = 0;
        }
        if (Objects.isNull(accessTokenTime)) {
            accessTokenTime = 0L;
        }
        long currentTime = System.currentTimeMillis();
        if (!accessTokenMap.isEmpty() && currentTime - accessTokenTime < (long)(accessTokenExpires * 1000)) {
            return accessTokenMap.get(key);
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder(clientId);
        sb.append(secrect).append(uid).append(prodInstCode).append(timestamp);
        String signature = SHAUtils.sha((String[])new String[]{sb.toString()});
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put("client_id", clientId);
        mpBody.put("uid", uid);
        mpBody.put("prod_inst_code", prodInstCode);
        mpBody.put("timestamp", timestamp);
        mpBody.put("method", "sha1");
        mpBody.put("signiture", signature);
        String sURL = userCenterHost + "clouderp/access_token";
        String accessTokenInfo = "";
        try {
            accessTokenInfo = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
        }
        catch (Exception e) {
            logger.error("UserAuthCenterHelper.getUserCenterAccessToken:", (Throwable)e);
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)accessTokenInfo)) {
            return Collections.emptyMap();
        }
        JSONObject userCenterAccessTokenInfo = null;
        try {
            userCenterAccessTokenInfo = JSON.parseObject((String)accessTokenInfo);
        }
        catch (Exception e) {
            logger.error("UserAuthCenterHelper.getUserCenterAccessToken.cast", (Throwable)e);
            return Collections.emptyMap();
        }
        Map data = (Map)userCenterAccessTokenInfo.get("data");
        if (Objects.isNull(data) || data.isEmpty()) {
            return userCenterAccessTokenInfo;
        }
        if (Objects.nonNull(data.get("access_token")) && Objects.nonNull(data.get("expires_in"))) {
            accessTokenMap.put(key, data);
            accessTokenExpiresMap.put(key, (Integer)data.get("expires_in"));
            accessTokenTimeMap.put(key, System.currentTimeMillis());
        }
        return userCenterAccessTokenInfo;
    }

    public static Map<String, Object> getAuthCodeInfo(String accessToken, String userCenterHost, String clientId, String uid, String refer_url) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)userCenterHost)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return Collections.emptyMap();
        }
        if (Objects.isNull(uid)) {
            return Collections.emptyMap();
        }
        String sURL = userCenterHost + "auth/user/auth_code";
        StringBuilder sb = new StringBuilder(sURL);
        sb.append("?refer_url=").append(refer_url);
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put("access_token", accessToken);
        String authCodeInfoCallBack = "";
        try {
            authCodeInfoCallBack = HttpClientUtils.post((String)sURL, mpHeader, mpBody);
        }
        catch (IOException e) {
            logger.error("UserAuthCenterHelper.getAuthCodeInfo", (Throwable)e);
            return Collections.emptyMap();
        }
        JSONObject authCodeInfoHashMap = null;
        if (StringUtils.isBlank((CharSequence)authCodeInfoCallBack)) {
            return Collections.emptyMap();
        }
        try {
            authCodeInfoHashMap = JSON.parseObject((String)authCodeInfoCallBack);
            if (Objects.isNull(authCodeInfoHashMap)) {
                return Collections.emptyMap();
            }
        }
        catch (Exception e) {
            logger.error("UserAuthCenterHelper.getAuthCodeInfo.error", (Throwable)e);
            return Collections.emptyMap();
        }
        if (Objects.isNull(authCodeInfoHashMap) || authCodeInfoHashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map data = (Map)authCodeInfoHashMap.get("data");
        if (Objects.isNull(data) || data.isEmpty()) {
            return Collections.emptyMap();
        }
        return authCodeInfoHashMap;
    }
}

