/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;

public class UserInfoCleanTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(UserInfoCleanTask.class);
    protected static final int BATCH_COUNT = 100;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("UserInfoCleanTask#execute start");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        Map infoCleanSchemeObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_user_infocleanscheme", (QFilter[])new QFilter[]{enable});
        Iterator iterator = infoCleanSchemeObjs.entrySet().iterator();
        while (iterator.hasNext()) {
            String entityNumber = "bos_user";
            Map.Entry entry = iterator.next();
            DynamicObject infoCleanSchemeObj = (DynamicObject)entry.getValue();
            QFilter filter = UserOperationUtils.convertRule2Filter(entityNumber, infoCleanSchemeObj.getString("rule"));
            if (ObjectUtils.isEmpty((Object)filter)) {
                return;
            }
            List<Object> hasCleanUserIds = this.queryHasCleanUserIds(infoCleanSchemeObj);
            if (CollectionUtils.isNotEmpty(hasCleanUserIds)) {
                filter.and(new QFilter("id", "not in", hasCleanUserIds));
            }
            ArrayList<Object> needCleanUserIds = new ArrayList<Object>(100);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"UserInfoCleanTask#needCleanUserIds", (String)entityNumber, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
            Throwable throwable = null;
            try {
                if (!ds.hasNext()) continue;
                for (Row row : ds) {
                    needCleanUserIds.add(row.get("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
                continue;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("userinfocleanschemeid", infoCleanSchemeObj.getPkValue().toString());
            operateOption.setVariableValue("needvalidate", "false");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"userinfoclean", (String)"bos_user", (Object[])needCleanUserIds.toArray(new Object[needCleanUserIds.size()]), (OperateOption)operateOption);
            if (operationResult.isSuccess() && CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) continue;
            logger.info("UserInfoCleanTask#execute operation fail,message:{},error:{}", (Object)operationResult.getMessage(), (Object)operationResult.getAllErrorOrValidateInfo());
        }
        logger.info("UserInfoCleanTask#execute end");
    }

    private List<Object> queryHasCleanUserIds(DynamicObject infoCleanSchemeObj) {
        ArrayList<Object> res = new ArrayList<Object>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserInfoCleanTask#queryHasCleanUserIds", (String)"bos_user_clean", (String)"user", (QFilter[])new QFilter[]{new QFilter("userinfocleanschemeid", "=", infoCleanSchemeObj.getPkValue())}, (String)"");){
            if (!dataSet.hasNext()) {
                ArrayList<Object> arrayList = res;
                return arrayList;
            }
            for (Row row : dataSet) {
                res.add(row.get("user"));
            }
        }
        return res;
    }
}

