/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.history.UserHistoryUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.sec.user.task.CloudUserDTO;
import kd.bos.sec.user.task.CloudUserSynInfo;
import kd.bos.sec.user.task.SynTypeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.collections4.CollectionUtils;

public class UserSynToYptTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UserSynToYptTask.class);
    private static final String API_USER_SYN = "kdproduct/member/sync/data";
    private static final String API_USER_SYN_RESULT = "kdproduct/prod_instance/member/sync_result_success";
    private static final String API_USER_SYN_FAIL_RESULT = "kdproduct/prod_instance/member/sync_result";
    private static final Integer API_USER_SYN_MAX = 100;
    private static final int SYN_FAIL_REASON_MAX_LENGTH = 200;
    private static final String KEY_CLIENT_ID = "clientId";
    private static final String KEY_CLIENT_SECRET = "clientSecret";
    private static final String ENTITY_LICENSE = "lic_license";
    private static final String SELECT_LIC_FIELDS = "prodinstcode";
    private static final String PROP_LIC_PROD_CODE = "prodinstcode";
    private static final String ENTITY_USER_SYN_FAIL_LOG = "bos_user_syntoyptfaillog";
    private static final String ENTITY_BOS_USER = "bos_user";
    private static final String KEY_USER_ACTIVE = "isactived";
    private static final String KEY_USER_REG = "isregisted";
    private static final String SELECT_USER_FIELDS = "number,fuid,phone,birthday,enable,email,name,gender,username,idcard,usertype,isregisted,isactived";
    private static final String SYSTEM_TYPE = "bos-sec-user";
    private static final ThreadLocal<Integer> THREAD_LOCAL = new ThreadLocal();
    private static final Map<String, String> PRESET_USER_TYPE = new HashMap<String, String>(3);
    private static final Set<String> PRESET_ADMIN_USERS = new HashSet<String>(4);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        QFilter filter = new QFilter(KEY_USER_REG, "=", (Object)Boolean.FALSE);
        filter.and(KEY_USER_ACTIVE, "=", (Object)Boolean.TRUE);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)SELECT_USER_FIELDS, (QFilter[])filter.toArray());
        if (users == null || users.length == 0) {
            return;
        }
        this.executeSynUser(context, new ArrayList<DynamicObject>(Arrays.asList(users)), SynTypeEnum.AUTO);
    }

    /*
     * Loose catch block
     */
    public String executeSynUser(RequestContext context, List<DynamicObject> users, SynTypeEnum synType) {
        try {
            String string;
            int size = users.size();
            THREAD_LOCAL.set(size);
            DynamicObject license = QueryServiceHelper.queryOne((String)ENTITY_LICENSE, (String)"prodinstcode", null);
            if (Objects.isNull(license) || StringUtils.isEmpty((CharSequence)license.getString("prodinstcode"))) {
                String reason = ResManager.loadKDString((String)"\u65e0\u4ea7\u54c1\u5b9e\u4f8b\u7801\u3002", (String)"UserSynToYptTask_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.writeSynFailLog(this.buildSynFailLog(context, synType, reason, users));
                String string2 = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f0\u6761\uff0c\u5931\u8d25%s\u6761\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"UserSynToYptTask_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), size);
                return string2;
            }
            String prodInstCode = license.getString("prodinstcode");
            try (DLock lock = DLock.create((String)prodInstCode);){
                lock.lock();
                LOGGER.info(ResManager.loadKDString((String)"\u5f00\u59cb\u540c\u6b65", (String)"UserSynToYptTask_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (size <= API_USER_SYN_MAX) {
                    this.batchSynUsers(context, users, synType, prodInstCode);
                    LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u675f", (String)"UserSynToYptTask_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    String string3 = this.getSynShowInfo(size);
                    return string3;
                }
                int totalPage = size % API_USER_SYN_MAX > 0 ? size / API_USER_SYN_MAX + 1 : size / API_USER_SYN_MAX;
                for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                    int fromIndex = pageNo * API_USER_SYN_MAX;
                    int toIndex = Math.min((pageNo + 1) * API_USER_SYN_MAX, size);
                    List<DynamicObject> pageUsers = users.subList(fromIndex, toIndex);
                    this.batchSynUsers(context, pageUsers, synType, prodInstCode);
                }
                LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u675f", (String)"UserSynToYptTask_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                string = this.getSynShowInfo(size);
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            THREAD_LOCAL.remove();
        }
    }

    private void batchSynUsers(RequestContext context, List<DynamicObject> users, SynTypeEnum synType, String prodInstCode) {
        ArrayList<DynamicObject> failLogs = new ArrayList<DynamicObject>(0);
        String key = this.sendUserToCloud(context, users, synType, prodInstCode, failLogs);
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            this.updateCurrentSynResult(context, synType, users, prodInstCode, failLogs, key);
        }
        this.writeSynFailLog(failLogs);
    }

    private String sendUserToCloud(RequestContext context, List<DynamicObject> users, SynTypeEnum synType, String prodInstCode, List<DynamicObject> failLogs) {
        List<CloudUserDTO> cloudUserDTOS = this.buildCloudUserDTO(context, users, synType, failLogs);
        if (CollectionUtils.isEmpty(cloudUserDTOS)) {
            return "";
        }
        String synUrl = this.getYptApiUrl(API_USER_SYN, prodInstCode);
        CloudUserSynInfo cloudUserSynInfo = this.buildSynParams(prodInstCode);
        String data = JSON.toJSONString(cloudUserDTOS);
        cloudUserSynInfo.setData(data);
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        String key = "";
        try {
            Map params = (Map)JSON.parseObject((String)JSON.toJSONString((Object)cloudUserSynInfo), Map.class);
            String result = HttpClientUtils.post((String)synUrl, header, (Map)params);
            if (StringUtils.isEmpty((CharSequence)result)) {
                String reason = ResManager.loadKDString((String)"\u53d1\u9001\u6570\u636e\u81f3\u4e91\u5e73\u53f0\u8fd4\u56de\u7a7a\u503c,\u8bf7\u68c0\u67e5clientId\u548cclientSecret\u7684\u914d\u7f6e\u3002", (String)"UserSynToYptTask_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
                return key;
            }
            JSONObject json = JSON.parseObject((String)result);
            Integer errCode = json.getInteger("errcode");
            if (!errCode.equals(0)) {
                String reason = Lang.zh_CN == RequestContext.get().getLang() ? json.getString("description_cn") : json.getString("description");
                failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
                return key;
            }
            key = json.getJSONObject("data").getString("key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                String reason = ResManager.loadKDString((String)"\u4e91\u5e73\u53f0\u672a\u8fd4\u56de\u540c\u6b65\u7684key\u503c\u3002", (String)"UserSynToYptTask_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
            }
        }
        catch (Exception e) {
            String reason = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u6237\u81f3\u4e91\u5e73\u53f0\u65f6\uff0c\u8c03\u7528\u540c\u6b65\u63a5\u53e3\u5931\u8d25\uff0c\u5f02\u5e38\u6d88\u606f\uff1a%s", (String)"UserSynToYptTask_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage());
            failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
            LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u6237\u81f3\u4e91\u5e73\u53f0\u65f6\uff0c\u8c03\u7528\u540c\u6b65\u63a5\u53e3\u5931\u8d25\uff0c\u8c03\u7528\u63a5\u53e3\u4e3a\uff1a", (String)"UserSynToYptTask_20", (String)SYSTEM_TYPE, (Object[])new Object[0]) + synUrl + this.getExcMsg() + e.getMessage());
        }
        return key;
    }

    private String getExcMsg() {
        return "\uff0c" + ResManager.loadKDString((String)"\u5f02\u5e38\u6d88\u606f", (String)"UserSynToYptTask_7", (String)SYSTEM_TYPE, (Object[])new Object[0]) + "\uff1a";
    }

    private void updateCurrentSynResult(RequestContext context, SynTypeEnum synType, Collection<DynamicObject> users, String prodInstCode, List<DynamicObject> failLogs, String key) {
        String synResultUrl = this.getSynUserResultUrl(prodInstCode, key);
        try {
            long startTime = System.currentTimeMillis();
            String synResult = HttpClientUtils.get((String)synResultUrl);
            while (!this.getErrCode(synResult).equals(0)) {
                if (System.currentTimeMillis() - startTime > 300000L) {
                    String reason = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u540c\u6b65\u7ed3\u679c\u63a5\u53e3\u8d85\u65f6\uff0c\u8bf730\u5206\u949f\u540e\u91cd\u8bd5\u3002", (String)"UserSynToYptTask_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
                    return;
                }
                Thread.sleep(1000L);
                synResult = HttpClientUtils.get((String)synResultUrl);
            }
            JSONObject json = JSON.parseObject((String)synResult);
            JSONArray array = json.getJSONArray("data");
            if (CollectionUtils.isEmpty((Collection)array)) {
                this.buildSynFailUserReason(context, synType, users, prodInstCode, failLogs, key);
                return;
            }
            this.updateUidToDb(context, synType, users, failLogs, array, key, prodInstCode);
        }
        catch (Exception e) {
            String reason = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u5e73\u53f0\u83b7\u53d6\u540c\u6b65\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38\uff0c\u5f02\u5e38\u6d88\u606f\uff1a%s", (String)"UserSynToYptTask_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage());
            failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
            LOGGER.info(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u5e73\u53f0\u83b7\u53d6\u540c\u6b65\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38\uff0c\u63a5\u53e3\u5730\u5740\uff1a", (String)"UserSynToYptTask_21", (String)SYSTEM_TYPE, (Object[])new Object[0]) + synResultUrl + this.getExcMsg() + e.getMessage());
        }
    }

    private void updateUidToDb(RequestContext context, SynTypeEnum synType, Collection<DynamicObject> users, List<DynamicObject> failLogs, JSONArray array, String key, String prodInstCode) {
        ArrayList<DynamicObject> needUpdateUsers = new ArrayList<DynamicObject>(users.size());
        ArrayList<Long> userIds = new ArrayList<Long>(users.size());
        Map<String, DynamicObject> erpAccUserMap = this.getErpAccUserMap(users);
        for (Object data : array) {
            JSONObject uidInfo = JSON.parseObject((String)data.toString());
            String erpAccount = uidInfo.getString("erp_account");
            DynamicObject user = erpAccUserMap.get(erpAccount);
            if (user == null) continue;
            user.set("fuid", (Object)uidInfo.getInteger("uid"));
            user.set(KEY_USER_REG, (Object)Boolean.TRUE);
            needUpdateUsers.add(user);
            userIds.add(Long.valueOf(user.getPkValue().toString()));
            erpAccUserMap.remove(erpAccount);
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateUsers.toArray(new DynamicObject[0]));
        UserHistoryUtils.saveUserHistory(userIds);
        DeleteServiceHelper.delete((String)ENTITY_USER_SYN_FAIL_LOG, (QFilter[])new QFilter[]{new QFilter("user", "in", userIds)});
        Collection<DynamicObject> values = erpAccUserMap.values();
        if (CollectionUtils.isNotEmpty(values)) {
            this.buildSynFailUserReason(context, synType, values, prodInstCode, failLogs, key);
        }
    }

    private void buildSynFailUserReason(RequestContext context, SynTypeEnum synType, Collection<DynamicObject> users, String prodInstCode, List<DynamicObject> failLogs, String key) {
        String synUserFailUrl = this.getSynUserFailUrl(prodInstCode, key);
        try {
            String result = HttpClientUtils.get((String)synUserFailUrl);
            JSONObject json = JSON.parseObject((String)result);
            if (!this.getErrCode(result).equals(0) || CollectionUtils.isEmpty((Collection)json.getJSONArray("data"))) {
                String reason = ResManager.loadKDString((String)"\u4e91\u5e73\u53f0\u89e3\u6790\u540c\u6b65\u6570\u636e\u5931\u8d25\u3002", (String)"UserSynToYptTask_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
                return;
            }
            Map<String, DynamicObject> erpAccUserMap = this.getErpAccUserMap(users);
            JSONArray data = json.getJSONArray("data");
            for (Object str : data) {
                JSONObject failUser = JSON.parseObject((String)str.toString());
                String erpAccount = failUser.getString("erp_account");
                DynamicObject user = erpAccUserMap.remove(erpAccount);
                String reason = failUser.getString("reason");
                failLogs.addAll(this.buildSynFailLog(context, synType, reason, Collections.singletonList(user)));
            }
            String reason = ResManager.loadKDString((String)"\u4e91\u5e73\u53f0\u672a\u5904\u7406\u7684\u6570\u636e\u3002", (String)"UserSynToYptTask_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            failLogs.addAll(this.buildSynFailLog(context, synType, reason, erpAccUserMap.values()));
        }
        catch (Exception e) {
            String reason = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u5e73\u53f0\u83b7\u53d6\u540c\u6b65\u5931\u8d25\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38\uff0c\u5f02\u5e38\u6d88\u606f\uff1a%s", (String)"UserSynToYptTask_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage());
            failLogs.addAll(this.buildSynFailLog(context, synType, reason, users));
            LOGGER.info(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u5e73\u53f0\u83b7\u53d6\u540c\u6b65\u5931\u8d25\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38\uff0c\u63a5\u53e3\u5730\u5740\uff1a", (String)"UserSynToYptTask_22", (String)SYSTEM_TYPE, (Object[])new Object[0]) + synUserFailUrl + this.getExcMsg() + e.getMessage());
        }
    }

    private Map<String, DynamicObject> getErpAccUserMap(Collection<DynamicObject> users) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(users.size());
        for (DynamicObject user : users) {
            String account = this.getErpAccount(user);
            map.put(account, user);
        }
        return map;
    }

    private String getErpAccount(DynamicObject user) {
        String email = user.getString("email");
        String phone = user.getString("phone");
        String username = user.getString("username");
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = StringUtils.isNotEmpty((CharSequence)phone) ? phone : email;
        }
        return username;
    }

    private Integer getErrCode(String synResult) {
        if (StringUtils.isEmpty((CharSequence)synResult)) {
            return Integer.MAX_VALUE;
        }
        JSONObject json = JSON.parseObject((String)synResult);
        return json.getInteger("errcode");
    }

    private String getSynShowInfo(int total) {
        Integer success = THREAD_LOCAL.get();
        if (success.equals(total)) {
            return ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\u3002", (String)"UserSynToYptTask_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"UserSynToYptTask_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), success, total - success);
    }

    private CloudUserSynInfo buildSynParams(String prodInstCode) {
        String clientId = System.getProperty(KEY_CLIENT_ID);
        String clientSecret = System.getProperty(KEY_CLIENT_SECRET);
        return new CloudUserSynInfo(clientId, clientSecret, prodInstCode);
    }

    private List<CloudUserDTO> buildCloudUserDTO(RequestContext context, List<DynamicObject> users, SynTypeEnum synType, List<DynamicObject> failLogs) {
        ArrayList<CloudUserDTO> result = new ArrayList<CloudUserDTO>(users.size());
        Iterator<DynamicObject> iterator = users.iterator();
        while (iterator.hasNext()) {
            String[] types;
            DynamicObject user = iterator.next();
            if (!this.paramCheck(context, synType, user, failLogs)) {
                iterator.remove();
                continue;
            }
            CloudUserDTO dto = new CloudUserDTO();
            String name = (String)user.getLocaleString("name").getDefaultItem();
            dto.setName(name);
            dto.setEmail(user.getString("email"));
            dto.setPhone(user.getString("phone"));
            dto.setErp_account(this.getErpAccount(user));
            Date birthday = user.getDate("birthday");
            if (!Objects.isNull(birthday)) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(birthday.toInstant(), ZoneId.systemDefault());
                dto.setBirthday(DateTimeFormatter.ISO_LOCAL_DATE.format(localDateTime));
            }
            dto.setMid(user.getString("number"));
            dto.setIdno(user.getString("idcard"));
            dto.setGender(this.getGender(user));
            dto.setIs_delete(0);
            dto.setStatus(user.getBoolean("enable") ? 1 : 0);
            String userType = user.getString("usertype");
            dto.setIs_remove_network(0);
            for (String type : types = userType.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)type) || !Objects.isNull(PRESET_USER_TYPE.get(type))) continue;
                dto.setIs_remove_network(1);
                break;
            }
            result.add(dto);
        }
        return result;
    }

    private int getGender(DynamicObject user) {
        int gender = user.getInt("gender");
        gender = gender == 1 ? 0 : (gender == 2 ? 1 : 0);
        return gender;
    }

    private boolean paramCheck(RequestContext context, SynTypeEnum type, DynamicObject user, List<DynamicObject> failLogs) {
        if (PRESET_ADMIN_USERS.contains(user.getPkValue().toString())) {
            String reason = ResManager.loadKDString((String)"\u9884\u7f6e\u7ba1\u7406\u5458\u6570\u636e\u4e0d\u7528\u540c\u6b65\u3002", (String)"UserSynToYptTask_15", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            List<DynamicObject> log = this.buildSynFailLog(context, type, reason, Collections.singletonList(user));
            failLogs.addAll(log);
            return false;
        }
        String name = (String)user.getLocaleString("name").getDefaultItem();
        if (StringUtils.isEmpty((CharSequence)name)) {
            String reason = String.format(ResManager.loadKDString((String)"\u7528\u6237\u5728\u5f53\u524d\u8bed\u8a00(%s)\u4e0b\u6ca1\u6709\u540d\u79f0,\u65e0\u6cd5\u540c\u6b65\u3002", (String)"UserSynToYptTask_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), context.getLang());
            List<DynamicObject> log = this.buildSynFailLog(context, type, reason, Collections.singletonList(user));
            failLogs.addAll(log);
            return false;
        }
        String email = user.getString("email");
        String phone = user.getString("phone");
        if (StringUtils.isEmpty((CharSequence)email) && StringUtils.isEmpty((CharSequence)phone)) {
            String reason = ResManager.loadKDString((String)"\u624b\u673a\u90ae\u7bb1\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"UserSynToYptTask_17", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            List<DynamicObject> log = this.buildSynFailLog(context, type, reason, Collections.singletonList(user));
            failLogs.addAll(log);
            return false;
        }
        return true;
    }

    private String getSynUserResultUrl(String prodInstCode, String key) {
        String yptApiUrl = this.getYptApiUrl(API_USER_SYN_RESULT, prodInstCode);
        return String.format("%s&key=%s", yptApiUrl, key);
    }

    private String getSynUserFailUrl(String prodInstCode, String key) {
        String yptApiUrl = this.getYptApiUrl(API_USER_SYN_FAIL_RESULT, prodInstCode);
        return String.format("%s&key=%s", yptApiUrl, key);
    }

    private String getYptApiUrl(String api, String prodInstCode) {
        String clientId = System.getProperty(KEY_CLIENT_ID);
        String clientSecret = System.getProperty(KEY_CLIENT_SECRET);
        String cloudUrl = System.getProperty("url");
        if (null != cloudUrl && !cloudUrl.endsWith("/")) {
            cloudUrl = cloudUrl + '/';
        }
        return String.format("%s%s?client_secret=%s&client_id=%s&prod_inst_code=%s", cloudUrl, api, clientSecret, clientId, prodInstCode);
    }

    private List<DynamicObject> buildSynFailLog(RequestContext context, SynTypeEnum synType, String reason, Collection<DynamicObject> users) {
        Date date = new Date(System.currentTimeMillis());
        ArrayList<DynamicObject> failLogs = new ArrayList<DynamicObject>(users.size());
        for (DynamicObject user : users) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_USER_SYN_FAIL_LOG);
            reason = 200 > reason.length() ? reason : reason.substring(0, 200);
            log.set("reason", (Object)reason);
            log.set("opuser", (Object)context.getUserId());
            log.set("type", (Object)synType.getValue());
            log.set("user", (Object)user);
            log.set("createtime", (Object)date);
            failLogs.add(log);
        }
        Integer count = THREAD_LOCAL.get();
        if (null != count) {
            THREAD_LOCAL.set(count - users.size());
        }
        return failLogs;
    }

    private void writeSynFailLog(List<DynamicObject> failLogs) {
        if (CollectionUtils.isNotEmpty(failLogs)) {
            SaveServiceHelper.save((DynamicObject[])failLogs.toArray(new DynamicObject[0]));
        }
    }

    static {
        PRESET_ADMIN_USERS.add("1");
        PRESET_ADMIN_USERS.add("2");
        PRESET_ADMIN_USERS.add("3");
        PRESET_ADMIN_USERS.add("10");
        PRESET_USER_TYPE.put("1", ResManager.loadKDString((String)"\u804c\u5458", (String)"UserSynToYptTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        PRESET_USER_TYPE.put("6", ResManager.loadKDString((String)"\u673a\u5668\u4eba", (String)"UserSynToYptTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }
}

