/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class PositionUtils {
    private static final Log log = LogFactory.getLog(PositionUtils.class);
    private static final String REPORT_TYPE_ID = "reporttype.id";
    private static final String BOS_REPORT_RELATION = "bos_reportrelation";
    private static final String POSITION_ID = "position.id";
    private static final String SUPERIOR_POSITION_ID = "superiorposition.id";
    private static final String POSITION_NAME = "position.name";
    private static final String SELECT_FIELDS = "position.id,position.name,position.enable,superiorposition.id";

    private PositionUtils() {
    }

    public static List<Long> getSubPositionIdIncludeGrand(long typeId, long positionId) {
        HashMap<Long, Long> positionToSPosition = new HashMap<Long, Long>(512);
        PositionUtils.getPositionToSPosition(typeId, positionToSPosition);
        if (positionToSPosition.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        Map<Long, List<Long>> parentToSubPositionsMap = PositionUtils.getParentToSubPositionsList(positionToSPosition);
        ArrayList<Long> subPositionIds = new ArrayList<Long>(positionToSPosition.size());
        subPositionIds.add(positionId);
        List<Long> subordinatePositions = parentToSubPositionsMap.get(positionId);
        if (CollectionUtils.isEmpty(subordinatePositions)) {
            return subPositionIds;
        }
        PositionUtils.getAllSubordinatePositions(parentToSubPositionsMap, subordinatePositions, subPositionIds);
        return subPositionIds;
    }

    private static void getPositionToSPosition(long typeId, Map<Long, Long> positionToSPosition) {
        QFilter typeFilter = new QFilter(REPORT_TYPE_ID, "=", (Object)typeId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PositionUtils.getPositionToSPosition", (String)BOS_REPORT_RELATION, (String)"id,position.id,superiorposition.id", (QFilter[])new QFilter[]{typeFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                long positionId = r.getLong(POSITION_ID);
                positionToSPosition.put(positionId, r.getLong(SUPERIOR_POSITION_ID));
            }
        }
        catch (Exception e) {
            log.warn("getPositionToSPosition is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
    }

    private static Map<Long, List<Long>> getParentToSubPositionsList(Map<Long, Long> positionToSPosition) {
        HashMap<Long, List<Long>> parentToSubPositionsMap = new HashMap<Long, List<Long>>(positionToSPosition.size());
        for (Map.Entry<Long, Long> entry : positionToSPosition.entrySet()) {
            long positionId = entry.getKey();
            long sPositionId = entry.getValue();
            List subPositionsList = parentToSubPositionsMap.computeIfAbsent(sPositionId, k -> new ArrayList(256));
            subPositionsList.add(positionId);
        }
        return parentToSubPositionsMap;
    }

    private static void getAllSubordinatePositions(Map<Long, List<Long>> parentToSubPositionsMap, List<Long> subordinatePositions, List<Long> subPositionIds) {
        for (long subordinatePositionId : subordinatePositions) {
            subPositionIds.add(subordinatePositionId);
            List<Long> subordinatePositionsList = parentToSubPositionsMap.get(subordinatePositionId);
            if (CollectionUtils.isEmpty(subordinatePositionsList)) continue;
            PositionUtils.getAllSubordinatePositions(parentToSubPositionsMap, subordinatePositionsList, subPositionIds);
        }
    }

    public static Map<String, TreeNode> getAllNodes(long typeId) {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(512);
        QFilter typeFilter = new QFilter(REPORT_TYPE_ID, "=", (Object)typeId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PositionUtils.getAllReportRelation", (String)BOS_REPORT_RELATION, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{typeFilter}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                String positionId = r.getString(POSITION_ID);
                allNodes.put(positionId, PositionUtils.createTreeNode(positionId, r.getString(SUPERIOR_POSITION_ID), r.getString(POSITION_NAME)));
            }
        }
        catch (Exception e) {
            log.warn("getAllReportRelation is error\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return allNodes;
    }

    private static TreeNode createTreeNode(String positionID, String supId, String text) {
        TreeNode treeNode = new TreeNode(supId, positionID, text);
        treeNode.setLeaf(true);
        return treeNode;
    }
}

