/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class UserOperateValidator {
    private static Log logger = LogFactory.getLog(UserOperateValidator.class);
    private Map<String, String> enableLangMap = new HashMap<String, String>(0);
    private DynamicObject userEntity;
    private static final String SYSTEM_TYPE = "bos-sec-user";

    public UserOperateValidator(DynamicObject userEntity) {
        this.userEntity = userEntity;
    }

    public void setEnableLangMap(Map<String, String> enableLangMap) {
        this.enableLangMap = enableLangMap;
    }

    public String check() {
        String msg = "";
        if (StringUtils.isBlank((Object)this.userEntity.get("number"))) {
            return BaseMessage.getMessage((String)"M00003");
        }
        ILocaleString localName = this.userEntity.getLocaleString("name");
        if (localName == null || StringUtils.isBlank((CharSequence)((CharSequence)localName.getDefaultItem()))) {
            return BaseMessage.getMessage((String)"M00001", (Object[])new Object[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"UserOperateValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0])});
        }
        String userType = this.userEntity.getString("usertype");
        if (StringUtils.isBlank((CharSequence)userType)) {
            this.userEntity.set("usertype", (Object)"1");
        } else {
            String[] userTypeArr = userType.split(",");
            if (userTypeArr.length > 1) {
                for (String eachType : userTypeArr) {
                    if (!"6".equals(eachType)) continue;
                    return UserMessage.getMessage((String)"M00003");
                }
            }
        }
        String name = (String)localName.getDefaultItem();
        if ("null".equals(name.toLowerCase())) {
            return BaseMessage.getMessage((String)"M00033", (Object[])new Object[]{name});
        }
        msg = this.isSuperAdminValid();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        msg = this.isValidBirthday();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        msg = this.isOrgAndPositionValid();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        return "";
    }

    private String isSuperAdminValid() {
        long id = Long.parseLong(this.userEntity.getPkValue().toString());
        if (1L != id) {
            if ("administrator".equals(this.userEntity.getLocaleString("name").getDefaultItem())) {
                return UserMessage.getMessage((String)"M00005", (Object[])new Object[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"UserOperateValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0])});
            }
            if ("administrator".equals(this.userEntity.getString("number"))) {
                return UserMessage.getMessage((String)"M00005", (Object[])new Object[]{ResManager.loadKDString((String)"\u7f16\u7801", (String)"UserOperateValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0])});
            }
            if ("administrator".equals(this.userEntity.getString("username"))) {
                return UserMessage.getMessage((String)"M00005", (Object[])new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d", (String)"UserOperateValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0])});
            }
        }
        return "";
    }

    private String isValidBirthday() {
        Object birthdayObj = this.userEntity.get("birthday");
        if (StringUtils.isBlank((Object)birthdayObj)) {
            return "";
        }
        Date currentTime = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String nowtime = df.format(currentTime);
            String birthday = df.format(birthdayObj);
            Date d1 = df.parse(nowtime);
            Date d2 = df.parse(birthday);
            if (d2.getTime() >= d1.getTime()) {
                return UserMessage.getMessage((String)"M00017");
            }
            Calendar now = Calendar.getInstance();
            now.setTime(d1);
            Calendar bir = Calendar.getInstance();
            bir.setTime(d2);
            bir.add(1, 5);
            if (now.getTimeInMillis() <= bir.getTimeInMillis()) {
                now.add(1, -5);
                this.userEntity.set("birthday", (Object)now.getTime());
                return "";
            }
            bir.add(1, 95);
            if (now.getTimeInMillis() >= bir.getTimeInMillis()) {
                now.add(1, -5);
                this.userEntity.set("birthday", (Object)now.getTime());
                return "";
            }
        }
        catch (Exception e) {
            logger.info("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            return birthdayObj + ":" + UserMessage.getMessage((String)"M00018");
        }
        return "";
    }

    private String isOrgAndPositionValid() {
        DynamicObjectCollection entryEntity = this.userEntity.getDynamicObjectCollection("entryentity");
        if (Utils.isListEmpty((List)entryEntity)) {
            return "";
        }
        int count = entryEntity.size();
        ArrayList<String> samePositionList = new ArrayList<String>(count);
        int mainJobCount = 0;
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        for (DynamicObject entity : entryEntity) {
            DynamicObject org = entity.getDynamicObject("dpt");
            if (org == null) {
                return UserMessage.getMessage((String)"M00020", (Object[])new Object[]{entity.get("seq")});
            }
            ILocaleString localPosition = entity.getLocaleString("position");
            if (localPosition == null || StringUtils.isBlank((CharSequence)((CharSequence)localPosition.getDefaultItem()))) {
                return UserMessage.getMessage((String)"M00021", (Object[])new Object[]{entity.get("seq")});
            }
            String orgId = org.getString("id");
            for (Map.Entry positionEntry : localPosition.entrySet()) {
                String positionValue;
                String lang = (String)positionEntry.getKey();
                if ("GLang".equals(lang) || !this.enableLangMap.containsKey(lang) || !StringUtils.isNotBlank((CharSequence)(positionValue = (String)positionEntry.getValue()))) continue;
                StringBuilder key = new StringBuilder(orgId);
                key.append(fullNameSep);
                key.append(lang);
                key.append(fullNameSep);
                key.append(positionValue);
                String compareKey = key.toString();
                if (samePositionList.contains(compareKey)) {
                    return UserMessage.getMessage((String)"M00022", (Object[])new Object[]{entity.get("seq")});
                }
                samePositionList.add(compareKey);
            }
            if (entity.getBoolean("ispartjob")) continue;
            ++mainJobCount;
        }
        if (mainJobCount == 0) {
            return UserMessage.getMessage((String)"M00023");
        }
        if (mainJobCount > 1) {
            return UserMessage.getMessage((String)"M00024");
        }
        return "";
    }
}

