/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class UserOperationExecutor {
    private boolean needActiveUser = Boolean.parseBoolean(LicenseServiceHelper.getPubTenantType()) && LicenseServiceHelper.isTemporaryLicense() || DevVerifyServiceHelper.isOEMEnv();

    public String beforeSaveOperation(DynamicObject user) {
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();
        String msg = this.beforeSaveOperation(user, userChangeList);
        if (StringUtils.isBlank((CharSequence)msg)) {
            UserOperationUtils.saveUserChange(user, userChangeList);
        }
        return msg;
    }

    public String beforeSaveOperation(DynamicObject user, List<Map<String, Object>> userChangeList) {
        this.prepareUserObj(user);
        if (user.getDataEntityState().getFromDatabase()) {
            userChangeList.add(UserOperationUtils.genUserChange(user, "2"));
        } else {
            userChangeList.add(UserOperationUtils.genUserChange(user, "1"));
        }
        return "";
    }

    private void prepareUserObj(DynamicObject user) {
        String idCard;
        if (StringUtils.isBlank((Object)user.get("fuid"))) {
            user.set("fuid", (Object)0);
        }
        if (this.needActiveUser) {
            user.set("isregisted", (Object)Boolean.TRUE);
            user.set("isactived", (Object)Boolean.TRUE);
        }
        if (null != (idCard = (String)user.get("idcard")) && idCard.length() > 0 && StringUtils.isBlank((CharSequence)idCard)) {
            user.set("idcard", (Object)" ");
        }
        if (StringUtils.isBlank((Object)user.get("gender"))) {
            user.set("gender", (Object)"0");
        }
    }
}

