/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dd.service.DingDingServiceHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.welink.TicketResp;
import kd.bos.org.utils.OrgBillListCommon;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.task.SynDingTalkTask;
import kd.bos.sec.user.task.SynUserTypeEnum;
import kd.bos.service.InteTimeZone;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.welink.service.WeLinkServiceHelper;
import kd.bos.wxqyh.service.WxqyhServiceHelper;
import kd.bos.yzj.model.user.YzjUserAccount;
import kd.bos.yzj.model.user.YzjUserModel;

public class UserOperationUtils {
    private static Log logger = LogFactory.getLog(UserOperationUtils.class);
    private static final String YZJ_REGSOURCE_NEXTERP = "NextERP";
    public static final String PARAM_FROM_USER_PAGE = "isFrom_bos_user_Page";
    public static final String PARAM_MODIFY_ADMIN_USER = "modifyAdminUser";
    private static final String CACHE_ADMIN_CHARGE_ORG = "cache_admin_charge_org";
    public static final String IS_SHOW_OTHER_TYPE_NODE = "isShowOtherTypeNode";
    public static final String CACHE_ADMIN_CHARGE_USER = "cache_admin_charge_user";
    private static final String BOS_SEC_USER = "bos-sec-user";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_user_sync", new DistributeCacheHAPolicy(true, true));
    private static final String USER_EMAIL_REGEX = "^([a-zA-Z0-9_\\-\\.\\/]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,6}|[0-9]{1,3})(\\]?)$";

    public static boolean isEmail(String email) {
        Pattern p = Pattern.compile(USER_EMAIL_REGEX);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isUserTypeExists(String userType) {
        String[] typeArr = userType.split(",");
        boolean isOnlyEmployee = true;
        if (typeArr.length == 0) {
            isOnlyEmployee = false;
        } else {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            ArrayList<Long> uerTypeIds = new ArrayList<Long>(typeArr.length);
            for (String uerTypeId : typeArr) {
                if (!StringUtils.isNotBlank((CharSequence)uerTypeId)) continue;
                uerTypeIds.add(Long.valueOf(uerTypeId.trim()));
            }
            QFilter idFilter = new QFilter("id", "in", uerTypeIds);
            QFilter[] filters = new QFilter[]{enableFilter, idFilter};
            isOnlyEmployee = QueryServiceHelper.exists((String)"bos_usertype", (QFilter[])filters);
        }
        return isOnlyEmployee;
    }

    public static boolean isUserTypeOnlyEmployee(String userType, List<Long> usertypeList) {
        String[] typeArr = userType.split(",");
        if (typeArr.length == 0) {
            return false;
        }
        boolean isOnlyEmployee = true;
        for (String type : typeArr) {
            if (StringUtils.isBlank((CharSequence)type)) continue;
            if (!"1".equals(type)) {
                isOnlyEmployee = false;
            }
            if (usertypeList == null) continue;
            usertypeList.add(Long.valueOf(type));
        }
        return isOnlyEmployee;
    }

    public static List<String> getUserTypeList(String userType) {
        String[] typeArr = userType.split(",");
        ArrayList<String> typeList = new ArrayList<String>(typeArr.length);
        if (typeArr.length > 0) {
            for (String type : typeArr) {
                if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                typeList.add(type);
            }
        }
        return typeList;
    }

    public static void saveUserChange(DynamicObject user, List<Map<String, Object>> userChangeList) {
        if (Utils.isListNotEmpty(userChangeList)) {
            String propUserId;
            Map<String, Object> userChangeMap = userChangeList.get(0);
            Object userId = userChangeMap.get(propUserId = "userID");
            if (StringUtils.isBlank((Object)userId) || "0".equals(userId.toString())) {
                userChangeMap.put(propUserId, user.getPkValue());
                userChangeMap.put("number", user.getString("number"));
            }
            UserServiceHelper userServiceHelper = new UserServiceHelper();
            userServiceHelper.updateUserChange(userChangeList);
        }
    }

    @Deprecated
    public static YzjUserModel genUserModel(DynamicObject userObj, List<Map<String, String>> orgMapList) {
        return UserOperationUtils.genUserModel(userObj);
    }

    public static YzjUserModel genUserModel(DynamicObject userObj) {
        if (userObj == null) {
            return null;
        }
        DynamicObjectCollection entry = (DynamicObjectCollection)userObj.get("entryentity");
        long mainDeptID = 0L;
        String mainDeptPath = "";
        String mainPosName = "";
        int userType = 2;
        ArrayList partJobList = new ArrayList();
        ArrayList<String> chargeOrgList = new ArrayList<String>();
        String mainYzjOrgId = "";
        String leaderOpenId = "";
        ArrayList<String> leaderOpenIds = new ArrayList<String>(entry.size());
        YzjUserModel userModel = UserOperationUtils.genUserModelByUserObj(userObj);
        DynamicObjectType orgStructureDynamicObjectType = null;
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        for (DynamicObject entryObj : entry) {
            DynamicObject superiorObj;
            String yzjOrgId;
            DynamicObject org = entryObj.getDynamicObject("dpt");
            if (org == null || StringUtils.isBlank((CharSequence)(yzjOrgId = org.getString("fyzjorgid")))) continue;
            String sPosition = "";
            ILocaleString localPosition = entryObj.getLocaleString("position");
            if (localPosition != null) {
                sPosition = (String)localPosition.getDefaultItem();
            }
            if ((superiorObj = entryObj.getDynamicObject("superior")) != null) {
                leaderOpenId = superiorObj.getString("useropenid");
                if (StringUtils.isBlank((CharSequence)leaderOpenId)) {
                    userModel.setOperSuccess(false);
                    userModel.setOperMsg(UserMessage.getMessage((String)"M00069", (Object[])new Object[]{superiorObj.getString("name")}));
                    return userModel;
                }
                leaderOpenIds.add(leaderOpenId);
            }
            String sIsIncharge = entryObj.getString("isincharge");
            String sIsPartJob = entryObj.getString("ispartjob");
            if (!Boolean.parseBoolean(sIsPartJob)) {
                String fullName;
                long orgId = org.getLong("id");
                DynamicObject orgStructObj = entryObj.getDynamicObject("orgstructure");
                if (orgStructObj == null) {
                    Map<Long, DynamicObject> orgStructure;
                    HashSet<Long> orgIdSet = new HashSet<Long>(1);
                    orgIdSet.add(orgId);
                    if (orgStructureDynamicObjectType == null) {
                        orgStructureDynamicObjectType = UserOperationUtils.getOrgStructureDynamicObjectType(userObj);
                    }
                    if ((orgStructObj = (orgStructure = UserOperationUtils.getOrgStructure(orgIdSet, orgStructureDynamicObjectType)).get(orgId)) == null) {
                        throw new KDBizException(OrgMessage.getMessage((String)"M00106"));
                    }
                    entryObj.set("orgstructure", (Object)orgStructObj);
                }
                if (!(fullName = orgStructObj.getString("fullname")).contains(fullNameSep)) {
                    mainDeptPath = "\\";
                } else {
                    fullName = StringUtils.substringAfter((String)fullName, (String)fullNameSep);
                    mainDeptPath = fullName.replace(fullNameSep, "\\");
                }
                mainYzjOrgId = yzjOrgId;
                mainDeptID = orgId;
                mainPosName = sPosition;
                if (Boolean.parseBoolean(sIsIncharge)) {
                    userType = 1;
                }
            } else {
                HashMap<String, String> mpPartJob = new HashMap<String, String>();
                mpPartJob.put("orgId", yzjOrgId);
                mpPartJob.put("jobTitle", sPosition);
                partJobList.add(mpPartJob);
            }
            if (!Boolean.parseBoolean(sIsIncharge)) continue;
            chargeOrgList.add(yzjOrgId);
        }
        userModel.setYzjOrgId(mainYzjOrgId);
        userModel.setDepartmentID(mainDeptID);
        userModel.setDepartment(mainDeptPath);
        userModel.setJobTitle(mainPosName);
        userModel.setOrgUserType(userType);
        userModel.setPartJob(partJobList);
        userModel.setChargeOrgList(chargeOrgList);
        userModel.setLeaderOpenId(leaderOpenId);
        userModel.setAddSuperiorList(leaderOpenIds);
        return userModel;
    }

    public static DynamicObjectType getOrgStructureDynamicObjectType(DynamicObject userObj) {
        if (userObj == null) {
            return null;
        }
        IDataEntityType userEntityType = userObj.getDataEntityType();
        EntryProp entryProp = (EntryProp)userEntityType.getProperties().get((Object)"entryentity");
        if (entryProp == null) {
            return null;
        }
        BasedataProp orgStructureProp = (BasedataProp)entryProp.getItemType().getProperties().get((Object)"orgstructure");
        if (orgStructureProp == null) {
            return null;
        }
        return (DynamicObjectType)orgStructureProp.getComplexType();
    }

    private static YzjUserModel genUserModelByUserObj(DynamicObject userObj) {
        YzjUserModel userModel = new YzjUserModel();
        userModel.setOperSuccess(true);
        String openId = userObj.getString("useropenid");
        userModel.setOpenId(openId);
        String jobNo = userObj.getString("number");
        userModel.setJobNo(jobNo);
        String name = userObj.getString("name");
        userModel.setName(name);
        String phone = userObj.getString("phone");
        userModel.setPhone(phone);
        String email = userObj.getString("email");
        userModel.setEmail(email);
        YzjUserAccount account = new YzjUserAccount(phone, email);
        userModel.setAccount(account);
        String gender = userObj.getString("gender");
        userModel.setGender(gender);
        String birthday = userObj.getString("birthday");
        if (StringUtils.isNotBlank((CharSequence)birthday)) {
            SimpleDateFormat fmtDate = new SimpleDateFormat("yyyy-MM-dd");
            InteTimeZone sysTimeZone = TimeServiceHelper.getSysTimeZone();
            birthday = sysTimeZone.format(userObj.getDate("birthday"), (DateFormat)fmtDate);
        }
        userModel.setBirthday(birthday);
        String idCard = userObj.getString("idcard");
        userModel.setIdentityId(idCard);
        String fullPhotoUrl = UserOperationUtils.getFullPhotoUrl(userObj);
        userModel.setPhotoUrl(fullPhotoUrl);
        userModel.setStatus("1");
        userModel.setRegSource(YZJ_REGSOURCE_NEXTERP);
        userModel.setWeights(1);
        return userModel;
    }

    public static Map<String, Object> genUserChange(DynamicObject user, String userChangeType) {
        HashMap<String, Object> userChangeMap = new HashMap<String, Object>();
        userChangeMap.put("userID", user.getPkValue());
        userChangeMap.put("number", user.getString("number"));
        userChangeMap.put("name", user.getString("name"));
        userChangeMap.put("phone", user.getString("phone"));
        userChangeMap.put("changeTime", new Date());
        userChangeMap.put("changeType", userChangeType);
        return userChangeMap;
    }

    @Deprecated
    public static String getFieldValue(DynamicObject obj, String field) {
        String value = "";
        try {
            Object fldobj = obj.get(field);
            if (fldobj != null) {
                value = fldobj.toString();
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return value;
    }

    private static String getFullPhotoUrl(DynamicObject obj) {
        String fullPhotoUrl = obj.getString("picturefield");
        if (StringUtils.isNotBlank((CharSequence)fullPhotoUrl)) {
            fullPhotoUrl = UrlService.getImageFullUrl((String)fullPhotoUrl);
        }
        return fullPhotoUrl;
    }

    public static void transUserNamePinyin(DynamicObject userObj, Set<String> existsUserNames) {
        UserUtils.transUserNamePinyin((DynamicObject)userObj, existsUserNames);
    }

    public static String getFullSpellByName(String name) {
        return UserUtils.getFullSpellByName((String)name);
    }

    public static String getFirstSpellByName(String name) {
        return UserUtils.getFirstSpellByName((String)name);
    }

    public static String getUserNameByFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames) {
        return UserUtils.getUserNameByFormatedFullPinyin((long)userId, (String)UserOperationUtils.formatNameSpell(fullPingyin), existsUserNames);
    }

    public static String getUserNameByFormatedFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames) {
        return UserUtils.getUserNameByFormatedFullPinyin((long)userId, (String)fullPingyin, existsUserNames);
    }

    public static String formatNameSpell(String fullPingyin) {
        return UserUtils.formatNameSpell((String)fullPingyin);
    }

    public static Set<String> getExistsUserNames(long userId, String fullPingyin) {
        return UserUtils.getExistsUserNames((long)userId, (String)fullPingyin);
    }

    public static Map<Long, DynamicObject> getOrgStructure(Set<Long> orgIdSet) {
        return UserOperationUtils.getOrgStructure(orgIdSet, null);
    }

    public static Map<Long, DynamicObject> getOrgStructure(Set<Long> orgIdSet, DynamicObjectType dynamicObjectType) {
        Map structObjMap;
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> orgStructureObjMap = new HashMap<Long, DynamicObject>(orgIdSet.size());
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", orgIdSet);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        if (dynamicObjectType == null) {
            String selectFields = "view,org,parent,longnumber,fullname,yzjorgid,yzjparentorgid,level,isleaf,isstatsum,isbizunit,isctrlunit,isfreeze,sealuptime,sortcode,sortnumber";
            structObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg_structure", (String)selectFields, (QFilter[])filters);
        } else {
            structObjMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dynamicObjectType, (QFilter[])filters);
        }
        if (CollectionUtils.isEmpty((Map)structObjMap)) {
            return orgStructureObjMap;
        }
        for (Map.Entry objEntry : structObjMap.entrySet()) {
            DynamicObject orgObj;
            DynamicObject structObj = (DynamicObject)objEntry.getValue();
            if (structObj == null || (orgObj = structObj.getDynamicObject("org")) == null) continue;
            orgStructureObjMap.put(orgObj.getLong("id"), structObj);
        }
        return orgStructureObjMap;
    }

    public static boolean synWxqyh(IFormView view) {
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "synType", (Object)"wxqyh", 1, TimeUnit.HOURS);
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        String corpid = "";
        String corpsecret = "";
        if (paramMap != null) {
            corpid = (String)paramMap.get("corpid");
            corpsecret = (String)paramMap.get("corpsecret");
        }
        String errMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u4ec5\u9002\u7528\u4e8e2022\u5e746\u670820\u65e5\u4e4b\u524d\u96c6\u6210\u7684\u5e94\u7528\u4f7f\u7528\uff0c\u5728\u6b64\u65f6\u95f4\u4e4b\u540e\u96c6\u6210\u7684\u5e94\u7528\u9700\u5728\u7528\u6237\u767b\u5f55\u65f6\u7ed1\u5b9a\u6620\u5c04\u5173\u7cfb\u6216\u624b\u52a8\u5bfc\u5165\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u4f01\u4e1a\u5fae\u4fe1\u5b98\u7f51\u3002", (String)"UserOperationUtils_9", (String)BOS_SEC_USER, (Object[])new Object[0]);
        String access_token = WxqyhServiceHelper.getAccess_token((String)corpid, (String)corpsecret);
        if (null != access_token) {
            List userList = WxqyhServiceHelper.getDeptUserList((String)access_token, (long)1L, (String)"1");
            if (userList != null && userList.size() > 0) {
                if (!UserOperationUtils.wxqyhHasMobile(userList)) {
                    cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)errMsg, 5, TimeUnit.SECONDS);
                    cache.put(SynDingTalkTask.getCacheKeyPrefix() + "progressbarap_disable", (Object)"true", 5, TimeUnit.SECONDS);
                    return false;
                }
                cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(1), 1, TimeUnit.DAYS);
                UserOperationUtils.writeLog("83bfebc8000037ac", "bos_user", "WeComSyn", new MultiLangEnumBridge("\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65", "UserOperationUtils_8", BOS_SEC_USER), null);
                UserOperationUtils.saveIMMapping(userList, "mobile", "phone", SynUserTypeEnum.WXQYH.getValue());
                UserOperationUtils.setSynDingTalkComletedNum(1);
                return true;
            }
            List deptList = WxqyhServiceHelper.getDeptList((String)access_token);
            if (deptList == null || deptList.size() <= 0) {
                cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)errMsg, 5, TimeUnit.SECONDS);
                cache.put(SynDingTalkTask.getCacheKeyPrefix() + "progressbarap_disable", (Object)"true", 5, TimeUnit.SECONDS);
                return false;
            }
            cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(deptList.size()), 1, TimeUnit.DAYS);
            int deptSize = 0;
            for (String deptId : deptList) {
                ++deptSize;
                userList = WxqyhServiceHelper.getDeptUserList((String)access_token, (long)Long.parseLong(deptId), (String)"1");
                if (userList != null && userList.size() > 0) {
                    if (!UserOperationUtils.wxqyhHasMobile(userList)) {
                        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)errMsg, 5, TimeUnit.SECONDS);
                        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "progressbarap_disable", (Object)"true", 5, TimeUnit.SECONDS);
                        return false;
                    }
                    UserOperationUtils.saveIMMapping(userList, "mobile", "phone", SynUserTypeEnum.WXQYH.getValue());
                }
                UserOperationUtils.setSynDingTalkComletedNum(deptSize);
            }
            UserOperationUtils.writeLog("83bfebc8000037ac", "bos_user", "WeComSyn", new MultiLangEnumBridge("\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65", "UserOperationUtils_8", BOS_SEC_USER), null);
            return true;
        }
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)UserMessage.getMessage((String)"M00063"), 5, TimeUnit.SECONDS);
        return false;
    }

    private static boolean wxqyhHasMobile(List<Map<String, String>> userList) {
        boolean flag = false;
        int size = userList.size() > 50 ? 50 : userList.size();
        for (int i = 0; i < size; ++i) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userList.get(i).get("mobile"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean synWxqyh() {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap == null) {
            return false;
        }
        Object corpid = paramMap.get("corpid");
        Object corpsecret = paramMap.get("corpsecret");
        String access_token = WxqyhServiceHelper.getAccess_token((String)corpid.toString(), (String)corpsecret.toString());
        if (null != access_token) {
            List userList = WxqyhServiceHelper.getDeptUserList((String)access_token, (long)1L, (String)"1");
            if (userList != null && userList.size() > 0) {
                return UserOperationUtils.saveIMMapping(userList, "mobile", "phone", SynUserTypeEnum.WXQYH.getValue());
            }
            List deptList = WxqyhServiceHelper.getDeptList((String)access_token);
            for (String deptId : deptList) {
                userList = WxqyhServiceHelper.getDeptUserList((String)access_token, (long)Long.parseLong(deptId), (String)"1");
                if (userList == null || userList.size() <= 0) continue;
                UserOperationUtils.saveIMMapping(userList, "mobile", "phone", SynUserTypeEnum.WXQYH.getValue());
            }
            return true;
        }
        return false;
    }

    public static void synDingByType(String type) {
        Map authScope;
        String accessToken = DingDingServiceHelper.getAccess_token();
        if (kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            UserOperationUtils.showConfigErrorMsg(null);
            return;
        }
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "synType", (Object)"ding", 1, TimeUnit.HOURS);
        String imTypeFieldName = "mobile";
        String sysFieldName = "phone";
        if ("email".equals(type)) {
            imTypeFieldName = "email";
            sysFieldName = "email";
        }
        if (UserOperationUtils.isAuthScope(authScope = DingDingServiceHelper.getAuthScope((String)accessToken))) {
            List authedUser = (List)authScope.get("authed_user");
            int userSize = 0;
            int deptSize = 0;
            if (null != authedUser && !authedUser.isEmpty()) {
                List userList = DingDingServiceHelper.getAuthScopeUsers((List)authedUser, (String)accessToken);
                UserOperationUtils.saveIMMapping(userList, imTypeFieldName, sysFieldName, SynUserTypeEnum.DINGDING.getValue());
                userSize = authedUser.size();
            }
            List authedDept = (List)authScope.get("authed_dept");
            int deptCount = 0;
            if (null != authedDept && !authedDept.isEmpty()) {
                List<String> allDept = UserOperationUtils.getChildrenList(accessToken, authedDept);
                authedDept.addAll(allDept);
                deptSize = authedDept.size();
                deptCount = UserOperationUtils.saveUserMappingByDept(accessToken, authedDept, imTypeFieldName, sysFieldName);
            }
            UserOperationUtils.setSynDingTalkComletedNum(deptCount + userSize);
            cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(userSize + deptSize), 1, TimeUnit.DAYS);
            return;
        }
        List deptList = DingDingServiceHelper.getDeptList((String)accessToken);
        if (deptList == null || deptList.isEmpty()) {
            cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)"deptList is null", 5, TimeUnit.SECONDS);
            return;
        }
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(deptList.size()), 1, TimeUnit.DAYS);
        int dept = UserOperationUtils.saveUserMappingByDept(accessToken, deptList, imTypeFieldName, sysFieldName);
        UserOperationUtils.setSynDingTalkComletedNum(dept);
        UserOperationUtils.writeLog("83bfebc8000037ac", "bos_user", "DingDingSyn", new MultiLangEnumBridge("\u9489\u9489\u540c\u6b65", "UserOperationUtils_3", BOS_SEC_USER), null);
    }

    private static void showConfigErrorMsg(IFormView view) {
        if (null == view || ObjectUtils.isEmpty((Object)view)) {
            logger.error(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9489\u9489\u914d\u7f6e\u53c2\u6570\u548c\u63a5\u53e3\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"UserOperationUtils_2", (String)BOS_SEC_USER, (Object[])new Object[0]));
            return;
        }
        view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9489\u9489\u914d\u7f6e\u53c2\u6570\u548c\u63a5\u53e3\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"UserOperationUtils_2", (String)BOS_SEC_USER, (Object[])new Object[0]));
    }

    public static void synDing() {
        UserOperationUtils.synDingByType(UserOperationUtils.getSynDingType());
    }

    private static String getSynDingType() {
        String methodSync = System.getProperty(RequestContext.get().getTenantId() + "_dingding_login_type");
        String type = "mobile";
        if ("email".equalsIgnoreCase(methodSync)) {
            type = "email";
        }
        return type;
    }

    private static List<String> getChildrenList(String accessToken, List<String> authedDept) {
        ArrayList<String> allDept = new ArrayList<String>(authedDept.size());
        for (String deptId : authedDept) {
            List deptList = DingDingServiceHelper.getDeptList((String)accessToken, (String)deptId);
            allDept.addAll(deptList);
        }
        return allDept;
    }

    private static int saveUserMappingByDept(String accessToken, List<String> deptList, String imTypeFieldName, String sysFieldName) {
        int completedCount = 1;
        for (String deptId : deptList) {
            List userList;
            long offset = 0L;
            long size = 100L;
            while ((userList = DingDingServiceHelper.getDeptUserList((String)accessToken, (long)Long.parseLong(deptId), (long)offset, (long)size, null)) != null && !userList.isEmpty()) {
                UserOperationUtils.saveIMMapping(userList, imTypeFieldName, sysFieldName, SynUserTypeEnum.DINGDING.getValue());
                if (userList.size() < 100) break;
                offset += 100L;
            }
            UserOperationUtils.setSynDingTalkComletedNum(completedCount);
            ++completedCount;
        }
        return completedCount;
    }

    private static boolean isAuthScope(Map<String, List<String>> authScope) {
        String dept;
        if (authScope.isEmpty()) {
            logger.error("authScope is empty");
            return false;
        }
        List<String> authedDept = authScope.get("authed_dept");
        if (null != authedDept && !authedDept.isEmpty() && "1".equals(dept = authedDept.get(0))) {
            logger.info("authed_dept : 1");
            return false;
        }
        return true;
    }

    public static boolean saveIMMapping(List<Map<String, String>> imUserList, String imTypeFieldName, String sysFieldName, long imTypeId) {
        if (CollectionUtils.isEmpty(imUserList) || StringUtils.isBlank((CharSequence)imTypeFieldName) || StringUtils.isBlank((CharSequence)sysFieldName) || imTypeId == 0L) {
            return true;
        }
        int count = imUserList.size();
        ArrayList<String> typeFiledValues = new ArrayList<String>(count);
        HashMap<String, DynamicObject[]> userOpenidMap = new HashMap<String, DynamicObject[]>(count);
        String fieldUserId = "userid";
        for (Map<String, String> userMap : imUserList) {
            String imTypeFieldValue = userMap.get(imTypeFieldName);
            if (imTypeId == SynUserTypeEnum.DINGDING.getValue() && imTypeFieldName.equals("email") && kd.bos.util.StringUtils.isEmpty((String)(imTypeFieldValue = UserOperationUtils.getStringValue(userMap.get("orgEmail"))))) {
                imTypeFieldValue = UserOperationUtils.getStringValue(userMap.get("email"));
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)imTypeFieldValue)) continue;
            typeFiledValues.add(imTypeFieldValue);
            DynamicObject[] openid = userMap.get("userid");
            userOpenidMap.put(imTypeFieldValue, openid);
        }
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)("id," + sysFieldName), (QFilter[])new QFilter[]{new QFilter(sysFieldName, "in", typeFiledValues)});
        if (users == null || users.length == 0) {
            return true;
        }
        ArrayList<Object> ids = new ArrayList<Object>(users.length);
        HashMap<String, String> sysTypeFieldMap = new HashMap<String, String>(users.length);
        for (DynamicObject dynamicObject : users) {
            ids.add(dynamicObject.getPkValue());
            sysTypeFieldMap.put(dynamicObject.getPkValue().toString(), dynamicObject.getString(sysFieldName));
        }
        DynamicObject[] imMapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,openid", (QFilter[])new QFilter[]{new QFilter(fieldUserId, "in", ids), new QFilter("imtype", "=", (Object)imTypeId)});
        if (imMapping != null && imMapping.length > 0) {
            ArrayList<DynamicObject> updateMapping = new ArrayList<DynamicObject>(imMapping.length);
            for (DynamicObject dynamicObject : imMapping) {
                String openid;
                String userid = dynamicObject.getString(fieldUserId);
                ids.remove(dynamicObject.get(fieldUserId));
                String sysFieldValue = (String)sysTypeFieldMap.get(userid);
                if (sysFieldValue == null || (openid = (String)userOpenidMap.get(sysFieldValue)) == null) continue;
                dynamicObject.set("openid", (Object)openid);
                updateMapping.add(dynamicObject);
            }
            if (updateMapping.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateMapping.toArray(new DynamicObject[1]));
            }
        }
        ArrayList<DynamicObject> insertMapping = new ArrayList<DynamicObject>(users.length);
        for (Object e : ids) {
            String openid;
            String phone = (String)sysTypeFieldMap.get(e.toString());
            if (phone == null || (openid = (String)userOpenidMap.get(phone)) == null) continue;
            MainEntityType imMappingType = EntityMetadataCache.getDataEntityType((String)"bas_immapping");
            DynamicObject mapping = new DynamicObject((DynamicObjectType)imMappingType);
            mapping.set(fieldUserId, e);
            mapping.set("user", e);
            mapping.set("imtype", (Object)imTypeId);
            mapping.set("openid", (Object)openid);
            insertMapping.add(mapping);
        }
        if (insertMapping.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertMapping.toArray(new DynamicObject[1]));
        }
        return true;
    }

    public static void synDingEmail() {
        UserOperationUtils.synDingByType("email");
    }

    private static void setSynDingTalkComletedNum(int completedCount) {
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "completed-count", (Object)String.valueOf(completedCount), 1, TimeUnit.DAYS);
    }

    public static boolean synWeLink(IFormView view) {
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "synType", (Object)"welink", 1, TimeUnit.HOURS);
        Boolean hasConfig = UserOperationUtils.checkWlConfigByToken(view);
        if (!hasConfig.booleanValue()) {
            return false;
        }
        TicketResp ticketResp = WeLinkServiceHelper.getAccessToken();
        Integer pageSubDeptNo = 0;
        Integer limit = 100;
        String subDeptCode = "";
        Map subDeptMap = new HashMap();
        String deptCode = "";
        Integer totalCount = 0;
        Integer totalPage = 0;
        String errMessage = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"UserOperationUtils_7", (String)BOS_SEC_USER, (Object[])new Object[0]);
        boolean success = true;
        int deptSize = 0;
        boolean hasSubDept = false;
        do {
            Integer n = pageSubDeptNo;
            pageSubDeptNo = pageSubDeptNo + 1;
            Integer n2 = pageSubDeptNo;
            subDeptMap = WeLinkServiceHelper.getSubDeptMap((String)ticketResp.getAccess_token(), (String)"0", (Integer)0, (Integer)pageSubDeptNo, (Integer)limit);
            if (Objects.isNull(subDeptMap) || subDeptMap.isEmpty()) {
                success = false;
                logger.error("welink subDeptMap is empty");
                break;
            }
            subDeptCode = (String)subDeptMap.get("code");
            if (!StringUtils.equals((CharSequence)subDeptCode, (CharSequence)"0")) {
                logger.error("welink_Syn===>", (Object)subDeptCode);
                break;
            }
            List departmentInfoList = (List)subDeptMap.get("departmentInfo");
            if (departmentInfoList.isEmpty()) break;
            hasSubDept = true;
            cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(departmentInfoList.size() + 1), 1, TimeUnit.DAYS);
            for (Map departmentMap : departmentInfoList) {
                ++deptSize;
                deptCode = (String)departmentMap.get("deptCode");
                if (StringUtils.isBlank((CharSequence)deptCode)) continue;
                UserOperationUtils.handleSingleDeptUser(ticketResp.getAccess_token(), deptCode);
                UserOperationUtils.handleUnderFirstLevelDept(ticketResp.getAccess_token(), deptCode);
                UserOperationUtils.setSynDingTalkComletedNum(deptSize);
            }
            totalCount = (Integer)subDeptMap.get("totalCount");
            limit = (Integer)subDeptMap.get("limit");
        } while (!Objects.equals(pageSubDeptNo, totalPage = Integer.valueOf((totalCount + limit - 1) / limit)));
        if (!hasSubDept) {
            cache.put(SynDingTalkTask.getCacheKeyPrefix() + "total-count", (Object)String.valueOf(1), 1, TimeUnit.DAYS);
        }
        UserOperationUtils.handleSingleDeptUser(ticketResp.getAccess_token(), "0");
        if (success) {
            UserOperationUtils.setSynDingTalkComletedNum(deptSize + 1);
            return true;
        }
        cache.put(SynDingTalkTask.getCacheKeyPrefix() + "errormsg", (Object)errMessage, 5, TimeUnit.SECONDS);
        return true;
    }

    public static Boolean checkWlConfigByToken(IFormView view) {
        TicketResp ticketResp = WeLinkServiceHelper.getAccessToken();
        if (!UserOperationUtils.checkTicketResp(ticketResp)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6WeLink\u901a\u8baf\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5WeLink\u914d\u7f6e\u53c2\u6570\u548c\u63a5\u53e3\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"UserOperationUtils_4", (String)BOS_SEC_USER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Boolean checkWxConfigByToken(IFormView view) {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f01\u4e1a\u5fae\u4fe1\u53c2\u6570\u914d\u7f6e\u548c\u63a5\u53e3\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"UserOperationUtils_5", (String)BOS_SEC_USER, (Object[])new Object[0]);
        String corpid = "";
        String corpsecret = "";
        if (paramMap != null) {
            corpid = (String)paramMap.get("corpid");
            corpsecret = (String)paramMap.get("corpsecret");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)corpid) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)corpsecret)) {
            view.showErrorNotification(msg);
            return false;
        }
        String access_token = WxqyhServiceHelper.getAccess_token((String)corpid, (String)corpsecret);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)access_token)) {
            view.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static Boolean checkDdConfigByToken(IFormView view) {
        String accessToken = DingDingServiceHelper.getAccess_token();
        if (kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            UserOperationUtils.showConfigErrorMsg(view);
            return false;
        }
        return true;
    }

    private static boolean checkTicketResp(TicketResp ticketResp) {
        if (Objects.isNull(ticketResp)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)ticketResp.getAccess_token());
    }

    @Deprecated
    public static boolean synWeLink() {
        TicketResp ticketResp = WeLinkServiceHelper.getAccessToken();
        if (Objects.isNull(ticketResp)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)ticketResp.getAccess_token())) {
            return false;
        }
        Integer pageSubDeptNo = 0;
        Integer limit = 100;
        String subDeptCode = "";
        Map subDeptMap = new HashMap();
        String deptCode = "";
        Integer totalCount = 0;
        Integer totalPage = 0;
        do {
            List departmentInfoList;
            Integer n = pageSubDeptNo;
            pageSubDeptNo = pageSubDeptNo + 1;
            Integer n2 = pageSubDeptNo;
            subDeptMap = WeLinkServiceHelper.getSubDeptMap((String)ticketResp.getAccess_token(), (String)"0", (Integer)0, (Integer)pageSubDeptNo, (Integer)limit);
            if (Objects.isNull(subDeptMap) || subDeptMap.isEmpty() || !StringUtils.equals((CharSequence)(subDeptCode = (String)subDeptMap.get("code")), (CharSequence)"0") || (departmentInfoList = (List)subDeptMap.get("departmentInfo")).isEmpty()) break;
            for (Map departmentMap : departmentInfoList) {
                deptCode = (String)departmentMap.get("deptCode");
                if (StringUtils.isBlank((CharSequence)deptCode)) continue;
                UserOperationUtils.handleSingleDeptUser(ticketResp.getAccess_token(), deptCode);
                UserOperationUtils.handleUnderFirstLevelDept(ticketResp.getAccess_token(), deptCode);
            }
            totalCount = (Integer)subDeptMap.get("totalCount");
            limit = (Integer)subDeptMap.get("limit");
        } while (!Objects.equals(pageSubDeptNo, totalPage = Integer.valueOf((totalCount + limit - 1) / limit)));
        UserOperationUtils.handleSingleDeptUser(ticketResp.getAccess_token(), "0");
        return true;
    }

    private static boolean handleUnderFirstLevelDept(String accessToken, String firstDeptCode) {
        Integer pageSubDeptNo = 0;
        String subDeptCode = "";
        String deptCode = "";
        Integer totalCount = 0;
        Integer limit = 100;
        Integer totalPage = 0;
        do {
            List departmentInfoList;
            Integer n = pageSubDeptNo;
            pageSubDeptNo = pageSubDeptNo + 1;
            Integer n2 = pageSubDeptNo;
            Map subDeptMap = WeLinkServiceHelper.getSubDeptMap((String)accessToken, (String)firstDeptCode, (Integer)1, (Integer)pageSubDeptNo, (Integer)limit);
            if (Objects.isNull(subDeptMap) || subDeptMap.isEmpty() || !StringUtils.equals((CharSequence)(subDeptCode = (String)subDeptMap.get("code")), (CharSequence)"0") || (departmentInfoList = (List)subDeptMap.get("departmentInfo")) == null || departmentInfoList.isEmpty()) break;
            for (Map departmentMap : departmentInfoList) {
                deptCode = (String)departmentMap.get("deptCode");
                if (StringUtils.isBlank((CharSequence)deptCode)) continue;
                UserOperationUtils.handleSingleDeptUser(accessToken, deptCode);
            }
            totalCount = (Integer)subDeptMap.get("totalCount");
            limit = (Integer)subDeptMap.get("limit");
        } while (!Objects.equals(pageSubDeptNo, totalPage = Integer.valueOf((totalCount + limit - 1) / limit)));
        return true;
    }

    private static boolean handleSingleDeptUser(String acceToken, String deptCode) {
        boolean synFlag = false;
        Integer pageUserNo = 0;
        Map deptUserMap = null;
        String code = "";
        String weLinkUserId = "";
        String mobileNumberOrg = "";
        String mobileNumber = "";
        ArrayList<String> weLinkPhones = new ArrayList<String>();
        HashMap<String, String> weLinkPhoneOpenIdMap = new HashMap<String, String>();
        ArrayList<String> ids = new ArrayList<String>();
        Integer pages = 0;
        Integer pageNo = 0;
        do {
            List data;
            Integer n = pageUserNo;
            pageUserNo = pageUserNo + 1;
            Integer n2 = pageUserNo;
            deptUserMap = WeLinkServiceHelper.getDeptUserList((String)acceToken, (String)deptCode, (Integer)pageUserNo, (Integer)50);
            if (Objects.isNull(deptUserMap) || deptUserMap.isEmpty()) break;
            logger.info(String.format("welink:getDeptUserList:access_tokenSize%d,pageNo:%s", deptUserMap.size(), pageUserNo));
            pages = UserOperationUtils.getIntegerValue(deptUserMap.get("pages"));
            pageNo = UserOperationUtils.getIntegerValue(deptUserMap.get("pageNo"));
            code = (String)deptUserMap.get("code");
            if (!StringUtils.equals((CharSequence)code, (CharSequence)"0") || Objects.equals(pages, 0) || (data = (List)deptUserMap.get("data")) == null || data.isEmpty()) break;
            for (Map mapUser : data) {
                weLinkUserId = (String)mapUser.get("userId");
                if (StringUtils.isBlank((CharSequence)weLinkUserId) || StringUtils.isBlank((CharSequence)(mobileNumberOrg = (String)mapUser.get("mobileNumber")))) continue;
                mobileNumber = WeLinkServiceHelper.getMobile((String)mobileNumberOrg);
                weLinkPhones.add(mobileNumber);
                weLinkPhoneOpenIdMap.put(mobileNumber, weLinkUserId);
            }
            Map bosUserIdPhoneMap = WeLinkServiceHelper.getWeLinkInBosUserIds(weLinkPhones);
            logger.info(String.format("synWeLink:getWeLinkInBosUserIds:weLinkPhonesSize:%d,bosUserIdPhoneMapSize:%d", weLinkPhones.size(), bosUserIdPhoneMap.size()));
            for (Map.Entry entry : bosUserIdPhoneMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                ids.add(mapKey);
            }
            synFlag = WeLinkServiceHelper.saveImMapping(weLinkPhoneOpenIdMap, ids, (Map)bosUserIdPhoneMap);
        } while (!Objects.equals(pageNo, pages));
        return synFlag;
    }

    private static Integer getIntegerValue(Object objectInteger) {
        Integer returnString = 0;
        if (StringUtils.isBlank((Object)objectInteger)) {
            return returnString;
        }
        returnString = objectInteger instanceof Integer ? (Integer)objectInteger : Integer.valueOf(String.valueOf(objectInteger));
        return returnString;
    }

    public static boolean chatYZJ(IFormView view, List<Long> userIds) {
        String selectFields = "id,useropenid,enable";
        QFilter filter = new QFilter("id", "in", userIds);
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filter.toArray());
        if (Utils.isListEmpty((List)userCol)) {
            view.showTipNotification(BaseMessage.getMessage((String)"M00062"));
            return false;
        }
        HashSet<String> openIdSet = new HashSet<String>(userCol.size());
        for (DynamicObject userObj : userCol) {
            if (!userObj.getBoolean("enable")) {
                view.showTipNotification(UserMessage.getMessage((String)"M00065"));
                return false;
            }
            String openId = userObj.getString("useropenid");
            if (!StringUtils.isNotBlank((CharSequence)openId)) continue;
            openIdSet.add(openId);
        }
        String openId = String.join((CharSequence)",", openIdSet);
        if (StringUtils.isBlank((CharSequence)openId)) {
            view.showConfirm(UserMessage.getMessage((String)"M00064"), MessageBoxOptions.OK);
            return false;
        }
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(view);
        HashMap<String, String> mData = new HashMap<String, String>(3);
        mData.put("openId", openId);
        mData.put("userName", "");
        mData.put("chattype", "chat_pc");
        yzj.yzjInterface("createAndChat", mData);
        return true;
    }

    public static List<Long> getAdminChargeOrgs(ListShowParameter listShowParameter, IPageCache pageCache) {
        boolean isUserF7 = listShowParameter.isLookUp();
        if (!isUserF7) {
            listShowParameter.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
        String cacheAdminChargeOrgs = null;
        if (pageCache != null) {
            cacheAdminChargeOrgs = pageCache.get(CACHE_ADMIN_CHARGE_ORG);
        }
        List orgList = null;
        if (cacheAdminChargeOrgs == null) {
            orgList = OrgBillListCommon.getPermOrgs(null, (String)"01", (Map)listShowParameter.getCustomParams(), (boolean)isUserF7);
            if (pageCache != null) {
                if (orgList == null) {
                    pageCache.put(CACHE_ADMIN_CHARGE_ORG, "");
                } else {
                    pageCache.put(CACHE_ADMIN_CHARGE_ORG, SerializationUtils.toJsonString((Object)orgList));
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)cacheAdminChargeOrgs)) {
            orgList = (List)SerializationUtils.fromJsonString((String)cacheAdminChargeOrgs, List.class);
        }
        return orgList;
    }

    @Deprecated
    public static QFilter getUserTypeFilter(String userTypeId) {
        return UserUtils.getUserTypeLikeFilter((String)userTypeId);
    }

    public static Set<String> getExternalUserTypeSet(String externalUserType) {
        String[] usertypeArr = externalUserType.split(",");
        HashSet<String> usertyepSet = new HashSet<String>();
        for (String usertype : usertypeArr) {
            if (!StringUtils.isNotBlank((CharSequence)usertype)) continue;
            usertyepSet.add(usertype.trim());
        }
        usertyepSet.remove("1");
        usertyepSet.remove("6");
        return usertyepSet;
    }

    public static List<Long> getUserTypeIds(String userTypeStr) {
        String[] usertypeArr = userTypeStr.split(",");
        ArrayList<Long> userTypeList = new ArrayList<Long>(usertypeArr.length);
        for (String usertype : usertypeArr) {
            if (!StringUtils.isNotBlank((CharSequence)usertype)) continue;
            userTypeList.add(Long.valueOf(usertype.trim()));
        }
        return userTypeList;
    }

    private static String getStringValue(Object StringObj) {
        String returnString = null;
        if (StringObj instanceof String) {
            returnString = (String)StringObj;
        } else if (StringObj != null) {
            returnString = String.valueOf(StringObj);
        }
        return returnString;
    }

    public static boolean isInsider(DynamicObject userObj) {
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return true;
        }
        for (DynamicObject userTypeEditObj : userTypesCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (!"1".equals(userTypeObj.getString("category"))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasViewPermissionOfBizPartner(IPageCache pageCache) {
        boolean isShowOtherTypeNode;
        if (pageCache == null) {
            isShowOtherTypeNode = PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)"", (String)"bos_bizpartneruser");
        } else {
            String isShowOtherTypeNodeCache = pageCache.get(IS_SHOW_OTHER_TYPE_NODE);
            if (StringUtils.isBlank((CharSequence)isShowOtherTypeNodeCache)) {
                isShowOtherTypeNode = PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)"", (String)"bos_bizpartneruser");
                pageCache.put(IS_SHOW_OTHER_TYPE_NODE, Boolean.toString(isShowOtherTypeNode));
            } else {
                isShowOtherTypeNode = Boolean.parseBoolean(isShowOtherTypeNodeCache);
            }
        }
        return isShowOtherTypeNode;
    }

    public static Date getDateStartTime(Date date, int addDays) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, addDays);
        return c.getTime();
    }

    public static boolean isPropertyChanged(DynamicObject object, String field) {
        if (ObjectUtils.isEmpty((Object)object) || StringUtils.isBlank((CharSequence)field)) {
            return false;
        }
        DataEntityState dataEntityState = object.getDataEntityState();
        if (!dataEntityState.getFromDatabase()) {
            return false;
        }
        Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
        if (bizChangedProperties == null) {
            return false;
        }
        Iterator changedProps = bizChangedProperties.iterator();
        boolean isPropertyChanged = false;
        while (changedProps.hasNext()) {
            if (!field.equals(((IDataEntityProperty)changedProps.next()).getName())) continue;
            isPropertyChanged = true;
            break;
        }
        return isPropertyChanged;
    }

    private static void writeLog(String bizAppId, String entityId, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(entityId);
        appLogInfo.setOpName(opKey, opNameBridge);
        if (opDescBridge != null) {
            appLogInfo.setOpDesc(opDescBridge, new String[0]);
        }
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    public static Date getMaxDate(Date ... dates) {
        long[] values = new long[dates.length];
        int index = 0;
        for (Date date : dates) {
            values[index++] = date == null ? 0L : date.getTime();
        }
        long max = 0L;
        for (long value : values) {
            if (value <= max) continue;
            max = value;
        }
        return new Date(max);
    }

    public static QFilter convertRule2Filter(String entityNumber, String rule) {
        if (StringUtils.isBlank((CharSequence)rule)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }
}

