/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.preOpenPermFormCheck;
import kd.bos.permission.formplugin.util.AdminSchemeAssignedTreeView;
import kd.bos.permission.formplugin.util.AdminSchemePermTreeView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class AdminSchemeEditPlugin
extends AbstractFormPlugin
implements preOpenPermFormCheck {
    private static final String PREFIX_APP = "app#";
    private static final String PREFIX_ENTITY = "entity#";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private Map<String, String> nameMap = null;
    private Map<String, String> nodeMap = null;
    private Set<String> entityIdSet = null;
    private TreeView sysFuncPermTree = null;
    private TreeView assignedTree = null;
    private AdminSchemePermTreeView adminSchemePermTreeView = null;
    private AdminSchemeAssignedTreeView adminSchemeAssignedTreeView = null;
    public static final String PGCACHE_PREVIOUSADMINTYPE = "pgCache_previousAdminType";
    private static final String PAGECACHE_TREENODE_ASSIGNED = "pagecache_treenode_assigned";
    private static Log logger = LogFactory.getLog(AdminSchemeEditPlugin.class);

    public void initialize() {
        super.initialize();
        this.initialVariable();
        this.addListener();
    }

    private void addListener() {
        final EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        eg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int[] selectRows = eg.getSelectRows();
                if (selectRows != null && selectRows.length == 1) {
                    if (selectRows[0] == -1) {
                        AdminSchemeEditPlugin.this.assignedTree.deleteAllNodes();
                        return;
                    }
                    DynamicObject adminType = (DynamicObject)AdminSchemeEditPlugin.this.getModel().getValue("admintype", selectRows[0]);
                    Long adminTypeId = null;
                    if (adminType != null) {
                        adminTypeId = adminType.getLong("id");
                    }
                    AdminSchemeEditPlugin.this.adminSchemeAssignedTreeView = new AdminSchemeAssignedTreeView(AdminSchemeEditPlugin.this.assignedTree, adminTypeId);
                    String cache_PreviousAdminType = AdminSchemeEditPlugin.this.getPageCache().get(AdminSchemeEditPlugin.PGCACHE_PREVIOUSADMINTYPE);
                    if (StringUtils.isEmpty((String)cache_PreviousAdminType) || !Long.valueOf(cache_PreviousAdminType).equals(adminTypeId)) {
                        AdminSchemeEditPlugin.this.adminSchemeAssignedTreeView.refreshTreeView();
                    }
                    AdminSchemeEditPlugin.this.refreshSysFuncPermTree();
                    AdminSchemeEditPlugin.this.refreshAssignedPermTree(adminTypeId);
                    if (adminTypeId != null && adminTypeId != 0L) {
                        AdminSchemeEditPlugin.this.getPageCache().put(AdminSchemeEditPlugin.PGCACHE_PREVIOUSADMINTYPE, String.valueOf(adminTypeId));
                    }
                }
                AdminSchemeEditPlugin.this.sysFuncPermTree.uncheckNode("root#FIRST");
                AdminSchemeEditPlugin.this.assignedTree.uncheckNode("root#FIRST");
            }
        });
    }

    private void initialVariable() {
        this.sysFuncPermTree = (TreeView)this.getControl("sysfuncpermtree");
        this.assignedTree = (TreeView)this.getControl("funcpermtree");
        this.adminSchemePermTreeView = new AdminSchemePermTreeView(this.sysFuncPermTree);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        if (entryCount > 0) {
            eg.selectRows(0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            Long adminSchemeId = (Long)this.getView().getFormShowParameter().getCustomParams().get("id");
            this.getModel().setValue("adminschemeid", (Object)adminSchemeId);
            this.loadAdminScheme(adminSchemeId);
        } else {
            ArrayList adminTypes = new ArrayList(10);
            this.getPageCache().put("adminTypes", SerializationUtils.toJsonString(adminTypes));
        }
        this.refreshSysFuncPermTree();
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        if (entryCount > 0) {
            eg.entryRowClick(Integer.valueOf(0));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarmain", "advcontoolbar"});
        this.addClickListeners(new String[]{"addnode", "delnode"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String itemKey = source.getKey();
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = eg.getSelectRows();
        Long curAdminTypeId = null;
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u865a\u62df\u7ba1\u7406\u5458\u3002", (String)"AdminSchemeEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> adminTypeIds = new ArrayList<Long>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            Long adminTypeId = ((DynamicObject)this.getModel().getValue("admintype", selectRows[i])).getLong("id");
            if (i == 0) {
                curAdminTypeId = adminTypeId;
            }
            adminTypeIds.add(adminTypeId);
        }
        this.adminSchemeAssignedTreeView = new AdminSchemeAssignedTreeView(this.assignedTree, curAdminTypeId);
        if ("addnode".equals(itemKey)) {
            List selectedNodes = this.sysFuncPermTree.getTreeState().getSelectedNodes();
            this.adminSchemeAssignedTreeView.addNode(adminTypeIds, selectedNodes);
        }
        if ("delnode".equals(itemKey)) {
            List selectedNodes = this.assignedTree.getTreeState().getSelectedNodes();
            Iterator iterator = selectedNodes.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!map.get("id").equals("root#FIRST")) continue;
                iterator.remove();
            }
            this.adminSchemeAssignedTreeView.removeNode(adminTypeIds, selectedNodes);
        }
        this.adminSchemePermTreeView.uncheckNode("root#FIRST");
        this.adminSchemeAssignedTreeView.uncheckNode("root#FIRST");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "advconbaritemadd": {
                this.mulAdminTypeF7Click();
                break;
            }
            case "baritem_save": {
                this.save();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "deleteentry".equals(operateKey = ((FormOperate)args.getSource()).getOperateKey())) {
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = eg.getEntryState().getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                for (int i = 0; i < selectedRows.length; ++i) {
                    Long adminTypeId = ((DynamicObject)this.getModel().getValue("admintype", selectedRows[i])).getLong("id");
                    this.getPageCache().remove(adminTypeId.toString());
                    this.getPageCache().remove("pagecache_treenode_assigned_" + adminTypeId);
                }
            }
            this.getPageCache().remove(PGCACHE_PREVIOUSADMINTYPE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        EntryGrid eg;
        int[] selectedRows;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteentry".equals(operateKey) && (selectedRows = (eg = (EntryGrid)this.getControl("entryentity")).getEntryState().getSelectedRows()) != null && selectedRows.length > 0) {
            eg.entryRowClick(Integer.valueOf(selectedRows[0]));
        }
    }

    private void save() {
        this.nameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("nameMap"), Map.class);
        this.nodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("nodeMap"), Map.class);
        this.entityIdSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("entityIdSet"), Set.class);
        if (!this.saveValidator()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DynamicObject adminScheme = BusinessDataServiceHelper.newDynamicObject((String)"perm_adminscheme");
                String admischemeId = this.getModel().getValue("adminschemeid").toString();
                if (StringUtils.isNotEmpty((String)admischemeId)) {
                    DynamicObject oldAdminScheme = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("adminschemeid"), (DynamicObjectType)adminScheme.getDynamicObjectType());
                    adminScheme.set("id", oldAdminScheme.getPkValue());
                    adminScheme.set("creator", oldAdminScheme.get("creator"));
                    adminScheme.set("createtime", oldAdminScheme.get("createtime"));
                    adminScheme.set("status", oldAdminScheme.get("status"));
                    adminScheme.set("enable", oldAdminScheme.get("enable"));
                    adminScheme.set("ispreset", oldAdminScheme.get("ispreset"));
                    DeleteServiceHelper.delete((IDataEntityType)adminScheme.getDataEntityType(), (Object[])new Object[]{this.getModel().getValue("adminschemeid")});
                } else {
                    adminScheme.set("status", (Object)"C");
                    adminScheme.set("enable", (Object)"0");
                    adminScheme.set("creator", (Object)RequestContext.get().getUserId());
                    adminScheme.set("createtime", (Object)TimeServiceHelper.now());
                }
                adminScheme.set("number", this.getModel().getValue("number"));
                adminScheme.set("name", this.getModel().getValue("name"));
                adminScheme.set("description", this.getModel().getValue("description"));
                adminScheme.set("isallowbizoperate", this.getModel().getValue("isallowbizoperate"));
                boolean schemeEnable = adminScheme.getBoolean("enable");
                Long adminSchemeId = adminScheme.getLong("id");
                List originAdminTypes = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("adminTypes"), Long.class);
                ArrayList<Long> newAdminTypes = new ArrayList<Long>(10);
                boolean needInitScheme = false;
                DynamicObjectCollection entryCol = adminScheme.getDynamicObjectCollection("entryentity");
                DynamicObjectType entryType = entryCol.getDynamicObjectType();
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                if (rowCount > 0) {
                    for (int i = 0; i < rowCount; ++i) {
                        String appId;
                        DynamicObject newRow = new DynamicObject(entryType);
                        Long adminTypeId = ((DynamicObject)this.getModel().getValue("admintype", i)).getLong("id");
                        newRow.set("admintype", this.getModel().getValue("admintype", i));
                        entryCol.add((Object)newRow);
                        newAdminTypes.add(adminTypeId);
                        boolean notNewAdminType = originAdminTypes.remove(adminTypeId);
                        if (!notNewAdminType && schemeEnable) {
                            needInitScheme = true;
                        }
                        DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("level", ">", (Object)1L).and("adminscheme", "=", (Object)((Long)adminScheme.getPkValue())).and("admintype", "=", (Object)adminSchemeId)});
                        ArrayList<Long> adminGroupIds = new ArrayList<Long>(10);
                        if (adminGroups != null && adminGroups.length > 0) {
                            for (DynamicObject adminGroup : adminGroups) {
                                adminGroupIds.add(adminGroup.getLong("id"));
                            }
                        }
                        DynamicObjectCollection subEntryCol = newRow.getDynamicObjectCollection("subentryentity");
                        DynamicObjectType subEntryType = subEntryCol.getDynamicObjectType();
                        String jsonStr = this.getPageCache().get(adminTypeId.toString());
                        if (StringUtils.isEmpty((String)jsonStr)) {
                            DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])new QFilter[]{new QFilter("perm_admingroup", "in", adminGroupIds)});
                            continue;
                        }
                        Set entityIds = (Set)SerializationUtils.fromJsonString((String)jsonStr, Set.class);
                        if (entityIds == null || entityIds.isEmpty()) {
                            DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])new QFilter[]{new QFilter("perm_admingroup", "in", adminGroupIds)});
                            continue;
                        }
                        String originSysRangeStr = this.getPageCache().get(adminTypeId + "_origin");
                        HashSet originSysRange = StringUtils.isNotEmpty((String)originSysRangeStr) ? (HashSet)SerializationUtils.fromJsonString((String)originSysRangeStr, Set.class) : new HashSet(16);
                        for (String entityId : entityIds) {
                            DynamicObject subEntryRow = new DynamicObject(subEntryType);
                            String appLongId = this.nodeMap.get(entityId);
                            if (StringUtils.isEmpty((String)appLongId)) continue;
                            originSysRange.remove(entityId);
                            appId = appLongId.substring(PREFIX_APP.length());
                            subEntryRow.set("bizapp", (Object)appId);
                            subEntryRow.set("entity", (Object)entityId.substring(PREFIX_ENTITY.length(), entityId.indexOf(64)));
                            subEntryCol.add((Object)subEntryRow);
                        }
                        if (CollectionUtils.isEmpty(originSysRange)) continue;
                        HashSet<String> appFilter = new HashSet<String>(16);
                        HashSet<String> entityFilter = new HashSet<String>(16);
                        for (String entity : originSysRange) {
                            appId = entity.substring(entity.indexOf(64) + 1);
                            appFilter.add(appId);
                            String entityId = entity.substring(PREFIX_ENTITY.length(), entity.indexOf(64));
                            entityFilter.add(entityId);
                        }
                        DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", adminGroupIds).and("app", "in", appFilter).and("entitynum", "in", entityFilter)});
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)originAdminTypes)) {
                    ArrayList<Long> deleteAdminGroupIds = new ArrayList<Long>(10);
                    DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("adminscheme", "=", (Object)adminSchemeId).and("admintype", "in", (Object)originAdminTypes)});
                    if (adminGroups != null && adminGroups.length > 0) {
                        for (DynamicObject adminGroup : adminGroups) {
                            deleteAdminGroupIds.add(adminGroup.getLong("id"));
                        }
                        DeleteServiceHelper.delete((String)"perm_useradmingroup", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingroupbizunit", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingrouporg", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingroupapp", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingroupadduser", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", deleteAdminGroupIds)});
                        DeleteServiceHelper.delete((String)"perm_admingroup", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteAdminGroupIds)});
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adminScheme});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminSchemeEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getModel().setValue("adminschemeid", adminScheme.getPkValue());
                this.getPageCache().put("adminTypes", SerializationUtils.toJsonString(newAdminTypes));
                if (needInitScheme) {
                    AdminSchemeHelper.initTopAdminGroup((Long)((Long)adminScheme.getPkValue()));
                }
                this.clearAllAdminCache();
            }
            catch (Exception e) {
                h.markRollback();
                logger.warn("\u4fdd\u5b58\u7ba1\u7406\u5458\u65b9\u6848\u5931\u8d25\uff0c\u6570\u636e\u5df2\u56de\u6eda\u3002", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6570\u636e\u5df2\u56de\u6eda\u3002", (String)"AdminSchemeEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private boolean saveValidator() {
        CharSequence mes;
        QFilter pkIdFilter;
        QFilter preSetFilter;
        boolean exist;
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"AdminSchemeEditPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        Object name = this.getModel().getValue("name");
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"AdminSchemeEditPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String adminSchemeId = (String)this.getModel().getValue("adminschemeid");
        if (!this.checkAdminSchemeInfoIfValid(adminSchemeId, "number", number, ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65b9\u6848\u7f16\u7801\u91cd\u590d\u3002", (String)"AdminSchemeEditPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]))) {
            return false;
        }
        if (!this.checkAdminSchemeInfoIfValid(adminSchemeId, "name", name.toString(), ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65b9\u6848\u540d\u79f0\u91cd\u590d\u3002", (String)"AdminSchemeEditPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]))) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)adminSchemeId) && (exist = QueryServiceHelper.exists((String)"perm_adminscheme", (QFilter[])new QFilter[]{preSetFilter = new QFilter("ispreset", "=", (Object)"1"), pkIdFilter = new QFilter("id", "=", (Object)Long.valueOf(adminSchemeId))}))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u7684\u7ba1\u7406\u5458\u65b9\u6848\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AdminSchemeEditPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        HashSet<Object> entityNumSet = new HashSet<Object>();
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                Object jsonStr;
                Long adminTypeId = ((DynamicObject)this.getModel().getValue("admintype", i)).getLong("id");
                DynamicObject adminTypeObj = (DynamicObject)this.getModel().getValue("admintype", i);
                String adminName = "";
                if (adminTypeObj != null) {
                    adminName = adminTypeObj.getLocaleString("name").getLocaleValue();
                }
                if (StringUtils.isEmpty((String)(jsonStr = this.getPageCache().get(adminTypeId.toString())))) {
                    mes = new StringBuilder(ResManager.loadKDString((String)"\u7b2c", (String)"AdminSchemeEditPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c\u7684", (String)"AdminSchemeEditPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u201c").append(adminName).append("\u201d").append(ResManager.loadKDString((String)" \u672a\u5206\u914d\u6743\u9650\u3002", (String)"AdminSchemeEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    this.getView().showErrorNotification(((StringBuilder)mes).toString());
                    return false;
                }
                Set entityIds = (Set)SerializationUtils.fromJsonString((String)jsonStr, Set.class);
                if (entityIds == null || entityIds.isEmpty()) {
                    StringBuilder mes2 = new StringBuilder(ResManager.loadKDString((String)"\u7b2c", (String)"AdminSchemeEditPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c\u7684", (String)"AdminSchemeEditPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u201c").append(adminName).append("\u201d").append(ResManager.loadKDString((String)" \u672a\u5206\u914d\u6743\u9650\u3002", (String)"AdminSchemeEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    this.getView().showErrorNotification(mes2.toString());
                    return false;
                }
                for (String entityId : entityIds) {
                    String entityNum = entityId.substring(PREFIX_ENTITY.length(), entityId.indexOf(64));
                    entityNumSet.add(entityNum);
                }
            }
        }
        if (this.entityIdSet.size() > entityNumSet.size()) {
            int diffEntityCount = this.entityIdSet.size() - entityNumSet.size();
            HashSet<String> allNeedAssignEntitySets = new HashSet<String>(this.entityIdSet);
            allNeedAssignEntitySets.removeAll(entityNumSet);
            StringBuilder sbNeedAssignEntityNum = new StringBuilder();
            int i = 0;
            for (String entityNum : allNeedAssignEntitySets) {
                if (i >= 3) break;
                if (i > 0) {
                    sbNeedAssignEntityNum.append(", ");
                }
                if (StringUtils.isEmpty((String)entityNum)) continue;
                String entityName = "";
                try {
                    entityName = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    continue;
                }
                String nameMapKey = null;
                for (Map.Entry entry : this.nodeMap.entrySet()) {
                    if (((String)entry.getKey()).indexOf(entityNum) == -1) continue;
                    nameMapKey = (String)entry.getValue();
                }
                String appName = this.nameMap.get(nameMapKey);
                sbNeedAssignEntityNum.append(appName).append('-').append(entityName);
                ++i;
            }
            String needAssignEntityNums = sbNeedAssignEntityNum.toString();
            mes = "\u3002";
            if (i > 3) {
                mes = "...";
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5c1a\u672a\u5206\u914d\u7684%1$s\u4e2a\u5b9e\u4f53\u6743\u9650\uff1a%2$s", (String)"AdminSchemeEditPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), diffEntityCount, needAssignEntityNums + (String)mes), Integer.valueOf(7000));
            return false;
        }
        return true;
    }

    private boolean checkAdminSchemeInfoIfValid(String adminSchemeId, String fieldKey, String info, String errNotification) {
        QFilter qfField = new QFilter(fieldKey, "=", (Object)info);
        if (StringUtils.isEmpty((String)adminSchemeId)) {
            boolean exist = QueryServiceHelper.exists((String)"perm_adminscheme", (QFilter[])new QFilter[]{qfField});
            if (exist) {
                this.getView().showErrorNotification(errNotification);
                return false;
            }
        } else {
            QFilter qfId = new QFilter("id", "=", (Object)Long.valueOf(adminSchemeId));
            boolean exist = QueryServiceHelper.exists((String)"perm_adminscheme", (QFilter[])new QFilter[]{qfId, qfField});
            if (!exist && !this.checkAdminSchemeInfoIfValid(null, fieldKey, info, errNotification)) {
                return false;
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String propName = e.getProperty().getName();
        if ("muladmintypef7".equals(propName)) {
            if (!(newValue instanceof DynamicObjectCollection)) {
                return;
            }
            DynamicObjectCollection doc = (DynamicObjectCollection)newValue;
            if (doc.isEmpty()) {
                return;
            }
            ArrayList<Long> adminTypeIds = new ArrayList<Long>(doc.size());
            for (int index = 0; index < doc.size(); ++index) {
                DynamicObject curObj = (DynamicObject)doc.get(index);
                adminTypeIds.add(curObj.getLong("fbasedataid_id"));
            }
            this.fillAdminTypeList(adminTypeIds);
            this.getPageCache().remove(PGCACHE_PREVIOUSADMINTYPE);
        } else if ("isallowbizoperate".equals(propName)) {
            if (!(newValue instanceof Boolean)) {
                return;
            }
            String adminSchemeID = (String)this.getModel().getValue("adminschemeid");
            if (StringUtils.isEmpty((String)adminSchemeID)) {
                return;
            }
            DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(adminSchemeID), (String)"perm_adminscheme");
            if (adminScheme == null) {
                logger.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u65b9\u6848\u5931\u8d25\uff0c\u65b9\u6848ID\uff1a " + adminSchemeID);
                return;
            }
            Boolean isAllowBizOperate = (Boolean)newValue;
            adminScheme.set("isallowbizoperate", (Object)isAllowBizOperate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adminScheme});
            PermissionServiceHelper.clearAllCache();
        } else if ("shownum".equals(propName)) {
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = eg.getEntryState().getSelectedRows();
            if (null == selectedRows || selectedRows.length == 0 || selectedRows[0] == -1) {
                if (StringUtils.isEmpty((String)this.getPageCache().get("first"))) {
                    this.getPageCache().put("first", "no");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u865a\u62df\u7ba1\u7406\u5458\u3002", (String)"AdminSchemeEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.getModel().setValue("shownum", (Object)false);
                return;
            }
            this.getPageCache().put("isShowNum", String.valueOf(newValue));
            this.getPageCache().remove("pgcache_treenode_all_adminscheme");
            this.refreshSysFuncPermTree();
            DynamicObject adminType = (DynamicObject)this.getModel().getValue("admintype", selectedRows[0]);
            Long adminTypeId = null;
            if (adminType != null) {
                adminTypeId = adminType.getLong("id");
            }
            this.adminSchemeAssignedTreeView = new AdminSchemeAssignedTreeView(this.assignedTree, adminTypeId);
            this.refreshAssignedPermTree(adminTypeId);
            this.getView().updateView("sysfuncpermtree");
            this.getView().updateView("funcpermtree");
        }
    }

    private void fillAdminTypeList(List<Long> adminTypeIds) {
        if (adminTypeIds == null || adminTypeIds.isEmpty()) {
            return;
        }
        HashSet<Long> tempSelUserIds = new HashSet<Long>(adminTypeIds);
        int newRowIndex = 0;
        for (Long id : tempSelUserIds) {
            newRowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("admintype", (Object)id, newRowIndex);
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.selectRows(newRowIndex, true);
        entry.entryRowClick(Integer.valueOf(newRowIndex));
    }

    private void mulAdminTypeF7Click() {
        MulBasedataEdit mulAdminTypeF7 = (MulBasedataEdit)this.getControl("muladmintypef7");
        this.getModel().beginInit();
        this.getModel().setValue("muladmintypef7", null);
        this.getModel().endInit();
        mulAdminTypeF7.addBeforeF7SelectListener(evt -> {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            ArrayList<Long> adminTypeList = new ArrayList<Long>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("admintype", i);
                if (dynamicObject == null) continue;
                Long adminTypeId = dynamicObject.getLong("id");
                String name = dynamicObject.getString("name");
                adminTypeList.add(adminTypeId);
            }
            ArrayList<QFilter> qList = new ArrayList<QFilter>();
            QFilter q1 = new QFilter("id", "not in", adminTypeList);
            qList.add(q1);
            ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
        });
        mulAdminTypeF7.click();
    }

    private void loadAdminScheme(Long adminSchemeId) {
        DynamicObjectCollection adminTypeEntry;
        DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)adminSchemeId, (String)"perm_adminscheme");
        this.getModel().setValue("number", adminScheme.get("number"));
        this.getModel().setValue("name", adminScheme.get("name"));
        this.getModel().setValue("description", adminScheme.get("description"));
        this.getModel().setValue("isallowbizoperate", adminScheme.get("isallowbizoperate"));
        boolean isPreset = adminScheme.getBoolean("ispreset");
        if (isPreset) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baritem_save", "addnode", "delnode"});
        }
        if ((adminTypeEntry = adminScheme.getDynamicObjectCollection("entryentity")) == null || adminTypeEntry.isEmpty()) {
            return;
        }
        ArrayList<Long> adminTypes = new ArrayList<Long>(10);
        for (DynamicObject entryRow : adminTypeEntry) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            DynamicObject adminType = entryRow.getDynamicObject("admintype");
            this.getModel().setValue("admintype", adminType.get("id"), newEntryRow);
            DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("subentryentity");
            if (subEntry == null || subEntry.isEmpty()) continue;
            HashSet<String> entityIds = new HashSet<String>();
            for (DynamicObject subEntryRow : subEntry) {
                if (subEntryRow.getDynamicObject("bizapp") == null || subEntryRow.getDynamicObject("bizapp").getPkValue() == null) continue;
                String appId = subEntryRow.getDynamicObject("bizapp").getPkValue().toString();
                DynamicObject entity = subEntryRow.getDynamicObject("entity");
                String entityId = null;
                if (entity == null) {
                    entityId = PREFIX_ENTITY + subEntryRow.getString("entity_id") + "@" + appId;
                    if (StringUtils.isEmpty((String)entityId)) {
                        continue;
                    }
                } else {
                    entityId = PREFIX_ENTITY + entity.getPkValue() + "@" + appId;
                }
                entityIds.add(entityId);
            }
            Long adminTypeId = adminType.getLong("id");
            this.getPageCache().put(adminTypeId.toString(), SerializationUtils.toJsonString(entityIds));
            this.getPageCache().put(adminTypeId + "_origin", SerializationUtils.toJsonString(entityIds));
            adminTypes.add(adminTypeId);
        }
        this.getPageCache().put("adminTypes", SerializationUtils.toJsonString(adminTypes));
        this.getView().updateView();
    }

    private void refreshSysFuncPermTree() {
        this.adminSchemePermTreeView.refreshTreeView();
    }

    private void refreshAssignedPermTree(Long adminSchemeId) {
        if (null == adminSchemeId) {
            return;
        }
        String jsonStr = this.getPageCache().get(adminSchemeId.toString());
        if (StringUtils.isEmpty((String)jsonStr)) {
            return;
        }
        this.nameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("nameMap"), Map.class);
        this.nodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("nodeMap"), Map.class);
        Set entityIds = (Set)SerializationUtils.fromJsonString((String)jsonStr, Set.class);
        if (entityIds == null || entityIds.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> assignedMap = new ArrayList<Map<String, Object>>(entityIds.size());
        for (String entityId : entityIds) {
            String text = this.nameMap.get(entityId);
            String parentid = this.nodeMap.get(entityId);
            if (text == null || parentid == null) continue;
            HashMap<String, String> nodeInfo = new HashMap<String, String>();
            nodeInfo.put("id", entityId);
            nodeInfo.put("parentid", parentid);
            nodeInfo.put("text", text);
            assignedMap.add(nodeInfo);
        }
        ArrayList<Long> adminTypeIds = new ArrayList<Long>();
        adminTypeIds.add(adminSchemeId);
        this.adminSchemeAssignedTreeView.addNode(adminTypeIds, assignedMap);
    }

    private void clearAllAdminCache() {
        PermissionServiceHelper.clearAllCache();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenPermForm(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermCommonUtil.isCosmicUser((Long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662fcosmic\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"AdminSchemeEditPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }
}

