/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class AdminSchemeListPlugin
extends AbstractListPlugin {
    private static final String PERM_ADMINSCHEME_EDIT = "perm_adminscheme_edit";
    public static final String BTN_NEW = "tblnew";
    public static final String BTN_ALLOWBIZOPERATE = "allowbizoperate";
    public static final String BTN_DONTALLOWBIZOPERATE = "dontallowbizoperate";
    public static final String CLOSECALLBACK_EDIT = "closeEditForm";
    private static final String ENABLE_CALLBACK = "enableCallBack";
    public static final String BILLLIST = "billlistap";
    private static final String OP_ENABLE = "enable";
    private static final String OP_DELETE = "delete";
    private static final String OP_DONOTHING_DELETE = "donothing_del";
    private static final String ENTITY_USERADMINTAGS = "perm_useradmintags";
    private static final String PROP_ADMINTAG = "admintag";
    private static final String PROP_USER = "user";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static Log logger = LogFactory.getLog(AdminSchemeListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult;
        super.preOpenForm(e);
        int modeType = LicenseServiceHelper.getModeType();
        float version = Float.parseFloat(LicenseServiceHelper.getProductVersion());
        if ((modeType == 2 || modeType == 4 || modeType == 3 && version >= 5.0f) && !(checkResult = LicenseServiceHelper.checkPerformGroup((String)"SOP")).getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            return;
        }
        String userId = RequestContext.get().getUserId();
        DynamicObject cosmicRel = BusinessDataServiceHelper.loadSingle((String)ENTITY_USERADMINTAGS, (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter(PROP_ADMINTAG, "=", (Object)"10")});
        if (cosmicRel == null) {
            return;
        }
        String cosmicUserId = cosmicRel.getString("user_id");
        if (!userId.equals(cosmicUserId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u975ecosmic\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u6b64\u529f\u80fd", (String)"AdminSchemeListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "tblnew": {
                this.showForm(PERM_ADMINSCHEME_EDIT, null, new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_EDIT), ShowType.MainNewTabPage, OperationStatus.ADDNEW);
                break;
            }
            case "allowbizoperate": {
                this.setAllowBizOperate(rows, true);
                break;
            }
            case "dontallowbizoperate": {
                this.setAllowBizOperate(rows, false);
                break;
            }
        }
    }

    private void setAllowBizOperate(ListSelectedRowCollection rows, boolean allowOrNot) {
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdminSchemeListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DynamicObject[] dynamicObjects = new DynamicObject[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            long adminSchemeID = (Long)rows.get(i).getPrimaryKeyValue();
            if (adminSchemeID == 0L) {
                return;
            }
            DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)adminSchemeID, (String)"perm_adminscheme");
            if (adminScheme == null) {
                logger.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u65b9\u6848\u5931\u8d25\uff0c\u65b9\u6848ID\uff1a " + adminSchemeID);
                return;
            }
            boolean oldValue = adminScheme.getBoolean("isallowbizoperate");
            if (oldValue == allowOrNot) {
                if (allowOrNot) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u201c\u5141\u8bb8\u4e1a\u52a1\u64cd\u4f5c\u201d\u72b6\u6001\u3002", (String)"AdminSchemeListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u201c\u7981\u6b62\u4e1a\u52a1\u64cd\u4f5c\u201d\u72b6\u6001\u3002", (String)"AdminSchemeListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                }
                return;
            }
            adminScheme.set("isallowbizoperate", (Object)allowOrNot);
            dynamicObjects[i] = adminScheme;
        }
        Object[] objects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        if (objects != null && objects.length != 0) {
            PermissionServiceHelper.clearAllCache();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"AdminSchemeListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"AdminSchemeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.isEmpty((String)operateKey)) {
            return;
        }
        if (OP_ENABLE.equals(operateKey)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            IFormView view = this.getView();
            if (selectedRows == null || selectedRows.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdminSchemeListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u201c\u6743\u9650\u63a7\u5236\u7b56\u7565\u201d\u3002", (String)"AdminSchemeListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long enableSchemeId = Long.valueOf(selectedRows.get(0).toString());
            DynamicObject forEnableAdminScheme = BusinessDataServiceHelper.loadSingle((Object)enableSchemeId, (String)"perm_adminscheme");
            if (forEnableAdminScheme.getBoolean(OP_ENABLE)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"AdminSchemeListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean allVirAdminBindedContact = AdminSchemeHelper.isAllVirAdminBindedContact((Long)enableSchemeId);
            if (!allVirAdminBindedContact) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u865a\u62df\u7ba1\u7406\u5458\u8d26\u6237\u5b89\u5168\uff0c\u8bf7\u5148\u5230\u201c\u865a\u62df\u7ba1\u7406\u5458\u7c7b\u578b\u201d\u9875\u9762\u7ef4\u62a4\u865a\u62df\u7ba1\u7406\u5458\u8054\u7cfb\u65b9\u5f0f\u3002", (String)"AdminSchemeListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            view.showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u542f\u7528\u5f53\u524d\u65b9\u6848\u5417\uff1f\u542f\u7528\u540e\u5c06\u7981\u7528\u539f\u65b9\u6848\u3002", (String)"AdminSchemeListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ENABLE_CALLBACK));
            args.setCancel(true);
        } else if (OP_DELETE.equals(operateKey) && (listSelectedData = args.getListSelectedData()) != null && listSelectedData.size() > 0) {
            for (ListSelectedRow listSelectedRow : listSelectedData) {
                Long pkId = (Long)listSelectedRow.getPrimaryKeyValue();
                DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"perm_adminscheme", (String)"ispreset");
                if (!loadSingle.getBoolean("ispreset")) continue;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u65b9\u6848\u4e2d\u5305\u542b\u9884\u7f6e\u65b9\u6848\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AdminSchemeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                args.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        String formId = billList.getView().getFormShowParameter().getFormId();
        if (formId.equals("bos_listf7")) {
            return;
        }
        args.setCancel(true);
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object focusRowPkId = billList.getFocusRowPkId();
        param.put("id", focusRowPkId);
        param.put("preOpenPageID", this.getView().getPageId() + focusRowPkId);
        this.showForm(PERM_ADMINSCHEME_EDIT, param, new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_EDIT), ShowType.MainNewTabPage, OperationStatus.EDIT);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equals(CLOSECALLBACK_EDIT)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (ENABLE_CALLBACK.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    BillList billList = (BillList)this.getControl(BILLLIST);
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    Long enableSchemeId = Long.valueOf(selectedRows.get(0).toString());
                    Long preSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
                    DynamicObject forEnableAdminScheme = BusinessDataServiceHelper.loadSingle((Object)enableSchemeId, (String)"perm_adminscheme");
                    ArrayList<Long> disableSchemeIds = new ArrayList<Long>();
                    DynamicObjectCollection forDisableObjs = QueryServiceHelper.query((String)"perm_adminscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter(OP_ENABLE, "=", (Object)"1")});
                    for (DynamicObject forDisableObj : forDisableObjs) {
                        disableSchemeIds.add(forDisableObj.getLong("id"));
                    }
                    String sql = "UPDATE t_perm_adminscheme SET FENABLE = '0' WHERE FENABLE = '1' ";
                    DB.execute((DBRoute)DBRoute.permission, (String)sql);
                    forEnableAdminScheme.set(OP_ENABLE, (Object)"1");
                    DynamicObjectCollection admins = forEnableAdminScheme.getDynamicObjectCollection("entryentity");
                    for (DynamicObject admin : admins) {
                        admin.getInt("admintype_id");
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{forEnableAdminScheme});
                    this.disableAndEnableVirtualAdmin(disableSchemeIds, enableSchemeId, preSchemeId);
                    StringBuilder initSchemeInfo = new StringBuilder();
                    try {
                        AdminSchemeHelper.initTopAdminGroup((Long)enableSchemeId);
                    }
                    catch (Exception ex) {
                        logger.warn("\u542f\u7528\u65b0\u7b56\u7565\u540e\u5347\u7ea7\u7ba1\u7406\u5458\u6570\u636e\u5f02\u5e38\uff1a" + initSchemeInfo + "----", (Throwable)ex);
                        throw ex;
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AdminSchemeListPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    PermissionServiceHelper.clearAllCache();
                }
                catch (Exception ex) {
                    logger.warn("\u542f\u7528\u5931\u8d25", (Throwable)ex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002", (String)"AdminSchemeListPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
            toolbar.itemClick("tblrefresh", "refresh");
        }
    }

    private void enableOrDisableUser(List<Long> forProcessUserIds, boolean isEnable) {
        String enableStr = isEnable ? "1" : "0";
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)OP_ENABLE, (QFilter[])new QFilter[]{new QFilter("id", "in", forProcessUserIds)});
        if (users != null && users.length > 0) {
            for (DynamicObject user : users) {
                user.set(OP_ENABLE, (Object)enableStr);
            }
            SaveServiceHelper.save((DynamicObject[])users);
        }
    }

    private boolean disableAndEnableVirtualAdmin(List<Long> disableAdminSchemeIds, Long enableAdminSchemeId, Long preSchemeId) {
        try {
            boolean hasEnableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
            DynamicObject[] forDisableAdminSchemes = BusinessDataServiceHelper.load((String)"perm_adminscheme", (String)"admintype", (QFilter[])new QFilter[]{new QFilter("id", "in", disableAdminSchemeIds)});
            ArrayList<Long> forDisableAdminTypeList = new ArrayList<Long>(10);
            for (DynamicObject adminScheme : forDisableAdminSchemes) {
                DynamicObjectCollection adminTypes = adminScheme.getDynamicObjectCollection("entryentity");
                for (DynamicObject adminTypeObj : adminTypes) {
                    long adminType = adminTypeObj.getLong("admintype_id");
                    forDisableAdminTypeList.add(adminType);
                }
            }
            DynamicObject[] forEnableAdminSchemes = BusinessDataServiceHelper.load((String)"perm_adminscheme", (String)"admintype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)enableAdminSchemeId)});
            ArrayList<Long> forEnableAdminTypeList = new ArrayList<Long>(10);
            for (DynamicObject adminScheme : forEnableAdminSchemes) {
                DynamicObjectCollection adminTypes = adminScheme.getDynamicObjectCollection("entryentity");
                for (DynamicObject adminTypeObj : adminTypes) {
                    Long adminType = adminTypeObj.getLong("admintype_id");
                    forEnableAdminTypeList.add(adminType);
                }
            }
            if (hasEnableOldAdmin) {
                Long userId;
                if (forDisableAdminTypeList.size() > 0) {
                    Object forDisableVirUser2;
                    DynamicObjectCollection forDisableVirtualUsers = QueryServiceHelper.query((String)"perm_admin", (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter("admintype", "in", forDisableAdminTypeList), new QFilter("type", "=", (Object)"10")});
                    ArrayList<Long> forClearCacheUserIds = new ArrayList<Long>();
                    ArrayList<Long> forDisableVirUserList = new ArrayList<Long>();
                    for (Object forDisableVirUser2 : forDisableVirtualUsers) {
                        Long userId2 = forDisableVirUser2.getLong(0);
                        forClearCacheUserIds.add(userId2);
                        forDisableVirUserList.add(userId2);
                    }
                    this.enableOrDisableUser(forDisableVirUserList, false);
                    Iterator forClearCacheRealUsers = QueryServiceHelper.query((String)"perm_admin", (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter("admintype", "in", forDisableAdminTypeList), new QFilter("type", "=", (Object)"20")});
                    forDisableVirUser2 = forClearCacheRealUsers.iterator();
                    while (forDisableVirUser2.hasNext()) {
                        DynamicObject forClearCacheRealUser = (DynamicObject)forDisableVirUser2.next();
                        userId = forClearCacheRealUser.getLong(0);
                        forClearCacheUserIds.add(userId);
                    }
                    UserAppCache.removeCache(forClearCacheUserIds);
                    UserMenuCache.removeUserMenuAllCache();
                }
                if (forEnableAdminTypeList.size() > 0) {
                    DynamicObjectCollection forEnableVirUsers = QueryServiceHelper.query((String)"perm_admin", (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter("admintype", "in", forEnableAdminTypeList), new QFilter("type", "=", (Object)"10")});
                    ArrayList<Long> forClearCacheUserIds = new ArrayList<Long>();
                    ArrayList<Long> forEnableUserList = new ArrayList<Long>();
                    for (DynamicObject forEnableVirUser : forEnableVirUsers) {
                        Long userId3 = forEnableVirUser.getLong(0);
                        forClearCacheUserIds.add(userId3);
                        forEnableUserList.add(userId3);
                    }
                    this.enableOrDisableUser(forEnableUserList, true);
                    DynamicObjectCollection forEnableRealUsers = QueryServiceHelper.query((String)"perm_admin", (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter("admintype", "in", forEnableAdminTypeList), new QFilter("type", "=", (Object)"20")});
                    for (DynamicObject forEnableRealUser : forEnableRealUsers) {
                        userId = forEnableRealUser.getLong(0);
                        forClearCacheUserIds.add(userId);
                    }
                    UserAppCache.removeCache(forClearCacheUserIds);
                    UserMenuCache.removeUserMenuAllCache();
                }
                AdminUserCache.removeAllCache();
            } else {
                Set disableAdminTypeSet = forDisableAdminTypeList.stream().map(x -> String.valueOf(x).trim()).collect(Collectors.toSet());
                AdminSchemeHelper.updateUserEnableStatus(disableAdminTypeSet, (String)"0", (Long)preSchemeId);
                Set enableAdminTypeSet = forEnableAdminTypeList.stream().map(x -> String.valueOf(x).trim()).collect(Collectors.toSet());
                AdminSchemeHelper.updateUserEnableStatus(enableAdminTypeSet, (String)"1", (Long)enableAdminSchemeId);
                CacheMrg.clearAllCache();
                CacheMrg.clearHasEnableOldAdmin();
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, OperationStatus opStatus) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            String preOpenPageID = (String)params.get("preOpenPageID");
            IFormView view = this.getView().getView(preOpenPageID);
            if (view != null) {
                PermCommonUtil.redirectToExistedPage((String)preOpenPageID, (IFormView)this.getView());
                return;
            }
            param.setPageId(preOpenPageID);
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        if (opStatus != null) {
            param.setStatus(opStatus);
        }
        this.getView().showForm(param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (OP_DONOTHING_DELETE.equals(opKey)) {
            boolean success = e.getOperationResult().isSuccess();
            if (success) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DynamicObject[] adminGroups;
                        List adminSchemeIds = e.getOperationResult().getSuccessPkIds();
                        if (!PermCommonUtil.hasEnableOldAdmin() && (adminGroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("adminscheme", "in", (Object)adminSchemeIds)})) != null && adminGroups.length > 0) {
                            ArrayList<Long> adminGroupIds = new ArrayList<Long>(10);
                            for (DynamicObject adminGroup : adminGroups) {
                                adminGroupIds.add(adminGroup.getLong("id"));
                            }
                            QFilter[] filters = new QFilter[]{new QFilter("usergroup", "in", adminGroupIds)};
                            DeleteServiceHelper.delete((String)"perm_useradmingroup", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingroupbizunit", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingrouporg", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingroupapp", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingroupadduser", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])filters);
                            DeleteServiceHelper.delete((String)"perm_admingroup", (QFilter[])new QFilter[]{new QFilter("id", "in", adminGroupIds)});
                            AdminUserCache.removeAllCache();
                        }
                        DeleteServiceHelper.delete((String)"perm_adminscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)adminSchemeIds)});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AdminSchemeListPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    catch (Exception ex) {
                        h.markRollback();
                        logger.warn("\u5220\u9664\u7ba1\u7406\u63a7\u5236\u7b56\u7565\u5931\u8d25", (Throwable)ex);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"AdminSchemeListPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                }
            }
            this.getView().updateView();
            BillList billList = (BillList)this.getView().getControl(BILLLIST);
            billList.clearSelection();
            billList.refresh();
            PermissionServiceHelper.clearAllCache();
        }
    }
}

