/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class AdminTypeListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(AdminTypeListPlugin.class);
    private static final String ENTITY_USERADMINTAGS = "perm_useradmintags";
    private static final String PROP_ADMINTAG = "admintag";
    private static final String PROP_USER = "user";

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        if (null == pageData || pageData.isEmpty()) {
            return;
        }
        Set collect = pageData.stream().map(x -> x.getString("id")).collect(Collectors.toSet());
        if (collect.isEmpty()) {
            return;
        }
        Map adminTypeUserNameMap = AdminSchemeHelper.getAdminTypeUserNameMap(collect);
        if (!adminTypeUserNameMap.isEmpty()) {
            for (DynamicObject dd : pageData) {
                dd.set("number", adminTypeUserNameMap.get(dd.getString("id")));
            }
        }
        this.getView().updateView("number");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List oriQFilters = e.getQFilters();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (null != oriQFilters && !oriQFilters.isEmpty()) {
            for (QFilter oriQFilter : oriQFilters) {
                String property = oriQFilter.getProperty();
                String cp = oriQFilter.getCP();
                Object value = oriQFilter.getValue();
                if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)cp) || null == value) {
                    qFilters.add(oriQFilter);
                    continue;
                }
                if (value instanceof List) {
                    qFilters.add(oriQFilter);
                    continue;
                }
                if (!(value instanceof String)) continue;
                String valueStr = (String)value;
                if (Objects.equals("1", property) && Objects.equals("ftlike", cp) && valueStr.startsWith("name,number#")) {
                    String[] split = valueStr.split("#", 2);
                    if (null == split || Objects.equals(0, valueStr.length())) {
                        qFilters.add(oriQFilter);
                        continue;
                    }
                    String vv = split[1];
                    if (StringUtils.isEmpty((String)vv)) {
                        qFilters.add(oriQFilter);
                        continue;
                    }
                    Set<Long> fidSet = AdminTypeListPlugin.searchByUserName(vv);
                    oriQFilter = new QFilter("id", "in", fidSet);
                    oriQFilter.or(new QFilter("1", "ftlike", (Object)("name#" + vv)));
                    qFilters.add(oriQFilter);
                    continue;
                }
                qFilters.add(oriQFilter);
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(qFilters);
    }

    private static Set<Long> searchByUserName(String vv) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid from t_perm_useradmintag a");
        sb.append(" inner join t_sec_user_u  b on a.fuserid = b.fid ");
        sb.append(" where b.fusername like '%").append(vv).append("%'");
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> fidSet = new HashSet<Long>(8);
                while (rs.next()) {
                    fidSet.add(rs.getLong("fid"));
                }
                return fidSet;
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String userId = RequestContext.get().getUserId();
        DynamicObject cosmicRel = BusinessDataServiceHelper.loadSingle((String)ENTITY_USERADMINTAGS, (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter(PROP_ADMINTAG, "=", (Object)"10")});
        if (cosmicRel == null) {
            return;
        }
        String cosmicUserId = cosmicRel.getString("user_id");
        if (!userId.equals(cosmicUserId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u975ecosmic\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u6b64\u529f\u80fd", (String)"AdminTypeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
    }
}

