/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.AdministratorEditPlugin;
import kd.bos.permission.formplugin.constant.form.AdministratorEditNewConst;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.StringUtils;

public class AdministratorEditNewPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(AdministratorEditPlugin.class);

    public void initialize() {
        super.initialize();
        TreeView adminiTree = (TreeView)this.getControl("administratortree");
        adminiTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        adminiTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView bizUnitTree = (TreeView)this.getControl("orgtree");
        bizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        bizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView adminOrgTree = (TreeView)this.getControl("adminorgtree");
        adminOrgTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        adminOrgTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView selBizUnitTree = (TreeView)this.getControl("selectedorgtree");
        selBizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        selBizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView selAdminOrgTree = (TreeView)this.getControl("selectedadminorgtree");
        selAdminOrgTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        selAdminOrgTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Tab mainTab = (Tab)this.getControl("tabap");
        mainTab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit user = (BasedataEdit)this.getControl("user");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit additionUser = (BasedataEdit)this.getControl("admin_exception_user");
        additionUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_addorg", "btn_deleteorg", "btn_addadminorg", "btn_deleteadminorg", "btn_addapp", "btn_delapp"});
        this.addItemClickListeners(new String[]{"tbmain", "toolbarap"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (PermFormCommonUtil.isSingleOrg()) {
            IFormView view = this.getView();
            view.setVisible(Boolean.FALSE, new String[]{"tabpage_bizunit"});
        }
    }

    private boolean checkNeedContinueEditNewAdmin(String adminId, String eventInfo) {
        if (this.isNewAdminEdit() && !"-2".equals(adminId)) {
            this.getView().showConfirm(AdministratorEditNewConst.getMSG_CANCEL_EDITNEWADMIN(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(eventInfo, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean checkNeedContinueEditCurAdmin(String adminId, String eventInfo) {
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("dataChanged"))) {
            this.getView().showConfirm(AdministratorEditNewConst.getMSG_CURADMIN_SAVEORNOT(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(eventInfo, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Button && ("btn_addorg".equals(((Button)source).getKey()) || "btn_deleteorg".equals(((Button)source).getKey()))) {
            Object adminId = this.getModel().getValue("admintreefocus");
            String ableUserIds = this.getPageCache().get("ableUserIds");
            if (ableUserIds != null) {
                Set ids = (Set)SerializationUtils.fromJsonString((String)ableUserIds, Set.class);
                String toAdminId = this.getPageCache().get("loginUser2AdminId");
                if (toAdminId != null) {
                    ids.remove(SerializationUtils.fromJsonString((String)toAdminId, String.class));
                }
                if (!ids.contains(adminId.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ed9\u4e0b\u7ea7\u7ba1\u7406\u5458\u5206\u914d\u4e1a\u52a1\u5355\u5143\u7ba1\u8f96\u8303\u56f4\u3002", (String)"AdministratorEditNewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String ctrlKey = c.getKey();
        if ("btn_addorg".equals(ctrlKey)) {
            this.addOrg("15");
        } else if ("btn_deleteorg".equals(ctrlKey)) {
            this.removeSelOrg("15");
        } else if ("btn_addadminorg".equals(ctrlKey)) {
            this.addOrg("01");
        } else if ("btn_deleteadminorg".equals(ctrlKey)) {
            this.removeSelOrg("01");
        } else if ("btn_addapp".equals(ctrlKey)) {
            this.addApp();
        } else if ("btn_delapp".equals(ctrlKey)) {
            this.removeSelApp();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        Set ableUserIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("ableUserIds"), Set.class);
        String curUserId = RequestContext.get().getUserId();
        TreeNode focusAdminTreeNode = this.getFocusAdminTreeNodeFromCache();
        if (focusAdminTreeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusId = focusAdminTreeNode.getId();
        switch (itemKey) {
            case "btn_addnew": {
                this.getModel().setValue("id", (Object)"0");
                String toAdminId = this.getPageCache().get("loginUser2AdminId");
                if (StringUtils.isEmpty((String)toAdminId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u65b0\u589e\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                ableUserIds.add(SerializationUtils.fromJsonString((String)toAdminId, String.class));
                if (!ableUserIds.contains(focusId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u65b0\u589e\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (this.isNewAdminEdit()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u7ea7\u7ba1\u7406\u5458\u672a\u5b8c\u6210\u7f16\u8f91\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u65b0\u589e\u5176\u4ed6\u4e0b\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), this.getPageCache().get("parentText")), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("parentid", String.valueOf(this.getModel().getDataEntity().getPkValue()));
                this.getModel().setDataChanged(false);
                this.setFormEnable(true);
                this.getPageCache().put("dataChanged", "true");
                this.getPageCache().remove("treeNodeClickUserRelation");
                String focusNodeId = this.addNewNode2AdminTree();
                if (StringUtils.isNotEmpty((String)focusAdminTreeNode.getParentid())) {
                    this.loadBizUnitTree(focusNodeId);
                    this.loadAdminOrgTree(focusNodeId);
                    this.initAppTree("apptree", focusNodeId);
                } else {
                    this.initBizUnitTree();
                    this.initAdminOrgTree();
                    this.initAppTree("apptree", null);
                }
                this.getModel().setValue("type", (Object)20);
                Object type = this.getModel().getValue("type");
                if ("10".equals(type)) {
                    this.getModel().setValue("typetext", (Object)ResManager.loadKDString((String)"\u865a\u62df\u7ba1\u7406\u5458", (String)"AdministratorEditNewPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                } else {
                    this.getModel().setValue("typetext", (Object)ResManager.loadKDString((String)"\u5b9e\u4f53\u7ba1\u7406\u5458", (String)"AdministratorEditNewPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("parent", (Object)focusId);
                this.getModel().setValue("user", null);
                this.getModel().deleteEntryData("entryentity");
                this.buildSelectedOrgTree("15");
                this.buildSelectedOrgTree("01");
                this.buildSelectedAppTree();
                FieldTip ft = new FieldTip();
                ft.setFieldKey("user");
                ft.setSuccess(true);
                this.getView().showFieldTip(ft);
                this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
                break;
            }
            case "btn_delete": {
                String curAdminUserId;
                Object value = this.getModel().getValue("admintreefocus");
                if (value != null && this.getAdminTypeStr().equals(value)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u6839\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject userObj = (DynamicObject)this.getModel().getValue("user");
                if (userObj != null && curUserId.equals(curAdminUserId = userObj.getString("id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u81ea\u5df1\u3002", (String)"AdministratorEditNewPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder errMsg = new StringBuilder();
                Object adminId = this.getModel().getValue("admintreefocus");
                boolean require = MutexHelper.require((IFormView)this.getView(), (String)"perm_admin", (Object)adminId, (String)"modify", (StringBuilder)errMsg);
                if (!require) {
                    this.getView().showTipNotification(errMsg.toString());
                    return;
                }
                DynamicObject[] childAdminObjs = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id,user,parent,isleaf", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)focusId), this.getAdminTypeFilter()});
                if (null != childAdminObjs && childAdminObjs.length >= 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u7ba1\u7406\u5458\u8fd8\u6709\u4e0b\u7ea7,\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AdministratorEditNewPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteCallBack", (IFormPlugin)this));
                } else if (this.isNewAdminEdit()) {
                    this.getView().showConfirm(AdministratorEditNewConst.getMSG_CANCEL_EDITNEWADMIN(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("eventId_delNewAdmin", (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"AdministratorEditNewPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteCallBack", (IFormPlugin)this));
                }
                this.getPageCache().remove("-2_orgDatas");
                this.getPageCache().remove("-2_AdminOrgDatas");
                break;
            }
            case "btn_save": {
                this.saveAdmin();
                break;
            }
            case "add_user": {
                if (!ableUserIds.contains(focusId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ed9\u4e0b\u7ea7\u7ba1\u7406\u5458\u6dfb\u52a0\u4eba\u5458\u3002", (String)"AdministratorEditNewPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("dataChanged", "true");
                ListShowParameter listForm = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                ArrayList<Object> selectedRowIds = new ArrayList<Object>(rowCount);
                while (rowCount > 0) {
                    DynamicObject user = (DynamicObject)this.getModel().getValue("admin_exception_user", --rowCount);
                    if (user == null) continue;
                    selectedRowIds.add(user.getPkValue());
                }
                Object[] selectRowIds = selectedRowIds.toArray();
                listForm.setSelectedRows(selectRowIds);
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                QFilter f1 = new QFilter("enable", "=", (Object)"1");
                listFilterParameter.setFilter(f1);
                listForm.setCustomParam("externalUserType", (Object)"all");
                listForm.setListFilterParameter(listFilterParameter);
                listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addUser"));
                this.getView().showForm((FormShowParameter)listForm);
                break;
            }
            case "del_user": {
                if (!ableUserIds.contains(focusId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ed9\u4e0b\u7ea7\u7ba1\u7406\u5458\u79fb\u9664\u4eba\u5458\u3002", (String)"AdministratorEditNewPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("dataChanged", "true");
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] rowIndex = entryGrid.getSelectRows();
                if (rowIndex != null && rowIndex.length > 0) {
                    this.getModel().deleteEntryRows("entryentity", rowIndex);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdministratorEditNewPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                break;
            }
        }
    }

    private String addNewNode2AdminTree() {
        TreeView adminTreeView = (TreeView)this.getControl("administratortree");
        String focusAdminId = adminTreeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusAdminId)) {
            focusAdminId = (String)this.getModel().getValue("admintreefocus");
        }
        if (StringUtils.isEmpty((String)focusAdminId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u5de6\u6811\u9009\u4e2d\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u7a0b\u5e8f\u903b\u8f91", (String)"AdministratorEditNewPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)focusAdminId, (String)"perm_admin");
        this.getPageCache().put("parentText", single.getDynamicObject("user").get("name").toString());
        adminTreeView.expand(focusAdminId);
        TreeNode node = new TreeNode();
        node.setText(ResManager.loadKDString((String)"\u65b0\u589e\u7ba1\u7406\u5458", (String)"AdministratorEditNewPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        node.setParentid(focusAdminId);
        node.setId("-2");
        this.getPageCache().put("changeadmin", "true");
        this.getPageCache().put("addNew", "true");
        this.getModel().setValue("admintreefocus", (Object)"-2");
        DynamicObject[] childAdminObjs = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id,user,parent,isleaf", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)focusAdminId), this.getAdminTypeFilter()});
        TreeNode adminTreeNodes = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        TreeNode focusNode = adminTreeNodes.getTreeNode(focusAdminId, 100);
        for (DynamicObject childAdminObj : childAdminObjs) {
            TreeNode childNode = new TreeNode();
            childNode.setId(childAdminObj.getPkValue().toString());
            if (childAdminObj.getDynamicObject("user") == null) continue;
            childNode.setText(childAdminObj.getDynamicObject("user").getString("name"));
            childNode.setParentid(focusAdminId);
            if ("false".equals(childAdminObj.get("isleaf")) || "0".equals(childAdminObj.get("isleaf")) || !childAdminObj.getBoolean("isleaf")) {
                childNode.setChildren(new ArrayList());
            }
            if (adminTreeNodes.getTreeNode(childAdminObj.getPkValue().toString(), 100) != null) continue;
            focusNode.addChild(childNode);
            adminTreeView.addNode(childNode);
        }
        adminTreeView.addNode(node);
        adminTreeView.focusNode(node);
        this.getPageCache().put("focus_AdminTreeNode", SerializationUtils.toJsonString((Object)node));
        this.getPageCache().put("adminTreeRootCache", SerializationUtils.toJsonString((Object)adminTreeNodes));
        return focusAdminId;
    }

    private void saveAdmin() {
        String adminId = null;
        TreeView adminTree = (TreeView)this.getControl("administratortree");
        try (DLock dl = DLock.create((String)"bas/permissinon/administrator");){
            String focusId;
            dl.lock();
            DynamicObject user = (DynamicObject)this.getModel().getValue("user");
            if (user == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7528\u6237\u540d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdministratorEditNewPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            Long curUserId = user.getLong("id");
            List<Long> allAdminUserIds = this.getAllAdminUserIds();
            adminId = this.getModel().getDataEntity().getString("id");
            if ("0".equals(adminId) && allAdminUserIds.contains(curUserId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u662f\u7ba1\u7406\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdministratorEditNewPlugin_17", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            Set ids = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("ableUserIds"), Set.class);
            if (!ids.contains(focusId = this.getModel().getValue("admintreefocus").toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u5f53\u524d\u7ba1\u7406\u5458\u7684\u4e0b\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
                return;
            }
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject curRowUser = (DynamicObject)this.getModel().getValue("admin_exception_user", i);
                if (curRowUser != null && curRowUser.getLong("id") != 0L) continue;
                String errInfo = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u5916\u7528\u6237\u5206\u5f55\u7684\u7b2c%s\u884c\u7684\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdministratorEditNewPlugin_19", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(errInfo, String.valueOf(i + 1)));
                return;
            }
            String type = (String)this.getModel().getValue("type");
            if (!this.ifLoginUserIsSuperAdmin() && "10".equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u80fd\u8bbe\u7f6e\u865a\u62df\u7ba1\u7406\u5458\u3002", (String)"AdministratorEditNewPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] nodeAndChildren = this.loadFocusNodeAndChildren();
            if (!"-2".equals(focusId)) {
                String toDelAppIdsJson;
                String toDelAdminOrgIdsJson;
                String toDeleteBizUnitIdsJson = this.getPageCache().get("todel_bizunitIds");
                if (StringUtils.isNotEmpty((String)toDeleteBizUnitIdsJson)) {
                    Set toDelBizUnits = (Set)SerializationUtils.fromJsonString((String)toDeleteBizUnitIdsJson, Set.class);
                    if (toDelBizUnits != null && !toDelBizUnits.isEmpty()) {
                        if (this.deleteSelBizUnitTreeNodeCasacade(nodeAndChildren)) {
                            String toDeleteAdminObjsName = this.getPageCache().get("toDeleteAdminObjsName");
                            String toDeleteAdminObjIds = this.getPageCache().get("toDeleteAdminObjsIds");
                            String toDeleteName = toDeleteAdminObjsName.substring(0, toDeleteAdminObjsName.length() - 1);
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u79fb\u9664\u4e1a\u52a1\u5355\u5143\u4f1a\u5220\u9664\u5f53\u524d\u6216\u4e0b\u7ea7\u7ba1\u7406\u5458\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"AdministratorEditNewPlugin_21", (String)"bos-permission-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u7406\u5458 ", (String)"AdministratorEditNewPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]) + toDeleteName + ResManager.loadKDString((String)" \u7ba1\u8f96\u7684\u4e1a\u52a1\u5355\u5143\u8303\u56f4\u4e3a\u7a7a\uff0c\u5c06\u88ab\u5220\u9664", (String)"AdministratorEditNewPlugin_23", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("deleteAdminCallBack_" + toDeleteAdminObjIds, (IFormPlugin)this));
                            return;
                        }
                        if (nodeAndChildren != null && nodeAndChildren.length > 0 && nodeAndChildren[0] != null) {
                            SaveServiceHelper.save((DynamicObject[])nodeAndChildren);
                        }
                    }
                    this.getPageCache().remove("todel_bizunitIds");
                }
                if (StringUtils.isNotEmpty((String)(toDelAdminOrgIdsJson = this.getPageCache().get("todel_adminOrgIds")))) {
                    Set toDelAdminOrgIds = (Set)SerializationUtils.fromJsonString((String)toDelAdminOrgIdsJson, Set.class);
                    if (toDelAdminOrgIds != null && !toDelAdminOrgIds.isEmpty()) {
                        if (nodeAndChildren == null) {
                            nodeAndChildren = this.loadFocusNodeAndChildren();
                        }
                        this.deleteSelAdminOrgTreeNode(nodeAndChildren);
                        if (nodeAndChildren != null && nodeAndChildren.length > 0 && nodeAndChildren[0] != null) {
                            SaveServiceHelper.save((DynamicObject[])nodeAndChildren);
                        }
                    }
                    this.getPageCache().remove("todel_adminOrgIds");
                }
                if (StringUtils.isNotEmpty((String)(toDelAppIdsJson = this.getPageCache().get("todel_appIds")))) {
                    Set toDelAppIds = (Set)SerializationUtils.fromJsonString((String)toDelAppIdsJson, Set.class);
                    if (toDelAppIds != null && !toDelAppIds.isEmpty()) {
                        if (nodeAndChildren == null) {
                            nodeAndChildren = this.loadFocusNodeAndChildren();
                        }
                        this.deleteSelAppTreeNode(nodeAndChildren);
                        if (nodeAndChildren != null && nodeAndChildren.length > 0 && nodeAndChildren[0] != null) {
                            SaveServiceHelper.save((DynamicObject[])nodeAndChildren);
                            for (DynamicObject curAdmin : nodeAndChildren) {
                                String curAdminId = (String)curAdmin.getPkValue();
                                if (curAdminId.equalsIgnoreCase(adminId)) continue;
                                this.getPageCache().remove(curAdminId + "_AppDatas");
                            }
                        }
                    }
                    this.getPageCache().remove("todel_appIds");
                }
            }
        }
    }

    private boolean checkChildAdminChargeNotRight(DynamicObject[] curAndChildAdminObjs) {
        List<Object> adminOrgDatas = new ArrayList();
        ArrayList<String> adminOrgIdsFromCache = new ArrayList<String>();
        String focusAdminId = this.getModel().getValue("admintreefocus").toString();
        if (focusAdminId.equals("-2")) {
            return false;
        }
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("focus_AdminTreeNode"), TreeNode.class);
        String adminOrgDataStr = this.getPageCache().get(treeNode.getId() + "_AdminOrgDatas");
        if (StringUtils.isNotEmpty((String)adminOrgDataStr)) {
            adminOrgDatas = SerializationUtils.fromJsonStringToList((String)adminOrgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)focusAdminId)) {
            adminOrgDatas = this.queryOrgLongNumberByAdmin(focusAdminId, "15");
        }
        for (String adminOrgData : adminOrgDatas) {
            String[] adminOrgInfo = adminOrgData.split("_split_");
            if (adminOrgInfo == null || adminOrgInfo.length <= 0) continue;
            adminOrgIdsFromCache.add(adminOrgInfo[0]);
        }
        TreeNode appRootNode = null;
        String appDataStr = this.getPageCache().get(treeNode.getId() + "_AppDatas");
        if (StringUtils.isNotEmpty((String)appDataStr)) {
            appRootNode = (TreeNode)SerializationUtils.fromJsonString((String)appDataStr, TreeNode.class);
        } else if (StringUtils.isNotEmpty((String)focusAdminId)) {
            appRootNode = this.queryAppRootNodeByAdmin(focusAdminId, "selectedapptree");
        }
        ArrayList<String> appIdsFromCache = new ArrayList<String>();
        if (appRootNode == null) {
            return false;
        }
        List cloudNodes = appRootNode.getChildren();
        if (cloudNodes != null && !cloudNodes.isEmpty()) {
            for (TreeNode cloudNode : cloudNodes) {
                List appNodes = cloudNode.getChildren();
                for (TreeNode appNode : appNodes) {
                    String appNodeId = appNode.getId();
                    String appId = appNodeId.substring(0, appNodeId.indexOf("#app"));
                    appIdsFromCache.add(appId);
                }
            }
        }
        for (DynamicObject adminObj : curAndChildAdminObjs) {
            if (adminObj.getString("id").equals(focusAdminId)) continue;
            String adminName = adminObj.getString("user.name");
            DynamicObjectCollection adminOrgs = adminObj.getDynamicObjectCollection("entry_adminorg");
            HashMap<String, String> adminOrgIds = new HashMap<String, String>(16);
            for (DynamicObject adminOrg : adminOrgs) {
                DynamicObject adminOrgObj = adminOrg.getDynamicObject("adminorg");
                if (adminOrgObj == null) continue;
                adminOrgIds.put(adminOrgObj.getString("id"), adminOrgObj.getString("name"));
            }
            if (adminOrgIdsFromCache != null && !adminOrgIdsFromCache.isEmpty() && adminOrgIds != null && !adminOrgIds.isEmpty()) {
                for (Map.Entry orgInfo : adminOrgIds.entrySet()) {
                    if (adminOrgIdsFromCache.contains(orgInfo.getKey())) continue;
                    String orgName = (String)orgInfo.getValue();
                    StringBuilder errorStr = new StringBuilder();
                    errorStr.append(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ba1\u7406\u5458\u7684\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u5b58\u5728\u5f53\u524d\u7ba1\u7406\u5458\u672a\u5206\u914d\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"AdministratorEditNewPlugin_27", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    errorStr.append("\r\n").append('[').append(adminName).append("]-[").append(orgName).append(']');
                    this.getView().showMessage(errorStr.toString());
                    return true;
                }
            }
            DynamicObjectCollection apps = adminObj.getDynamicObjectCollection("entry_app");
            HashMap<String, String> appIdsFromDB = new HashMap<String, String>(16);
            for (DynamicObject app : apps) {
                DynamicObject appObjObj = app.getDynamicObject("app");
                if (appObjObj == null) continue;
                appIdsFromDB.put(appObjObj.getString("id"), appObjObj.getString("name"));
            }
            if (appIdsFromCache == null || appIdsFromCache.isEmpty() || appIdsFromDB == null || appIdsFromDB.isEmpty()) continue;
            for (Map.Entry appInfo : appIdsFromDB.entrySet()) {
                if (appIdsFromCache.contains(appInfo.getKey())) continue;
                String appName = (String)appInfo.getValue();
                StringBuilder errorStr = new StringBuilder();
                errorStr.append(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ba1\u7406\u5458\u7684\u5e94\u7528\u7ba1\u8f96\u8303\u56f4\u5b58\u5728\u5f53\u524d\u7ba1\u7406\u5458\u672a\u5206\u914d\u7684\u5e94\u7528\u3002", (String)"AdministratorEditNewPlugin_28", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                errorStr.append("\r\n").append('[').append(adminName).append("]-[").append(appName).append(']');
                this.getView().showMessage(errorStr.toString());
                return true;
            }
        }
        return false;
    }

    private boolean processRangeData(String adminId, StringBuilder errorMsg) {
        boolean processResult1 = false;
        boolean processResult2 = false;
        boolean processResult3 = false;
        errorMsg.append(ResManager.loadKDString((String)"\u8054\u52a8\u5904\u7406\u4e0b\u7ea7\u7ba1\u7406\u5458\u51fa\u73b0\u5f02\u5e38\uff1a", (String)"AdministratorEditNewPlugin_29", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        try (TXHandle tx = TX.required();){
            try {
                processResult1 = this.processBizUnitRangeData(adminId, errorMsg);
                processResult2 = this.processAdminOrgRangeData(adminId, errorMsg);
                processResult3 = this.processAppRangeData(adminId, errorMsg);
            }
            catch (Exception e) {
                logger.warn(errorMsg.toString());
            }
        }
        return processResult1 && processResult2 && processResult3;
    }

    private boolean processBizUnitRangeData(String adminId, StringBuilder errorMsg) {
        return true;
    }

    private boolean processAdminOrgRangeData(String adminId, StringBuilder errorMsg) {
        return true;
    }

    private boolean processAppRangeData(String adminId, StringBuilder errorMsg) {
        return true;
    }

    private String save(TreeNode treeNode, String parentid) {
        DynamicObject dot = null;
        Date now = TimeServiceHelper.now();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"perm_admin");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentid, (DynamicObjectType)entityType);
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        String type = (String)this.getModel().getValue("type");
        String adminId = null;
        String adminTypeValue = this.getAdminTypeStr();
        if (!"-2".equals(treeNode.getId())) {
            adminId = treeNode.getId();
            dot = BusinessDataServiceHelper.loadSingle((Object)adminId, (DynamicObjectType)entityType);
        } else {
            dot = BusinessDataServiceHelper.newDynamicObject((String)"perm_admin");
            if (StringUtils.isNotEmpty((String)parentid)) {
                dynamicObject.set("isleaf", (Object)Boolean.FALSE);
                SaveServiceHelper.save((IDataEntityType)entityType, (Object[])new DynamicObject[]{dynamicObject});
                dot.set("parent", (Object)parentid);
            }
            adminId = DB.genStringId((String)"perm_admin");
            dot.set("creator", (Object)RequestContext.get().getUserId());
            dot.set("createtime", (Object)now);
            dot.set("id", (Object)adminId);
            dot.set("number", (Object)adminId);
            dot.set("longnumber", (Object)(dynamicObject.getString("longnumber") + "." + adminId));
            dot.set("masterid", (Object)adminId);
            dot.set("disabler", (Object)"0");
            dot.set("disabledate", null);
            dot.set("type", (Object)type);
            dot.set("longnumber", (Object)".");
            dot.set("level", (Object)(dynamicObject.getInt("level") + 1));
            dot.set("isleaf", (Object)Boolean.TRUE);
            dot.set("enable", (Object)"1");
            dot.set("fullname", (Object)"null.null");
            dot.set("admintype", (Object)adminTypeValue);
        }
        dot.set("user", (Object)user);
        DynamicObjectCollection orgs = dot.getDynamicObjectCollection("bizlist");
        DynamicObjectType orgsType = orgs.getDynamicObjectType();
        orgs.clear();
        List<Object> orgDatas = new ArrayList();
        String orgDataStr = this.getPageCache().get(treeNode.getId() + "_orgDatas");
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, "15");
        }
        if (!PermFormCommonUtil.isSingleOrg()) {
            for (String org : orgDatas) {
                DynamicObject newOrg = new DynamicObject(orgsType);
                newOrg.set("biznumber", (Object)org.split("_split_")[0]);
                orgs.add((Object)newOrg);
            }
        } else {
            Long rootOrgPK = OrgUnitServiceHelper.getRootOrgId();
            DynamicObject newOrg = new DynamicObject(orgsType);
            newOrg.set("biznumber", (Object)rootOrgPK);
            orgs.add((Object)newOrg);
        }
        DynamicObjectCollection adminOrgEntry = dot.getDynamicObjectCollection("entry_adminorg");
        DynamicObjectType adminOrgType = adminOrgEntry.getDynamicObjectType();
        adminOrgEntry.clear();
        List<Object> adminOrgDatas = new ArrayList();
        String adminOrgDataStr = this.getPageCache().get(treeNode.getId() + "_AdminOrgDatas");
        if (StringUtils.isNotEmpty((String)adminOrgDataStr)) {
            adminOrgDatas = SerializationUtils.fromJsonStringToList((String)adminOrgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            adminOrgDatas = this.queryOrgLongNumberByAdmin(adminId, "01");
        }
        if (!PermFormCommonUtil.isSingleOrg()) {
            for (String adminOrg : adminOrgDatas) {
                DynamicObject newAdminOrg = new DynamicObject(adminOrgType);
                newAdminOrg.set("adminorg", (Object)adminOrg.split("_split_")[0]);
                adminOrgEntry.add((Object)newAdminOrg);
            }
        } else {
            Long rootOrgPK = OrgUnitServiceHelper.getRootOrgId();
            DynamicObject newAdminOrg = new DynamicObject(adminOrgType);
            newAdminOrg.set("adminorg", (Object)rootOrgPK);
            adminOrgEntry.add((Object)newAdminOrg);
        }
        DynamicObjectCollection appEntry = dot.getDynamicObjectCollection("entry_app");
        DynamicObjectType appEntryRowType = appEntry.getDynamicObjectType();
        appEntry.clear();
        TreeNode appRootNode = null;
        String appDataStr = this.getPageCache().get(treeNode.getId() + "_AppDatas");
        if (StringUtils.isNotEmpty((String)appDataStr)) {
            appRootNode = (TreeNode)SerializationUtils.fromJsonString((String)appDataStr, TreeNode.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            appRootNode = this.queryAppRootNodeByAdmin(adminId, "selectedapptree");
        }
        if (appRootNode == null) {
            return null;
        }
        List cloudNodes = appRootNode.getChildren();
        if (cloudNodes != null && !cloudNodes.isEmpty()) {
            for (TreeNode cloudNode : cloudNodes) {
                List appNodes = cloudNode.getChildren();
                for (TreeNode appNode : appNodes) {
                    DynamicObject newAppObj = new DynamicObject(appEntryRowType);
                    String appNodeId = appNode.getId();
                    String appId = appNodeId.substring(0, appNodeId.indexOf("#app"));
                    newAppObj.set("app", (Object)appId);
                    appEntry.add((Object)newAppObj);
                }
            }
        }
        DynamicObjectCollection eus = dot.getDynamicObjectCollection("entryentity");
        eus.clear();
        DynamicObjectType eusType = eus.getDynamicObjectType();
        DynamicObjectCollection extraUsers = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject extraUser : extraUsers) {
            DynamicObject newEu = new DynamicObject(eusType);
            if (extraUser == null || extraUser.getDynamicObject("admin_exception_user") == null) continue;
            newEu.set("admin_exception_user", extraUser.getDynamicObject("admin_exception_user").getPkValue());
            eus.add((Object)newEu);
        }
        dot.set("modifier", (Object)RequestContext.get().getUserId());
        dot.set("modifytime", (Object)now);
        SaveServiceHelper.save((IDataEntityType)entityType, (Object[])new DynamicObject[]{dot});
        return adminId;
    }

    private boolean appendCloudFilter(StringBuilder sb) {
        String cloudStr;
        List<String> cloudIdsBlackListFromStd;
        StringBuilder cloud = new StringBuilder();
        String cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (StringUtils.isNotEmpty((String)cloudIdBlackList)) {
            cloud.append(cloudIdBlackList);
        }
        if (!CollectionUtils.isEmpty(cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList())) {
            for (int i = 0; i < cloudIdsBlackListFromStd.size(); ++i) {
                cloudIdsBlackListFromStd.set(i, "'" + cloudIdsBlackListFromStd.get(i) + "'");
            }
            String cloudIds = String.join((CharSequence)",", cloudIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)cloudIds)) {
                if (StringUtils.isNotEmpty((String)cloud.toString())) {
                    cloud.append(',').append(cloudIds);
                } else {
                    cloud.append(cloudIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(cloudStr = cloud.toString()))) {
            sb.append(" WHERE t.cloudl_id NOT IN (").append(cloudStr).append(')');
            return true;
        }
        return false;
    }

    private void appendAppFilter(StringBuilder sb, boolean hasCloudFilter) {
        String appStr;
        List<String> appIdsBlackListFromStd;
        StringBuilder app = new StringBuilder();
        String appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist();
        if (StringUtils.isNotEmpty((String)appIdBlackList)) {
            app.append(appIdBlackList);
        }
        if (!CollectionUtils.isEmpty(appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList())) {
            for (int i = 0; i < appIdsBlackListFromStd.size(); ++i) {
                appIdsBlackListFromStd.set(i, "'" + appIdsBlackListFromStd.get(i) + "'");
            }
            String appIds = String.join((CharSequence)",", appIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)appIds)) {
                if (StringUtils.isNotEmpty((String)app.toString())) {
                    app.append(',').append(appIds);
                } else {
                    app.append(appIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(appStr = app.toString()))) {
            if (hasCloudFilter) {
                sb.append(" AND");
            } else {
                sb.append(" WHERE");
            }
            sb.append(" t.app_id NOT IN (").append(appStr).append(')');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeNode> queryAssignableAppRange(String adminId, int maxLevel) {
        ArrayList<TreeNode> arrayList;
        if (maxLevel == 0) {
            return null;
        }
        String langName = RequestContext.get().getLang().name();
        String algoPrefixKey = ((Object)((Object)this)).getClass().getName() + ".queryAssignableAppRange.";
        DataSet cloudAppDS = null;
        DataSet adminAppDS = null;
        DataSet finalDS = null;
        try {
            StringBuilder sbCloudAppSql = new StringBuilder().append("select t.cloudl_id, t.cloudl_name, t.cloud_seq,  ").append("t.app_id, t.app_name, t.app_seq ,t.temp_id, t.finheritpath from ( ").append("SELECT DISTINCT cloudl.fid cloudl_id, cloudl.fname cloudl_name, cloud.fseq cloud_seq,  ").append("a.fmasterid app_id, b.fname app_name, a.fseq app_seq ,a.fid temp_id, a.finheritpath ").append("FROM  t_meta_bizapp a ").append("JOIN  t_meta_bizapp_l b ON (a.fid = b.fid and b.flocaleid= ?) ").append("JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = a.fbizcloudid and cloudl.flocaleid = ?) ").append("JOIN t_meta_bizcloud cloud ON cloud.FID = cloudl.FID ").append("WHERE NOT EXISTS (SELECT 1 FROM t_meta_appruntime c ").append("WHERE (a.fid = c.fid OR a.fmasterid = c.fid) AND c.falluserapp = '1') ").append("AND a.fdeploystatus = '2' ").append("AND a.falluserapp = '0' ").append("AND a.fmasterid <> ' ' ").append("AND a.fid not in (select a.fparentid from t_meta_bizapp a) ").append("union ").append("SELECT DISTINCT cloudl.fid cloudl_id, cloudl.fname cloudl_name, cloud.fseq cloud_seq, ").append("a.fid app_id, b.fname app_name, a.fseq app_seq ,a.fmasterid temp_id, a.finheritpath ").append("FROM  t_meta_bizapp a ").append("JOIN  t_meta_bizapp_l b ON (a.fid = b.fid and b.flocaleid= ?) ").append("JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = a.fbizcloudid and cloudl.flocaleid = ?) ").append("JOIN t_meta_bizcloud cloud ON cloud.FID = cloudl.FID ").append("where a.fmasterid = ' ' ").append("and a.fid not in (select a.fparentid from t_meta_bizapp a) ").append("AND a.fdeploystatus = '2' ").append("AND a.falluserapp = '0') t ");
            boolean hasCloudFilter = this.appendCloudFilter(sbCloudAppSql);
            this.appendAppFilter(sbCloudAppSql, hasCloudFilter);
            sbCloudAppSql.append(" order by t.cloud_seq, t.app_seq, t.finheritpath desc ");
            cloudAppDS = DB.queryDataSet((String)(algoPrefixKey + ".cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{langName, langName, langName, langName});
            finalDS = null;
            if (StringUtils.isNotEmpty((String)adminId)) {
                String adminAppEntrySql = "select paae.fappid paae_appid from t_perm_adminappentry paae where paae.fid = ? ";
                adminAppDS = DB.queryDataSet((String)(algoPrefixKey + ".adminAppDS"), (DBRoute)DBRoute.permission, (String)adminAppEntrySql, (Object[])new Object[]{adminId});
                finalDS = cloudAppDS.join(adminAppDS).on("app_id", "paae_appid").select(new String[]{"cloudl_id", "cloudl_name", "cloud_seq", "app_id", "app_name", "app_seq"}, new String[0]).finish().orderBy(new String[]{"cloud_seq", "app_seq"});
            } else {
                finalDS = cloudAppDS;
            }
            HashMap<String, TreeNode> cloudMap = new HashMap<String, TreeNode>();
            ArrayList<TreeNode> cloudNodes = new ArrayList<TreeNode>();
            HashSet<String> appIds = new HashSet<String>(100);
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String cloudId = row.getString("cloudl_id");
                String cloudName = row.getString("cloudl_name");
                String appId = row.getString("app_id");
                String appName = row.getString("app_name");
                if (appIds.contains(appId)) continue;
                TreeNode cloudNode = (TreeNode)cloudMap.get(cloudId);
                if (cloudNode == null) {
                    cloudNode = new TreeNode("-1", cloudId + "#cloud", cloudName, true);
                    cloudNode.setChildren(new ArrayList());
                    cloudNodes.add(cloudNode);
                    cloudMap.put(cloudId, cloudNode);
                }
                cloudNode.getChildren().add(new TreeNode(cloudId + "#cloud", appId + "#app", appName, false));
                appIds.add(appId);
            }
            arrayList = cloudNodes;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
        return arrayList;
    }

    private TreeNode queryAppRootNodeByAdmin(String adminId, String treeViewKey) {
        List<TreeNode> appList = this.queryAssignableAppRange(adminId, 1);
        if (treeViewKey.equals("apptree")) {
            String parentAdminId = null;
            for (int maxRecursiveLevel = 50; !(appList != null && !appList.isEmpty() || maxRecursiveLevel <= 0 || (parentAdminId = this.getParentAdminId(adminId)) == null || "0".equals(parentAdminId) || this.isVirtualAdmin(parentAdminId)); --maxRecursiveLevel) {
                appList = this.queryAssignableAppRange(parentAdminId, maxRecursiveLevel);
                adminId = parentAdminId;
            }
        }
        String treeRootText = null;
        if (treeViewKey.equals("apptree")) {
            if (appList == null || appList.isEmpty()) {
                appList = this.queryAssignableAppRange(null, 1);
            }
            treeRootText = ResManager.loadKDString((String)"\u5f85\u9009\u5e94\u7528", (String)"AdministratorEditNewPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        } else if (treeViewKey.equals("selectedapptree")) {
            treeRootText = this.getSelAppRootNodeText();
        }
        TreeNode rootNode = this.getRootTreeNode(treeRootText);
        if (appList != null && !appList.isEmpty()) {
            rootNode.setChildren(appList);
        } else {
            rootNode.setText(this.getSameAsParentRootNodeText());
        }
        return rootNode;
    }

    private TreeNode getRootTreeNode(String treeRootText) {
        TreeNode rootNode = new TreeNode();
        rootNode.setParentid("");
        rootNode.setId("-1");
        rootNode.setText(treeRootText);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("addUser".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection source = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int entryCount = this.getModel().getEntryRowCount("entryentity");
            if (entryCount != 0) {
                --entryCount;
                while (entryCount >= 0) {
                    this.getModel().deleteEntryRow("entryentity", entryCount);
                    --entryCount;
                }
            }
            if (source == null) {
                return;
            }
            Object[] ids = new Object[source.size()];
            for (int i = 0; i < source.size(); ++i) {
                ids[i] = source.get(i).getPrimaryKeyValue();
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name, phone, email", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                this.getModel().batchCreateNewEntryRow("entryentity", dynamicObjects.length);
            }
            if (dynamicObjects != null) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    this.getModel().setValue("admin_exception_user", (Object)dynamicObjects[i], i);
                }
            }
        }
    }

    private boolean refreshPageCache(TreeNode node, boolean isAdd, boolean refreshAdminTree) {
        String changeadmin = this.getPageCache().get("changeadmin");
        TreeNode rootNodeFromCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        TreeNode toChangeParentNode = rootNodeFromCache.getTreeNode(node.getParentid(), 100);
        if ("true".equals(changeadmin)) {
            boolean initSuperAdminTree = this.initSuperAdminTree(false);
            if (!initSuperAdminTree) {
                return false;
            }
            this.getPageCache().put("focus_AdminTreeNode", SerializationUtils.toJsonString((Object)node));
            return true;
        }
        if (toChangeParentNode != null) {
            if (isAdd) {
                List children = toChangeParentNode.getChildren();
                if (children != null) {
                    for (int i = children.size(); i > 0; --i) {
                        if (!((TreeNode)children.get(i - 1)).getId().equals(node.getId()) || !node.getId().equals("-2")) continue;
                        children.remove(children.get(i - 1));
                    }
                }
                if (this.getPageCache().get("addNewNode") != null) {
                    toChangeParentNode.addChild(node);
                    this.getPageCache().remove("addNewNode");
                }
                toChangeParentNode.setIsOpened(true);
                this.getPageCache().put("focus_AdminTreeNode", SerializationUtils.toJsonString((Object)node));
            } else {
                ArrayList children = toChangeParentNode.getChildren();
                for (int i = children.size(); i > 0; --i) {
                    String nodeId;
                    TreeNode treeNode = (TreeNode)children.get(i - 1);
                    String treeNodeId = treeNode.getId();
                    if (!treeNodeId.equals(nodeId = node.getId())) continue;
                    children.remove(treeNode);
                }
                if (children.size() == 0) {
                    children = new ArrayList();
                }
                toChangeParentNode.setChildren((List)children);
            }
        }
        this.getPageCache().put("adminTreeRootCache", SerializationUtils.toJsonString((Object)rootNodeFromCache));
        return true;
    }

    private boolean ifLoginUserIsSuperAdmin() {
        String userId = RequestContext.get().getUserId();
        return PermissionServiceHelper.isAdminUser((long)Long.parseLong(userId), (String)"10");
    }

    private TreeNode getFocusAdminTreeNodeFromCache() {
        String focusNodeCache = this.getPageCache().get("focus_AdminTreeNode");
        TreeNode treeNode = null;
        if (StringUtils.isNotEmpty((String)focusNodeCache)) {
            treeNode = (TreeNode)SerializationUtils.fromJsonString((String)focusNodeCache, TreeNode.class);
        }
        return treeNode;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        String parentid = (String)this.getModel().getValue("parent");
        TreeNode focusAdminTreeNode = this.getFocusAdminTreeNodeFromCache();
        if (callBackId.equals("deleteCallBack")) {
            boolean deleteAdmin;
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes) && !(deleteAdmin = this.deleteAdmin(null))) {
                return;
            }
        } else if (callBackId.startsWith("deleteAdminCallBack")) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                String forDeleteAdminIdsStr = callBackId.substring(callBackId.indexOf("deleteAdminCallBack") + "deleteAdminCallBack".length());
                String focusAdminId = this.getModel().getValue("admintreefocus").toString();
                TreeNode adminRootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
                TreeNode focusAminNode = adminRootNode.getTreeNode(focusAdminId, 100);
                Object[] forDeleteAdminIdsArr = forDeleteAdminIdsStr.split("_");
                boolean deleteAdmin = this.deleteAdmin((String[])forDeleteAdminIdsArr);
                if (!deleteAdmin) {
                    return;
                }
                if (Arrays.binarySearch(forDeleteAdminIdsArr, focusAdminId) > 0) {
                    return;
                }
                String toDeleteBizUnitIdsJson = this.getPageCache().get("todel_bizunitIds");
                if (toDeleteBizUnitIdsJson == null) {
                    return;
                }
                DynamicObject[] curOrChildAdminObjs = this.loadFocusNodeAndChildren();
                StringBuilder idString = new StringBuilder();
                StringBuilder parentIds = new StringBuilder();
                ArrayList<Long> userIds = new ArrayList<Long>();
                Set toDeleteBizUnitIds = (Set)SerializationUtils.fromJsonString((String)toDeleteBizUnitIdsJson, Set.class);
                block0: for (DynamicObject curOrChildAdminObj : curOrChildAdminObjs) {
                    DynamicObjectCollection orgCol;
                    if (focusAdminId.equals(curOrChildAdminObj.getString("id")) || (orgCol = curOrChildAdminObj.getDynamicObjectCollection("bizlist")) == null) continue;
                    for (int index = orgCol.size() - 1; index >= 0; --index) {
                        DynamicObject orgObj = (DynamicObject)orgCol.get(index);
                        if (orgObj == null || orgObj.getDynamicObject("biznumber") == null) continue;
                        String selectedOrgId = orgObj.getDynamicObject("biznumber").getPkValue().toString();
                        if (toDeleteBizUnitIds.contains(selectedOrgId)) {
                            orgCol.remove(index);
                        }
                        if (orgCol.size() != 0) continue;
                        idString.append('_');
                        idString.append(curOrChildAdminObj.getPkValue());
                        parentIds.append('_');
                        parentIds.append(curOrChildAdminObj.getDynamicObject("parent").getPkValue());
                        userIds.add((Long)curOrChildAdminObj.getDynamicObject("user").getPkValue());
                        continue block0;
                    }
                    curOrChildAdminObj.set("bizlist", (Object)orgCol);
                }
                String toDeleteAdminOrgIdsJson = this.getPageCache().get("todel_adminOrgIds");
                if (StringUtils.isNotEmpty((String)toDeleteAdminOrgIdsJson)) {
                    Set toDeleteAdminOrgIds = (Set)SerializationUtils.fromJsonString((String)toDeleteAdminOrgIdsJson, Set.class);
                    block2: for (DynamicObject curOrChildAdminObj : curOrChildAdminObjs) {
                        DynamicObjectCollection adminOrgs;
                        if (focusAdminId.equals(curOrChildAdminObj.getString("id")) || (adminOrgs = curOrChildAdminObj.getDynamicObjectCollection("entry_adminorg")) == null) continue;
                        for (int index = adminOrgs.size() - 1; index >= 0; --index) {
                            DynamicObject adminOrgObj = (DynamicObject)adminOrgs.get(index);
                            if (adminOrgObj == null || adminOrgObj.getDynamicObject("adminorg") == null) continue;
                            String selAdminOrgId = adminOrgObj.getDynamicObject("adminorg").getPkValue().toString();
                            if (toDeleteAdminOrgIds.contains(selAdminOrgId)) {
                                adminOrgs.remove(index);
                            }
                            if (adminOrgs.size() == 0) continue block2;
                        }
                        curOrChildAdminObj.set("entry_adminorg", (Object)adminOrgs);
                    }
                }
                this.save(focusAdminTreeNode, parentid);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"perm_admin");
                if (idString != null && idString.length() > 1) {
                    DynamicObject[] load;
                    DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])idString.substring(1).split("_"));
                    DynamicObject[] parentAdminObjs = BusinessDataServiceHelper.load((Object[])parentIds.toString().split("_"), (DynamicObjectType)entityType);
                    HashSet<Object> ids = new HashSet<Object>(parentAdminObjs.length);
                    for (DynamicObject parentAdminObj : parentAdminObjs) {
                        ids.add(parentAdminObj.getPkValue());
                    }
                    for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"perm_admin", (String)"isleaf", (QFilter[])new QFilter[]{new QFilter("parent", "in", ids), this.getAdminTypeFilter()})) {
                        ids.remove(dynamicObject.getPkValue());
                    }
                    DynamicObject[] toSaveObject = new DynamicObject[ids.size()];
                    int i = 0;
                    for (DynamicObject parentAdminObj : parentAdminObjs) {
                        Object pkValue = parentAdminObj.getPkValue();
                        if (ids.contains(pkValue)) {
                            parentAdminObj.set("isleaf", (Object)Boolean.TRUE);
                            toSaveObject[i] = parentAdminObj;
                        }
                        ++i;
                    }
                    SaveServiceHelper.save((DynamicObject[])toSaveObject);
                    if (userIds != null && userIds.size() > 0) {
                        UserAppCache.removeCache(userIds);
                        UserMenuCache.removeUserMenuAllCache();
                    }
                    AdminUserCache.removeAllCache();
                    this.getPageCache().remove("dataChanged");
                    TreeView treeView = (TreeView)this.getControl("administratortree");
                    treeView.deleteNodes(Arrays.asList(forDeleteAdminIdsArr));
                    treeView.treeNodeClick(focusAminNode.getParentid(), focusAminNode.getId());
                }
                this.getPageCache().remove("toDeleteAdminObjsName");
                this.getPageCache().remove("toDeleteAdminObjsIds");
            }
        } else if (callBackId.equals("exitCallBack")) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.save(focusAdminTreeNode, parentid);
                IFormView view = this.getView().getParentView();
                view.close();
                this.getView().sendFormAction(view);
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                UserAppCache.removeCache((Long)userId);
                UserMenuCache.removeCache((Long)userId);
                DynamicObject user = (DynamicObject)this.getModel().getValue("user");
                Long targetUserId = (Long)user.getPkValue();
                UserAppCache.removeCache((Long)targetUserId);
                UserMenuCache.removeCache((Long)targetUserId);
                JSONArray resultApps = this.getAllAppsInSystem();
                resultApps = this.getAppsAfterFilters(resultApps);
                IPageCache appViewCache = (IPageCache)this.getView().getMainView().getService(IPageCache.class);
                IFormView appView = this.getView().getMainView().getView(appViewCache.get("appPageId2MainPage"));
                ((IClientViewProxy)appView.getService(IClientViewProxy.class)).addAction("APPSTORELIST", (Object)resultApps);
                this.getView().sendFormAction(appView);
            } else {
                this.getPageCache().put("perm2Other", "true");
                this.getPageCache().remove("firstSave");
            }
        } else if (callBackId.startsWith("newAdminContinueEdit")) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                String[] eventInfo = callBackId.split("\\$");
                this.clearNewAdmin();
                this.adminTreeNodeClick(eventInfo[1], eventInfo[2]);
            } else {
                this.jumpBackToPreviousAdminNode("-2");
            }
        } else if (callBackId.startsWith("curAdminContinueEdit")) {
            String[] eventInfo = callBackId.split("\\$");
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().remove("dataChanged");
                this.adminTreeNodeClick(eventInfo[1], eventInfo[2]);
            } else {
                this.jumpBackToPreviousAdminNode(eventInfo[3]);
            }
        } else if (callBackId.startsWith("queryTreeNodeChildren_AdminTree_NewAdmin")) {
            String[] eventInfo = callBackId.split("\\$");
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearNewAdmin();
                this.queryAdminTreeNodeChildren(eventInfo[1]);
            } else {
                TreeView adminTreeView = (TreeView)this.getControl("administratortree");
                adminTreeView.collapse(eventInfo[1]);
                this.jumpBackToPreviousAdminNode("-2");
            }
        } else if (callBackId.startsWith("queryTreeNodeChildren_AdminTree_CurAdmin")) {
            String[] eventInfo = callBackId.split("\\$");
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().remove("dataChanged");
                this.queryAdminTreeNodeChildren(eventInfo[1]);
            } else {
                TreeView adminTreeView = (TreeView)this.getControl("administratortree");
                adminTreeView.collapse(eventInfo[1]);
                this.jumpBackToPreviousAdminNode(eventInfo[2]);
            }
        } else if (callBackId.startsWith("eventId_delNewAdmin")) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearNewAdmin();
                TreeView adminTree = (TreeView)this.getControl("administratortree");
                adminTree.treeNodeClick("", this.getPageCache().get("superAdminId"));
            }
        } else if (callBackId.equals("beforeCloseConfirm") && mbce.getResult() == MessageBoxResult.Yes) {
            PermFormCommonUtil.closeClientForm(this.getView());
        }
    }

    private void jumpBackToPreviousAdminNode(String adminNodeId) {
        TreeView adminiTree = (TreeView)this.getControl("administratortree");
        adminiTree.focusNode(new TreeNode("", adminNodeId, ""));
    }

    private JSONArray getAppIds(JSONArray apps) {
        JSONArray appIds = new JSONArray();
        for (int i = 0; i < apps.size(); ++i) {
            JSONArray cloudAndApp = apps.getJSONArray(i);
            for (int j = 0; j < cloudAndApp.size(); ++j) {
                JSONObject cloudOrApp = cloudAndApp.getJSONObject(j);
                if (cloudOrApp.getString("iscloud") != null) continue;
                appIds.add((Object)cloudOrApp.getString("id"));
            }
        }
        return appIds;
    }

    private JSONArray getAppsAfterFilters(JSONArray allApps) {
        List userBizApps;
        boolean hasPersonalApps = false;
        JSONArray appIds = this.getAppIds(allApps);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String apps = UserConfigServiceHelper.getSetting((long)userId, (String)"appPersonalList");
        if (apps != null && !apps.trim().isEmpty()) {
            allApps = JSONArray.parseArray((String)apps);
            hasPersonalApps = true;
        }
        if ((userBizApps = PermissionServiceHelper.getUserBizApps((Long)userId)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u5e94\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdministratorEditNewPlugin_31", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return allApps;
        }
        String userTypeInContext = RequestContext.get().getUserType();
        if (userTypeInContext == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u7c7b\u578b\u5931\u8d25\u3002", (String)"AdministratorEditNewPlugin_32", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return allApps;
        }
        String[] userType = userTypeInContext.split(",");
        ArrayList<String> userTypeList = new ArrayList<String>(Arrays.asList(userType));
        for (int i = 0; i < allApps.size(); ++i) {
            JSONArray cloudAndApp = allApps.getJSONArray(i);
            for (int j = 0; j < cloudAndApp.size(); ++j) {
                JSONObject cloudOrApp = cloudAndApp.getJSONObject(j);
                if (cloudOrApp.get((Object)"iscloud") != null || !this.filterApp(cloudOrApp, hasPersonalApps, appIds, userBizApps, userTypeList)) continue;
                cloudAndApp.remove(j);
                --j;
            }
            if (cloudAndApp.size() != 1) continue;
            allApps.remove(i);
            --i;
        }
        return allApps;
    }

    private boolean filterApp(JSONObject appObject, boolean hasPersonalApps, JSONArray appIds, List<String> userBizApps, List<String> userTypeList) {
        boolean isRemoveApp = false;
        String appId = appObject.getString("id");
        String allUserApp = appObject.getString("alluserapp");
        String[] appUserType = appObject.getString("usertype").split(",");
        ArrayList<String> appUserTypeList = new ArrayList<String>(Arrays.asList(appUserType));
        if (hasPersonalApps && !appIds.contains((Object)appId)) {
            isRemoveApp = true;
        }
        if (!(isRemoveApp || userBizApps == null || userBizApps.contains(appId) || allUserApp.equals("true"))) {
            isRemoveApp = true;
        }
        if (!isRemoveApp && Collections.disjoint(appUserTypeList, userTypeList)) {
            isRemoveApp = true;
        }
        return isRemoveApp;
    }

    private JSONArray getAllAppsInSystem() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("AppMetadata", new DistributeCacheHAPolicy(true, true));
        String portalAppInfo = null;
        try {
            portalAppInfo = (String)cache.get("Runtime-AppMetadata-" + CacheKeyUtil.getAcctId() + "-portalapp");
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        String log = ResManager.loadKDString((String)"\u6574\u4f53\u7f13\u5b58\u540e\u8017\u65f6 ", (String)"AdministratorEditNewPlugin_33", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (StringUtils.isBlank((String)portalAppInfo)) {
            log = ResManager.loadKDString((String)"\u6574\u4f53\u7f13\u5b58\u524d\u8017\u65f6 ", (String)"AdministratorEditNewPlugin_34", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        }
        long start = System.currentTimeMillis();
        JSONArray allAppsInSystem = BizAppServiceHelp.getAllAppInfo();
        logger.warn(log + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        return allAppsInSystem;
    }

    private String getAdminTypeStr() {
        String strAdminType = this.getPageCache().get("pgCache_key_adminType");
        if (StringUtils.isEmpty((String)strAdminType)) {
            String loginUserId = RequestContext.get().getUserId();
            AdminType adminType = PermissionServiceHelper.getAdminType((long)Long.parseLong(loginUserId));
            if (adminType != null) {
                strAdminType = adminType.toString();
            }
            this.getPageCache().put("pgCache_key_adminType", strAdminType);
        }
        return strAdminType;
    }

    private QFilter getAdminTypeFilter() {
        String adminTypeValue = this.getAdminTypeStr();
        return new QFilter("admintype", "=", (Object)Long.valueOf(adminTypeValue));
    }

    public void afterCreateNewData(EventObject e) {
        if (StringUtils.isEmpty((String)this.getPageCache().get("firstinit"))) {
            boolean initSuperAdminTree = this.initSuperAdminTree(true);
            if (!initSuperAdminTree) {
                return;
            }
            this.getPageCache().put("firstinit", "1");
            this.getEnableIdsPutIntoPageCache();
        }
        String loginUserId = RequestContext.get().getUserId();
        boolean adminPermResult = AdminPermCache.checkAdminPerm((Long)Long.valueOf(loginUserId), (String)"83bfebc8000037ac", (String)"bos_usergroup_user");
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabpage_app"});
    }

    private void getEnableIdsPutIntoPageCache() {
        DynamicObject[] dynamicObjects;
        String loginUserId = RequestContext.get().getUserId();
        String id = null;
        HashSet<String> ids = new HashSet<String>();
        ids.add("-2");
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id,user,parent.user", (QFilter[])new QFilter[]{this.getAdminTypeFilter()})) {
            DynamicObject user = dynamicObject.getDynamicObject("user");
            if (user == null || user.getPkValue() == null || !loginUserId.equals(dynamicObject.getDynamicObject("user").getPkValue().toString())) continue;
            id = dynamicObject.getPkValue().toString();
            this.getPageCache().put("loginUser2AdminId", SerializationUtils.toJsonString((Object)id));
            ids.add(id);
            break;
        }
        if (id != null) {
            this.findChildren(dynamicObjects, id, ids, false);
        }
        ids.remove(id);
        this.getPageCache().put("ableUserIds", SerializationUtils.toJsonString(ids));
    }

    private void findChildren(DynamicObject[] allAdmins, String curId, Set<String> ids, boolean isUserNode) {
        for (DynamicObject adminObj : allAdmins) {
            if (isUserNode) {
                boolean add;
                DynamicObject parentAdminUser;
                DynamicObject adminUserObj = adminObj.getDynamicObject("user");
                if (adminUserObj == null) continue;
                if (this.isVirtualAdmin(curId)) {
                    ids.add(adminUserObj.getPkValue().toString());
                    continue;
                }
                DynamicObject parentAdmin = adminObj.getDynamicObject("parent");
                if (parentAdmin == null || (parentAdminUser = parentAdmin.getDynamicObject("user")) == null || !curId.equals(parentAdminUser.getPkValue().toString()) && !curId.equals(adminUserObj.getPkValue().toString()) || !(add = ids.add(adminUserObj.getPkValue().toString()))) continue;
                this.findChildren(allAdmins, adminUserObj.getPkValue().toString(), ids, isUserNode);
                continue;
            }
            if (this.isVirtualAdmin(curId)) {
                ids.add(adminObj.getPkValue().toString());
                continue;
            }
            DynamicObject parent = adminObj.getDynamicObject("parent");
            if (parent == null || !curId.equals(parent.getPkValue().toString())) continue;
            ids.add(adminObj.getPkValue().toString());
            this.findChildren(allAdmins, adminObj.getPkValue().toString(), ids, isUserNode);
        }
    }

    private void removeSelApp() {
        TreeView tv = (TreeView)this.getControl("selectedapptree");
        List checkedNodes = tv.getTreeState().getCheckedNodes();
        List checkedNodeIdList = tv.getTreeState().getCheckedNodeIds();
        if (checkedNodeIdList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u5e94\u7528\u201d\u4e2d\u7684\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_35", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        String adminId = (String)this.getModel().getValue("admintreefocus");
        TreeNode appRootNode = null;
        String appDataStr = this.getPageCache().get(adminId + "_AppDatas");
        appRootNode = StringUtils.isNotEmpty((String)appDataStr) ? (TreeNode)SerializationUtils.fromJsonString((String)appDataStr, TreeNode.class) : (!"-1".equals(adminId) && StringUtils.isNotEmpty((String)adminId) ? this.queryAppRootNodeByAdmin(adminId, "selectedapptree") : this.getRootTreeNode(this.getSelAppRootNodeText()));
        for (Iterator forDelNodeId : checkedNodeIdList) {
            appRootNode.deleteChildNode((String)((Object)forDelNodeId));
        }
        HashSet<String> tempDelNodeIds = new HashSet<String>(checkedNodes.size());
        for (Map checkedNodeMap : checkedNodes) {
            tempDelNodeIds.add((String)checkedNodeMap.get("parentid"));
        }
        for (String tempDelNodeId : tempDelNodeIds) {
            TreeNode queryParentNode = appRootNode.getTreeNode(tempDelNodeId, 100);
            if (queryParentNode == null || queryParentNode.getChildren() == null || !queryParentNode.getChildren().isEmpty()) continue;
            appRootNode.deleteChildNode(tempDelNodeId);
            checkedNodeIdList.add(tempDelNodeId);
        }
        HashSet<String> removeNodeId = new HashSet<String>(checkedNodeIdList);
        this.updateDelIdsCache(removeNodeId, true, "todel_appIds");
        this.updateAddIdsCache(removeNodeId, false, "toadd_appIds");
        this.getPageCache().put(adminId + "_AppDatas", SerializationUtils.toJsonString((Object)appRootNode));
        this.getPageCache().put("dataChanged", "true");
        if (appRootNode.getChildren() == null || appRootNode.getChildren().isEmpty()) {
            tv.deleteAllNodes();
            tv.addNode(this.getRootTreeNode(this.getSameAsParentRootNodeText()));
        } else {
            tv.deleteNodes(checkedNodeIdList);
            tv.addNode(this.getRootTreeNode(this.getSelAppRootNodeText()));
        }
        tv.uncheckNodes(checkedNodeIdList);
    }

    private void addApp() {
        TreeView tree = (TreeView)this.getControl("apptree");
        List checkedNodeIdList = tree.getTreeState().getCheckedNodeIds();
        if (checkedNodeIdList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u5e94\u7528\u201d\u4e2d\u7684\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_36", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        String rootNodeText = this.getSelAppRootNodeText();
        String adminId = (String)this.getModel().getValue("admintreefocus");
        TreeNode appRootNode = null;
        String appDataStr = this.getPageCache().get(adminId + "_AppDatas");
        appRootNode = StringUtils.isNotEmpty((String)appDataStr) ? (TreeNode)SerializationUtils.fromJsonString((String)appDataStr, TreeNode.class) : (!"-1".equals(adminId) && StringUtils.isNotEmpty((String)adminId) ? this.queryAppRootNodeByAdmin(adminId, "selectedapptree") : this.getRootTreeNode(rootNodeText));
        this.addAppNode(appRootNode);
        HashSet<String> addNodeId = new HashSet<String>(checkedNodeIdList);
        this.updateDelIdsCache(addNodeId, false, "todel_appIds");
        this.updateAddIdsCache(addNodeId, true, "toadd_appIds");
        this.getPageCache().put(adminId + "_AppDatas", SerializationUtils.toJsonString((Object)appRootNode));
        tree.uncheckNodes(checkedNodeIdList);
        this.getPageCache().put("dataChanged", "true");
    }

    private void addAppNode(TreeNode appRootNode) {
        TreeView tree = (TreeView)this.getControl("apptree");
        List allCloudNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("pgCache_allCloudInfo"), List.class);
        List allAppNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("pgCache_allAppInfo"), List.class);
        HashSet<Object> forAddCloudNodeIds = new HashSet<Object>();
        HashSet<String> forAddAppNodeIds = new HashSet<String>();
        List checkedNodes = tree.getTreeState().getCheckedNodes();
        for (Map map : checkedNodes) {
            String checkedNodeId = (String)map.get("id");
            if (checkedNodeId.endsWith("#cloud")) {
                forAddCloudNodeIds.add(checkedNodeId);
                continue;
            }
            if (!checkedNodeId.endsWith("#app")) continue;
            String cloudNodeId = (String)map.get("parentid");
            forAddCloudNodeIds.add(cloudNodeId);
            forAddAppNodeIds.add(checkedNodeId);
        }
        ArrayList<TreeNode> forAddCloudNodes = new ArrayList<TreeNode>();
        ArrayList<TreeNode> forAddAppNodes = new ArrayList<TreeNode>();
        String needExpandNodeId = null;
        block1: for (String string : forAddCloudNodeIds) {
            if (appRootNode.getTreeNode(string, 4) != null) continue;
            for (Map allCloudMap : allCloudNodes) {
                if (!string.equals(allCloudMap.get("id").toString())) continue;
                String newCloudNodeId = allCloudMap.get("id").toString();
                TreeNode newCloudNode = new TreeNode(allCloudMap.get("parentid").toString(), newCloudNodeId, allCloudMap.get("text").toString(), true);
                appRootNode.addChild(newCloudNode);
                forAddCloudNodes.add(newCloudNode);
                forAddAppNodes.add(newCloudNode);
                if (needExpandNodeId != null) continue block1;
                needExpandNodeId = newCloudNodeId;
                continue block1;
            }
        }
        block3: for (String string : forAddAppNodeIds) {
            if (appRootNode.getTreeNode(string, 4) != null) continue;
            for (Map allAppMap : allAppNodes) {
                if (!string.equals(allAppMap.get("id").toString())) continue;
                String cloudNodeId = allAppMap.get("parentid").toString();
                TreeNode cloudNode = appRootNode.getTreeNode(cloudNodeId, 4);
                TreeNode newAppNode = new TreeNode(cloudNodeId, allAppMap.get("id").toString(), allAppMap.get("text").toString(), false);
                cloudNode.addChild(newAppNode);
                forAddAppNodes.add(newAppNode);
                if (needExpandNodeId != null) continue block3;
                needExpandNodeId = cloudNodeId;
                continue block3;
            }
        }
        TreeView selAppTree = (TreeView)this.getControl("selectedapptree");
        if (forAddCloudNodes.size() == 0 && forAddAppNodes.size() == 0) {
            return;
        }
        appRootNode.setText(this.getSelAppRootNodeText());
        selAppTree.updateNode(appRootNode);
        selAppTree.addNodes(forAddCloudNodes);
        selAppTree.addNodes(forAddAppNodes);
        selAppTree.expand(needExpandNodeId);
    }

    private void removeSelOrg(String orgViewType) {
        String treeViewKey = null;
        String noticeMsg = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        if (orgViewType.equals("15")) {
            treeViewKey = "selectedorgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_37", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rightNodeIdCacheKey = "orgTreerRightNodeIds";
            toDelIdCacheKey = "todel_bizunitIds";
            toAddIdCacheKey = "toadd_bizunitIds";
        } else if (orgViewType.equals("01")) {
            treeViewKey = "selectedadminorgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u884c\u653f\u7ec4\u7ec7\u201d\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_38", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rightNodeIdCacheKey = "AdminOrgTreeRightNodeIds";
            toDelIdCacheKey = "todel_adminOrgIds";
            toAddIdCacheKey = "toadd_adminOrgIds";
        }
        String rightNodeIds = this.getPageCache().get(rightNodeIdCacheKey);
        if (StringUtils.isEmpty((String)rightNodeIds)) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        Set rightNodeIdSets = (Set)SerializationUtils.fromJsonString((String)rightNodeIds, Set.class);
        if (rightNodeIdSets.size() == 0) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.updateDelIdsCache(rightNodeIdSets, true, toDelIdCacheKey);
        this.updateAddIdsCache(rightNodeIdSets, false, toAddIdCacheKey);
        this.deleteEntryByList(rightNodeIdSets, orgViewType);
        this.buildSelectedOrgTree(orgViewType);
        this.getPageCache().remove(rightNodeIdCacheKey);
    }

    private void addOrg(String orgViewType) {
        String treeViewKey = null;
        String noticeMsg = null;
        String rootTreeNodeCacheKey = null;
        String leftNodeIdCacheKey = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        if (orgViewType.equals("15")) {
            treeViewKey = "orgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_39", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootTreeNodeCacheKey = "orgTreeLeftRoot";
            leftNodeIdCacheKey = "orgTreeLeftNodeIds";
            rightNodeIdCacheKey = "orgTreerRightNodeIds";
            toDelIdCacheKey = "todel_bizunitIds";
            toAddIdCacheKey = "toadd_bizunitIds";
        } else if (orgViewType.equals("01")) {
            treeViewKey = "adminorgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u884c\u653f\u7ec4\u7ec7\u201d\u8282\u70b9\u3002", (String)"AdministratorEditNewPlugin_40", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootTreeNodeCacheKey = "AdminOrgTreeLeftRoot";
            leftNodeIdCacheKey = "AdminOrgTreeLeftNodeIds";
            rightNodeIdCacheKey = "AdminOrgTreeRightNodeIds";
            toDelIdCacheKey = "todel_adminOrgIds";
            toAddIdCacheKey = "toadd_adminOrgIds";
        }
        String leftNodeIdCacheJson = this.getPageCache().get(leftNodeIdCacheKey);
        if (StringUtils.isEmpty((String)leftNodeIdCacheJson)) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        Set leftNodeIds = (Set)SerializationUtils.fromJsonString((String)leftNodeIdCacheJson, Set.class);
        if (leftNodeIds.size() == 0) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.updateDelIdsCache(leftNodeIds, false, toDelIdCacheKey);
        this.updateAddIdsCache(leftNodeIds, true, toAddIdCacheKey);
        this.adjustOrg(true, orgViewType, leftNodeIds);
        this.getPageCache().remove(leftNodeIdCacheKey);
        this.getPageCache().remove(rightNodeIdCacheKey);
        TreeView tree = (TreeView)this.getControl(treeViewKey);
        List checkedNodeIdList = tree.getTreeState().getCheckedNodeIds();
        tree.uncheckNodes(checkedNodeIdList);
        TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rootTreeNodeCacheKey), TreeNode.class);
        rootTreeNode.setCheckable(false);
        List children = rootTreeNode.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(rootTreeNodeCacheKey, SerializationUtils.toJsonString((Object)rootTreeNode));
    }

    private void deleteEntryByList(Set<String> toDeleteIds, String orgViewType) {
        String orgDataSuffixCacheKey = null;
        if (orgViewType.equals("15")) {
            orgDataSuffixCacheKey = "_orgDatas";
        } else if (orgViewType.equals("01")) {
            orgDataSuffixCacheKey = "_AdminOrgDatas";
        }
        List<Object> orgDatas = new ArrayList();
        String adminId = (String)this.getModel().getValue("admintreefocus");
        String orgDataStr = this.getPageCache().get(adminId + orgDataSuffixCacheKey);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        Iterator it = orgDatas.iterator();
        while (it.hasNext()) {
            String orgData = (String)it.next();
            if (StringUtils.isEmpty((String)orgData.split("_split_")[0]) || !toDeleteIds.contains(orgData.split("_split_")[0])) continue;
            it.remove();
        }
        this.getPageCache().put(adminId + orgDataSuffixCacheKey, SerializationUtils.toJsonString(orgDatas));
    }

    private void setFormEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"tabap", "user"});
    }

    private void adminTreeNodeClick(String parentNodeId, String adminId) {
        DynamicObject admin;
        QFilter[] filters;
        String curFocusAdminId;
        if (this.isVirtualAdmin(adminId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        }
        TreeView tree = (TreeView)this.getControl("administratortree");
        String curLoginUserIdStr = RequestContext.get().getUserId();
        String parentid = (String)this.getModel().getValue("parent");
        if (StringUtils.isEmpty((String)parentNodeId) && !this.isVirtualAdmin(adminId)) {
            this.getModel().setValue("parent", (Object)parentid);
            parentNodeId = parentid;
        } else {
            this.getModel().setValue("parent", (Object)parentNodeId);
        }
        String ableUserIds = this.getPageCache().get("ableUserIds");
        if (StringUtils.isNotEmpty((String)ableUserIds)) {
            Set ids = (Set)SerializationUtils.fromJsonString((String)ableUserIds, Set.class);
            if (ids.contains(adminId)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"user"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"user"});
            }
        }
        if (!this.isVirtualAdmin(adminId)) {
            StringBuilder errMsg = new StringBuilder();
            boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (String)"perm_admin", (Object)adminId, (String)"modify", (StringBuilder)errMsg);
            if (!isMutexLocked) {
                this.getView().showTipNotification(errMsg.toString());
                this.setFormEnable(false);
            } else {
                this.setFormEnable(true);
            }
        }
        if (!adminId.equals(curFocusAdminId = (String)this.getModel().getValue("admintreefocus"))) {
            this.getPageCache().remove("todel_bizunitIds");
        }
        if ("-2".equals(adminId)) {
            this.getModel().setValue("user", null);
            this.getPageCache().put("parentid", parentNodeId);
            this.getModel().deleteEntryData("entryentity");
        }
        if (!this.isVirtualAdmin(adminId)) {
            this.loadData(adminId);
            filters = new QFilter[]{new QFilter("id", "=", (Object)adminId), this.getAdminTypeFilter()};
            admin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id,user", (QFilter[])filters);
            String userName = "";
            if (admin != null) {
                DynamicObject user = (DynamicObject)admin.get("user");
                userName = user.getString("name");
                long curFocusAdminUserId = user.getLong("id");
                if (curFocusAdminUserId == Long.parseLong(curLoginUserIdStr)) {
                    this.setFormEnable(false);
                }
                this.getPageCache().put("treeNodeClickUserRelation", DataEntitySerializer.serializerToString((Object)user));
                this.getPageCache().put("pgCache_focusAdmin_userId", String.valueOf(curFocusAdminUserId));
                this.showBaseInfo(new QFilter("user", "=", (Object)Long.valueOf(user.getPkValue().toString())));
            } else {
                this.getPageCache().remove("treeNodeClickUserRelation");
            }
            if ("-2".equals(adminId)) {
                this.getModel().getDataEntity().set("id", (Object)0);
            } else {
                this.getModel().getDataEntity().set("id", (Object)adminId);
            }
            this.getModel().setValue("admintreefocus", (Object)adminId);
            this.buildSelectedOrgTree("15");
            this.buildSelectedOrgTree("01");
            this.buildSelectedAppTree();
            if (StringUtils.isNotEmpty((String)parentNodeId) && !this.isVirtualAdmin(parentNodeId)) {
                this.loadBizUnitTree(parentNodeId);
                this.loadAdminOrgTree(parentNodeId);
                this.loadAppTree(parentNodeId);
            } else {
                String parentAdminId = null;
                parentAdminId = "-2".equals(adminId) ? parentNodeId : this.getParentAdminId(adminId);
                if (StringUtils.isNotEmpty((String)parentAdminId) && !this.isVirtualAdmin(parentAdminId)) {
                    this.loadBizUnitTree(parentAdminId);
                    this.loadAdminOrgTree(parentAdminId);
                    this.loadAppTree(parentAdminId);
                } else {
                    this.initBizUnitTree();
                    this.initAdminOrgTree();
                    this.initAppTree("apptree", null);
                }
            }
            this.getModel().setValue("type", (Object)"20");
            TreeNode node = new TreeNode(String.valueOf(parentNodeId), String.valueOf(adminId), userName);
            if (StringUtils.isNotEmpty((String)parentNodeId)) {
                node.setParentid(parentNodeId);
            }
            tree.focusNode(node);
            this.getPageCache().put("focus_AdminTreeNode", SerializationUtils.toJsonString((Object)node));
            this.getPageCache().put("parentid", node.getParentid());
        } else {
            this.setFormEnable(false);
            filters = new QFilter[]{new QFilter("id", "=", (Object)adminId), this.getAdminTypeFilter()};
            admin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id,user", (QFilter[])filters);
            String userName = "";
            if (admin != null) {
                DynamicObject user = (DynamicObject)admin.get("user");
                userName = user.getString("name");
                long curFocusAdminUserId = user.getLong("id");
                this.getPageCache().put("treeNodeClickUserRelation", DataEntitySerializer.serializerToString((Object)user));
                this.getPageCache().put("pgCache_focusAdmin_userId", String.valueOf(curFocusAdminUserId));
                this.showBaseInfo(new QFilter("user", "=", (Object)Long.valueOf(user.getPkValue().toString())));
            } else {
                this.getPageCache().remove("treeNodeClickUserRelation");
            }
            TreeNode node = new TreeNode(String.valueOf(parentNodeId), String.valueOf(adminId), userName);
            if (StringUtils.isNotEmpty((String)parentNodeId)) {
                node.setParentid(parentNodeId);
            }
            tree.focusNode(node);
            this.getPageCache().put("focus_AdminTreeNode", SerializationUtils.toJsonString((Object)node));
            this.getPageCache().remove("parentid");
            this.getModel().setValue("admintreefocus", (Object)adminId);
            this.buildSelectedOrgTree("15");
            this.buildSelectedOrgTree("01");
            this.buildSelectedAppTree();
        }
        this.getPageCache().remove("orgTreerRightNodeIds");
        this.getPageCache().remove("orgTreeLeftNodeIds");
        this.getPageCache().remove("AdminOrgTreeRightNodeIds");
        this.getPageCache().remove("AdminOrgTreeLeftNodeIds");
        Object type = this.getModel().getValue("type");
        if ("10".equals(type)) {
            this.getModel().setValue("typetext", (Object)ResManager.loadKDString((String)"\u865a\u62df\u7ba1\u7406\u5458", (String)"AdministratorEditNewPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("typetext", (Object)ResManager.loadKDString((String)"\u5b9e\u4f53\u7ba1\u7406\u5458", (String)"AdministratorEditNewPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        boolean isSuperAdmin = this.ifLoginUserIsSuperAdmin();
        if (!isSuperAdmin) {
            return;
        }
        if ("-2".equals(adminId)) {
            this.getPageCache().put("changeadmin", "true");
        } else {
            this.getPageCache().put("changeadmin", "false");
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        String adminId = (String)treeNodeEvent.getNodeId();
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        if (treeView.getKey().equals("administratortree")) {
            String preFocusAdminId = (String)this.getModel().getValue("admintreefocus");
            this.getPageCache().put("admintreefocus_previous", preFocusAdminId);
            String eventInfo1 = "newAdminContinueEdit$" + parentNodeId + "$" + adminId;
            String eventInfo2 = "curAdminContinueEdit$" + parentNodeId + "$" + adminId + "$" + preFocusAdminId;
            if (!this.checkNeedContinueEditNewAdmin(adminId, eventInfo1) && !this.checkNeedContinueEditCurAdmin(adminId, eventInfo2)) {
                this.adminTreeNodeClick(parentNodeId, adminId);
            }
            if (PermFormCommonUtil.isSingleOrg()) {
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab("tabpage_adminorg");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadBizUnitTree(String parentNodeId) {
        void var11_14;
        TreeView tv = (TreeView)this.getControl("orgtree");
        tv.deleteAllNodes();
        TreeNode node = new TreeNode();
        node.setParentid("");
        node.setId("-1");
        node.setText(ResManager.loadKDString((String)"\u5f85\u9009\u4e1a\u52a1\u5355\u5143", (String)"AdministratorEditNewPlugin_41", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        node.setIsOpened(true);
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)parentNodeId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(parentNodeId, "15");
        }
        int size = orgDatas.size();
        int i = 0;
        String lastLongNumber = "";
        String longNumber = "";
        HashMap orgNumber = new HashMap();
        for (String string : orgDatas) {
            String[] orgDataArr = string.split("_split_");
            if (orgDataArr.length < 3) continue;
            longNumber = orgDataArr[2];
            if (StringUtils.isEmpty((String)longNumber)) {
                ++i;
                continue;
            }
            if (longNumber.lastIndexOf(33) > 0 && orgNumber.containsValue(longNumber.substring(0, longNumber.lastIndexOf(33)))) {
                ++i;
                continue;
            }
            if (i > 0 && (longNumber.equals(lastLongNumber) || longNumber.startsWith(lastLongNumber + "!") || longNumber.contains(lastLongNumber + "!") && longNumber.replace(lastLongNumber + "!", "").contains("!"))) {
                ++i;
                continue;
            }
            lastLongNumber = longNumber;
            TreeNode childNode = new TreeNode();
            childNode.setText(orgDataArr[1]);
            childNode.setParentid("-1");
            childNode.setId(orgDataArr[0]);
            childNode.setLongNumber(orgDataArr[2]);
            if (i + 1 < size) {
                String[] orgDataArrNext = ((String)orgDatas.get(i + 1)).split("_split_");
                if (orgDataArrNext.length < 3) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (StringUtils.isEmpty((String)nextLongNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_42", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (nextLongNumber.startsWith(longNumber + "!")) {
                    childNode.setChildren(new ArrayList());
                }
            }
            node.addChild(childNode);
            ++i;
        }
        List childNodes = node.getChildren();
        Object var11_12 = null;
        if (!CollectionUtils.isEmpty((Collection)childNodes)) {
            String string = ((TreeNode)childNodes.get(0)).getId();
        }
        this.getPageCache().put("orgTreeLeftRoot", SerializationUtils.toJsonString((Object)node));
        tv.addNode(node);
        if (StringUtils.isNotEmpty((String)var11_14)) {
            tv.expand((String)var11_14);
            tv.queryTreeNodeChildren("-1", (String)var11_14);
        }
    }

    private void loadAdminOrgTree(String adminId) {
        TreeView tv = (TreeView)this.getControl("adminorgtree");
        tv.deleteAllNodes();
        TreeNode node = new TreeNode();
        node.setParentid("");
        node.setId("-1");
        node.setText(ResManager.loadKDString((String)"\u5f85\u9009\u884c\u653f\u7ec4\u7ec7", (String)"AdministratorEditNewPlugin_43", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        node.setIsOpened(true);
        String parentId = adminId;
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)parentId) && ((orgDatas = this.queryOrgLongNumberByAdmin(parentId, "01")) == null || orgDatas.isEmpty())) {
            String newParentAdminId = null;
            for (int maxRecursiveLevel = 100; !(orgDatas != null && !orgDatas.isEmpty() || maxRecursiveLevel <= 0 || StringUtils.isEmpty((String)(newParentAdminId = this.getParentAdminId(parentId))) || "0".equals(newParentAdminId) || this.isVirtualAdmin(newParentAdminId)); --maxRecursiveLevel) {
                orgDatas = this.queryOrgLongNumberByAdmin(newParentAdminId, "01");
                parentId = newParentAdminId;
            }
        }
        if (orgDatas == null || orgDatas.isEmpty()) {
            this.initAdminOrgTree();
            return;
        }
        int size = orgDatas.size();
        int i = 0;
        String lastLongNumber = "";
        String longNumber = "";
        HashMap orgNumber = new HashMap();
        for (String string : orgDatas) {
            String[] orgDataArr = string.split("_split_");
            if (orgDataArr.length < 3) continue;
            longNumber = orgDataArr[2];
            if (StringUtils.isEmpty((String)longNumber)) {
                ++i;
                continue;
            }
            if (longNumber.lastIndexOf(33) > 0 && orgNumber.containsValue(longNumber.substring(0, longNumber.lastIndexOf(33)))) {
                ++i;
                continue;
            }
            if (i > 0 && (longNumber.equals(lastLongNumber) || longNumber.startsWith(lastLongNumber + "!") || longNumber.contains(lastLongNumber + "!") && longNumber.replace(lastLongNumber + "!", "").contains("!"))) {
                ++i;
                continue;
            }
            lastLongNumber = longNumber;
            TreeNode childNode = new TreeNode();
            childNode.setText(string.split("_split_")[1]);
            childNode.setParentid("-1");
            childNode.setId(string.split("_split_")[0]);
            if (i + 1 < size) {
                String[] orgDataArrNext = ((String)orgDatas.get(i + 1)).split("_split_");
                if (orgDataArrNext.length < 3) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (StringUtils.isEmpty((String)nextLongNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_44", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (nextLongNumber.startsWith(longNumber + "!")) {
                    childNode.setChildren(new ArrayList());
                }
            }
            node.addChild(childNode);
            ++i;
        }
        this.getPageCache().put("AdminOrgTreeLeftRoot", SerializationUtils.toJsonString((Object)node));
        tv.addNode(node);
        String firstNodeId = null;
        List list = node.getChildren();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            firstNodeId = ((TreeNode)list.get(0)).getId();
        }
        if (StringUtils.isNotEmpty(firstNodeId)) {
            tv.expand(firstNodeId);
            tv.queryTreeNodeChildren("-1", firstNodeId);
        }
    }

    private void loadAppTree(String parentAdminId) {
        this.initAppTree("apptree", parentAdminId);
    }

    private void loadSelAppTree(String adminId) {
        this.initAppTree("selectedapptree", adminId);
    }

    private void queryAdminTreeNodeChildren(String nodeId) {
        TreeView adminTreeView = (TreeView)this.getControl("administratortree");
        Set<Map<String, String>> adminDatas = this.getAdminisByParentId(nodeId);
        boolean addNodesToParent = this.addNodesToParent(adminDatas, adminTreeView, nodeId);
        if (!addNodesToParent) {
            return;
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView tv = (TreeView)treeNodeEvent.getSource();
        String nodeId = (String)treeNodeEvent.getNodeId();
        TreeNode focusAdminTreeNode = this.getFocusAdminTreeNodeFromCache();
        if (focusAdminTreeNode == null) {
            return;
        }
        String focusAdminId = focusAdminTreeNode.getId();
        TreeView adminTree = (TreeView)this.getView().getControl("administratortree");
        String curFocusNodeId = adminTree.getTreeState().getFocusNodeId();
        String curFocusParentNodeId = "";
        if (StringUtils.isEmpty((String)curFocusNodeId)) {
            curFocusNodeId = focusAdminId;
            curFocusParentNodeId = focusAdminTreeNode.getParentid();
        } else {
            curFocusParentNodeId = (String)adminTree.getTreeState().getFocusNode().get("parentid");
        }
        String parentAdminId = null;
        if (!curFocusNodeId.equals("-2")) {
            parentAdminId = this.getParentAdminId(curFocusNodeId);
        }
        if (StringUtils.isNotEmpty(parentAdminId) && !curFocusParentNodeId.equals(parentAdminId)) {
            curFocusParentNodeId = parentAdminId;
        }
        switch (tv.getKey()) {
            case "administratortree": {
                String preFocusAdminId = focusAdminId;
                this.getPageCache().put("admintreefocus_previous", preFocusAdminId);
                String eventInfo1 = "queryTreeNodeChildren_AdminTree_NewAdmin$" + nodeId;
                String eventInfo2 = "queryTreeNodeChildren_AdminTree_CurAdmin$" + nodeId + "$" + preFocusAdminId;
                if (this.checkNeedContinueEditNewAdmin(nodeId, eventInfo1) || this.checkNeedContinueEditCurAdmin(nodeId, eventInfo2)) break;
                this.queryAdminTreeNodeChildren(nodeId);
                break;
            }
            case "orgtree": {
                if (this.isVirtualAdmin(curFocusParentNodeId)) {
                    this.querySpecificTreeNodeChildren(tv, nodeId, "15");
                    break;
                }
                this.commonQueryTreeNodeChildren(tv, nodeId, "15", curFocusParentNodeId, "orgTreeLeftRoot");
                break;
            }
            case "adminorgtree": {
                if (nodeId.equals("-1")) {
                    return;
                }
                if (this.isVirtualAdmin(curFocusParentNodeId)) {
                    this.querySpecificTreeNodeChildren(tv, nodeId, "01");
                    break;
                }
                if (this.isVirtualAdmin(curFocusParentNodeId = this.getSuitableAdminId(curFocusParentNodeId))) {
                    this.querySpecificTreeNodeChildren(tv, nodeId, "01");
                    break;
                }
                this.commonQueryTreeNodeChildren(tv, nodeId, "01", curFocusParentNodeId, "AdminOrgTreeLeftRoot");
                break;
            }
            case "selectedorgtree": {
                this.commonQueryTreeNodeChildren(tv, nodeId, "15", curFocusNodeId, "orgTreeRightRoot");
                break;
            }
            case "selectedadminorgtree": {
                this.commonQueryTreeNodeChildren(tv, nodeId, "01", curFocusNodeId, "AdminOrgTreeRightRoot");
                break;
            }
            case "apptree": {
                break;
            }
            case "selectedapptree": {
                break;
            }
        }
    }

    private String getSuitableAdminId(String adminId) {
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)adminId) && ((orgDatas = this.queryOrgLongNumberByAdmin(adminId, "01")) == null || orgDatas.isEmpty())) {
            String newParentAdminId = null;
            for (int maxRecursiveLevel = 100; (orgDatas == null || orgDatas.isEmpty()) && maxRecursiveLevel > 0; --maxRecursiveLevel) {
                newParentAdminId = this.getParentAdminId(adminId);
                if (StringUtils.isEmpty((String)newParentAdminId) || "0".equals(newParentAdminId) || this.isVirtualAdmin(newParentAdminId)) {
                    adminId = this.getVirtualAdminId();
                    break;
                }
                orgDatas = this.queryOrgLongNumberByAdmin(newParentAdminId, "01");
                adminId = newParentAdminId;
            }
        }
        return adminId;
    }

    public void commonQueryTreeNodeChildren(TreeView tv, String nodeId, String orgViewType, String adminId, String treeRootCache) {
        if ("-1".equals(nodeId)) {
            return;
        }
        String orgDataCacheKey = null;
        String errorMsgNotInView = null;
        String errorMsgNotInView2 = null;
        if (orgViewType.equals("15")) {
            orgDataCacheKey = "_orgDatas";
            errorMsgNotInView = ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_45", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            errorMsgNotInView2 = ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_42", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        } else if (orgViewType.equals("01")) {
            orgDataCacheKey = "_AdminOrgDatas";
            errorMsgNotInView = ResManager.loadKDString((String)"\u8be5\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_46", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            errorMsgNotInView2 = ResManager.loadKDString((String)"\u90e8\u5206\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdministratorEditNewPlugin_44", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        }
        String orgDataStr = this.getPageCache().get(adminId + orgDataCacheKey);
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)orgDataStr) && !"[]".equals(orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        Map checkedNodeLongInfo = OrgServiceHelper.getOrgLongProperty((String)orgViewType, (long)Long.parseLong(nodeId));
        String checkedNodeLongNumber = (String)checkedNodeLongInfo.get("number");
        if (checkedNodeLongNumber == null) {
            this.getView().showTipNotification(errorMsgNotInView, Integer.valueOf(7000));
            return;
        }
        TreeNode treeRootNodeCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRootCache), TreeNode.class);
        TreeNode parentTreeNode = treeRootNodeCache.getTreeNode(nodeId, 100);
        int size = orgDatas.size();
        int i = 0;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        String lastLongNumber = "_";
        for (String string : orgDatas) {
            String[] orgDataArr = string.split("_split_");
            String orgName = orgDataArr[1];
            if (orgDataArr.length < 3) continue;
            String orgLongNumber = orgDataArr[2];
            if (null == orgLongNumber || orgName == null) {
                this.getView().showTipNotification(errorMsgNotInView2, Integer.valueOf(7000));
                ++i;
                continue;
            }
            if (orgLongNumber.equals(checkedNodeLongNumber) || !orgLongNumber.startsWith(checkedNodeLongNumber + "!")) {
                ++i;
                continue;
            }
            if (!orgLongNumber.startsWith(lastLongNumber + "!") && !orgLongNumber.equals(lastLongNumber)) {
                TreeNode node = new TreeNode();
                node.setParentid(nodeId);
                if (i + 1 < size) {
                    String nextOrg = (String)orgDatas.get(i + 1);
                    String[] orgDataArrNext = nextOrg.split("_split_");
                    if (orgDataArrNext.length < 3) continue;
                    String nextLongNumber = orgDataArrNext[2];
                    if (nextLongNumber.startsWith(orgLongNumber + "!")) {
                        node.setChildren(new ArrayList());
                    }
                }
                node.setId(orgDataArr[0]);
                node.setText(orgDataArr[1]);
                node.setLongNumber(orgDataArr[2]);
                nodes.add(node);
                lastLongNumber = orgLongNumber;
            }
            ++i;
        }
        tv.addNodes(nodes);
        if (parentTreeNode.isCheckable()) {
            tv.checkNodes(nodes);
            nodes.forEach(x -> x.setCheckable(true));
        }
        if (!CollectionUtils.isEmpty(nodes)) {
            if (parentTreeNode.getChildren() != null) {
                parentTreeNode.getChildren().addAll(nodes);
            } else {
                parentTreeNode.setChildren(nodes);
            }
            this.getPageCache().put(treeRootCache, SerializationUtils.toJsonString((Object)treeRootNodeCache));
        }
    }

    public void querySpecificTreeNodeChildren(TreeView tv, String nodeId, String orgViewType) {
        Long orgViewTypeLong = 15L;
        String orgRootCacheKey = null;
        if (orgViewType.equals("15")) {
            orgViewTypeLong = 15L;
            orgRootCacheKey = "orgTreeLeftRoot";
        } else if (orgViewType.equals("01")) {
            orgViewTypeLong = 1L;
            orgRootCacheKey = "AdminOrgTreeLeftRoot";
        }
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewTypeLong.longValue());
        param.setIncludeDisable(false);
        param.setIncludeFreeze(false);
        param.setId(Long.parseLong(nodeId));
        param.setOrderBy("longNumber");
        List childNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        tv.addNodes(childNodes);
        String orgTreeRootStr = this.getPageCache().get(orgRootCacheKey);
        TreeNode treeNode = null;
        TreeNode orgTreeRoot = null;
        if (StringUtils.isNotEmpty((String)orgTreeRootStr) && !"null".equals(orgTreeRootStr)) {
            orgTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)orgTreeRootStr, TreeNode.class);
            treeNode = orgTreeRoot.getTreeNode(nodeId, 100);
            if (treeNode.isCheckable()) {
                childNodes.stream().forEach(x -> x.setCheckable(true));
                tv.checkNodes(childNodes);
            }
            treeNode.addChildren(childNodes);
        }
        this.getPageCache().put(orgRootCacheKey, SerializationUtils.toJsonString(orgTreeRoot));
    }

    public static Map<String, Map<String, Object>> getOrgLongProperty(String ovType, Set<Long> orgIds) {
        HashMap<String, Map<String, Object>> mp = new HashMap<String, Map<String, Object>>();
        if (orgIds == null || orgIds.size() == 0) {
            return mp;
        }
        QFilter f1 = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter f3 = new QFilter("org", "in", orgIds);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), "bos_org_structure", "org,longnumber,fullname", new QFilter[]{f1, f2, f3});){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>();
                Row row = (Row)iter.next();
                map.put("number", row.getString("longnumber"));
                map.put("name", row.getString("fullname"));
                mp.put(row.getString("org"), map);
            }
        }
        return mp;
    }

    private boolean admin2Other(DynamicObject user) {
        Long userId = user.getLong("id");
        String tree2UserJson = this.getPageCache().get("treeNodeClickUserRelation");
        if (tree2UserJson != null) {
            DynamicObject treeNodeClickUserRelation = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)tree2UserJson, (IDataEntityType)user.getDataEntityType());
            String treeNodeClickUserId = treeNodeClickUserRelation.getPkValue().toString();
            String loginUserId = RequestContext.get().getUserId();
            String isFirstSave = this.getPageCache().get("firstSave");
            if (!treeNodeClickUserId.equals(userId.toString())) {
                this.getPageCache().put("perm2Other", "true");
                if (isFirstSave == null && loginUserId.equals(treeNodeClickUserId)) {
                    this.getPageCache().put("firstSave", "true");
                    String mes = String.format(ResManager.loadKDString((String)"\u82e5\u628a\u7ba1\u7406\u5458\u804c\u80fd\u79fb\u4ea4\u7ed9%1$s\uff0c\u9700\u7acb\u5373\u9000\u51fa\u5f53\u524d\u5e94\u7528", (String)"AdministratorEditNewPlugin_47", (String)"bos-permission-formplugin", (Object[])new Object[0]), user.get("name"));
                    this.getView().showConfirm(mes, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exitCallBack", (IFormPlugin)this));
                    return true;
                }
            }
            this.getPageCache().remove("firstSave");
        }
        return false;
    }

    private boolean deleteSelBizUnitTreeNodeCasacade(DynamicObject[] adminObjs) {
        boolean isEmpty = false;
        String toDeleteBizUnitIdsJson = this.getPageCache().get("todel_bizunitIds");
        if (StringUtils.isEmpty((String)toDeleteBizUnitIdsJson)) {
            return isEmpty;
        }
        Set toDeleteBizUnitIds = (Set)SerializationUtils.fromJsonString((String)toDeleteBizUnitIdsJson, Set.class);
        StringBuilder name = new StringBuilder();
        StringBuilder sbid = new StringBuilder();
        String toAddBizUnitIdsJson = this.getPageCache().get("toadd_bizunitIds");
        Set toAddBizUnitIds = new HashSet();
        if (toAddBizUnitIdsJson != null) {
            toAddBizUnitIds = (Set)SerializationUtils.fromJsonString((String)toAddBizUnitIdsJson, Set.class);
        }
        String focusNodeJson = this.getPageCache().get("focus_AdminTreeNode");
        TreeNode focusNode = (TreeNode)SerializationUtils.fromJsonString((String)focusNodeJson, TreeNode.class);
        String focusNodeId = focusNode.getId();
        for (DynamicObject adminObj : adminObjs) {
            String adminId = adminObj.getPkValue().toString();
            DynamicObjectCollection bizUnitObjs = adminObj.getDynamicObjectCollection("bizlist");
            String adminUserName = adminObj.getDynamicObject("user").getString("name");
            if (bizUnitObjs == null) continue;
            for (int i = bizUnitObjs.size() - 1; i >= 0; --i) {
                DynamicObject object = (DynamicObject)bizUnitObjs.get(i);
                if (object == null || object.getDynamicObject("biznumber") == null) continue;
                String selBizUnitId = object.getDynamicObject("biznumber").getPkValue().toString();
                if (!toAddBizUnitIds.contains(selBizUnitId) && toDeleteBizUnitIds.contains(selBizUnitId)) {
                    bizUnitObjs.remove(i);
                }
                if (bizUnitObjs.size() != 0 || (!adminId.equals(focusNodeId) || !toAddBizUnitIds.isEmpty()) && adminId.equals(focusNodeId)) continue;
                name.append(adminUserName);
                name.append('\u3001');
                if (sbid.length() > 0) {
                    sbid.append('_');
                }
                sbid.append(adminId);
                isEmpty = true;
                break;
            }
            if (bizUnitObjs == null || bizUnitObjs.size() == 0) {
                adminObj.set("bizlist", null);
                continue;
            }
            adminObj.set("bizlist", (Object)bizUnitObjs);
        }
        this.getPageCache().put("toDeleteAdminObjsName", name.toString());
        this.getPageCache().put("toDeleteAdminObjsIds", sbid.toString());
        return isEmpty;
    }

    private boolean deleteSelAdminOrgTreeNode(DynamicObject[] adminObjs) {
        boolean isEmpty = false;
        String toDelAdminOrgIdsJson = this.getPageCache().get("todel_adminOrgIds");
        if (StringUtils.isEmpty((String)toDelAdminOrgIdsJson)) {
            return isEmpty;
        }
        Set toDelIds = (Set)SerializationUtils.fromJsonString((String)toDelAdminOrgIdsJson, Set.class);
        StringBuilder name = new StringBuilder();
        StringBuilder sbid = new StringBuilder();
        String focusNodeJson = this.getPageCache().get("focus_AdminTreeNode");
        TreeNode focusNode = (TreeNode)SerializationUtils.fromJsonString((String)focusNodeJson, TreeNode.class);
        String focusNodeId = focusNode.getId();
        block0: for (DynamicObject adminObj : adminObjs) {
            String adminId = adminObj.getPkValue().toString();
            DynamicObjectCollection adminOrgObjs = adminObj.getDynamicObjectCollection("entry_adminorg");
            String adminUserName = adminObj.getDynamicObject("user").getString("name");
            if (adminOrgObjs == null) continue;
            for (int i = adminOrgObjs.size() - 1; i >= 0; --i) {
                DynamicObject object = (DynamicObject)adminOrgObjs.get(i);
                if (object == null || object.getDynamicObject("adminorg") == null) continue;
                String selBizUnitId = object.getDynamicObject("adminorg").getPkValue().toString();
                if (toDelIds.contains(selBizUnitId)) {
                    adminOrgObjs.remove(i);
                }
                if (adminOrgObjs.size() != 0 || !adminId.equals(focusNodeId) && adminId.equals(focusNodeId)) continue;
                name.append(adminUserName).append('\u3001');
                if (sbid.length() > 0) {
                    sbid.append('_');
                }
                sbid.append(adminId);
                isEmpty = true;
                continue block0;
            }
            if (adminOrgObjs == null || adminOrgObjs.size() == 0) {
                adminObj.set("entry_adminorg", null);
                continue;
            }
            adminObj.set("entry_adminorg", (Object)adminOrgObjs);
        }
        return isEmpty;
    }

    private boolean deleteSelAppTreeNode(DynamicObject[] adminObjs) {
        boolean isEmpty = false;
        String toDelIdsJson = this.getPageCache().get("todel_appIds");
        if (StringUtils.isEmpty((String)toDelIdsJson)) {
            return isEmpty;
        }
        Set toDelIds = (Set)SerializationUtils.fromJsonString((String)toDelIdsJson, Set.class);
        StringBuilder name = new StringBuilder();
        StringBuilder sbid = new StringBuilder();
        String focusNodeJson = this.getPageCache().get("focus_AdminTreeNode");
        TreeNode focusNode = (TreeNode)SerializationUtils.fromJsonString((String)focusNodeJson, TreeNode.class);
        String focusNodeId = focusNode.getId();
        block0: for (DynamicObject adminObj : adminObjs) {
            String adminId = adminObj.getPkValue().toString();
            DynamicObjectCollection appObjs = adminObj.getDynamicObjectCollection("entry_app");
            String adminUserName = adminObj.getDynamicObject("user").getString("name");
            if (appObjs == null) continue;
            for (int i = appObjs.size() - 1; i >= 0; --i) {
                DynamicObject object = (DynamicObject)appObjs.get(i);
                if (object == null || object.getDynamicObject("app") == null) continue;
                String selId = object.getDynamicObject("app").getPkValue().toString();
                if (toDelIds.contains(selId + "#app")) {
                    appObjs.remove(i);
                }
                if (appObjs.size() != 0 || !adminId.equals(focusNodeId) && adminId.equals(focusNodeId)) continue;
                name.append(adminUserName).append('\u3001');
                if (sbid.length() > 0) {
                    sbid.append('_');
                }
                sbid.append(adminId);
                isEmpty = true;
                continue block0;
            }
            if (appObjs == null || appObjs.size() == 0) {
                adminObj.set("entry_app", null);
                continue;
            }
            adminObj.set("entry_app", (Object)appObjs);
        }
        return isEmpty;
    }

    private DynamicObject[] loadFocusNodeAndChildren() {
        DynamicObject[] allAdminObjs = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id,user,parent", (QFilter[])new QFilter[]{this.getAdminTypeFilter()});
        HashSet<String> userIds = new HashSet<String>();
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        if (user != null) {
            this.findChildren(allAdminObjs, user.getPkValue().toString(), userIds, true);
        }
        HashSet<Long> userLongIds = new HashSet<Long>(userIds.size());
        for (String userId : userIds) {
            userLongIds.add(Long.valueOf(userId));
        }
        QFilter userFilter = new QFilter("user", "in", userLongIds);
        QFilter[] filters = new QFilter[]{userFilter, this.getAdminTypeFilter()};
        DynamicObject[] aminObjs = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id,bizlist,user,bizlist.biznumber,parent,entry_adminorg.adminorg, entry_app.app", (QFilter[])filters);
        return aminObjs;
    }

    private List<Long> getAllAdminUserIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user", null);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dObj : dynamicObjects) {
                Long userId = dObj.getLong("user_id");
                if (userId == null || userId == 0L) continue;
                ids.add(userId);
            }
        }
        return ids;
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        TreeView tv = (TreeView)event.getSource();
        String nodeId = (String)event.getNodeId();
        Boolean checked = event.getChecked();
        String treeViewKey = tv.getKey();
        Map focusNode = tv.getTreeState().getFocusNode();
        if ("-1".equals(nodeId)) {
            if (checked.booleanValue()) {
                if ("orgtree".equals(treeViewKey)) {
                    this.leftTreeNodeCheckAtRoot(tv, "orgTreeLeftRoot", "orgTreeLeftNodeIds");
                } else if ("adminorgtree".equals(treeViewKey)) {
                    this.leftTreeNodeCheckAtRoot(tv, "AdminOrgTreeLeftRoot", "AdminOrgTreeLeftNodeIds");
                } else if ("selectedorgtree".equals(treeViewKey)) {
                    this.rightTreeNodeCheckAtRoot(tv, "15");
                } else if ("selectedadminorgtree".equals(treeViewKey)) {
                    this.rightTreeNodeCheckAtRoot(tv, "01");
                }
            } else {
                tv.uncheckNodes(tv.getTreeState().getCheckedNodeIds());
                this.treeNodeUncheckAtRoot(treeViewKey);
            }
            return;
        }
        if (checked.booleanValue()) {
            boolean checkSelOrgTreeNode;
            if ("orgtree".equals(treeViewKey)) {
                this.checkLeftTreeNode(tv, nodeId, "15");
            } else if ("adminorgtree".equals(treeViewKey)) {
                this.checkLeftTreeNode(tv, nodeId, "01");
            } else if ("selectedorgtree".equals(treeViewKey) ? !(checkSelOrgTreeNode = this.checkRightTreeNode(tv, nodeId, "15")) : "selectedadminorgtree".equals(treeViewKey) && !(checkSelOrgTreeNode = this.checkRightTreeNode(tv, nodeId, "01"))) {
                return;
            }
        } else {
            this.uncheckTreeNode(tv, nodeId, treeViewKey);
        }
    }

    private void treeNodeUncheckAtRoot(String treeViewKey) {
        String treeNodeRootCache = null;
        if ("selectedorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeRightRoot";
            this.getPageCache().remove("orgTreerRightNodeIds");
        } else if ("orgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeLeftRoot";
            this.getPageCache().remove("orgTreeLeftNodeIds");
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeRightRoot";
            this.getPageCache().remove("AdminOrgTreeRightNodeIds");
        } else if ("adminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeLeftRoot";
            this.getPageCache().remove("AdminOrgTreeLeftNodeIds");
        }
        TreeNode treeNodeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeRootCache), TreeNode.class);
        treeNodeRoot.setCheckable(false);
        List children = treeNodeRoot.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)treeNodeRoot));
    }

    private void uncheckChildNodes(List<TreeNode> nodes) {
        if (!CollectionUtils.isEmpty(nodes)) {
            nodes.stream().forEach(x -> {
                x.setCheckable(false);
                List children = x.getChildren();
                this.uncheckChildNodes(children);
            });
        }
    }

    private void uncheckTreeNode(TreeView tv, String nodeId, String treeViewKey) {
        String nodesCacheKey = null;
        String orgRootNodeCacheKey = null;
        String orgDataCacheKey = null;
        String orgViewType = null;
        if ("orgtree".equals(treeViewKey)) {
            nodesCacheKey = "orgTreeLeftNodeIds";
            orgRootNodeCacheKey = "orgTreeLeftRoot";
            orgDataCacheKey = "_orgDatas";
            orgViewType = "15";
        } else if ("adminorgtree".equals(treeViewKey)) {
            nodesCacheKey = "AdminOrgTreeLeftNodeIds";
            orgRootNodeCacheKey = "AdminOrgTreeLeftRoot";
            orgDataCacheKey = "_AdminOrgDatas";
            orgViewType = "01";
        } else if ("selectedorgtree".equals(treeViewKey)) {
            nodesCacheKey = "orgTreerRightNodeIds";
            orgRootNodeCacheKey = "orgTreeRightRoot";
            orgDataCacheKey = "_orgDatas";
            orgViewType = "15";
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            nodesCacheKey = "AdminOrgTreeRightNodeIds";
            orgRootNodeCacheKey = "AdminOrgTreeRightRoot";
            orgDataCacheKey = "_AdminOrgDatas";
            orgViewType = "01";
        }
        String adminId = (String)this.getModel().getValue("admintreefocus");
        String orgDataStr = this.getPageCache().get(adminId + orgDataCacheKey);
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)orgDataStr) && !"[]".equals(orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        TreeNode rootNodeCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(orgRootNodeCacheKey), TreeNode.class);
        Set nodeIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(nodesCacheKey), Set.class);
        TreeNode treeNode = rootNodeCache.getTreeNode(nodeId, 100);
        treeNode.setCheckable(false);
        nodeIds.remove(nodeId);
        List children = treeNode.getChildren();
        if (!treeNode.getIsOpened() && children != null && children.size() == 0) {
            String longNumber = treeNode.getLongNumber();
            for (String string : orgDatas) {
                String[] orgDataArr = string.split("_split_");
                if (orgDataArr.length < 3) continue;
                String orgId = orgDataArr[0];
                String orglongNumber = orgDataArr[2];
                if (!orglongNumber.startsWith(longNumber + "!")) continue;
                nodeIds.remove(orgId);
            }
        }
        this.getPageCache().put(orgRootNodeCacheKey, SerializationUtils.toJsonString((Object)rootNodeCache));
        this.getPageCache().put(nodesCacheKey, SerializationUtils.toJsonString((Object)nodeIds));
    }

    public boolean checkRightTreeNode(TreeView tv, String nodeId, String orgViewType) {
        String treeNodeRootCache = null;
        String nodeIdsCacheKey = null;
        String errMsgNotExist = null;
        String orgdataCacheKey = null;
        if (orgViewType.equals("01")) {
            errMsgNotExist = ResManager.loadKDString((String)"\u89c6\u56fe\u4e2d\u4e0d\u5b58\u5728\u8be5\u884c\u653f\u7ec4\u7ec7\u3002", (String)"AdministratorEditNewPlugin_49", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            orgdataCacheKey = "_AdminOrgDatas";
            treeNodeRootCache = "AdminOrgTreeRightRoot";
            nodeIdsCacheKey = "AdminOrgTreeRightNodeIds";
        } else if (orgViewType.equals("15")) {
            errMsgNotExist = ResManager.loadKDString((String)"\u89c6\u56fe\u4e2d\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5355\u5143\u3002", (String)"AdministratorEditNewPlugin_50", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            orgdataCacheKey = "_orgDatas";
            treeNodeRootCache = "orgTreeRightRoot";
            nodeIdsCacheKey = "orgTreerRightNodeIds";
        }
        Map map = OrgServiceHelper.getOrgLongProperty((String)orgViewType, (long)Long.parseLong(nodeId));
        if (map == null || map.size() <= 0) {
            this.getView().showTipNotification(errMsgNotExist, Integer.valueOf(7000));
            return false;
        }
        List<Object> orgDatas = new ArrayList();
        String adminId = (String)this.getModel().getValue("admintreefocus");
        String orgDataStr = this.getPageCache().get(adminId + orgdataCacheKey);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        Set<String> ids = new HashSet<String>(100);
        String nodeIdsCache = this.getPageCache().get(nodeIdsCacheKey);
        if (StringUtils.isNotEmpty((String)nodeIdsCache)) {
            ids = (Set)SerializationUtils.fromJsonString((String)nodeIdsCache, Set.class);
        }
        ids.add(nodeId);
        TreeNode treeNodeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeRootCache), TreeNode.class);
        TreeNode parentNode = treeNodeRoot.getTreeNode(nodeId, 100);
        parentNode.setCheckable(true);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (String string : orgDatas) {
            String number;
            String[] orgDataArr = string.split("_split_");
            if (orgDataArr.length < 3 || (number = orgDataArr[2]) == null || !number.startsWith(map.get("number") + "!")) continue;
            TreeNode currentNode = treeNodeRoot.getTreeNode(orgDataArr[0], 100);
            if (currentNode != null) {
                currentNode.setCheckable(true);
                nodeList.add(currentNode);
            }
            ids.add(orgDataArr[0]);
        }
        tv.checkNodes(nodeList);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)treeNodeRoot));
        this.getPageCache().put(nodeIdsCacheKey, SerializationUtils.toJsonString(ids));
        return true;
    }

    public void rightTreeNodeCheckAtRoot(TreeView tv, String orgViewType) {
        String treeNodeIdsCacheKey = "";
        String orgCacheKeySuffix = "";
        String treeNodeRootCache = null;
        if (orgViewType.equals("15")) {
            treeNodeIdsCacheKey = "orgTreerRightNodeIds";
            orgCacheKeySuffix = "_orgDatas";
            treeNodeRootCache = "orgTreeRightRoot";
        } else if (orgViewType.equals("01")) {
            treeNodeIdsCacheKey = "AdminOrgTreeRightNodeIds";
            orgCacheKeySuffix = "_AdminOrgDatas";
            treeNodeRootCache = "AdminOrgTreeRightRoot";
        }
        String treeNodeIdsJson = this.getPageCache().get(treeNodeIdsCacheKey);
        Set<String> treeNodeIds = new HashSet(1000);
        if (StringUtils.isNotEmpty((String)treeNodeIdsJson)) {
            treeNodeIds = (Set)SerializationUtils.fromJsonString((String)treeNodeIdsJson, Set.class);
        }
        List<Object> orgDatas = new ArrayList(100);
        String adminId = (String)this.getModel().getValue("admintreefocus");
        String orgDataStr = this.getPageCache().get(adminId + orgCacheKeySuffix);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            if ("orgTreerRightNodeIds".equals(treeNodeIdsCacheKey)) {
                orgDatas = this.queryOrgLongNumberByAdmin(adminId, "15");
            } else if ("AdminOrgTreeRightNodeIds".equals(treeNodeIdsCacheKey)) {
                orgDatas = this.queryOrgLongNumberByAdmin(adminId, "01");
            }
        }
        TreeNode treeNodeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeRootCache), TreeNode.class);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(orgDatas.size());
        for (String string : orgDatas) {
            String[] orgDataArr = string.split("_split_");
            TreeNode currentNode = treeNodeRoot.getTreeNode(orgDataArr[0], 100);
            if (currentNode != null) {
                nodes.add(currentNode);
                currentNode.setCheckable(true);
            }
            treeNodeIds.add(orgDataArr[0]);
        }
        tv.checkNodes(nodes);
        this.getPageCache().put(treeNodeIdsCacheKey, SerializationUtils.toJsonString(treeNodeIds));
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)treeNodeRoot));
    }

    public void leftTreeNodeCheckAtRoot(TreeView tv, String treeNodeCacheKey, String leftTreeNodesCacheKey) {
        TreeNode rootOrgNode;
        String orgTreeLeftNodeIdsJson = this.getPageCache().get(leftTreeNodesCacheKey);
        HashSet<String> orgTreeLeftNodeIds = null;
        orgTreeLeftNodeIds = orgTreeLeftNodeIdsJson != null ? (HashSet<String>)SerializationUtils.fromJsonString((String)orgTreeLeftNodeIdsJson, Set.class) : new HashSet<String>(16);
        String orgTreeRootCache = this.getPageCache().get(treeNodeCacheKey);
        if (StringUtils.isNotEmpty((String)orgTreeRootCache) && (rootOrgNode = (TreeNode)SerializationUtils.fromJsonString((String)orgTreeRootCache, TreeNode.class)) != null) {
            rootOrgNode.setCheckable(true);
            List labelPara = rootOrgNode.getLabelPara();
            List childNodes_first = rootOrgNode.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childNodes_first)) {
                tv.checkNodes(childNodes_first);
                for (TreeNode childNode : childNodes_first) {
                    childNode.setCheckable(true);
                    orgTreeLeftNodeIds.add(childNode.getId());
                    List labelPara1 = childNode.getLabelPara();
                    this.getPageCache().put(leftTreeNodesCacheKey, SerializationUtils.toJsonString(orgTreeLeftNodeIds));
                    this.getPageCache().put(treeNodeCacheKey, SerializationUtils.toJsonString((Object)rootOrgNode));
                    tv.treeNodeCheck(childNode.getParentid(), childNode.getId(), Boolean.TRUE);
                }
            }
        }
    }

    private void checkLeftTreeNode(TreeView tv, String nodeId, String orgViewType) {
        String leftNodesCacheKey = null;
        String orgRootNodeCacheKey = null;
        String adminId = (String)this.getModel().getValue("parent");
        if (orgViewType.equals("15")) {
            leftNodesCacheKey = "orgTreeLeftNodeIds";
            orgRootNodeCacheKey = "orgTreeLeftRoot";
        } else if (orgViewType.equals("01")) {
            leftNodesCacheKey = "AdminOrgTreeLeftNodeIds";
            orgRootNodeCacheKey = "AdminOrgTreeLeftRoot";
            adminId = this.getSuitableAdminId(adminId);
        }
        String leftTreeNodeIdsJson = this.getPageCache().get(leftNodesCacheKey);
        Set<String> ids = new HashSet<String>(1000);
        if (StringUtils.isNotEmpty((String)leftTreeNodeIdsJson)) {
            ids = (Set)SerializationUtils.fromJsonString((String)leftTreeNodeIdsJson, Set.class);
        }
        ids.add(nodeId);
        List<Map<String, String>> childrenTreeDatas = this.getOrgChildrenTreeData(new ArrayList<Map<String, String>>(), Long.parseLong(nodeId), adminId, this.getAdminTypeStr(), orgViewType);
        TreeNode treeRootFromCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(orgRootNodeCacheKey), TreeNode.class);
        TreeNode parentTreeNode = treeRootFromCache.getTreeNode(nodeId, 100);
        parentTreeNode.setCheckable(true);
        ArrayList<TreeNode> nodes2Check = new ArrayList<TreeNode>(childrenTreeDatas.size());
        for (Map<String, String> childTreeDataMap : childrenTreeDatas) {
            String currentNodeId = childTreeDataMap.get("id");
            String parentNodeId = childTreeDataMap.get("parentid");
            TreeNode treeNode = treeRootFromCache.getTreeNode(currentNodeId, 100);
            if (treeNode != null) {
                nodes2Check.add(treeNode);
                treeNode.setCheckable(true);
            }
            ids.add(currentNodeId);
        }
        tv.checkNodes(nodes2Check);
        this.getPageCache().put(orgRootNodeCacheKey, SerializationUtils.toJsonString((Object)treeRootFromCache));
        this.getPageCache().put(leftNodesCacheKey, SerializationUtils.toJsonString(ids));
    }

    public List<Map<String, String>> getOrgChildrenTreeData(final List<Map<String, String>> orgTreeData, long parentid, String adminId, String adminTypeValue, String orgViewType) {
        String langName = RequestContext.get().getLang().name();
        String entryTableName = "";
        String entryKeyField = "";
        String orgViewTypeValue = "";
        if (orgViewType.equals("01")) {
            entryTableName = "t_perm_adminorgentry";
            entryKeyField = "fadminorgId";
            orgViewTypeValue = "1";
        } else if (orgViewType.equals("15")) {
            entryTableName = "t_perm_adminbizentry";
            entryKeyField = "fbizorgId";
            orgViewTypeValue = "15";
        }
        DynamicObject parentOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view", "=", (Object)Long.valueOf(orgViewTypeValue)), new QFilter("org.id", "=", (Object)parentid)});
        if (parentOrg == null) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT os.FORGID org,orgl.fname name,os.fparentid parent,os.fisleaf isleaf, os.FLONGNUMBER longnumber ");
        sqlBuilder.append(" from t_org_structure os ");
        if (!this.isVirtualAdmin(adminId)) {
            sqlBuilder.append(" left join ").append(entryTableName).append(" pae on pae.").append(entryKeyField).append(" = os.FORGID ");
            sqlBuilder.append(" left join t_perm_admin pa on pa.fid = pae.fid ");
        }
        sqlBuilder.append(" left join t_org_org torg on (torg.fid = os.FORGID and torg.fenable = '1') ");
        sqlBuilder.append(" inner join t_org_org_l orgl on (orgl.fid = torg.fid and orgl.flocaleid = '").append(langName).append("') ");
        sqlBuilder.append(" where os.FVIEWID = ").append(Long.parseLong(orgViewTypeValue)).append(" and os.FLONGNUMBER like  ? ").append(" and os.fisfreeze = '0' ");
        if (!this.isVirtualAdmin(adminId)) {
            sqlBuilder.append(" and pa.fid = ? ");
        }
        sqlBuilder.append(" order by longnumber ");
        Object[] params = null;
        if (!this.isVirtualAdmin(adminId)) {
            params = new SqlParameter[2];
            params[1] = new SqlParameter(":pa.fid", 12, (Object)adminId);
        } else {
            params = new SqlParameter[]{new SqlParameter(":os.FLONGNUMBER", 12, (Object)(parentOrg.getString("longnumber") + "!%"))};
        }
        DB.query((DBRoute)DBRoute.basedata, (String)sqlBuilder.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws KDException {
                try {
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        if (rs.getString("org") == null || rs.getString("org") != null && StringUtils.isEmpty((String)rs.getString("org"))) continue;
                        map.put("id", rs.getString("org") == null ? "0" : rs.getString("org"));
                        map.put("name", rs.getString("name") == null ? "" : rs.getString("name"));
                        map.put("parentid", rs.getString("parent") == null ? "0" : rs.getString("parent"));
                        map.put("isleaf", rs.getString("isleaf"));
                        map.put("longnumber", rs.getString("longnumber"));
                        orgTreeData.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return null;
            }
        });
        return orgTreeData;
    }

    private void updateDelIdsCache(Set<String> ids, boolean isToDelete, String toDelCacheKey) {
        String toDeleteIdsJson = this.getPageCache().get(toDelCacheKey);
        Set<String> toDeletegIdSet = new HashSet();
        if (StringUtils.isNotEmpty((String)toDeleteIdsJson)) {
            toDeletegIdSet = (Set)SerializationUtils.fromJsonString((String)toDeleteIdsJson, Set.class);
        }
        boolean idsChanged = false;
        idsChanged = isToDelete ? toDeletegIdSet.addAll(ids) : toDeletegIdSet.removeAll(ids);
        if (idsChanged) {
            this.getPageCache().put(toDelCacheKey, SerializationUtils.toJsonString(toDeletegIdSet));
        }
    }

    private void updateAddIdsCache(Set<String> ids, boolean isToAdd, String cacheKey) {
        String toAddIdsJson = this.getPageCache().get(cacheKey);
        Set<String> toAddIdSet = new HashSet();
        if (StringUtils.isNotEmpty((String)toAddIdsJson)) {
            toAddIdSet = (Set)SerializationUtils.fromJsonString((String)toAddIdsJson, Set.class);
        }
        boolean idsChanged = false;
        idsChanged = isToAdd ? toAddIdSet.addAll(ids) : toAddIdSet.removeAll(ids);
        if (idsChanged) {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(toAddIdSet));
        }
    }

    private String getMsg_notFoundRootAdminAndRepair() {
        return ResManager.loadKDString((String)"\u672a\u627e\u5230\u6839\u7ba1\u7406\u5458\uff0c\u8bf7\u4fee\u590d\u6570\u636e\u8bb0\u5f55\u3002", (String)"AdministratorEditNewPlugin_51", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getMsg_notFoundCurAdminAndRepair() {
        return ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u7ba1\u7406\u5458\u8bb0\u5f55\uff0c\u8bf7\u4fee\u590d\u6570\u636e\u8bb0\u5f55\u3002", (String)"AdministratorEditNewPlugin_52", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private boolean initSuperAdminTree(boolean isClick) {
        QFilter adminTypeFilter = this.getAdminTypeFilter();
        String userId = RequestContext.get().getUserId();
        TreeView adminTree = (TreeView)this.getView().getControl("administratortree");
        adminTree.deleteAllNodes();
        QFilter superadministratorfilter = new QFilter("type", "=", (Object)"10");
        DynamicObject superAdmin = null;
        try {
            superAdmin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id, user", (QFilter[])new QFilter[]{adminTypeFilter, superadministratorfilter});
        }
        catch (Exception e) {
            this.getView().showErrorNotification(this.getMsg_notFoundRootAdminAndRepair());
            logger.warn("initSuperAdminTree\u65b9\u6cd5\u901a\u8fc7loadSingleFromCache\u67e5\u8be2\u6839\u7ba1\u7406\u5458\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
        if (superAdmin == null) {
            this.getView().showErrorNotification(this.getMsg_notFoundRootAdminAndRepair());
            return false;
        }
        this.getPageCache().put("superAdminId", superAdmin.getString("id"));
        DynamicObject curAdmin = null;
        if (!superAdmin.getString("user_id").equals(userId)) {
            try {
                curAdmin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id, user, parent", (QFilter[])new QFilter[]{adminTypeFilter, new QFilter("user", "=", (Object)Long.valueOf(userId))});
            }
            catch (Exception e) {
                logger.warn("initSuperAdminTree\u65b9\u6cd5\u901a\u8fc7loadSingleFromCache\u67e5\u8be2\u5f53\u524d\u7ba1\u7406\u5458\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                this.getView().showErrorNotification(this.getMsg_notFoundCurAdminAndRepair());
                return false;
            }
            if (curAdmin == null) {
                this.getView().showErrorNotification(this.getMsg_notFoundCurAdminAndRepair());
                return false;
            }
        } else {
            curAdmin = superAdmin;
        }
        TreeNode rootNode = new TreeNode();
        DynamicObject superAdminUser = (DynamicObject)superAdmin.get("user");
        rootNode.setParentid("");
        rootNode.setId(superAdmin.getString("id"));
        rootNode.setText(superAdminUser.getString("name"));
        rootNode.setIsOpened(true);
        rootNode.setData((Object)superAdminUser.getLong("id"));
        TreeNode curAdminNode = null;
        if (curAdmin != superAdmin) {
            DynamicObject curAdminUser = curAdmin.getDynamicObject("user");
            curAdminNode = new TreeNode(superAdmin.getString("id"), curAdmin.getString("id"), curAdminUser.getString("name"));
            curAdminNode.setIsOpened(true);
            curAdminNode.setData((Object)curAdminUser.getLong("id"));
            if (curAdmin.getDynamicObject("parent") != null && curAdmin.getDynamicObject("parent").getPkValue() != null) {
                String parentid = curAdmin.getDynamicObject("parent").getPkValue().toString();
                this.getModel().setValue("parent", (Object)parentid);
            }
            rootNode.addChild(curAdminNode);
        }
        Set<Map<String, String>> datas = this.getAdminisByParentId(curAdmin.getString("id"));
        Iterator<Map<String, String>> nodeInfo = datas.iterator();
        while (nodeInfo.hasNext()) {
            TreeNode newNode = new TreeNode();
            Map<String, String> nodeData = nodeInfo.next();
            newNode.setParentid(curAdmin.getString("id"));
            newNode.setId(nodeData.get("id"));
            newNode.setText(nodeData.get("name"));
            if ("false".equals(nodeData.get("isleaf")) || "0".equals(nodeData.get("isleaf"))) {
                newNode.addChildren(new ArrayList());
            }
            newNode.setExpend(true);
            if (curAdmin != superAdmin) {
                curAdminNode.addChild(newNode);
                continue;
            }
            rootNode.addChild(newNode);
        }
        adminTree.addNode(rootNode);
        adminTree.focusNode(rootNode);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("adminTreeRootCache", SerializationUtils.toJsonString((Object)rootNode));
        if (isClick) {
            adminTree.treeNodeClick("", curAdmin.getString("id"));
        }
        return true;
    }

    private void initBizUnitTree() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(15L);
        param.setIncludeDisable(false);
        param.setIncludeFreeze(false);
        TreeNode firstOrgNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        TreeNode rootNode = new TreeNode();
        rootNode.setParentid("");
        rootNode.setId("-1");
        rootNode.setText(ResManager.loadKDString((String)"\u5f85\u9009\u4e1a\u52a1\u5355\u5143", (String)"AdministratorEditNewPlugin_41", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        rootNode.addChildren(new ArrayList());
        rootNode.setIsOpened(true);
        rootNode.addChild(firstOrgNode);
        if (firstOrgNode == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u89c6\u56fe\u662f\u5426\u6b63\u786e\u3002", (String)"AdministratorEditNewPlugin_53", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        param.setId(Long.parseLong(firstOrgNode.getId()));
        param.setOrderBy("longNumber");
        List childNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        firstOrgNode.setChildren(childNodes);
        TreeView tv = (TreeView)this.getControl("orgtree");
        tv.deleteAllNodes();
        tv.addNode(rootNode);
        firstOrgNode.setParentid("-1");
        tv.addNode(firstOrgNode);
        this.getPageCache().put("orgTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    private void initAdminOrgTree() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(1L);
        param.setIncludeDisable(false);
        param.setIncludeFreeze(false);
        TreeNode firstOrgNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        TreeNode rootNode = new TreeNode();
        rootNode.setParentid("");
        rootNode.setId("-1");
        rootNode.setText(ResManager.loadKDString((String)"\u5f85\u9009\u884c\u653f\u7ec4\u7ec7", (String)"AdministratorEditNewPlugin_43", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        rootNode.setIsOpened(true);
        rootNode.addChild(firstOrgNode);
        if (firstOrgNode == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6839\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"AdministratorEditNewPlugin_54", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        param.setId(Long.parseLong(firstOrgNode.getId()));
        param.setOrderBy("longNumber");
        List childNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        firstOrgNode.setChildren(childNodes);
        TreeView tv = (TreeView)this.getControl("adminorgtree");
        tv.deleteAllNodes();
        tv.addNode(rootNode);
        firstOrgNode.setParentid("-1");
        tv.addNode(firstOrgNode);
        this.getPageCache().put("AdminOrgTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    private void initAppTree(String treeViewKey, String adminId) {
        String appDataCache;
        boolean needLoadFromDB = true;
        TreeNode rootNode = new TreeNode();
        if (treeViewKey.equals("selectedapptree") && StringUtils.isNotEmpty((String)(appDataCache = this.getPageCache().get(adminId + "_AppDatas")))) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)appDataCache, TreeNode.class);
            needLoadFromDB = false;
        }
        if ("-1".equals(adminId)) {
            needLoadFromDB = false;
        }
        if (needLoadFromDB) {
            rootNode = this.queryAppRootNodeByAdmin(adminId, treeViewKey);
            if (StringUtils.isNotEmpty((String)adminId) && treeViewKey.equals("selectedapptree")) {
                this.getPageCache().put(adminId + "_AppDatas", SerializationUtils.toJsonString((Object)rootNode));
            }
        }
        TreeView tv = (TreeView)this.getControl(treeViewKey);
        tv.deleteAllNodes();
        tv.addNode(rootNode);
    }

    private void showBaseInfo(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter, this.getAdminTypeFilter()};
        DynamicObject admin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id,user,type", (QFilter[])filters);
        DynamicObject user = (DynamicObject)admin.get("user");
        this.getModel().setValue("user", user.getPkValue());
        this.getModel().setValue("type", admin.get("type"));
    }

    private Set<Map<String, String>> getAdminisByParentId(String parentId) {
        String langStr = RequestContext.get().getLang().name();
        QFilter adminTypeFilter = this.getAdminTypeFilter();
        QFilter superadministratorfilter = new QFilter("parent", "=", (Object)parentId);
        DynamicObject[] userCollection = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id, user, isleaf", (QFilter[])new QFilter[]{superadministratorfilter, adminTypeFilter});
        HashSet<Map<String, String>> administratorSet = new HashSet<Map<String, String>>();
        for (DynamicObject administratorObject : userCollection) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject user = (DynamicObject)administratorObject.get("user");
            if (user == null) continue;
            map.put("isleaf", administratorObject.getString("isleaf"));
            map.put("id", administratorObject.getString("id"));
            map.put("name", ((ILocaleString)user.get("name")).get((Object)langStr));
            administratorSet.add(map);
        }
        return administratorSet;
    }

    private boolean addNodesToParent(Collection<Map<String, String>> dataInfo, TreeView treeView, String parentNodeId) {
        Iterator<Map<String, String>> nodeInfo = dataInfo.iterator();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(dataInfo.size());
        String orgTreeRootStr = this.getPageCache().get("orgTreeLeftRoot");
        TreeNode treeNode = null;
        TreeNode orgTreeRoot = null;
        if (StringUtils.isNotEmpty((String)orgTreeRootStr) && !"null".equals(orgTreeRootStr)) {
            orgTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)orgTreeRootStr, TreeNode.class);
            treeNode = orgTreeRoot.getTreeNode(parentNodeId, 100);
        }
        String adminTreeRootJson = this.getPageCache().get("adminTreeRootCache");
        TreeNode adminTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)adminTreeRootJson, TreeNode.class);
        TreeNode adminParentNode = adminTreeRoot.getTreeNode(parentNodeId, 100);
        TreeNode firstChildNode = null;
        while (nodeInfo.hasNext()) {
            TreeNode newNode = new TreeNode();
            Map<String, String> nodeData = nodeInfo.next();
            String nodeId = nodeData.get("id");
            if ("0".equals(nodeId)) continue;
            newNode.setParentid(parentNodeId);
            newNode.setId(nodeId);
            newNode.setText(nodeData.get("name"));
            if ("false".equals(nodeData.get("isleaf")) || "0".equals(nodeData.get("isleaf"))) {
                newNode.addChildren(new ArrayList());
            }
            if (treeView.getKey().equals("orgtree")) {
                if (null != treeNode) {
                    treeNode.addChild(newNode);
                }
            } else if (treeView.getKey().equals("administratortree")) {
                adminParentNode.addChild(newNode);
                if (firstChildNode == null) {
                    firstChildNode = newNode;
                }
            }
            nodes.add(newNode);
            if ("administratortree".equals(treeView.getKey())) {
                boolean refreshPageCache = this.refreshPageCache(newNode, true, false);
                if (refreshPageCache) continue;
                return false;
            }
            if (!"orgtree".equals(treeView.getKey())) continue;
            treeView.checkNode(newNode);
        }
        this.getPageCache().put("orgTreeLeftRoot", SerializationUtils.toJsonString((Object)orgTreeRoot));
        this.getPageCache().put("adminTreeRootCache", SerializationUtils.toJsonString((Object)adminTreeRoot));
        treeView.addNodes(nodes);
        if (firstChildNode != null) {
            treeView.focusNode(firstChildNode);
            treeView.treeNodeClick(firstChildNode.getParentid(), firstChildNode.getId());
        }
        return true;
    }

    private void adjustOrg(boolean isAdd, String orgViewType, Set<String> nodeIds) {
        this.adjustEntry(nodeIds, isAdd, orgViewType);
        this.buildSelectedOrgTree(orgViewType);
    }

    private void adjustEntry(Set<String> nodeIds, boolean isAdd, String orgViewType) {
        String langName = RequestContext.get().getLang().name();
        String orgCacheKeySuffix = null;
        if (orgViewType.equals("15")) {
            orgCacheKeySuffix = "_orgDatas";
        } else if (orgViewType.equals("01")) {
            orgCacheKeySuffix = "_AdminOrgDatas";
        }
        List<Object> orgDatas = new ArrayList();
        String adminId = (String)this.getModel().getValue("admintreefocus");
        String orgDataStr = this.getPageCache().get(adminId + orgCacheKeySuffix);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        if (isAdd) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = nodeIds.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next()).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT os.forgid,o.fname,os.flongnumber FROM t_org_org_l o ");
            sql.append(" left join T_ORG_Structure os on (o.fid=os.forgid and o.flocaleid = '").append(langName).append("') ");
            sql.append(" left join t_org_viewschema ov on ov.fid = os.fviewid ");
            sql.append(" where  ov.FID = ").append(Long.parseLong(orgViewType)).append(" and ov.FISDEFAULT = '1' ");
            sql.append(" and o.fid in (").append((CharSequence)sb).append(')');
            sql.append(" and o.FLOCALEID='").append(langName).append("' ");
            sql.append(" order by os.flongnumber ");
            Set orgAddDatas = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws SQLException {
                    HashSet<String> set = new HashSet<String>(1000);
                    while (rs.next()) {
                        String orgsAndLongNumber = rs.getString(1) + "_split_" + rs.getString(2) + "_split_" + rs.getString(3);
                        set.add(orgsAndLongNumber);
                    }
                    return set;
                }
            });
            HashSet orgDatas_ = new HashSet(orgDatas);
            orgDatas_.addAll(orgAddDatas);
            orgDatas = new ArrayList(orgDatas_);
            orgDatas.sort(new Comparator<String>(){

                @Override
                public int compare(String org1, String org2) {
                    String[] orgFromArr = org1.split("_split_");
                    String[] orgToArr = org2.split("_split_");
                    if (orgFromArr.length < 3 || orgToArr.length < 3) {
                        return 0;
                    }
                    String orgId1 = orgFromArr[2];
                    String orgId2 = orgToArr[2];
                    return orgId1.compareTo(orgId2);
                }
            });
        }
        this.getPageCache().put(adminId + orgCacheKeySuffix, SerializationUtils.toJsonString(orgDatas));
    }

    private void buildSelectedOrgTree(String orgViewType) {
        String adminId = (String)this.getModel().getValue("admintreefocus");
        if (this.isVirtualAdmin(adminId)) {
            return;
        }
        String selTreeKey = null;
        String rootNodeText = "";
        String orgDataCacheKey = "";
        String treeNodeRootCache = null;
        if (orgViewType.equals("15")) {
            selTreeKey = "selectedorgtree";
            rootNodeText = this.getSelBizUnitRootText();
            orgDataCacheKey = "_orgDatas";
            treeNodeRootCache = "orgTreeRightRoot";
        } else if (orgViewType.equals("01")) {
            selTreeKey = "selectedadminorgtree";
            rootNodeText = this.getSelAdminOrgRootNodeText();
            orgDataCacheKey = "_AdminOrgDatas";
            treeNodeRootCache = "AdminOrgTreeRightRoot";
        }
        TreeView tree = (TreeView)this.getControl(selTreeKey);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("-1");
        root.setText(rootNodeText);
        root.setIsOpened(true);
        String lastLongNumber = "_";
        String orgDataStr = this.getPageCache().get(adminId + orgDataCacheKey);
        List<Object> orgDatas = new ArrayList();
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgDatas = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else if (StringUtils.isNotEmpty((String)adminId)) {
            orgDatas = this.queryOrgLongNumberByAdmin(adminId, orgViewType);
        }
        int size = orgDatas.size();
        int i = 0;
        String firstOrgNodeId = null;
        for (String string : orgDatas) {
            String[] orgDataArr = string.split("_split_");
            if (orgDataArr.length < 3) continue;
            String orgId = orgDataArr[0];
            String orgName = orgDataArr[1];
            String orglongNumber = orgDataArr[2];
            if (null == orgId || orglongNumber.startsWith(lastLongNumber + "!") || orglongNumber.equals(lastLongNumber)) {
                ++i;
                continue;
            }
            TreeNode newNode = new TreeNode();
            newNode.setParentid("-1");
            newNode.setId(orgId);
            firstOrgNodeId = orgId;
            newNode.setText(orgName);
            if (i + 1 < size) {
                String nextOrgData = (String)orgDatas.get(i + 1);
                String[] orgDataArrNext = nextOrgData.split("_split_");
                if (orgDataArrNext.length < 3) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (nextLongNumber.startsWith(orglongNumber + "!")) {
                    newNode.addChildren(new ArrayList());
                }
            }
            lastLongNumber = orglongNumber;
            root.addChild(newNode);
            ++i;
        }
        if (size == 0) {
            if (orgViewType.equals("15")) {
                root.setText(this.getSelBizUnitRootText());
            } else if (orgViewType.equals("01")) {
                root.setText(this.getSameAsParentRootNodeText());
            }
        } else if (orgViewType.equals("15")) {
            root.setText(this.getSelBizUnitRootText());
        } else if (orgViewType.equals("01")) {
            root.setText(this.getSelAdminOrgRootNodeText());
        }
        tree.addNode(root);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)root));
        if (StringUtils.isNotEmpty(firstOrgNodeId)) {
            tree.queryTreeNodeChildren("-1", firstOrgNodeId);
            tree.expand(firstOrgNodeId);
        }
    }

    private String getSelAdminOrgRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u884c\u653f\u7ec4\u7ec7", (String)"AdministratorEditNewPlugin_55", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSelBizUnitRootText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u4e1a\u52a1\u5355\u5143", (String)"AdministratorEditNewPlugin_56", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private void buildSelectedAppTree() {
        String adminId = (String)this.getModel().getValue("admintreefocus");
        if (!this.isVirtualAdmin(adminId)) {
            this.loadSelAppTree(adminId);
        }
    }

    private void loadData(String adminId) {
        QFilter administratorfilter = new QFilter("id", "=", (Object)adminId);
        DynamicObject admin = BusinessDataServiceHelper.loadSingle((String)"perm_admin", (String)"id,user,entryentity.admin_exception_user", (QFilter[])new QFilter[]{administratorfilter, this.getAdminTypeFilter()});
        if (null == admin) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection extraUsers = admin.getDynamicObjectCollection("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("admin_exception_user", new Object[0]);
        for (DynamicObject extraUser : extraUsers) {
            DynamicObject user;
            if (extraUser == null || null == (user = extraUser.getDynamicObject("admin_exception_user")) || !StringUtils.isNotEmpty((String)user.getString("id"))) continue;
            vs.addRow(new Object[]{user.getString("id")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.queryOrgLongNumberByAdmin(adminId, "15");
        this.queryOrgLongNumberByAdmin(adminId, "01");
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private List<String> queryOrgLongNumberByAdmin(String adminId, String orgViewType) {
        String langName = RequestContext.get().getLang().name();
        String entryTableName = "";
        String entryKeyField = "";
        String orgDataCacheKey = "";
        if (orgViewType.equals("01")) {
            entryTableName = "t_perm_adminorgentry";
            entryKeyField = "fadminorgId";
            orgDataCacheKey = adminId + "_AdminOrgDatas";
        } else if (orgViewType.equals("15")) {
            entryTableName = "t_perm_adminbizentry";
            entryKeyField = "fbizorgId";
            orgDataCacheKey = adminId + "_orgDatas";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT os.forgid,o.fname,os.flongnumber ").append(" FROM ").append(entryTableName).append(" pa ").append(" left join t_org_org org on (org.fid=pa.").append(entryKeyField).append(" and org.fenable = '1')").append(" inner join t_org_org_l o on (org.fid = o.fid and o.FLOCALEID = '").append(langName).append("') ").append(" left join T_ORG_Structure os on pa.").append(entryKeyField).append(" =os.forgid ").append(" left join t_org_viewschema ov on ov.fid = os.fviewid ").append(" where  ov.FID = ").append(Long.parseLong(orgViewType)).append(" and ov.FISDEFAULT = '1' ").append(" and os.fisfreeze = '0' ").append(" and o.FLOCALEID='").append(langName).append("' ").append(" and pa.fid = '").append(adminId).append("' ").append(" order by os.flongnumber ");
        List orgDatas = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(1000);
                while (rs.next()) {
                    String orgsAndLongNumber = rs.getString(1) + "_split_" + rs.getString(2) + "_split_" + rs.getString(3);
                    list.add(orgsAndLongNumber);
                }
                return list;
            }
        });
        orgDatas.sort(new Comparator<String>(){

            @Override
            public int compare(String org1, String org2) {
                String[] orgFromArr = org1.split("_split_");
                String[] orgToArr = org2.split("_split_");
                if (orgFromArr.length < 3 || orgToArr.length < 3) {
                    return 0;
                }
                String orgId1 = orgFromArr[2];
                String orgId2 = orgToArr[2];
                return orgId1.compareTo(orgId2);
            }
        });
        this.getPageCache().put(orgDataCacheKey, SerializationUtils.toJsonString((Object)orgDatas));
        return orgDatas;
    }

    private boolean deleteAdmin(String[] forDeleteIdsArr) {
        TreeView adminTree = (TreeView)this.getControl("administratortree");
        String nodeId = adminTree.getTreeState().getFocusNodeId();
        Set<String> forDelAdminIds = null;
        forDelAdminIds = forDeleteIdsArr != null && forDeleteIdsArr.length > 0 ? new HashSet<String>(Arrays.asList(forDeleteIdsArr)) : this.toDeleteNodeIds(nodeId);
        forDelAdminIds.removeIf(id -> StringUtils.isEmpty((String)id));
        ArrayList<Long> userIds = new ArrayList<Long>();
        ArrayList<String> forUpdateParentAdminIds = new ArrayList<String>();
        DynamicObject[] forDelAdmins = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user, parent", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelAdminIds), this.getAdminTypeFilter()});
        if (forDelAdmins != null && forDelAdmins.length > 0) {
            for (DynamicObject dynamicObject : forDelAdmins) {
                DynamicObject user = dynamicObject.getDynamicObject("user");
                if (user == null) continue;
                userIds.add(user.getLong("id"));
                DynamicObject parentAdminObj = dynamicObject.getDynamicObject("parent");
                if (parentAdminObj == null) continue;
                forUpdateParentAdminIds.add(parentAdminObj.getString("id"));
                DynamicObject parentAdminUserObj = parentAdminObj.getDynamicObject("user");
                if (parentAdminUserObj == null) continue;
                userIds.add(parentAdminUserObj.getLong("id"));
            }
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"perm_admin");
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])forDelAdminIds.toArray());
        this.getPageCache().remove("dataChanged");
        if (userIds != null && userIds.size() > 0) {
            UserAppCache.removeCache(userIds);
            UserMenuCache.removeUserMenuAllCache();
        }
        AdminUserCache.removeAllCache();
        ArrayList<TreeNode> forUpdateParentNodes = new ArrayList<TreeNode>();
        if (forUpdateParentAdminIds != null && !forUpdateParentAdminIds.isEmpty()) {
            DynamicObject[] dynamicObjectArray;
            DynamicObject[] parentsArr;
            for (DynamicObject parentElement : parentsArr = BusinessDataServiceHelper.load((String)"perm_admin", (String)"parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", forUpdateParentAdminIds), this.getAdminTypeFilter()})) {
                DynamicObject parentObj;
                if (parentElement == null || (parentObj = parentElement.getDynamicObject("parent")) == null) continue;
                forUpdateParentAdminIds.remove(parentObj.getString("id"));
            }
            if (forUpdateParentAdminIds != null && !forUpdateParentAdminIds.isEmpty() && (dynamicObjectArray = BusinessDataServiceHelper.load((String)"perm_admin", (String)"id, parent, isleaf, user", (QFilter[])new QFilter[]{new QFilter("id", "in", forUpdateParentAdminIds), this.getAdminTypeFilter()})) != null && dynamicObjectArray.length > 0) {
                for (DynamicObject forUpdateParentAdmin : dynamicObjectArray) {
                    DynamicObject user;
                    forUpdateParentAdmin.set("isleaf", (Object)Boolean.TRUE);
                    String parentAdminId = "";
                    String adminUserName = "";
                    DynamicObject parentAdmin = forUpdateParentAdmin.getDynamicObject("parent");
                    if (parentAdmin != null) {
                        parentAdminId = parentAdmin.getString("id");
                    }
                    if ((user = forUpdateParentAdmin.getDynamicObject("user")) != null) {
                        adminUserName = user.getString("name");
                    }
                    forUpdateParentNodes.add(new TreeNode(parentAdminId, forUpdateParentAdmin.getString("id"), adminUserName, false));
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
            }
        }
        ArrayList<Object> forDelAdminIdList = new ArrayList();
        if (forDelAdminIds != null && !forDelAdminIds.isEmpty()) {
            forDelAdminIdList = new ArrayList<String>(forDelAdminIds);
        }
        adminTree.deleteNodes(forDelAdminIdList);
        if (forUpdateParentNodes != null && !forUpdateParentNodes.isEmpty()) {
            adminTree.updateNodes(forUpdateParentNodes);
        }
        String string = this.getModel().getValue("admintreefocus").toString();
        TreeNode adminRootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        TreeNode focusAminNode = adminRootNode.getTreeNode(string, 100);
        TreeNode focusParentAminNode = adminRootNode.getTreeNode(focusAminNode.getParentid(), 100);
        adminTree.focusNode(new TreeNode(focusParentAminNode.getParentid(), focusParentAminNode.getId(), focusParentAminNode.getText()));
        adminTree.treeNodeClick(focusParentAminNode.getParentid(), focusParentAminNode.getId());
        this.deleteAdminNodeFromCache(forDelAdminIds);
        this.getPageCache().remove("addNew");
        this.getPageCache().remove("changeadmin");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AdministratorEditNewPlugin_57", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        return true;
    }

    private Set<String> toDeleteNodeIds(String nodeId) {
        TreeNode tn = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        TreeNode selNode = tn.getTreeNode(nodeId, 100);
        HashSet<String> set = new HashSet<String>();
        if (selNode == null) {
            set.add("-2");
            return set;
        }
        selNode.iterate(100, n -> set.add(n.getId()));
        return set;
    }

    private void deleteAdminNodeFromCache(Set<String> forDelAdminIds) {
        TreeNode tn = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        for (String forDelAdminId : forDelAdminIds) {
            tn.deleteChildNode(forDelAdminId);
        }
        this.getPageCache().put("adminTreeRootCache", SerializationUtils.toJsonString((Object)tn));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IDataModel model = this.getModel();
        boolean ifChanged = StringUtils.isNotEmpty((String)this.getPageCache().get("dataChanged"));
        if (ifChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeCloseConfirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AdministratorEditNewPlugin_58", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AdministratorEditNewPlugin_59", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AdministratorEditNewPlugin_60", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, model.getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            e.setCancel(true);
        }
    }

    private boolean checkIfFocusAdminUserHasChanged() {
        Long curFocusAdminUserId = this.getCurFocusAdminUserId();
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        return user != null && curFocusAdminUserId.longValue() != user.getLong("id");
    }

    private Long getCurFocusAdminUserId() {
        String strUserId = this.getPageCache().get("pgCache_focusAdmin_userId");
        if (StringUtils.isNotEmpty((String)strUserId)) {
            return Long.valueOf(strUserId);
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("user".equals(key)) {
            ListShowParameter listShowPara = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilters = listShowPara.getListFilterParameter().getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>();
            }
            qFilters.add(new QFilter("usertype", "in", (Object)"1"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("isforbidden", "=", (Object)"0"));
            Iterator it = qFilters.iterator();
            while (it.hasNext()) {
                QFilter filter = (QFilter)it.next();
                if (!filter.getProperty().equals("id")) continue;
                it.remove();
            }
            List<Long> allAdminUserIds = this.getAllAdminUserIds();
            if (this.checkIfFocusAdminUserHasChanged()) {
                Long curSelUserId;
                Long curFocusAdminUserId = this.getCurFocusAdminUserId();
                DynamicObject userObj = (DynamicObject)this.getModel().getValue("user");
                if (userObj != null && (curSelUserId = Long.valueOf(userObj.getLong("id"))) != 0L) {
                    allAdminUserIds.add(curSelUserId);
                }
                allAdminUserIds.removeIf(userId -> Long.valueOf(userId.toString()).equals(curFocusAdminUserId));
            }
            qFilters.add(new QFilter("id", "not in", allAdminUserIds));
            String userId2 = RequestContext.get().getUserId();
            boolean isVirtualAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(userId2), (String)"10");
            if (!isVirtualAdmin) {
                listShowPara.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            }
        } else if ("admin_exception_user".equals(key)) {
            ArrayList<Long> hasSelUsers = new ArrayList<Long>();
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                Long curRowUserId;
                DynamicObject curRowUser = (DynamicObject)this.getModel().getValue("admin_exception_user", i);
                if (curRowUser == null || (curRowUserId = Long.valueOf(curRowUser.getLong("id"))) == 0L) continue;
                hasSelUsers.add(curRowUserId);
            }
            QFilter filter = new QFilter("id", "not in", hasSelUsers);
            ListShowParameter listShowPara = (ListShowParameter)evt.getFormShowParameter();
            listShowPara.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private String getParentAdminId(String adminId) {
        if (StringUtils.isEmpty((String)adminId)) {
            return null;
        }
        DynamicObject doc = BusinessDataServiceHelper.loadSingleFromCache((Object)adminId, (String)"perm_admin", (String)"parent");
        DynamicObject parentDObj = doc.getDynamicObject("parent");
        if (parentDObj != null) {
            return parentDObj.getString("id");
        }
        return null;
    }

    private boolean isNewAdminEdit() {
        String addNewAdminStatus = this.getPageCache().get("addNew");
        return StringUtils.isNotEmpty((String)addNewAdminStatus);
    }

    private void clearNewAdmin() {
        this.getPageCache().remove("addNew");
        this.getPageCache().remove("changeadmin");
        this.getPageCache().remove("dataChanged");
        this.getPageCache().remove("orgTreeRightRoot");
        this.getPageCache().remove("AdminOrgTreeRightRoot");
        this.getPageCache().remove("-2_orgDatas");
        this.getPageCache().remove("-2_AdminOrgDatas");
        this.getPageCache().remove("-2_AppDatas");
        TreeView adminTree = (TreeView)this.getControl("administratortree");
        adminTree.deleteNode("-2");
        TreeNode newAdminNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("focus_AdminTreeNode"), TreeNode.class);
        TreeNode adminRootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("adminTreeRootCache"), TreeNode.class);
        TreeNode forDelParentAminNode = adminRootNode.getTreeNode(newAdminNode.getParentid(), 100);
        List childrenNodes = forDelParentAminNode.getChildren();
        if (childrenNodes == null || childrenNodes.isEmpty()) {
            adminTree.updateNode(new TreeNode(forDelParentAminNode.getParentid(), forDelParentAminNode.getId(), forDelParentAminNode.getText(), false));
        }
    }

    private String getVirtualAdminId() {
        return this.getPageCache().get("superAdminId");
    }

    private boolean isVirtualAdmin(String adminId) {
        return this.getVirtualAdminId().equals(adminId);
    }

    public void tabSelected(TabSelectEvent e) {
        String allCloudCache;
        String tabKey = e.getTabKey();
        if (tabKey.equals("tabpage_app") && StringUtils.isEmpty((String)(allCloudCache = this.getPageCache().get("pgCache_allCloudInfo")))) {
            this.initialAllCloudAppCache();
        }
    }

    private void initialAllCloudAppCache() {
        String langName = RequestContext.get().getLang().name();
        StringBuilder sb = new StringBuilder().append("SELECT DISTINCT cloudl.fid AS cloudId, cloudl.fname AS cloudName, ").append("app.fid AS appId, applr.fname as appName, appl.fname as appName2 ").append("FROM t_meta_bizapp app ").append("INNER JOIN t_meta_bizapp_l appl ON (app.fid = appl.fid and appl.flocaleid = '").append(langName).append("') ").append("LEFT JOIN t_meta_appruntime_l applr ON (applr.fappid = app.fnumber and applr.flocaleid = '").append(langName).append("') ").append("INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.fbizcloudid and cloudl.flocaleid = '").append(langName).append("') ").append("WHERE app.falluserapp = '0' and app.fparentid = ' ' order by cloudId ");
        final HashMap cloudMap = new HashMap();
        final ArrayList cloudNodes = new ArrayList();
        final ArrayList appNodes = new ArrayList();
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String cloudId = rs.getString("cloudId");
                    String cloudName = rs.getString("cloudName");
                    String appId = rs.getString("appId");
                    String appName = StringUtils.isNotEmpty((String)rs.getString("appName")) ? rs.getString("appName") : rs.getString("appName2");
                    TreeNode cloudNode = (TreeNode)cloudMap.get(cloudId);
                    if (cloudNode == null) {
                        cloudNode = new TreeNode("-1", cloudId + "#cloud", cloudName, true);
                        cloudNode.setChildren(new ArrayList());
                        cloudNodes.add(cloudNode);
                        cloudMap.put(cloudId, cloudNode);
                    }
                    TreeNode appNode = new TreeNode(cloudId + "#cloud", appId + "#app", appName, false);
                    cloudNode.getChildren().add(appNode);
                    appNodes.add(appNode);
                }
                return null;
            }
        });
        this.getPageCache().put("pgCache_allCloudInfo", SerializationUtils.toJsonString(cloudNodes));
        this.getPageCache().put("pgCache_allAppInfo", SerializationUtils.toJsonString(appNodes));
    }

    private String getSelAppRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u5e94\u7528", (String)"AdministratorEditNewPlugin_61", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSameAsParentRootNodeText() {
        return ResManager.loadKDString((String)"\u540c\u4e0a\u7ea7\u7ba1\u7406\u5458\u8303\u56f4", (String)"AdministratorEditNewPlugin_62", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!PermCommonUtil.hasEnableOldAdmin()) {
            String pageId = "newAdmin_list" + this.getView().getPageId();
            IFormView newFv = this.getView().getView(pageId);
            IFormView appview = this.getView().getParentView();
            if (newFv != null) {
                newFv.activate();
                this.getView().sendFormAction(newFv);
                this.getView().close();
            }
            ListShowParameter lsp = new ListShowParameter();
            lsp.setPageId(pageId);
            lsp.setBillFormId("perm_useradmingroup");
            lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
            lsp.getOpenStyle().setTargetKey("_submaintab_");
            lsp.setHasRight(true);
            appview.showForm((FormShowParameter)lsp);
            this.getView().sendFormAction(appview);
            this.getView().close();
        }
    }
}

